#ifndef _incl_utility
#define _incl_utility

#include "macros.h"
#include "types.h"

#define  IS_BIG_ENDIAN  0
#define  IS_LITTLE_ENDIAN  1

/* below should be used only on Azara-written data */
extern Bool determine_swapped
	();

extern Status endian_fwrite
	(char *x, int n, FILE *fp);

extern Bool is_big_endian
	();

extern Bool is_little_endian
	();

extern int endianess
	();

extern Bool file_exists
	(String file);

extern Bool equal_strings
	(String string1, String string2);

extern Status copy_string
	(String *string1, String string2, String error_msg);

extern Bool empty_string
	(String string);

extern void print_integer_array
	(int n, int *array);

extern void swap_bytes
	(char *ptr, int nbytes);

extern void float_words
	(float *ptr, int nwords);

extern void int_words
	(int *ptr, int nwords);

extern int log_2
	(int n);

extern int floor_power_of_2
	(int n);

extern int ceil_power_of_2
	(int n);

extern int greatest_common_factor
	(int m, int n);

extern YesNo yes_func
	(String msg, String yes, String no, String cancel);

extern YesNo no_func
	(String msg, String yes, String no, String cancel);

extern YesNo cancel_func
	(String msg, String yes, String no, String cancel);

extern Status start_screen_print
	(String error_msg);

extern void print_screen_message
	(String message);

extern void end_screen_print
	();

extern void start_no_timer
	(String message);

extern int update_no_timer
	(float fraction);

extern void stop_no_timer
	(Status status);

extern void start_screen_timer
	(String message);

extern int update_screen_timer
	(float fraction);

extern void stop_screen_timer
	(Status status);

extern Status get_integers
	(int n, int *array, char *string);

extern Status get_floats
	(int n, float *array, char *string);

extern int get_max_integers
	(int nmax, int *array, char *string);

extern int get_max_floats
	(int nmax, float *array, char *string);

extern Status get_some_integers
	(int n, int m, int *skip, int *array, char *string);

extern Status get_some_floats
	(int n, int m, int *skip, float *array, char *string);

#endif /* _incl_utility */
