#ifndef _incl_window
#define _incl_window

#include "widget.h"

#define  NO_CALLBACK	((Callback_proc) NULL)
#define  NO_DATA	((Callback_ptr) NULL)

#define  NO_ATTACH	((Widget) 0)
#define  FORM_ATTACH	((Widget) 1)

#define  NO_POSITION	(-1)

#define  NO_OFFSET	0
#define  UNIT_OFFSET	5

#define  NOTHING_SELECTED	(-1)

#define  CHECK_WIDGET(w)  \
	 {   if (!(w))  return  (Widget) NULL;   }

#define  CHECK_WIDGET_DESTROY(p, w)  \
	 {   if (!(p)) \
	     {   destroy_widget(w);  w = (Widget) NULL; \
		 return  (Widget) NULL;   }   }

#define  WIDGET_WARNING  "Could not create widget"

#define  CHECK_WIDGET_WARNING(w)  \
	 {   if (!(w))  {   serious_warning(WIDGET_WARNING);  return;   }   }

#define  CHECK_WIDGET_DESTROY_WARNING(p, w)  \
	 {   if (!(p)) \
	     {   destroy_widget(w);  w = (Widget) NULL; \
		 serious_warning(WIDGET_WARNING);   return;   }   }

typedef struct
{
    char *label;
    Callback_proc callback;
    Callback_ptr data;
}   Button_item;

typedef struct
{
    char *label;
    Callback_proc callback;
    Callback_ptr data;
    Widget *box;
}   Box_item;

typedef Box_item Radiobox_item;
typedef Box_item Checkbox_item;

typedef Widget (*Widget_func)(Widget parent, int n);

typedef struct
{
    int n;
    int width;
    String label[2];
    Widget_func func[2];
}   Alternating_info;

typedef struct
{
    char *label;
    char *value;
    Callback_proc callback;
    Callback_ptr data;
    Widget *field;
}   Textfield_item;

typedef struct
{
    int nrows;
    int ncolumns;
    Bool editable;
    int edit_mode;
}   Scrolled_text_info;

typedef String (*String_item_func)(int, Generic_ptr);

typedef struct
{
    int selection_policy;
    int nitems;
    String_item_func func;
    Generic_ptr func_data;
    int nvisible_items;
    Callback_proc callback;
    Callback_ptr callback_data;
}   Scrolled_list_info;

#define  DBL_MULTI_LIST		0
#define  DBL_SINGLE_LIST	1

typedef struct
{
    int nitems;
    String_item_func funcs[2];
    Generic_ptr func_data[2];
    int nvisible_items;
    Widget *widgets;
    Callback_proc callbacks[2];
    Callback_ptr callback_data[2];
}   Scrolled_dbl_list_info;

typedef struct
{
    char *label;
    int nitems;
    String *items;
    Bool callback_names;
    Callback_proc callback;
}   Dropdown_list_info;

typedef struct
{
    int width;
    int height;
    Callback_proc expose;
    Callback_proc resize;
}   Drawing_area_info;

typedef struct
{
    int width;
    int height;
    int view_width;
    int view_height;
    Widget *bars;
    Callback_proc expose;
    Callback_proc resize;
    Callback_proc scroll;
}   Scrolled_drawing_area_info;

typedef struct
{
    int width;
    int height;
}   Scrolled_window_info;

typedef struct
{
    float multiplier;
    float minimum;
    float maximum;
    float value;
}   Scale_numbers;

typedef struct
{
    int orientation;
    Scale_numbers *numbers;
    Bool show_value;
    char *title;
    Callback_proc value_changed;
    Callback_proc dragged;
    Callback_ptr data;
}   Scale_info;

typedef struct
{
    Scale_info *scale_info;
    Widget *scale;
    Textfield_item *limits;
}   Text_scale_info;

typedef struct
{
    int nbuttons;
    Button_item *buttons;
    Textfield_item *text;
}   Text_buttons_info;

extern Widget initialize_application
	(String name, int *argc, char **argv);

extern void application_main_loop
	();

extern void de_iconify_application
	();

extern void manage_widget
	(Widget widget);

extern void realize_widget
	(Widget widget);

extern void popup
	(Widget widget);

extern void popdown
	(Widget widget);

extern Widget get_topshell
	();

extern Widget top_shell
	(Widget widget);

extern void change_delete_protocol
	(Widget shell, Callback_proc callback);

extern void do_nothing_callback
	(Widget widget, Callback_ptr data, Callback_ptr cbs);

extern void not_implemented_callback
	(Widget widget, Callback_ptr data, Callback_ptr cbs);

extern void attachments
	(Widget widget, Widget top, Widget bottom, Widget left, Widget right);

extern void positions
	(Widget widget, int top, int bottom, int left, int right);

extern void offsets
	(Widget widget, int top, int bottom, int left, int right);

extern Bool toggle_being_set
	(Callback_ptr cbs);

extern int get_radio_state
	(Widget *boxes, int nboxes);

extern void set_radio_state
	(Widget *boxes, int nboxes, int to_set);

extern int get_check_state
	(Widget *boxes, int nboxes);

extern void set_check_state
	(Widget *boxes, int nboxes, int to_set);

extern void get_textfields
	(Textfield_item *textfield_items, int ntexts);

extern void set_textfields
	(Textfield_item *textfield_items, int ntexts);

extern void set_text_edit_state
	(Widget widget, Bool state);

extern void set_label
	(Widget widget, String string);

extern void print_text
	(Widget widget, Bool new_text, String string);

extern Status insert_in_list
	(Widget widget, String string, int position);

extern Status replace_in_list
	(Widget widget, String string, int position);

extern void delete_from_list
	(Widget widget, int position);

extern void select_from_list
	(Widget widget, int position, Bool notify);

extern void deselect_from_list
	(Widget widget, int position);

extern Bool selection_from_list
	(Widget widget, int **selected, int *nselected);

extern int list_position
	(Callback_ptr cbs);

extern void get_scale_value
	(Callback_ptr cbs, Scale_numbers *numbers);

extern void set_scale_value
	(Widget scale, Scale_numbers *numbers);

extern void set_scale_numbers
	(Widget scale, Scale_numbers *numbers);

extern void get_widget_size
	(Widget widget, int *width, int *height);

extern void set_widget_size
	(Widget widget, int width, int height);

extern int get_scrollbar_value
	(Callback_ptr cbs);

extern void set_scrollbar_value
	(Widget scrollbar, int value);

extern void destroy_widget
	(Widget widget);

extern Widget create_popup
	(Widget parent, String name);

extern Widget create_iconifiable_popup
	(Widget parent, String name);

extern Widget create_drawing
	(Widget parent, Drawing_area_info *drawing_info);

extern void update_scrollbar
	(Widget scrollbar, int view_size);

extern Widget create_scrolled_drawing
	(Widget parent, Scrolled_drawing_area_info *drawing_info);

extern Widget create_scrolled_window
	(Widget parent, Scrolled_window_info *scrolled_info);

extern Widget create_form
	(Widget parent);

extern Widget create_rowcol
	(Widget parent);

extern Widget create_separator
	(Widget parent);

extern Widget create_label
	(Widget parent, String string);

extern Widget create_vertical_buttons
	(Widget parent, Button_item *button_items, int nbuttons);

extern Widget create_pixmap_button
	(Widget parent, Button_item *button_items, Pixmap pixmap);

extern Widget create_horizontal_buttons
	(Widget parent, Button_item *button_items, int nbuttons);

extern void initialize_boxes
	(Radiobox_item *items, String *labels, Widget *boxes, int nboxes);

extern Widget create_radiobox
	(Widget parent, Radiobox_item *items, int nboxes, int item_set,
							int orientation);

extern Widget create_checkbox
	(Widget parent, Checkbox_item *items, int nboxes, int items_set,
							int orientation);

extern Widget create_label_radiobox
	(Widget parent, String string, Radiobox_item *items, int nboxes,
							int item_set);

extern Widget create_label_checkbox
	(Widget parent, String string, Checkbox_item *items, int nboxes,
							int item_set);

extern Widget create_alternating_pair
	(Widget parent, Alternating_info *alternating_info);

extern Widget create_textfields
	(Widget parent, Textfield_item *textfield_items, int ntexts);

extern Widget create_scrolled_text
	(Widget parent, Scrolled_text_info *scrolled_text_info);

extern Widget create_scrolled_list
	(Widget parent, Scrolled_list_info *scrolled_list_info);

extern Widget create_scrolled_dbl_list
	(Widget parent, Scrolled_dbl_list_info *scrolled_dbl_list_info);

extern Widget create_dropdown_list
	(Widget parent, Dropdown_list_info *dropdown_list_info);

extern Widget create_scale
	(Widget parent, Scale_info *scale_info);

extern Widget create_text_scale
	(Widget parent, Text_scale_info *text_scale_info);

extern Widget create_text_buttons
	(Widget parent, Text_buttons_info *text_buttons_info);

extern YesNo force_question
	(String msg, String yes, String no, String cancel);

extern YesNo select_file
	(String file);

extern void print_error_message
	(String message);

extern void serious_warning
	(String message);

extern void force_update
	(Widget shell);

extern void check_for_event
	();

extern void register_shell
	(Widget shell);

extern void unregister_shell
	(Widget shell);

extern void change_cursor
	(Cursor cursor);

extern Cursor create_busy_cursor
	(Display *display);

extern void flush_display
	(Display *display);

#endif /* _incl_window */
