/* The following code is a slightly modified version of that found in
   "Data structures, an advanced approach using C" by J. Esakov and
   T. Weiss (Prentice Hall, 1989)                                     */

#include "list.h"

Status allocate_node(List *p_list, Generic_ptr data_ptr)
{
    MALLOC(*p_list, Node, 1);
    DATA(*p_list) = data_ptr;
    NEXT(*p_list) = NULL;

    return  OK;
}
 
void free_node(List *p_list)
{
    FREE(*p_list, Node);
}
 
Status init_list(List *p_list)
{
    *p_list = NULL;
    return  OK;
}
 
Bool empty_list(List list)
{
    return  (list == NULL) ? TRUE : FALSE;
}
 
Status insert_list(List *p_list, Generic_ptr data_ptr)
{
    List list;
 
    CHECK_STATUS(allocate_node(&list, data_ptr));
 
    NEXT(list) = *p_list;
    *p_list = list;
    return  OK;
}
 
Status append_list(List *p_list, Generic_ptr data_ptr)
{
    List list, L;
 
    CHECK_STATUS(allocate_node(&list, data_ptr));
 
    if (empty_list(*p_list) == TRUE)
        *p_list = list;
    else
    {
        for (L = *p_list; NEXT(L) != NULL; L = NEXT(L))  ;

        NEXT(L) = list;
    }

    return  OK;
}
 
Status delete_key(List *p_list, Generic_ptr key_ptr)
{
    List list;

    if (empty_list(*p_list) == TRUE)  return  ERROR;
 
    if (DATA(*p_list) == key_ptr)
    {
	list = *p_list;
        *p_list = NEXT(*p_list);
    }
    else
    {
        List L;
 
        for (L = *p_list; (L != NULL) &&
			(DATA(NEXT(L)) != key_ptr); L = NEXT(L))  ;
 
        if (L == NULL)  return  ERROR;
	list = NEXT(L);
        NEXT(L) = NEXT(list);
    }

    free_node(&list);
 
    return  OK;
}
 
Status delete_node(List *p_list, List list)
{
    if (empty_list(*p_list) == TRUE)  return  ERROR;
 
    if (*p_list == list)
    {
        *p_list = NEXT(*p_list);
    }
    else
    {
        List L;
 
        for (L = *p_list; (L != NULL) && (NEXT(L) != list); L = NEXT(L))  ;
 
        if (L == NULL)  return  ERROR;
        NEXT(L) = NEXT(list);
    }

    free_node(&list);
 
    return  OK;
}
 
Status delete_list(List *p_list, Generic_ptr *p_data_ptr)
{
    if (empty_list(*p_list) == TRUE)  return  ERROR;
 
    *p_data_ptr = DATA(*p_list);
    return  delete_node(p_list, *p_list);
}
 
Status traverse_list(List list, Check_func func)
{
    if (empty_list(list) == TRUE)  return  OK;
 
    CHECK_STATUS((*func)(DATA(list)));
 
    return  traverse_list(NEXT(list), func);
}
 
List list_iterator(List list, List last_return)
{
    return  (last_return == NULL)  ?  list  :  NEXT(last_return);
}
 
Status find_key(List list, Generic_ptr key_ptr, Equal_func cmp,
							List *p_key_list)
{
    List curr = NULL;
 
    while ((curr = list_iterator(list, curr)) != NULL)
    {
        if ((*cmp)(key_ptr, DATA(curr)) == TRUE)
        {
            *p_key_list = curr;
            return  OK;
        }
    }
 
    return  ERROR;
}
 
void destroy_list(List *p_list, Data_func func)
{
    if (empty_list(*p_list) == FALSE)
    {
        destroy_list(&NEXT(*p_list), func);
        if (func != NULL)  (*func)(DATA(*p_list));
/*        if (func != NULL)  (*func)(&DATA(*p_list)); */  /* modified (&)*/
        free_node(p_list);
    }
}
