#include "avance_param.h"

#define  NDSPFVS_VALUES  4

typedef struct
{
    int decim;
    int values[NDSPFVS_VALUES];
}   Avance_entry;

static int dspfvs_values[NDSPFVS_VALUES] = { 10, 11, 12, 13 };

static Avance_entry table[] =
{
    { 2, { 179,184,184,11 } },
    { 3, { 201,219,219,17 } },
    { 4, { 533,384,384,23 } },
    { 6, { 709,602,602,35 } },
    { 8, { 1097,852,852,47 } },
    { 12, { 1449,1668,1668,71 } },
    { 16, { 2225,2312,2292,95 } },
    { 24, { 2929,3368,3368,143 } },
    { 32, { 4481,4656,4616,191 } },
    { 48, { 5889,6768,6768,287 } },
    { 64, { 8993,9344,9264,383 } },
    { 96, { 11809,13568,13568,575 } },
    { 128, { 18017,18560,18560,-1 } },
    { 192, { 23649,27392,27392,-1 } },
    { 256, { 36065,36992,36992,-1 } },
    { 384, { 47329,55040,55040,-1 } },
    { 512, { 72161,73856,73856,-1 } },
    { 768, { 94689,110336,110336,-1 } },
    { 1024, { 144353,147584,147584,-1 } },
    { 1536, { 189409,220928,220928,-1 } },
    { 2048, { 288737,295040,295040,-1 } }
};

static int ndecim_values = sizeof(table) / sizeof(table[0]);

Status find_avance_param(Avance_param *param, String error_msg)
{
/*  inefficient searching but does not matter  */

    int row, col, v;
    float p;

    for (col = 0; col < NDSPFVS_VALUES; col++)
    {
	v = dspfvs_values[col];

	if (v == param->dspfvs)
	    break;

	if (v > param->dspfvs)
	    RETURN_ERROR_MSG("unknown DSPFVS value");
    }

    if (col == NDSPFVS_VALUES)
	RETURN_ERROR_MSG("unknown DSPFVS value");

    for (row = 0; row < ndecim_values; row++)
    {
	v = table[row].decim;

	if (v == param->decim)
	    break;

	if (v > param->decim)
	    RETURN_ERROR_MSG("unknown DECIM value");
    }

    if (row == ndecim_values)
	RETURN_ERROR_MSG("unknown DECIM value");

    v = table[row].values[col];

    if (v == -1)
	RETURN_ERROR_MSG("unknown (DSPFVS, DECIM) pair");

    param->lookup = v;
    p = (param->angle * param->lookup) / ((float) param->decim);
    param->phase = NEAREST_INTEGER(p);

    p = ((float) param->phase) / 360.0;
    param->shift = NEAREST_INTEGER(p);

    if (param->shift % 2) /* odd */
	param->ph0 = 180;
    else
	param->ph0 = 0;

    param->ph1 = param->phase - 360*param->shift;

    return  OK;
}
