#! /bin/sh
# $Id: substlang.sh,v 1.3 2001/11/28 23:55:07 mjt Exp $
# "Poor man's" NLS messaging substitution "system"
#
# usage: $0 base lang

base=$1
lang=$2

. ${base}en || exit

E_ADMIN_MSG="$ADMIN_MSG" ; ADMIN_MSG=
E_SENDER_MSG="$SENDER_MSG" ; SENDER_MSG=
E_RCPT_MSG="$RCPT_MSG" ; RCPT_MSG=
E_STAMP="$STAMP"; STAMP=
CHARSET=us-ascii

if [ -n "$lang" -a "$lang" != en ] ; then
  . $base$lang || exit
else
 lang=en
fi

tmp=subst.sed.tmp

exec 3>$tmp || exit
trap "rm -f $tmp" 0

echo "1,/^$/D" >&3
echo "s|@CHARSET@|$CHARSET|" >&3
echo "s|@STAMP@|$E_STAMP|" >&3
echo "s|@ISTAMP@|$STAMP|" >&3

substit() {
  echo "s|@$1@|\\" >&3
  ( if [ -n "$2" ] ; then
      echo "echo \"See English message below.

$2

---

$3\""
    else
      echo "echo \"$3\""
    fi
  ) | sed -e 's#\([\\|&]\)#\\\1#g' -e 's|$|\\|' >&3
  echo "\\
|" >&3
}

substit ADMIN_MSG "$ADMIN_MSG" "$E_ADMIN_MSG"
substit SENDER_MSG "$SENDER_MSG" "$E_SENDER_MSG"
substit RCPT_MSG "$RCPT_MSG" "$E_RCPT_MSG"

exec 3>&2

sed -f $tmp ${base}template
