#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "globals.h"
#include "functions.h"


int eval_token(int tokentype,char *token)
{
char temptoken[TOKENSIZE];
char newtoken[1024];
char molecule1[LINELENGTH];
int t,objtype;

#ifdef DEBUG
printf("eval_token(): %s (type=%i)\n",token,tokentype);
#endif

  newtoken[0]=0;
  molecule1[0]=0;

  if (strcasecmp(token,"@")==0)
  { 
    t=gettoken(temptoken);
    if (strcasecmp(temptoken,"language")==0)
    { strcpy(token,"@language"); }
      else
    { push(temptoken,t); }
  }

  if (strcasecmp(token,"exit")==0)
  {
    t=gettoken(temptoken);
    autoindent();

    if (strcasecmp(temptoken,"function")==0)
    {
      fprintf(out,"return $function_ret;\n");
    }
      else
    if (strcasecmp(temptoken,"sub")==0)
    {
      fprintf(out,"return $function_ret;\n");
    }
      else
    if (strcasecmp(temptoken,"class")==0)
    {
      fprintf(out,"}\n");
    }
      else
    if (loopcount==0)
    { 
      push(temptoken,t);
      fprintf(out,"exit();\n"); 
    }
      else
    { 
      if (strcasecmp(temptoken,"for")==0  ||
          strcasecmp(temptoken,"while")==0 || 
          strcasecmp(temptoken,"do")==0)
      { fprintf(out,"break;\n"); }
        else
      { push(temptoken,t); }
    }
  }
    else
  if (strcasecmp(token,"do")==0)
  { parse_do(); }
    else
  if (strcasecmp(token,"while")==0)
  { parse_while(); }
    else
  if (strcasecmp(token,"select")==0)
  { parse_select(); }
    else
  if (strcasecmp(token,"if")==0)
  { parse_if(); }
    else
  if (strcasecmp(token,"rem")==0)
  { parse_rem(); }
    else
  if (strcasecmp(token,"randomize")==0)
  { parse_randomize(); }
    else
  if (strcasecmp(token,"dim")==0)
  { parse_dim(""); }
    else
  if (strcasecmp(token,"redim")==0)
  { parse_dim(""); }
    else
  if (strcasecmp(token,"@language")==0)
  { parse_at_language(); }
    else
  if (strcasecmp(token,"option")==0)
  { fprintf(out,"// Option "); eval_expression(" ");  }
    else
  if (tokentype==TOK_KEYWORD && strcasecmp(token,"set")==0)
  {
    autoindent();
    parse_set(newtoken);
    fprintf(out,"%s",newtoken);
  }
    else
  if (strcasecmp(token,"sub")==0)
  { parse_funct(2); }
    else
  if (strcasecmp(token,"function")==0)
  { parse_funct(1); }
    else
  if (strcasecmp(token,"class")==0)
  { parse_class(); }
    else
  if (strcasecmp(token,"call")==0)
  {
    t=gettoken(token);
    convert_funct(molecule1,"1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30",4);
    fprintf(out,"%s%s;",token,molecule1);
  }
    else
  if (strcasecmp(token,"session")==0)
  { parse_session(); }
    else
  if (strcasecmp(token,"response")==0)
  { parse_response(); }
    else
  if (strcasecmp(token,"request")==0)
  {
    parse_request(newtoken);
    fprintf(out,"%s",newtoken); 
  }
    else
  if (strcasecmp(token,"const")==0)
  { 
    tokentype=gettoken(token);
    eval_expression(token); 
  }
    else
  if (strcasecmp(token,"on")==0)
  { 
    /* ignore "on error resume next" */
    tokentype=gettoken(token);
    if (strcasecmp(token,"error")==0)
    {
      tokentype=gettoken(token);
      if (strcasecmp(token,"resume")==0)
      {
        tokentype=gettoken(token);
        if (strcasecmp(token,"next")!=0)
        {
          push(token,tokentype);
        }
      }
      else
      {
        push(token,tokentype);
      }
    }
    else
    {
      push(token,tokentype);
    }
  }
    else
  if (strcasecmp(token,"public")==0 || strcasecmp(token,"private")==0)
  { 
    t=gettoken(temptoken);
    if (strcasecmp(temptoken,"function")==0)
    {
      push(token,tokentype);
      parse_funct(1);
    }
      else
    if (strcasecmp(temptoken,"sub")==0)
    {
      push(token,tokentype);
      parse_funct(2);
    }
      else
    if (strcasecmp(temptoken,"property")==0)
    {
      tokentype=gettoken(token);
      parse_funct(1);
    }
      else
    {
      push(temptoken,t);
      parse_dim(token);
    }
  }
    else
  if (strcasecmp(token,"server")==0)
  {
    parse_server(newtoken);
    fprintf(out,"%s",newtoken);
  }
    else
  if (strcasecmp(token,"for")==0)
  { parse_for(); }
    else
  if (strcmp(token,"=")==0)
  {
    autoindent();
    fprintf(out,"echo ");
    eval_expression(" ");
  }
    else
  if (tokentype==TOK_KEYWORD && ((objtype=getobject(token,&t))!=0))
  {
    parse_object(newtoken,token,objtype);
    autoindent();
    fprintf(out,"%s",newtoken);
  }
    else
  if (isfunction(token)!=-1)
  {
    fprintf(out,"%s",token);
    convert_funct(newtoken,"1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30",4);
    fprintf(out,"%s",newtoken);
  }
    else
  if (isclass(token)==1 || strcasecmp(token,"this")==0)
  {
    eval_element(newtoken,tokentype,token);
    fprintf(out,"%s;",newtoken);
  }
    else
  { 
    tokentype=gettoken(temptoken);
    if (strcmp(temptoken,".")==0)
    {
      autoindent();
      fprintf(out,"$%s->",token);
      tokentype=gettoken(token);
      if (isfunction(token)!=-1)
      {
        convert_funct(molecule1,"1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30",4);
        fprintf(out,"%s%s;\n",token,molecule1);
      }
        else
      {
        fprintf(out,"%s",token);
        /* tokentype=gettoken(token); */
        eval_expression(" ");
      }
    }
      else
    {
      push(temptoken,tokentype);
      eval_expression(token); 
    }
  }

  return 0;
}

int eval_molecule(char *newtoken)
{
char token[TOKENSIZE];
char temptoken[LINELENGTH];
int tokentype;
int isstring=0;
int r;
int paren=0;

  strcpy(newtoken,"");

  while((tokentype=gettoken(token))!=TOK_EOF)
  {
    if (strcmp(token,"(")==0) paren++;
      else
    if (strcmp(token,")")==0) paren--;

    if (paren<0) return 1;

    if (tokentype==TOK_DBLQT || tokentype==TOK_SNGQT)
    { isstring=1; strcat(newtoken,token); }
      else
    if (tokentype==TOK_ENDCODE)
    {
      push(token,tokentype);
      break;
    }
      else
    if (tokentype==TOK_EOL || tokentype==TOK_COLON)
    { break; }
      else
    if (strcmp(token,"&")==0)
    { strcat(newtoken,"."); }
      else
    if (strcmp(token,",")==0)
    { return 2; }
      else
/*
    if (strcmp(token,"+")==0 && isstring==1)
    { strcat(newtoken,"."); }
      else
*/
    if (tokentype==TOK_KEYWORD && strcasecmp(token,"AND")==0)
    { strcat(newtoken,"&"); }
      else
    if (tokentype==TOK_KEYWORD && strcasecmp(token,"OR")==0)
    { strcat(newtoken,"|"); }
      else
    if (tokentype==TOK_NUMBER)
    { strcat(newtoken,token); }
      else
    if (tokentype==TOK_UNDERSCORE)
    {
      strcat(newtoken,"\n");
      for (r=0; r<indent+1; r++) strcat(newtoken,"  ");
    }
      else
    if (tokentype!=TOK_KEYWORD)
    { strcat(newtoken,token); }
      else
    {
      eval_element(temptoken,tokentype,token);
      strcat(newtoken,temptoken);
    }
  }

  return 0;
}

