.TH ASNAP 1
.PD
.ad b
.SH NAME
asnap \- Take a snapshot of a region of the screen
.SH SYNOPSIS
\fBasnap\fR
[\|\fB-display\fR displayname\|] 
[\|\fB-bd\fR border\|] 
[\|\fB-bw\fR borderwidth\|] 
[\|\fB-geometry\fR geometry\|] 
[\|\fB-icongeometry\fR icongeometry\|] 
[\|\fB-region\fR geometry\|] 
[\|\fB-iconic\fR\|] 
[\|\fB-nograb\fR\|] 
[\|\fB-atk\fR\|] 
[\|\fB-xwd\fR\|] 
[\|\fB-file\fR filename\|] 
[\|\fB-noshow\fR\|] 
[\|\fB-name\fR name\|] 
.SH DESCRIPTION
.PP
The \fIasnap\fP program allows one to take a snapshot of
a specified region of the screen.  If \fIasnap\fP is run without a region being 
specified,  the  user is prompted to interactively drag one out with the mouse.
In this case, pressing button 1 will select one corner of the region, and an opposite
corner will be selected upon the release of button 1.   A window whose contents are a
copy of this region is then created.  
Pressing "Q", "q", or "^C" in this  window will exit the program.
The region may also be stored to a file for later use.
Note that this program is a variant of the original \fIxsnap\fP program.
.SH OPTIONS
.TP 8
.B \-display \fIdisplay\fP
Specifies the display to use for both specifying and displaying the region.
.TP 8
.B \-bd \fIborder\fP
Border color of snapshot window.  Defaults to white.
.TP 8
.B \-bw \fIborder width\fP
Border width of snapshot window.  Defaults to 2.
.TP 8
.B \-geometry \fIgeom\fP
Geometry of snapshot window.  
.TP 8
.B \-icongeometry \fIgeom\fp
Geometry of icon.
.TP 8
.B \-iconic
If specified, snapshot window will start up in iconic state.
.TP 8
.B \-nograb
Do not grab the server during specification of region.
.TP 8
.B \-atk
Store the pixmap as an Andrew Toolkit raster object to the output.  Convert color to monochrome.
.TP 8
.B \-xwd
Store the pixmap in X window dump format to the output.
.TP 8
.B \-file \fIfilename\fp
Store the output in the file \fIfilename\fp.  Overwrite if it already exists.
.TP 8
.B \-noshow
Do not display the pixmap in a window.  (Useful with -atk or -xwd).
.TP 8
.B \-name \fIname\fp
Name for icon to be passed to window manager.
.TP 8
.B \-region \fIgeom\fP
The size and  location on the screen of the region to be copied.
.SH BUGS
.br
No support for colormaps.
.br
Incorrect behavior may result on displays that support windows of different depths.
.br
Since it creates a pixmap for each snapshot,  it can chew up server memory very fast.
.br
The icongeometry option  doesn't know about icon sizes.
.SH AUTHOR
Clauss Strauch
.br
Engineering Design Research Center
.br
Carnegie Mellon University
.sp 1
Bill Janssen
.br
Xerox Palo Alto Research Center







