/*
 * Copyright (c) 2002, Douwe Kiela All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * - Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 * 
 * - Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * - Neither name of author nor the names of its contributors may be used to
 * endorse or promote products derived from this software without specific
 * prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * asm2html v-1.4
 */

#include <asm2html.h>

int
main(int argc, char *argv[])
{

	int             fset = 0, c;
	extern char    *optarg;
	struct finfo   *files;
	char *options = "b:f:hlt:xv";

	/* set some defaults */
	showlines = 0;
	banner = 1;

	/* alocate memory for files structure */
	if ((files = malloc(sizeof(struct finfo))) == NULL) {
		perror("asm2html");
		exit(EXIT_FAILURE);
	}

	while ((c = getopt(argc, argv, options)) != -1) {
		switch (c) {
		case 'b':
			if ((files->bottom = fopen(optarg, "r")) == NULL) {
				perror("asm2html");
				exit(EXIT_FAILURE);
			}
			break;
		case 'f':
			fset = 1;
			if ((files->in = fopen(optarg, "r")) == NULL) {
				perror("asm2html");
				exit(EXIT_FAILURE);
			}
			snprintf(files->filename, sizeof(files->filename), "./%s.html", optarg);
			break;
		case 'h':
			if (!fset) {
				usage();
			}
			break;
		case 'l':
			showlines = 1;
			break;
		case 't':
			if ((files->top = fopen(optarg, "r")) == NULL) {
				perror("asm2html");
				exit(EXIT_FAILURE);
			}
			break;
		case 'x':
			banner = 0;
			break;
		case 'v':
			if (!fset) {
				fprintf(stderr, "asm2html version %s\n", VERSION);
				exit(0);
			}
			break;
		}

	}

	if (!fset) {
		fprintf(stderr, "You didn't specify a file to read\n");
		usage();
	}
	if (argc < 2) {
		usage();
	}
	if ((files->out = fopen(files->filename, "w")) == NULL) {
		perror("asm2html");
		exit(EXIT_FAILURE);
	}
	asm2html(files);

	return 0;
}





void
usage()
{
	fprintf(stderr, "Usage:\n"
		"asm2html [-hlxv] [-b [bottomfile]] [-f [file]] [-t [topfile]]\n"
		"Options:\n"
		"-b [bottomfile]\t-\t\tSpecify the HTML file to be inserted at the bottom of our generated file\n"
		"-f [file]\t-\t\tSpecify file to read\n"
		"-h\t\t-\t\tThis help info\n"
		"-l\t\t-\t\tShow lines\n"
		"-t [topfile]\t-\t\tSpecify the HTML file to be inserted at the top of our generated file\n"
		"-x\t\t-\t\tDont display \"Generated with\" info\n"
		"-v\t\t-\t\tShow version\n");
	exit(0);
}
