/*
 * Copyright (c) 2002, Douwe Kiela All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * - Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 * 
 * - Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * - Neither name of author nor the names of its contributors may be used to
 * endorse or promote products derived from this software without specific
 * prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <asm2html.h>

unsigned int num;

char           *
strline(unsigned int line)
{
	unsigned int    cnt = 1, ofs;
	static char    *ret;
	if (!ret) {
		if ((ret = (char *)malloc(num) + 1) == NULL) {
			perror("asm2html");
			exit(EXIT_FAILURE);
		}
	}
	memset(ret, '0', num);
	ofs = line;
	while (ofs /= 10)
		cnt++;
	ofs = num - cnt;
	sprintf(ret + ofs, "%d", line);
	return ret;
}


int
get_line_nr(struct finfo *files)
{
	int             count = 1, nr = 1;
	char            buf[128];
	while (fgets(buf, sizeof(buf), files->in) != NULL) count++;
	fseek(files->in,0L,SEEK_SET);
	while(count /= 10) nr++;
	return nr;
}


int
asm2html(struct finfo * files)
{
	int             c, oc, strindex = 0, quotesfound = 0, comment = 0;
	unsigned int    line = 1;
	char            string[4096];


	if (files->top != NULL) {
		top_html_file(files);
	} else {
		start_html(files);
	}


	if (showlines) {
		num=get_line_nr(files);
		fprintf(files->out, "<a name=\"%s\"><a href=\"#%s\"><font color=\"#000000\">%s</font></a>%s",strline(line),strline(line),strline(line),TAB);
	}

	while (!feof(files->in)) {
		c = fgetc(files->in);

		if (is_ok(c)) {
			string[strindex] = c;
			strindex++;
		} else {
			string[strindex] = '\0';

			if (comment == 0 && quotesfound == 0) {
				if (strindex)
					process_line(files->out, string);
			} else {
				fprintf(files->out, "%s", string);
			}

			strindex = 0;

			if (c == '<') {
				fprintf(files->out, "&lt;");
			} else if (c == '>') {
				fprintf(files->out, "&gt;");
			} else if ((c == '"' || c == '\'') && oc != '\\') {
				if (quotesfound) {
					if (quote == c) {
						fprintf(files->out, "%c</FONT>", c);
						quotesfound = 0;
					} else {
						fprintf(files->out, "%c", c);
					}
				} else {
					fprintf(files->out, "<FONT color=\"%s\">%c", CLR_QUOTES, c);
					quote = c;
					quotesfound = 1;
				}
			} else if (c == '&') {
				fprintf(files->out, "&amp;");
			} else if (c == ';') {
				fprintf(files->out, "<I><font color=\"%s\">;", CLR_COMMENT);
				comment = 1;
			} else if (c == '\n') {
				if (showlines) {
					line++;
					if (comment) {
						fprintf(files->out, "</font></i>\n<br>\n<a name=\"%s\"><a href=\"#%s\"><font color=\"#000000\">%s</font></a>%s",strline(line),strline(line),strline(line), TAB);
						comment = 0;
					} else {
						fprintf(files->out, "<br>\n<a name=\"%s\"><a href=\"#%s\"><font color=\"#000000\">%s</font></a>%s",strline(line),strline(line),strline(line), TAB);
					}
				} else {
					if (comment)
						fprintf(files->out, "</i>");
					fprintf(files->out, "\n<BR>\n");
				}
				if (comment) {
					fprintf(files->out, "\n</FONT>\n");
					comment = 0;
				}
			} else if (c == '\t') {
				fprintf(files->out, "%s", TAB);
			} else if (c == ' ') {
				fprintf(files->out, "&nbsp;");
			} else if (isdigit(c)) {
				if (!comment && !quotesfound)
					fprintf(files->out, "<font color=\"%s\">%c</font>", CLR_NUMBER, c);
				else
					fprintf(files->out, "%c", c);
			} else {
				if (c == EOF)
					break;
				fprintf(files->out, "%c", c);
			}

		}

		if (c == '\\' && oc == '\\') {
			oc = 0;
		} else {
			oc = c;
		}


	}

	if (files->bottom != NULL) {
		bottom_html_file(files);
	} else {
		end_html(files->out);
	}

	fclose(files->in);
	fclose(files->out);

	return 0;
}
