/*
 * Copyright (c) 2002, Douwe Kiela All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * - Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 * 
 * - Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * - Neither name of author nor the names of its contributors may be used to
 * endorse or promote products derived from this software without specific
 * prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef __ASM2HTML_H_
#define __ASM2HTML_H_

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>

#define VERSION "1.4"

#define CLR_COMMENT "#000033"
#define CLR_QUOTES "#FF0000"
#define CLR_NUMBER "#CC6600"
#define CLR_REGISTER "#CC0000"
#define CLR_STATUSFLAG "#C0C0C0"
#define CLR_PREDICATE "#004400"
#define CLR_INSTRUCTION "#000000"
#define CLR_PSEUDO "#0000FF"
#define CLR_DIRECTIVE "#003333"
#define CLR_PREPROCESSOR "#660033"
#define CLR_MACRO "#FF3300"
#define CLR_SECTION "#333300"
#define CLR_KEYWORD "#FF0099"

#define TAB "&nbsp;&nbsp;&nbsp;"

char            quote;
int             banner, showlines;

struct finfo
{
char filename[128];
FILE *in;
FILE *out;
FILE *top;
FILE *bottom;
};

/* html.c */
void            start_html(struct finfo *files);
void            end_html(FILE * fp);
void		top_html_file(struct finfo *files);
void		bottom_html_file(struct finfo *files);


/* process.c */
int             is_ok(char c);
int             process_line(FILE * fp, char *string);

/* main.c */
void            usage();

/* asm2html.c */
int asm2html(struct finfo *files);

#endif
