static char readme[] = "\n"
"Contents:\n"
"\n"
"1. About Arka\n"
"\n"
"2. How to use Arka\n"
" 2.1. Arka window\n"
" 2.2. Menus\n"
"  2.2.1. General\n"
"	2.2.2. Shortcut keys\n"
"  2.2.3. Edit\n"
"  2.2.4. Options\n"
"  2.2.5. Tools\n"
"  2.2.6. Windows\n"
"  2.2.7. Programs\n"
"\n"
"3. Configuration files.\n"
" 3.1. Files\n"
" 3.2. Spec files for the command-line programs in the `Programs' menu.\n"
"\n"
"4. Problems, bugs, maintainer\n"
" 4.1. Bugs\n"
" 4.2. Mail me!\n"
"\n"
"=================================================================================\n"
"\n"
"1. About Arka\n"
"\n"
"Arka is a program that (1) serves as a graphical interface for the programs\n"
"from the GP package (see http://www.bioinformatics.org/genpak/) and virtually\n"
"for any other command line program (2) has some funtions on it's own. The main\n"
"scope of the program is the manipulation and visualisation of DNA / RNA /\n"
"protein sequences, but arka is a suitable, however humble, interface for\n"
"anything from blasta through make to zip.\n"
"\n"
"The GP package contains many command-line utilities which fullfill a whole bunch\n"
"of tasks (from DNA sequence searches to restriction analysis and determining the\n"
"melting temperature of oligonucleotides). While those programs are convenient to\n"
"use in batch processing and CGI scripts (which was the purpose of those\n"
"programs), they lack a nice GUI. \n"
"\n"
"Arka remembers the options for the command-line programs and knows what both the\n"
"programs and the options do. Besides, it has some gadgets on its own. It\n"
"requires GTK+, but doesn't need GNOME. Also, it is small and quick: look, I\n"
"write and use my programs on an old 486 laptop. It should run like hot butter on\n"
"your computer.\n"
"\n"
"=================================================================================\n"
"\n"
"2. How to use Arka\n"
"\n"
"2.1. Arka window\n"
"\n"
"The main window of the program consists of three sub-windows. They are called\n"
"'input', 'output' and 'error' and correspond to stdin, stdout and stderr. In\n"
"other words, 'input' window contains the data which are fed into the used GP\n"
"program; when you run the program, it's output is stored in the 'output' window\n"
"and any error messages issued are stored in the 'error' window. You can load\n"
"just any text file into the 'input' window -- a FASTA formatted sequence, a\n"
"matrix, a list of parameters. Anything goes. However, if you run a GP program\n"
"and it doesn't find in the input what it expects (for example, gp_gc expects a\n"
"DNA / RNA sequence), you will get an error message in the 'error' window.\n"
"\n"
"\n"
"2.2. Menus\n"
"\n"
"2.2.1. General\n"
"\n"
"I think I don't have to explain what the 'File', 'Options' or 'Help' menus do.\n"
"Just note that the entry field in each 'file' dialog is nearly as potent as a bash\n"
"commandline: it supports file extension with TAB, ctrl-e, ctrl-a, ctrl-u etc.\n"
"Another nice feature of the gtk+ toolkit: in each menu, you see a dashed line on\n"
"the top of the menu. This is called a 'tearoff' -- try clicking on it and you\n"
"will get a separate 'toolbox' window. This is so much more efficient than\n"
"standard toolboxes!\n"
"\n"
"\n"
"2.2.2. Shortcut keys\n"
"\n"
"You can easily add shortcuts to menu items -- just select a menu item (place the\n"
"mouse cursor over it) and press a key or a combo. For example, if you press\n"
"Ctrl-s when the menu item Save is highlited, you will be able to use the\n"
"shortcut Ctrl-s to access the Save dialog directly. The shortcuts will be\n"
"saved in the configuration file ~/.arka/shortcuts automagically upon exit.\n"
"\n"
"\n"
"2.2.3. Edit\n"
"\n"
"'Clear' clears one of the three main windows (input, output and error).\n"
"'External editor' launches either the editor defined in the preferences or\n"
"'xterm -e vi', which should work in any case. 'Output=>Input' moves the contents\n"
"of the 'output' window to the 'input' window. This is a simple way of piping the\n"
"output of one program to another one: first you run the first program, next you\n"
"move the contents from input to output, and finally, you run the second program.\n"
"\n"
"In the search / replace dialog box you can use any standard regular expression\n"
"(e.g. input 'f.*oo' to match 'faaaaaoo', 'foo' and 'fooooo'). '\n' denotes\n"
"newlines, '\t' tabs.\n"
"\n"
"'Sequence editor' is an editor specifically designed for DNA/RNA/protein\n"
"sequences. It doesn't have many features yet, but is already useful for me.\n"
"You can have many types of data on the input window, and you can edit it\n"
"directly or using an external editor; however, for nucleotide sequences there is\n"
"a special tool -- the sequence editor, featuring several conveniece tools. You\n"
"launch it with the Edit->Sequence editor menu entry; all sequences found on the\n"
"input can be edited simultaniously -- just choose the name of the sequence you'd\n"
"like to edit from the pop-down list and press ENTER. Note that when you press\n"
"done the contents of the input window will get overwritten with the sequences.\n"
"\n"
"\n"
"2.2.4. Options\n"
"\n"
"'Editable' -- normally, you cannot directly edit the input window. 'Hide\n"
"tooltips' -- tooltips might be useful on the beginning, but in the longer run,\n"
"they are very annoying. Note that this option will get saved upon program exit.\n"
"'Font' sets the current font used to draw input / output /error / sequence\n"
"editor windows, but doesn't save it as a default. 'Preferences...' allows you to\n"
"change and save some global preferences: how many items to save in the file and\n"
"command history, whether hide or show the tooltips, default font to use, and\n"
"external editor command.\n"
"\n"
"\n"
"2.2.5. Tools\n"
"\n"
"The 'Tools' menu contain gadgets specific for the Arka program. 'GC graph'\n"
"draws a GC contents graph based on the sequences in the 'input' window. This\n"
"tool expects FASTA sequences in the 'input' window. '3D graph' draws a\n"
"complicated 3D graph (I am very proud on this thing: I have re-invented the\n"
"z-buffer). The file to draw should have in each line three tab-separated\n"
"numbers: the x,y,z coordinates of the data point to draw; optionally, you can\n"
"also place an integer number designating the class of the data point (each class\n"
"will be drawn with another color) and a label (string) for that point. Empty\n"
"lines or lines starting with a '#' are ignored. Here is an example:\n"
"\n"
"# x	y	z	class	label\n"
"1.9	2.0	-1.5	8	some point\n"
"\n"
"'Command...' runs for you any arbitrary command (any program you can run from a\n"
"normal command line). It stores the command history in the Arkas configuration\n"
"file. You can treat the text contained in the 'input' window just like a normal\n"
"file -- just put an '%input' string where you would put the file's name, for\n"
"example try to enter something like that:\n"
"\n"
"wc -l %input\n"
"\n"
"...and you will get the number of the lines in the 'input' window.\n"
"\n"
"\n"
"2.2.6. Windows\n"
"\n"
"'Windows' lets you currently only hide / show the three main windows and even\n"
"this doesn't work all to well.\n"
"\n"
"\n"
"2.2.7. Programs\n"
"\n"
"'Programs' contains a list of the supported command line programs. If you choose\n"
"one, you will see a brief summary of what the program does and an entry +\n"
"description for each relevant option the program supports. The 'man page' button\n"
"will launch 'xterm -e man name', where name is the name of the program you\n"
"selected.\n"
"\n"
"Arka will build a command line out of the options you select. Example: you\n"
"choose Programs / Unix utilities / text / word count. A dialog pops up, showing\n"
"all of the supported options. You click on 'count lines', and then on the\n"
"'Launch' button. Now arka will run the wc program, which will count the lines in\n"
"your input window. Here is what arka exactly does:\n"
"\n"
"	(i) constructs a command line:\n"
"		wc -l %input\n"
"\n"
"	(ii) it stores the 'input' window in a temporary file\n"
"	\n"
"	(iii) substitutes the '%input' in the command line with the name of the\n"
"	temporary file\n"
"\n"
"	(iv) runs the program. During the execution of the command line program, a\n"
"	dialog box pops up with an 'abort' button -- which, when pressed, kills the\n"
"	command line program (so that if the program hangs, you can gracefully quit\n"
"	it).\n"
"\n"
"	(v) puts the output of the command line program into the 'output' window, and\n"
"	any error messages issued during execution into the 'error' window.\n"
"\n"
"	(vi) stores the command in the command line history.\n"
"\n"
"=================================================================================\n"
"\n"
"3. Configuration files.\n"
"\n"
"3.1. Files\n"
"\n"
"There is the global config file, /etc/arkarc, and a user directory,\n"
"$HOME/.arka/, which contains a config file (configuaration),\n"
"command_history, file_history, shortcuts with the shortcuts you have created and\n"
"(possibly) a file called `programs'.\n"
"\n"
"The trick arka uses to do its work is as follows: arka stores the input window\n"
"in a temporary file, and then passes the name of this temporary file to the\n"
"program it runs. To be more specific, it builds the command line from the\n"
"options and arguments shown in the dialog box, and replaces each string of the\n"
"following form:\n"
"\n"
"%input\n"
"\n"
"...with the name of the temporary file. So, wherever you'd like to put the\n"
"contents of your input window, and the program you run expects a file -- you put\n"
"an '%input', and the program will get its file. For example, say you want to\n"
"count lines in the input window using the standard unix program wc. You'd then\n"
"put something like that on in the command line:\n"
"\n"
"wc -l %input\n"
"\n"
"or\n"
"\n"
"cat %input | wc -l\n"
"\n"
"While running the program, arka catches its stdout into another temporary file,\n"
"and dumps its contents to the 'output' window. The stderr gets caught into yet\n"
"another temp file, and dumped to 'error' window.\n"
"\n"
"\n"
"3.2. Spec files for the command-line programs in the `Programs' menu.\n"
"\n"
"How does arka know how to run a program? The answer is -- it reads its detailed\n"
"descriptions stored in one of the two files, /etc/arkarc (take a look at it),\n"
"and $HOME/.arka/programs. You can write your own spec files for just any\n"
"command-line programs of your choice or create it with the dialog 'Create...'\n"
"from the 'Programs' menu (it will get stored in the ~/.arka/programs file).\n"
"\n"
"Editing and creating spec files should be easy using the 'Edit...' and 'New...'\n"
"dialogs from the 'Programs' menu. If you find those dialogs confusing, mail me\n"
"and tell me why. I sincerly hope that they are self-explanatory. One note only:\n"
"if you edit a program, the description will be saved in your local program\n"
"specs file, $HOME/.arka/programs, and not the global one.\n"
"\n"
"=================================================================================\n"
"\n"
"4. Problems, bugs, maintainer\n"
"\n"
"4.1. Bugs.\n"
"\n"
"I'm sure there are numerous, but I try to fix anything I find. There are two\n"
"problems I am aware at the moment. First, the text windows are not horizontally\n"
"scrollable. This is not a problem of Arka, but of the gtk_text widget. The\n"
"second problem is what I think is a serious memory leak in graph.c. I will fix\n"
"it. Some day. Besides, don't use Arka when you are logged in as root. \n"
"\n"
"There might be some problems with some of the programs from the FASTA package. I\n"
"did not test them all, and FASTA programs as a default run in an interactive\n"
"mode. They do have options for non-interactive mode, however, and I should make\n"
"sure that they do use them. The most important ones (fasta, fastx, tfasta etc.)\n"
"should run fine. Unfortunately, randseq, when run in a non-interactive mode,\n"
"does not feed the output to stdout, so currently arka cannot support it.\n"
"\n"
"4.2. Mail me!\n"
"\n"
"I wonder whether these tools will be useful to anyone but me. On the other hand,\n"
"they are useful for me (I wrote Arka because I couldn't remember all the\n"
"options of the programs I wrote, and because I needed the 3D graph part to\n"
"visualise DNA structures). So, whether you like the program or not, please do\n"
"mail me (like, to save me the effort of writing another README file). My address\n"
"is january@bioinformatics.org; programs homepage is\n"
"http://www.bioinformatics.org/genpak/.\n"
;
