/*-
 * Copyright (c) 2014-2017 Carsten Sonne Larsen <cs@innolan.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Generated with FlexCat. For more information, see:
 * http://sourceforge.net/projects/flexcat/
 *
 * Project homepage:
 * https://amath.innolan.net
 * 
 */

#ifndef AMATH_LOCALE_IDENT_H
#define AMATH_LOCALE_IDENT_H

/**
 * @file  loc/ident.h
 * @brief Help texts for built-in functions
 */

#include "amath.h"
#include "amathc.h"
#include "amatht.h"

static const identhelpdef identtexts[] = {
    { 0, "abs", "No help is available for this function.#NEWLINE#" },
    { 1, "sgn", "No help is available for this function.#NEWLINE#" },
    { 2, "round", "No help is available for this function.#NEWLINE#" },
    { 3, "trunc", "No help is available for this function.#NEWLINE#" },
    { 4, "floor", "No help is available for this function.#NEWLINE#" },
    { 5, "ceil", "No help is available for this function.#NEWLINE#" },
    { 6, "sqr", "No help is available for this function.#NEWLINE#" },
    { 7, "cbr", "No help is available for this function.#NEWLINE#" },
    { 8, "lb", "No help is available for this function.#NEWLINE#" },
    { 9, "ln", "No help is available for this function.#NEWLINE#" },
    { 10, "lg", "No help is available for this function.#NEWLINE#" },
    { 11, "sin", "No help is available for this function.#NEWLINE#" },
    { 12, "cos", "No help is available for this function.#NEWLINE#" },
    { 13, "tan", "No help is available for this function.#NEWLINE#" },
    { 14, "cot", "No help is available for this function.#NEWLINE#" },
    { 15, "sec", "No help is available for this function.#NEWLINE#" },
    { 16, "csc", "No help is available for this function.#NEWLINE#" },
    { 17, "asin", "No help is available for this function.#NEWLINE#" },
    { 18, "acos", "No help is available for this function.#NEWLINE#" },
    { 19, "atan", "No help is available for this function.#NEWLINE#" },
    { 20, "acot", "No help is available for this function.#NEWLINE#" },
    { 21, "asec", "No help is available for this function.#NEWLINE#" },
    { 22, "acsc", "No help is available for this function.#NEWLINE#" },
    { 23, "sinh", "No help is available for this function.#NEWLINE#" },
    { 24, "cosh", "No help is available for this function.#NEWLINE#" },
    { 25, "tanh", "No help is available for this function.#NEWLINE#" },
    { 26, "coth", "No help is available for this function.#NEWLINE#" },
    { 27, "sech", "No help is available for this function.#NEWLINE#" },
    { 28, "csch", "No help is available for this function.#NEWLINE#" },
    { 29, "asinh", "No help is available for this function.#NEWLINE#" },
    { 30, "acosh", "No help is available for this function.#NEWLINE#" },
    { 31, "atanh", "No help is available for this function.#NEWLINE#" },
    { 32, "acoth", "No help is available for this function.#NEWLINE#" },
    { 33, "asech", "No help is available for this function.#NEWLINE#" },
    { 34, "acsch", "No help is available for this function.#NEWLINE#" },
    { 35, "ver", "The versed sine is an early appearing trigonometric function.#NEWLINE#It is equal to one minus the cosine.#NEWLINE#ver(x) = 1 - cos(x)#NEWLINE#" },
    { 36, "vcs", "The versed cosine is an early appearing trigonometric function.#NEWLINE#It is equal to one plus the cosine.#NEWLINE#ver(x) = 1 + cos(x)#NEWLINE#" },
    { 37, "cvs", "The coversed sine is an early appearing trigonometric function.#NEWLINE#It is equal to one minus the sine.#NEWLINE#ver(x) = 1 - sin(x)#NEWLINE#" },
    { 38, "cvc", "The coversed cosine is an early appearing trigonometric function.#NEWLINE#It is equal to one plus the sine.#NEWLINE#cvc(x) = 1 + sin(x)#NEWLINE#" },
    { 39, "hv", "No help is available for the haversed sine function.#NEWLINE#" },
    { 40, "hvc", "No help is available for the haversed cosine function.#NEWLINE#" },
    { 41, "hcv", "No help is available for the hacoversed sine function.#NEWLINE#" },
    { 42, "hcc", "No help is available for the hacoversed cosine function.#NEWLINE#" },
    { 43, "aver", "No help is available for this function.#NEWLINE#" },
    { 44, "avcs", "No help is available for this function.#NEWLINE#" },
    { 45, "acvs", "No help is available for this function.#NEWLINE#" },
    { 46, "acvc", "No help is available for this function.#NEWLINE#" },
    { 47, "ahv", "No help is available for this function.#NEWLINE#" },
    { 48, "ahvc", "No help is available for this function.#NEWLINE#" },
    { 49, "ahcv", "The inverse hacoversed sine is not implemented in this version of amath.#NEWLINE#" },
    { 50, "ahcc", "The inverse hacoversed cosine is not implemented in this version of amath.#NEWLINE#" },
    { 51, "exsec", "No help is available for the exsecant function.#NEWLINE#" },
    { 52, "excsc", "No help is available for the excosecant function.#NEWLINE#" },
    { 53, "aexsec", "No help is available for the inverse exsecant function.#NEWLINE#" },
    { 54, "aexcsc", "No help is available for the inverse excosecant function.#NEWLINE#" },
    { -1, EMPTYSTRING, EMPTYSTRING }
};

#endif
