// printer.cpp
// Revision 20-mar-2004

#include "printer.h"

#include <fstream>
#include <stdio.h>

//***********************************************
//		SpoolPrinter::Internal
//***********************************************

class SpoolPrinter::Internal {
public:
	~Internal ();
	void put (char c);
	void flush ();
private:
	std::string str;
};

SpoolPrinter::Internal::~Internal ()
{
	flush ();
}

void SpoolPrinter::Internal::put (char c)
{
	str+= c;
}

void SpoolPrinter::Internal::flush ()
{
	if (str.empty () )
		return;
	FILE * f= popen ("lp", "w");
	if (f != NULL)
	{
		fwrite (str.data (), 1, str.size (), f);
		pclose (f);
	}
	str.erase ();
}

//***********************************************
//		SpoolPrinter
//***********************************************

SpoolPrinter::SpoolPrinter () :
	pin (new Internal)
{
}

SpoolPrinter::~SpoolPrinter ()
{
	delete pin;
}

void SpoolPrinter::put (char c)
{
	pin->put (c);
}

void SpoolPrinter::flush ()
{
	pin->flush ();
}

//***********************************************
//		FilePrinter::Internal
//***********************************************

class FilePrinter::Internal {
public:
	Internal (const std::string & filename);
	void put (char c);
	void flush ();
private:
	const std::string filename;
	bool opened;
	std::ofstream file;
};

FilePrinter::Internal::Internal (const std::string & filename) :
	filename (filename),
	opened (false)
{
}

void FilePrinter::Internal::put (char c)
{
	if (! opened)
	{
		file.open (filename.c_str () );
		if (! file.is_open () )
			throw "Error opening printer file";
		opened= true;
	}
	file.put (c);
}

void FilePrinter::Internal::flush ()
{
	if (opened)
		file.flush ();
}

//***********************************************
//		FilePrinter
//***********************************************

FilePrinter::FilePrinter (const std::string & filename) :
	pin (new Internal (filename) )
{
}

FilePrinter::~FilePrinter ()
{
	delete pin;
}

void FilePrinter::put (char c)
{
	pin->put (c);
}

void FilePrinter::flush ()
{
	pin->flush ();
}

// End of printer.cpp
