#ifndef INCLUDE_CPU_H
#define INCLUDE_CPU_H

// cpu.h
// Revision 13-may-2005


#if ! defined USE_ImcZ80 || defined DISASM_WITH_libz80

extern "C" {

#include "z80.h"
}

#endif


//#ifdef USE_ImcZ80

#include "Z80.hxx"

//#endif


#ifdef USE_ImcZ80

typedef word z80word;

#else

typedef ushort z80word;

#endif


#include <vector>
// ostream not available in some versions of gcc.
//#include <ostream>
#include <iostream>


class Cpu : private ImcZ80 {
private:
	int self;
	static std::vector <Cpu *> vi;
	static int putvi (Cpu *);
protected:
	byte mem [65536];
private:
	static byte memread (int param, z80word address);
	static void memwrite (int param, z80word address, byte data);
	static byte ioread (int param, z80word address);
	static void iowrite (int param, z80word address, byte data);
public:
	byte memread (z80word address) const;
	z80word memreadw (z80word address) const;
	void memwrite (z80word address, byte data);
	void memwritew (z80word address, z80word data);

	void clear_all_mem (byte value);

	#if ! defined USE_ImcZ80 || defined DISASM_WITH_libz80

private:
	Z80Context z;

	#endif

	#ifndef USE_ImcZ80

public:
	#if 0
	static byte flag_c (byte f) { return f & F_C; }
	static byte flag_n (byte f) { return f & F_N; }
	static byte flag_pv (byte f) { return f & F_PV; }
	static byte flag_h (byte f) { return f & F_H; }
	static byte flag_z (byte f) { return f & F_Z; }
	static byte flag_s (byte f) { return f & F_S; }
	#endif

	byte get_a () { return z.R1.br.A; }
	byte get_f () { return z.R1.br.F; }
	byte get_b () { return z.R1.br.B; }
	byte get_c () { return z.R1.br.C; }
	byte get_d () { return z.R1.br.D; }
	byte get_e () { return z.R1.br.E; }
	byte get_h () { return z.R1.br.H; }
	byte get_l () { return z.R1.br.L; }

	void set_a (byte v) { z.R1.br.A= v; }
	void set_f (byte v) { z.R1.br.F= v; }
	void set_b (byte v) { z.R1.br.B= v; }
	void set_c (byte v) { z.R1.br.C= v; }
	void set_d (byte v) { z.R1.br.D= v; }
	void set_e (byte v) { z.R1.br.E= v; }
	void set_h (byte v) { z.R1.br.H= v; }
	void set_l (byte v) { z.R1.br.L= v; }

	z80word get_af () { return z.R1.wr.AF; }
	z80word get_bc () { return z.R1.wr.BC; }
	z80word get_de () { return z.R1.wr.DE; }
	z80word get_hl () { return z.R1.wr.HL; }
	z80word get_ix () { return z.R1.wr.IX; }
	z80word get_iy () { return z.R1.wr.IY; }
	z80word get_sp () { return z.R1.wr.SP; }
	z80word get_pc () { return z.PC; }

	void set_af (z80word v) { z.R1.wr.AF= v; }
	void set_bc (z80word v) { z.R1.wr.BC= v; }
	void set_de (z80word v) { z.R1.wr.DE= v; }
	void set_hl (z80word v) { z.R1.wr.HL= v; }
	void set_ix (z80word v) { z.R1.wr.IX= v; }
	void set_iy (z80word v) { z.R1.wr.IY= v; }
	void set_sp (z80word v) { z.R1.wr.SP= v; }
	void set_pc (z80word v) { z.PC= v; }

	#else

private:
	// Virtual functions required for ImcZ80.
	int interrupt ()
	{
		return 0;
	}
	//unsigned int out (unsigned long time, byte hi, byte lo, byte val)
	unsigned int out (unsigned long, byte, byte, byte)
	{
		// Returns the number of wait states.
		return 0;
	}
	//unsigned int in (unsigned long time,
	//	unsigned long hi, unsigned long lo)
	unsigned int in (unsigned long,
		unsigned long, unsigned long)
	{
		// Returns the value readed from the port plus the
		// number of wait states << 8.
		return 0;
	}
	void EDFE ()
	{ }
	void EDFD ()
	{ }
	//void startwatch (int flag)
	void startwatch (int)
	{ }
	long stopwatch ()
	{
		return 0;
	}

public:
	// Registers access.

	//typedef unsigned short z80word;
	// Already defined.

	#if 0
	static byte flag_c (byte f) { return f & FLG_C; }
	static byte flag_n (byte f) { return f & FLG_N; }
	static byte flag_pv (byte f) { return f & FLG_PV; }
	static byte flag_h (byte f) { return f & FLG_H; }
	static byte flag_z (byte f) { return f & FLG_Z; }
	static byte flag_s (byte f) { return f & FLG_S; }
	#endif

	byte get_a () { return a; }
	byte get_f () { return f; }
	byte get_b () { return b; }
	byte get_c () { return c; }
	byte get_d () { return d; }
	byte get_e () { return e; }
	byte get_h () { return h; }
	byte get_l () { return l; }

	void set_a (byte v) { a= v; }
	void set_f (byte v) { f= v; }
	void set_b (byte v) { b= v; }
	void set_c (byte v) { c= v; }
	void set_d (byte v) { d= v; }
	void set_e (byte v) { e= v; }
	void set_h (byte v) { h= v; }
	void set_l (byte v) { l= v; }

	z80word get_af () { return (a << 8) | f; }
	z80word get_bc () { return (b << 8) | c; }
	z80word get_de () { return (d << 8) | e; }
	z80word get_hl () { return (h << 8) | l; }
	z80word get_ix () { return ix; }
	z80word get_iy () { return iy; }
	z80word get_sp () { return sp; }
	z80word get_pc () { return pc; }

	void set_af (z80word v) { a= (v >> 8); f= v & 0xFF; }
	void set_bc (z80word v) { b= (v >> 8); c= v & 0xFF; }
	void set_de (z80word v) { d= (v >> 8); e= v & 0xFF; }
	void set_hl (z80word v) { h= (v >> 8); l= v & 0xFF; }
	void set_ix (z80word v) { ix= v; }
	void set_iy (z80word v) { iy= v; }
	void set_sp (z80word v) { sp= v; }
	void set_pc (z80word v) { pc= v; }

private:
	// Memory access
	byte fetch (z80word x)
	{
		return mem [x];
	}
	void store (z80word x, byte y)
	{
		mem [x]= y;
	}

	#endif

private:
	#ifndef USE_ImcZ80
	enum Flag { FlagC= F_C, FlagN= F_N, FlagPV= F_PV, FlagH= F_H,
		FlagZ= F_Z, FlagS= F_S };
	#else
	enum Flag { FlagC= FLG_C, FlagN= FLG_N, FlagPV= FLG_PV, FlagH= FLG_H,
		FlagZ= FLG_Z, FlagS= FLG_S };
	#endif

	bool get_flag (Flag flag) { return get_f () & flag; }
	void set_flag (Flag flag, bool value)
	{
		byte f= get_f ();
		if (value)
			f|= byte (flag);
		else
			f&= ~ byte (flag);
		set_f (f);
	}

public:
	bool flag_c () { return get_flag (FlagC); }
	bool flag_n () { return get_flag (FlagN); }
	bool flag_pv () { return get_flag (FlagPV); }
	bool flag_h () { return get_flag (FlagH); }
	bool flag_z () { return get_flag (FlagZ); }
	bool flag_s () { return get_flag (FlagS); }

	void setflag_c (bool value) { set_flag (FlagC, value); }
	void setflag_n (bool value) { set_flag (FlagN, value); }
	void setflag_pv (bool value) { set_flag (FlagPV, value); }
	void setflag_h (bool value) { set_flag (FlagH, value); }
	void setflag_z (bool value) { set_flag (FlagZ, value); }
	void setflag_s (bool value) { set_flag (FlagS, value); }

public:
	Cpu ();
	virtual ~Cpu ();

	#if defined USE_ImcZ80 && defined DISASM_WITH_libz80
	void aux_set_pc (z80word npc)
	{ z.PC= npc; }
	#endif

	#if ! defined USE_ImcZ80 || defined DISASM_WITH_libz80
	void disassembly (std::ostream & out);
	#else
	z80word disassembly (std::ostream & out);
	z80word disassembly (std::ostream & out, z80word pos);
	#endif

	void execute ()
	{
		#ifndef USE_ImcZ80

		Z80Execute (& z);

		#else

		ImcZ80::execute ();

		#endif
	}
	void reset ()
	{
		#ifdef USE_ImcZ80
		ImcZ80::reset ();
		#endif
	}
};

class Hex2 {
public:
	Hex2 (byte b) : b (b)
	{ }
	byte getb () const
	{ return b; }
private:
	byte b;
};

class Hex4 {
public:
	Hex4 (z80word n) : n (n)
	{ }
	z80word getn () const
	{ return n; }
private:
	z80word n;
};

inline Hex2 hex2 (byte b)
{ return Hex2 (b); }

inline Hex4 hex4 (z80word n)
{ return Hex4 (n); }

std::ostream & operator << (std::ostream & os, const Hex2 & h2);
std::ostream & operator << (std::ostream & os, const Hex4 & h4);


#endif

// End of cpu.h
