## ait - small yet mighty GNU Emacs style editor

ait is inspired by GNU Emacs, [acme](https://acme.cat-v.org/),
[mle](https://github.com/adsr/mle), microEMACS,
[mg](https://man.openbsd.org/mg), and vi/vim/neovim.
Based on [Atto](https://github.com/hughbarney/atto/). Started as a fork of Atto
but was then ported to [Termbox2](https://github.com/termbox/termbox2) to become
what it is now. ait can be compiled with no dependencies other than libc. It
should work on all unix-like systems although at this point it only works on
GNU/Linux (glibc & musl), macOS, FreeBSD, and NetBSD.

## Features
- Emacs-like keybindings (see key.c)
- basic window/buffer support
- isearch
- find/replace
- M-x to run shell commands
  - shell commands are either inserted at the point or replace the region.
  For example, if you ran the `scripts/spell` command on a word, it would
  replace the word.
- M-o to open files with external command
- basic unlimited undo/redo
- keyboard macros
- jump/zap to char
- bracket highlighting
- syntax highlighting (see buffer.c & hilite.c & syntax.h)
- quick jump to line and word (similar to [avy](https://github.com/abo-abo/avy))
- UTF-8/Unicode Support
- GNU Emacs-like kill ring

## Goals
- simplicity but don't suck
- portability
- reasonably small
- support the most important core GNU Emacs keybinding
- UTF8 & unicode
- don't reinvent the wheel
- don't be total trash

## Non-goals
- customizability
- extension language
- be Emacs
- be Vim
- IDE-like features
- rewriting things that work

## Abstract
The purpose of this editor is to be similar enough to Emacs but
without the extra stuff. It focuses on using the existing system to do
things, and having smaller footprint without lacking in important
editor features. To do this, most of the keybindings are the vanilla
Emacs bindings with a few exceptions, having similar buffer and cursor
controls, and having a familiar look. Instead of rewriting everything
in C, ait allows you to use shell commands as an pseudo-extension
language. See `scripts/` for more information.

The codebase comes from 2 other authors, most of which was written back in the
90s. That being said, some of the code is clearly outdated but since it works,
I have no desire to rewrite it. There is also no reason for me to support things
that I don't actually use or things that can easily be done using an existing
function. For example, multiple cursors is really great but a complicated
feature to add when most situations can be solved using keyboard macros.

## Why the name ait?
ait stands for Atto In Termbox or Atto Implemented in Termbox. Also, an
[ait](https://en.wikipedia.org/wiki/Ait) is a small island usually found in
rivers. I thought about calling it simply At but there is already a program
called `at`<sup>[1](https://man.netbsd.org/at.1) [2](https://man.openbsd.org/at.1)
[3](https://man.freebsd.org/cgi/man.cgi?query=at&apropos=0&sektion=0&manpath=FreeBSD+13.2-RELEASE+and+Ports&arch=default&format=html)
[4](https://linux.die.net/man/1/at) [5](https://ss64.com/osx/at.html)</sup>. My wife
also came up with the name of aint, standing for Atto IN Termbox and having the
catch phrase of "because it ain't your editor."

## Derivation
From Atto's README: _"Atto is based on the public domain code of Anthony Howe's
editor (commonly known as Anthony's Editor or AE, [2]).  Rather than representing
a file as a linked list of lines, the AE Editor uses the concept of a Buffer-Gap
[4,5,6].  A Buffer-Gap editor stores the file in a single piece of contiguous
memory with some extra unused space known as the buffer gap.  On character
insertion and deletion the gap is first moved to the current point.  A character
deletion then extends the gap by moving the gap pointer back by 1 OR the gap is
reduced by 1 when a character is inserted.  The Buffer-Gap technique is elegant
and significantly reduces the amount of code required to load a file, modify it
and redraw the display.  The proof of this is seen when you consider that Atto
supports almost the same command set that Pico supports,  but Pico requires
almost 17 times the amount of code."_

ait comes from Atto so the derivation is trival. I just ported it to termbox and
started hacking in my own changes for fun.

## Known Issues
See [issues](https://notabug.org/nuclearkev/ait/issues).

## Copying
ait code is released under the BSD 3-Clause License. Atto code is released to
the public domain. Anthony's Editor code claims to be public domain but
contains a questionable (see AE_LICENSE) license that isn't actually public
domain. See the LICENSE file for the offical statements.

## Acknowledgements
Hugh Barney for writing Atto.

Anthony Howe for writing Anthony's Editor.

GNU Emacs for keybindings, power, and inspritation.

Plan 9's acme for inspiration.

mle for inspiration and guidance.

Termbox2 for being nice.

Adam Saponara for making the previous 2.
