/*  $Id: Controller.cpp,v 1.14 2012/07/14 04:46:56 sarrazip Exp $
    Controller.h - Source of commands from the user.

    afternoonstalker - A robot-killing video game.
    Copyright (C) 2001-2012 Pierre Sarrazin <http://sarrazip.com/>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public
    License along with this program; if not, write to the Free
    Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA  02110-1301, USA.
*/

#include "Controller.h"


Controller::Controller()
  : menuKS(SDLK_ESCAPE),
    leftKS(SDLK_LEFT),
    rightKS(SDLK_RIGHT),
    upKS(SDLK_UP),
    downKS(SDLK_DOWN),
    selectKS(SDLK_SPACE, SDLK_RETURN),
    shootKS(SDLK_LCTRL, SDLK_RCTRL),
    pauseKS(SDLK_p),
    shootLeftKS(SDLK_h),
    shootRightKS(SDLK_l),
    shootUpKS(SDLK_k),
    shootDownKS(SDLK_j),
    fullScreenKS(SDLK_F11),
    joystick(),
    shootLeftBI(flatzebra::Joystick::X_BTN),
    shootRightBI(flatzebra::Joystick::B_BTN),
    shootUpBI(flatzebra::Joystick::Y_BTN),
    shootDownBI(flatzebra::Joystick::A_BTN),
    startBI(flatzebra::Joystick::START_BTN),
    pauseBI(flatzebra::Joystick::BACK_BTN)
{
}


Controller::~Controller()
{
}


void
Controller::processKey(SDLKey keysym, bool pressed)
{
    menuKS.check(keysym, pressed);
    leftKS.check(keysym, pressed);
    rightKS.check(keysym, pressed);
    upKS.check(keysym, pressed);
    downKS.check(keysym, pressed);
    selectKS.check(keysym, pressed);
    shootKS.check(keysym, pressed);
    pauseKS.check(keysym, pressed);
    shootLeftKS.check(keysym, pressed);
    shootDownKS.check(keysym, pressed);
    fullScreenKS.check(keysym, pressed);
    shootUpKS.check(keysym, pressed);
    shootRightKS.check(keysym, pressed);
}


void
Controller::update()
{
    menuKS.remember();
    leftKS.remember();
    rightKS.remember();
    upKS.remember();
    downKS.remember();
    selectKS.remember();
    shootKS.remember();
    pauseKS.remember();
    shootLeftKS.remember();
    shootRightKS.remember();
    shootUpKS.remember();
    shootDownKS.remember();
    fullScreenKS.remember();

    joystick.update();
}
