# Third Party Licenses

The pure Python code for computing the MFCCs
`aeneas/mfcc.py`
is a modified version from the
[CMU Sphinx3 project](http://cmusphinx.sourceforge.net/).
See [licenses/sphinx3.txt](https://raw.githubusercontent.com/readbeyond/aeneas/master/licenses/sphinx3.txt) for details.

The pure Python code for reading and writing WAVE files 
`aeneas/wavfile.py`
is a slightly modified version from the
[scipy project](https://github.com/scipy/scipy/),
included here to avoid installing the whole `scipy` package.
See [licenses/scipy.txt](https://raw.githubusercontent.com/readbeyond/aeneas/master/licenses/scipy.txt) for details.

The C header `speak_lib.h` for the Python C extension `cew`
is a verbatim copy from the
[espeak project](http://espeak.sourceforge.net/).
See [licenses/eSpeak.txt](https://raw.githubusercontent.com/readbeyond/aeneas/master/licenses/eSpeak.txt) for details.

The C++ headers in `festival` and `speech_tools` for the Python C++ extension `cfw`
are verbatim copies from the
[Festival project](http://www.cstr.ed.ac.uk/projects/festival/)
and the
[Edinburgh Speech Tools Library project](http://www.cstr.ed.ac.uk/projects/speech_tools/).
See
[licenses/Festival.txt](https://raw.githubusercontent.com/readbeyond/aeneas/master/licenses/Festival.txt)
and
[licenses/speech_tools.txt](https://raw.githubusercontent.com/readbeyond/aeneas/master/licenses/EST.txt)
for details.

The HTML file `aeneas/res/finetuneas.html`
is a verbatim copy from the
[finetuneas project](https://github.com/ozdefir/finetuneas),
courtesy of Firat Ozdemir.
See [licenses/finetuneas.txt](https://raw.githubusercontent.com/readbeyond/aeneas/master/licenses/finetuneas.txt) for details.

Audio files contained in the unit tests `aeneas/tests/res/` directory
are adapted from recordings produced by
the [LibriVox Project](http://www.librivox.org)
and they are in the public domain.
See [licenses/LibriVox.txt](https://raw.githubusercontent.com/readbeyond/aeneas/master/licenses/LibriVox.txt) for details.

Text files contained in the unit tests `aeneas/tests/res/` directory
are adapted from files produced by
the [Project Gutenberg](http://www.gutenberg.org)
and they are in the public domain.
See [licenses/ProjectGutenberg.txt](https://raw.githubusercontent.com/readbeyond/aeneas/master/licenses/ProjectGutenberg.txt) for details.

