#!perl -W

use warnings;
use XML::LibXML;

my $top_srcdir=shift @ARGV;
open CFILE,">${top_srcdir}/admsXml/xmlXpath.c";

my@grammar=XML::LibXML->new->parse_file ("$top_srcdir/admstpath.xml")->getDocumentElement->findnodes("/admstpath");
my$document=$grammar[0]->ownerDocument->getDocumentElement;
my@regexp=$document->findnodes("/admstpath/lex/regexp");
my@terminal=$document->findnodes("/admstpath/lex/terminal");
my@constant=$document->findnodes("/admstpath/lex/constant");
my@ignore=$document->findnodes("/admstpath/lex/ignore");
my@productionset=$document->findnodes("/admstpath/yacc/productionset");
my@code=$document->findnodes("/admstpath/yacc/code");
my%terminal;
my%constant;
map{$terminal{$_->getAttribute("id")}=1;} @terminal;
map{$constant{$_->getAttribute("id")}=1;} @constant;

print CFILE "\n/* ------- code automatically created by $0 -------------- */\n\n";

#build goto semantic
print CFILE "\n";
my$index=0;
while(@code)
{
  my$code=shift @code;
  my$id=$code->getAttribute("id");
  my$inside=$code->getAttribute("inside")?$code->getAttribute("inside"):"";
  my$cdata=$code->findnodes("child::text()[position()=2]")->[0]->textContent();
  if($inside =~ /(condition)/)
  {
    print CFILE "static inline void adms_admst_semantic_$id (p_admstpathevaluate myadmstpathevaluate,p_slist mylocation,p_admst mycuradmst,char**mytext,p_admstpathevaluate mylocaladmstpathevaluate[])\n";
  }
  elsif($inside =~ /(location)/)
  {
    print CFILE "static inline void adms_admst_semantic_$id (p_admstpathevaluate myadmstpathevaluate,p_admst mycuradmst,char**mytext,p_admstpathevaluate mylocaladmstpathevaluate[],p_slist* mynewlocationptr)\n";
  }
  elsif($id eq "root")
  {
    print CFILE "static inline p_admst adms_admst_semantic_$id (p_admstpathevaluate myadmstpathevaluate,p_admst mycuradmst,char**mytext)\n";
  }
  elsif($id =~ /(postcondition)/)
  {
    print CFILE "static inline p_slist adms_admst_semantic_$id (p_admstpathevaluate myadmstpathevaluate,p_slist mynewlocation,char**mytext)\n";
  }
  else
  {die;}
  $cdata=~s/(.*)\n\s*/$1/s;
  if($inside =~ /(location)/)
  {
    print CFILE "{$cdata\n  adms_message_dbg_xml((\"       s=$id\\n\"))\n}\n";
  }
  elsif($id eq "root")
  {
    print CFILE "{$cdata\n  adms_message_dbg_xml((\"       s=$id\\n\"))\n  return mynewadmst;\n}\n";
  }
  else
  {
    print CFILE "{$cdata\n  adms_message_dbg_xml((\"       s=$id\\n\"))\n}\n";
  }
}

#build goto parse
print CFILE "
#define adms_admstpathparse_lookahead \\
  const char* mystringposition=adms_admstpathparser_valueof_stringposition(myadmstpathparser);\\
  e_admstpathparser_token mytoken=adms_admstpathparser_valueof_token(myadmstpathparser);\\
  const char* mytokenstrstart=adms_admstpathparser_valueof_tokenstrstart(myadmstpathparser);\\
  int mytokenstrlen=adms_admstpathparser_valueof_tokenstrlen(myadmstpathparser);
#define adms_admstpathparse_reject \\
{\\
  adms_admstpathparser_valueto_stringposition(myadmstpathparser,mystringposition);\\
  adms_admstpathparser_valueto_token(myadmstpathparser,mytoken);\\
  adms_admstpathparser_valueto_tokenstrstart(myadmstpathparser,mytokenstrstart);\\
  adms_admstpathparser_valueto_tokenstrlen(myadmstpathparser,mytokenstrlen);\\
}
static inline void adms_admstpathparse_donotreach (p_admstpathparser myadmstpathparser)
{
  adms_message_fatal((\"%s: %s: invalid admstpath expression\\n\",
    adms_admsttransform_uid(adms_admstpathparser_valueof_admsttransform(myadmstpathparser)),
    adms_quark_valueof_value(adms_admstpathparser_valueof_admstpath(myadmstpathparser))))
}
static void adms_admstpathparse_lex(p_admstpathparser myadmstpathparser)
{
  const char* t=adms_admstpathparser_valueof_stringposition(myadmstpathparser);
  const char* tstart;";
my@ignored; map{push @ignored,$_->getAttribute("regexp")} @ignore;
my$ignored=join "||",@ignored;
print CFILE "
  while($ignored) t++;
  tstart=t;
  if (0) {}";
while(@constant)
{
  my$constant=shift @constant;
  my$token=$constant->getAttribute("id");
  my$regexp=$constant->getAttribute("regexp");
  print CFILE "
  else if(!strncmp(t,\"$regexp\",".length($regexp)."))
  {
    t+=".length($regexp)."; adms_admstpathparser_valueto_token(myadmstpathparser,adms_admstpathparser_enumeration_token_$token);
  }";
}
while(@regexp)
{
  my$regexp=shift @regexp;
  my$cdata=$regexp->findnodes("child::text()[position()=2]")->[0]->textContent();
  print CFILE $cdata;
}
print CFILE "
  else
  {
    adms_message_fatal((\"%s: invalid admstpath expression - unexpected string '%s'\\n\",
    adms_admsttransform_uid(adms_admstpathparser_valueof_admsttransform(myadmstpathparser)),
    adms_quark_valueof_value(adms_admstpathparser_valueof_admstpath(myadmstpathparser))))
  }
  adms_admstpathparser_valueto_stringposition(myadmstpathparser,t);
  return;
}
";
print CFILE "\n";
print CFILE "#define _t_goto_parse(function) static p_slist (function) (p_admstpathparser myadmstpathparser)\n";
foreach my$productionset(@productionset)
{
  my@productions=$productionset->findnodes("production");
  my$gotoname=$productionset->getAttribute("id");
  print CFILE "_t_goto_parse(parse_$gotoname);\n";
}
foreach my$productionset(@productionset)
{
  my@productions=$productionset->findnodes("production");
  my$gotoname=$productionset->getAttribute("id");
  print CFILE "_t_goto_parse(parse_$gotoname)
\{
  adms_admstpathparse_lookahead
";
  my%index;
  my$gotoindex=0;
  while(@productions)
  {
    $gotoindex++;
    my$production=shift @productions;
    my@prodems=$production->findnodes("prodem");
    print CFILE "  {\n";
    my$myindexterminal=0;
    my$nbterminal=0;foreach my$prodem(@prodems)
    {
      my$token=$prodem->getAttribute("linktotoken");
      if($terminal{$token})
      {
        $index{\$token}=$nbterminal;
        $nbterminal++;
        $myindexterminal++;
      }
    }
    print CFILE "    p_slist myl=NULL;\n";
    @prodems=$production->findnodes("prodem");
    my$mylc_required=0;
    foreach(@prodems)
    {
      my$token=$_->getAttribute("linktotoken");
      $mylc_required=1 if(!$constant{$token}&&!$terminal{$token});
    }
    print CFILE "    p_slist mylc=NULL;\n" if($mylc_required);
    print CFILE "    char**mytext=malloc(($nbterminal+1)*sizeof(char*));\n";
    print CFILE "    mytext[$nbterminal]=NULL;\n";
    $myindexterminal=0;
    while(@prodems)
    {
      my$prodem=shift @prodems;
      my$token=$prodem->getAttribute("linktotoken");
      if($constant{$token})
      {
        print CFILE "    if(adms_admstpathparser_valueof_token(myadmstpathparser)==adms_admstpathparser_enumeration_token_$token)\n";
        print CFILE "    {\n";
        print CFILE "      adms_admstpathparse_lex(myadmstpathparser);\n";
      }
      elsif($terminal{$token})
      {
        print CFILE "    if(adms_admstpathparser_valueof_token(myadmstpathparser)==adms_admstpathparser_enumeration_token_$token)\n";
        print CFILE "    {\n";
        print CFILE "      mytext[$myindexterminal]=adms_constnclone(adms_admstpathparser_valueof_tokenstrstart(myadmstpathparser),adms_admstpathparser_valueof_tokenstrlen(myadmstpathparser));\n";
        print CFILE "      adms_admstpathparse_lex(myadmstpathparser);\n";
        $myindexterminal++;
      }
      else
      {
        print CFILE "    if((mylc=parse_$token(myadmstpathparser)))\n";
        print CFILE "    {\n";
        print CFILE "      adms_slist_concat(&myl,mylc);\n";
      }
      if(not@prodems)
      {
        print CFILE "      adms_slist_push(&myl,adms_adms(adms_admstpathgoto_new(\"$gotoname\",$gotoindex,mytext)));\n";
        print CFILE "      return myl;\n";
      }
    }
    print CFILE "    ";
    foreach my$prodem ($production->findnodes("prodem")) {print CFILE "}";}
    print CFILE "\n  }\n";
    print CFILE "  adms_admstpathparse_reject\n";
  }
  $gotoindex++;
  my@empty=$productionset->findnodes("empty");
  if(@empty)
  {
    print CFILE "  {\n";
    print CFILE "    char**mytext=malloc(sizeof(char*));\n";
    print CFILE "    p_slist myl=NULL;\n";
    print CFILE "    mytext[0]=NULL;\n";
    print CFILE "    adms_slist_push(&myl,adms_adms(adms_admstpathgoto_new(\"$gotoname\",$gotoindex,mytext)));\n";
    print CFILE "    return myl;\n";
    print CFILE "  }\n";
  }
  else
  {
    print CFILE "  adms_admstpathparse_donotreach(myadmstpathparser);\n";
    print CFILE "  return NULL;\n";
  }
  print CFILE "}\n";
}

#build goto macros
print CFILE "\n";
print CFILE "/*admstpathevaluate*/\n";
print CFILE "
#define _t_goto_evaluate_local(function) inline p_admstpathevaluate (function)(p_admstpathevaluate myadmstpathevaluate,p_admst mycuradmst)
#define _t_goto_evaluate(function) inline void (function)(p_admstpathevaluate myadmstpathevaluate,p_admst mycuradmst)
#define _t_goto_evaluate_location(function) inline void (function)(p_admstpathevaluate myadmstpathevaluate,p_admst mycuradmst,p_slist *mynewlocationptr)
#define _t_goto_evaluate_binary(function) inline void (function) (p_admstpathevaluate myadmstpathevaluate,p_slist mylocation,p_admst mycuradmst)\n";
foreach my$productionset(@productionset)
{
  my@productions=$productionset->findnodes("production");
  my$gotoname=$productionset->getAttribute("id");
  if($gotoname =~ /(root)/)
  {
    print CFILE "_t_goto_evaluate(admstpathevaluate_${gotoname});\n";
    print CFILE "_t_goto_evaluate_local(admstpathevaluate_local_$gotoname);\n";
  }
  elsif($gotoname =~ /(admstpath)/)
  {
    print CFILE "_t_goto_evaluate(admstpathevaluate_$gotoname);\n";
  }
  elsif($gotoname =~ /(location)/)
  {
    print CFILE "_t_goto_evaluate_location(admstpathevaluate_$gotoname);\n";
  }
  elsif($gotoname =~ /(condition)|(expression)|(binary)|(unary)/)
  {
    print CFILE "_t_goto_evaluate_binary(admstpathevaluate_$gotoname);\n";
  }
  else
  {die;}
}
print CFILE "
#define _t_goto_evaluate_empty(function) static void (function)(p_admstpathevaluate myadmstpathevaluate)\n";
foreach my$productionset(@productionset)
{
  my@productions=$productionset->findnodes("production");
  my$gotoname=$productionset->getAttribute("id");
  print CFILE "_t_goto_evaluate_empty(admstpathevaluate_${gotoname}_empty);\n";
}
print CFILE "\n";
foreach my$productionset(@productionset)
{
  my@productions=$productionset->findnodes("production");
  my$gotoname=$productionset->getAttribute("id");
  my$gotoindex=0;
  print CFILE "_t_goto_evaluate_empty(admstpathevaluate_${gotoname}_empty)\n";
  print CFILE "{\n";
  print CFILE "  p_admstpathgoto myadmstpathgoto=adms_admstpathgoto((*(myadmstpathevaluate->_admstpathgotonode))->data);\n";
  print CFILE "  int mygotoindex=myadmstpathgoto->_gotoindex;\n";
  print CFILE "  adms_message_dbg_xml((\"       r=%s gotoindex=%i\\n\",myadmstpathgoto->_gotoname,mygotoindex))\n";
  print CFILE "  *(myadmstpathevaluate->_admstpathgotonode)=(*(myadmstpathevaluate->_admstpathgotonode))->next;\n";
  if($gotoname =~ /(location)/)
  {
    print CFILE "  adms_admstpathevaluate_valueto_admstaslist(myadmstpathevaluate,NULL);\n";
  }
  print CFILE "  if(0)\n";
  print CFILE "  {}\n";
  while(@productions)
  {
    $gotoindex++;
    my$production=shift @productions;
    print CFILE "  else if(mygotoindex==$gotoindex)\n";
    print CFILE "  {\n";
    my@prodems=$production->findnodes("prodem");
    my$hassemantic=0;
    while(@prodems)
    {
      my$prodem=shift @prodems;
      my$token=$prodem->getAttribute("linktotoken");
      if($constant{$token})
      {}
      elsif($terminal{$token})
      {}
      else
      {
        print CFILE "    admstpathevaluate_${token}_empty(myadmstpathevaluate);\n";
      }
      my@semantics=$prodem->findnodes("semantic");
      $hassemantic=scalar(@semantics);
    }
    @prodems=$production->findnodes("prodem");
    print CFILE "  }\n";
  }
  $gotoindex++;
  my@empty=$productionset->findnodes("empty");
  if(@empty)
  {
    print CFILE "  else if(mygotoindex==$gotoindex)\n";
    print CFILE "  {\n";
    print CFILE "  }\n";
  }
  print CFILE "  else\n";
  print CFILE "  {\n";
  print CFILE "    adms_message_fatal_continue((\"program aborted at goto=$gotoname(%s.%i) - pls contact developpers\\n\",myadmstpathgoto->_gotoname,mygotoindex))\n";
  print CFILE "    adms_message_fatal((\"see %s\\n\",adms_admsttransform_uid(myadmstpathevaluate->_admsttransform)))\n";
  print CFILE "  }\n";
  print CFILE "}\n";
}
print CFILE "
_t_goto_evaluate_local(admstpathevaluate_local_admstroot)
{
  p_admstpathevaluate mynewadmstpathevaluate=adms_admstpathevaluate_new(myadmstpathevaluate->_admsttransform,myadmstpathevaluate->_admsttransformattribute);
  adms_admstpathevaluate_valueto_admstasscalar(mynewadmstpathevaluate,NULL);
  adms_admstpathevaluate_valueto_admstasscalarfixme(mynewadmstpathevaluate,NULL);
  adms_admstpathevaluate_valueto_admstaslist(mynewadmstpathevaluate,NULL);
  mynewadmstpathevaluate->_admstpathgotonode=myadmstpathevaluate->_admstpathgotonode;
  admstpathevaluate_admstroot(mynewadmstpathevaluate,mycuradmst);
  return mynewadmstpathevaluate;
}\n";

#inside goto: call semantic
sub semantic
{
  my@semantics=shift->findnodes("semantic");
  my$gotoname=shift;
  my$nblocallocation=shift;
  foreach my$semantic (@semantics)
  {
    my$id=$semantic->getAttribute("linktocode");
    my@code=$document->findnodes("/admstpath/yacc/code[\@id='$id']");
    my$text=$code[0]->textContent();
    if($id eq "root")
    {
      print CFILE "    mypreviouslocation=adms_admst_semantic_$id(myadmstpathevaluate,mypreviouslocation,myadmstpathgoto->_text);\n";
    }
    elsif($id =~ /(postcondition)/)
    {
      print CFILE "    mynewlocation=adms_admst_semantic_$id(myadmstpathevaluate,mynewlocation,myadmstpathgoto->_text);\n";
    }
    elsif($gotoname =~ /(admstpath)/)
    {
      print CFILE "    mynewlocation=adms_admst_semantic_$id(myadmstpathevaluate,mynewlocation,myadmstpathgoto->_text);\n";
    }
    elsif($gotoname =~ /(location)/)
    {
      if($nblocallocation)
      {
        print CFILE "    adms_admst_semantic_$id(myadmstpathevaluate,mycuradmst,myadmstpathgoto->_text,mylocaladmstpathevaluate,mynewlocationptr);\n";
      }
      else
      {
        print CFILE "    adms_admst_semantic_$id(myadmstpathevaluate,mycuradmst,myadmstpathgoto->_text,NULL,mynewlocationptr);\n";
      }
    }
    elsif($gotoname =~ /(condition)|(binary)/)
    {
      print CFILE "    adms_admst_semantic_$id(myadmstpathevaluate,mylocation,mycuradmst,myadmstpathgoto->_text,NULL);\n";
    }
    elsif($gotoname =~ /(unary)/)
    {
      if($nblocallocation)
      {
        print CFILE "    adms_admst_semantic_$id(myadmstpathevaluate,mylocation,mycuradmst,myadmstpathgoto->_text,mylocaladmstpathevaluate);\n";
      }
      else
      {
        print CFILE "    adms_admst_semantic_$id(myadmstpathevaluate,mylocation,mycuradmst,myadmstpathgoto->_text,NULL);\n";
      }
    }
    elsif($id =~ /(admstpath)/)
    {
      print CFILE "    return adms_admst_semantic_$id(myadmstpathevaluate,mynewlocation,myadmstpathgoto->_text);\n";
    }
    else
    {
      die;
    }
  }
}
print CFILE "
inline void code1 (char**mytext,p_admstpathevaluate myadmstpathevaluate,p_admst mypreviousadmst)
{
  p_slist mynewlocation=NULL;
  admstpathevaluate_location(myadmstpathevaluate,mypreviousadmst,&mynewlocation);
  if(mynewlocation==NULL)
    admstpathevaluate_condition_empty(myadmstpathevaluate);
  else
  {
    p_slist myadmstlist;
    p_slist myadmstpathgotonode=*(myadmstpathevaluate->_admstpathgotonode);
    for(myadmstlist=mynewlocation;myadmstlist;myadmstlist=myadmstlist->next)
    {
      p_admst myadmst=adms_admst(myadmstlist->data);
      *(myadmstpathevaluate->_admstpathgotonode)=myadmstpathgotonode;
      admstpathevaluate_condition(myadmstpathevaluate,mynewlocation,myadmst);
    }
  }
  mynewlocation=adms_admst_semantic_postcondition(myadmstpathevaluate,mynewlocation,mytext);
  if(mynewlocation==NULL)
    admstpathevaluate_admstpath_empty(myadmstpathevaluate);
  else
  {
    p_slist myadmstlist;
    p_slist myadmstpathgotonode=*(myadmstpathevaluate->_admstpathgotonode);
    p_admstpathgoto myadmstpathgoto=adms_admstpathgoto((*(myadmstpathevaluate->_admstpathgotonode))->data);
    int mygotoindex=myadmstpathgoto->_gotoindex;
    if(mygotoindex==1)
      adms_admstpathevaluate_valueto_admstaslist(myadmstpathevaluate,NULL);
    for(myadmstlist=mynewlocation;myadmstlist;myadmstlist=myadmstlist->next)
    {
      *(myadmstpathevaluate->_admstpathgotonode)=myadmstpathgotonode;
      admstpathevaluate_admstpath(myadmstpathevaluate,adms_admst(myadmstlist->data));
    }
    adms_slist_concat(&myadmstpathevaluate->_admstasscalar,adms_slist_reverse(myadmstpathevaluate->_admstasscalarfixme));
    adms_admstpathevaluate_valueto_admstasscalarfixme(myadmstpathevaluate,NULL);
  }
}
\n";
#inside goto: build goto
foreach my$productionset(@productionset)
{
  my$gotoindex=0;
  my@productions=$productionset->findnodes("production");
  my$gotoname=$productionset->getAttribute("id");
  print CFILE "_t_goto_evaluate(admstpathevaluate_${gotoname})\n" if($gotoname =~ /(admstroot)/);
  print CFILE "_t_goto_evaluate(admstpathevaluate_$gotoname)\n" if($gotoname =~ /(admstpath)/);
  print CFILE "_t_goto_evaluate_location(admstpathevaluate_$gotoname)\n" if($gotoname =~ /(location)/);
  print CFILE "_t_goto_evaluate_binary(admstpathevaluate_$gotoname)\n" if($gotoname =~ /(condition)|(expression)|(binary)|(unary)/);
  print CFILE "{\n";
  print CFILE "  p_admstpathgoto myadmstpathgoto=adms_admstpathgoto((*(myadmstpathevaluate->_admstpathgotonode))->data);\n";
  print CFILE "  int mygotoindex=myadmstpathgoto->_gotoindex;\n";
  print CFILE "  adms_message_dbg_xml((\"       r=%s gotoindex=%i\\n\",myadmstpathgoto->_gotoname,mygotoindex))\n";
  print CFILE "  *(myadmstpathevaluate->_admstpathgotonode)=(*(myadmstpathevaluate->_admstpathgotonode))->next;\n";
  print CFILE "  if(0)\n";
  print CFILE "  {}\n";
  while(@productions)
  {
    $gotoindex++;
    my$production=shift @productions;
    print CFILE "  else if(mygotoindex==$gotoindex)\n";
    print CFILE "  {\n";
    my@prodems=$production->findnodes("prodem");
    my$hassemantic=0;
    my$nblocallocation=0;
    while(@prodems)
    {
      my$prodem=shift @prodems;
      my$token=$prodem->getAttribute("linktotoken");
      if(not($constant{$token}||$terminal{$token})&&($token =~ /(admstroot)/))
      {
        $nblocallocation++;
      }
    }
    if($nblocallocation)
    {
      print CFILE "    p_admstpathevaluate mylocaladmstpathevaluate[$nblocallocation];\n";
    }
    my$ilocallocation=0;
    @prodems=$production->findnodes("prodem");
    if(($gotoname =~ /(binary)/) && ($gotoindex == 1))
    {
      print CFILE "    if(mycuradmst->_istrue==adms_admst_enumeration_istrue_yes)\n";
      print CFILE "    {\n";
      print CFILE "      admstpathevaluate_unary(myadmstpathevaluate,mylocation,mycuradmst);\n";
      print CFILE "      admstpathevaluate_binary(myadmstpathevaluate,mylocation,mycuradmst);\n";
      print CFILE "    }\n";
      print CFILE "    else\n";
      print CFILE "    {\n";
      print CFILE "      admstpathevaluate_unary_empty(myadmstpathevaluate);\n";
      print CFILE "      admstpathevaluate_binary_empty(myadmstpathevaluate);\n";
      print CFILE "    }\n";
    }
    elsif(($gotoname =~ /(binary)/) && ($gotoindex == 2))
    {
      print CFILE "    if(mycuradmst->_istrue==adms_admst_enumeration_istrue_no)\n";
      print CFILE "    {\n";
      print CFILE "      admstpathevaluate_unary(myadmstpathevaluate,mylocation,mycuradmst);\n";
      print CFILE "      admstpathevaluate_binary(myadmstpathevaluate,mylocation,mycuradmst);\n";
      print CFILE "    }\n";
      print CFILE "    else\n";
      print CFILE "    {\n";
      print CFILE "      admstpathevaluate_unary_empty(myadmstpathevaluate);\n";
      print CFILE "      admstpathevaluate_binary_empty(myadmstpathevaluate);\n";
      print CFILE "    }\n";
    }
    while(@prodems)
    {
      my$prodem=shift @prodems;
      my$token=$prodem->getAttribute("linktotoken");
      if($gotoname =~ /(admstroot)/)
      {
        if($token =~ /(separator)/)
        {
          print CFILE "    mycuradmst=adms_admst_semantic_root(myadmstpathevaluate,mycuradmst,myadmstpathgoto->_text);\n";
        }
        elsif($token =~ /(admstpath)/)
        {
          print CFILE "    code1(myadmstpathgoto->_text,myadmstpathevaluate,mycuradmst);\n";
        }
      }
      elsif($gotoname =~ /(binary)/)
      {
      }
      elsif($gotoname =~ /(admstpath)/)
      {
        if($token =~ /(admstpath)/)
        {
          print CFILE "    code1(myadmstpathgoto->_text,myadmstpathevaluate,mycuradmst);\n";
        }
      }
      else
      {
      if(not($constant{$token}||$terminal{$token}))
      {
        if($token =~ /(location)/)
        {
          print CFILE "    p_slist dummyl;\n";
          print CFILE "    p_slist myadmstpathgotonode=*(myadmstpathevaluate->_admstpathgotonode);\n";
          print CFILE "    adms_admstpathevaluate_valueto_admstaslist(myadmstpathevaluate,NULL);\n";
          print CFILE "    if(mypreviouslocation==NULL)\n";
          print CFILE "      admstpathevaluate_location_empty(myadmstpathevaluate);\n";
          print CFILE "    for(dummyl=mypreviouslocation;dummyl;dummyl=dummyl->next)\n";
          print CFILE "    {\n";
          print CFILE "      p_admst mycuradmst=adms_admst(dummyl->data);\n";
          print CFILE "      *myadmstpathgotonodeptr=myadmstpathgotonode;\n";
          print CFILE "      admstpathevaluate_location(myadmstpathevaluate,mycuradmst,&mynewlocation);\n";
          print CFILE "    }\n";
        }
        elsif($token =~ /(condition)/)
        {
          print CFILE "    if(mynewlocation==NULL)\n";
          print CFILE "      admstpathevaluate_condition_empty(myadmstpathevaluate);\n";
          print CFILE "    else\n";
          print CFILE "    {\n";
          print CFILE "      myadmstpathgotonode=*(myadmstpathevaluate->_admstpathgotonode);\n";
          print CFILE "      for(dummyl=mynewlocation;dummyl;dummyl=dummyl->next)\n";
          print CFILE "      {\n";
          print CFILE "        *myadmstpathgotonodeptr=myadmstpathgotonode;\n";
          print CFILE "        admstpathevaluate_$token(myadmstpathevaluate,mynewlocation,adms_admst(dummyl->data));\n";
          print CFILE "      }\n";
          print CFILE "    }\n";
        }
        elsif($token =~ /(admstroot)/)
        {
          if($gotoname =~ /(unary)/)
          {
            print CFILE "    if(mycuradmst->_isrelative==adms_admst_enumeration_isrelative_no)\n";
            print CFILE "      mycuradmst->_container=mylocation;;\n";
          }
          print CFILE "    mylocaladmstpathevaluate[$ilocallocation]=admstpathevaluate_local_$token(myadmstpathevaluate,mycuradmst);\n";
          $ilocallocation++;
        }
        elsif($token =~ /(expression)|(binary)|(unary)/)
        {
          print CFILE "    admstpathevaluate_$token(myadmstpathevaluate,mylocation,mycuradmst);\n";
        }
        elsif($token =~ /(admstpath)/)
        {
          print CFILE "    admstpathevaluate_$token(myadmstpathevaluate,mynewlocation);\n";
        }
        else
        {
          die;
        }
      }
      &semantic($prodem,$gotoname,$nblocallocation);
      }
      my@semantics=$prodem->findnodes("semantic");
      $hassemantic=scalar(@semantics);
    }
    @prodems=$production->findnodes("prodem");
    $ilocallocation=0;
    while(@prodems)
    {
      my$prodem=shift @prodems;
      my$token=$prodem->getAttribute("linktotoken");
      if(not($constant{$token}||$terminal{$token})&&($token =~ /(admstroot)/))
      {
        print CFILE "    free_admstpathevaluate(mylocaladmstpathevaluate[$ilocallocation]);\n";
        $ilocallocation++;
      }
    }
    print CFILE "  }\n";
  }
  $gotoindex++;
  my@empty=$productionset->findnodes("empty");
  if(@empty)
  {
    print CFILE "  else if(mygotoindex==$gotoindex)\n";
    print CFILE "  {\n";
    &semantic($empty[0],$gotoname);
    if($gotoname =~ /(admstpath)/)
    {
      print CFILE "    adms_slist_push(&myadmstpathevaluate->_admstasscalarfixme,adms_adms(mycuradmst));\n";
    }
    print CFILE "  }\n";
  }
  print CFILE "  else\n";
  print CFILE "  {\n";
  print CFILE "    adms_message_fatal_continue((\"program aborted at goto=$gotoname(%s.%i) - pls contact developpers\\n\",myadmstpathgoto->_gotoname,mygotoindex))\n";
  print CFILE "    adms_message_fatal((\"see %s\\n\",adms_admsttransform_uid(myadmstpathevaluate->_admsttransform)))\n";
  print CFILE "  }\n";
  print CFILE "}\n";
}
print CFILE "\n";

close CFILE;

