#!/bin/perl -w

sub text2ccode
{
  my$fileFullName = shift;
  $fileFullName =~ m/\/?([^\/]+)$/;
  my$fileName = $1;
  my$OutputCfile = "$fileName.c";
  my$cName = $fileName;
  $cName =~ s/\./_/g;
  open IF, "<${fileFullName}";
  open OCF, ">${OutputCfile}";
  printf(OCF "/* File automatically created by " . __FILE__ . "*/\n");
  printf(OCF "\n");
  printf(OCF "const char * %s = \"\"\n",${cName});
  while(<IF>)
  {
    my $line=$_;
    $line=~s/\r?$//;
    $line=~s/\n$//;
    $line=~s/\\/\\\\/g;
    $line=~s/"/\\"/g;
    printf(OCF "\"%s\\n\"\n", $line);
  }
  printf(OCF ";\n");
  close IF;
  close OCF;
}

&text2ccode(shift);
