#/bin/sh
#CFLAGS options:
# -pg: gprof
# -O3: optimization
# -gdwarf-2 and -g3: provides macro information

CFLAGS="-pg -g " #then admsXml <filename> && gprof /usr/local/bin/admsXml.exe > admsXml.gprof
#CFLAGS="-O3 -mcpu=pentium -malign-double -fno-exceptions"
#CFLAGS="-ggdb"
CFLAGS="-Wall -g -mno-cygwin"
CFLAGS="-g -mno-cygwin"


SOURCE="
admsObject/object*.c
admsFile/file*.c
admsPreprocessor/preprocessor*.c
admsVeriloga/veriloga*.c
admsXml/admsXml.c
"
#-DHAVE_DMALLOC
DEFINE="
-DHAVE_CONFIG_H
-D_inside_admsPreprocessor
-D_inside_admsFile
-D_inside_admsObject
-D_inside_admsVeriloga
-D_inside_admsXml
-DWIN32
"
INCLUDE="-I."
PKG_CFLAGS=`pkg-config glib-2.0 --cflags`
PKG_LIBS=`pkg-config glib-2.0 --libs`

test -f config.h || { echo "error: first create file config.h" && exit 1; }
(cd admsObject && perl ../scripts/adms_build_object.pl ..) && \
(cd admsVeriloga && perl ../scripts/yaccIn2yacc.pl ./verilogaYacc.y.in) && \
(cd admsVeriloga && flex  -Padms_veriloga_ -olex.yy.c verilogaLex.l) && \
(cd admsVeriloga && bison -y -by -padms_veriloga_ -d verilogaYacc.y) && \
(cd admsVeriloga && mv y.tab.c verilogaYacc.c && mv y.tab.h verilogaYacc.h) && \
(cd admsVeriloga && mv lex.yy.c verilogaLex.c) && \
(cd admsPreprocessor && flex  -Padms_preprocessor_ -olex.yy.c preprocessorLex.l) && \
(cd admsPreprocessor && bison -y -by -padms_preprocessor_ -d preprocessorYacc.y) && \
(cd admsPreprocessor && mv y.tab.c preprocessorYacc.c && mv y.tab.h preprocessorYacc.h) && \
(cd admsPreprocessor && mv lex.yy.c preprocessorLex.c) && \
(cd admsPreprocessor && perl ../scripts/text2Ccode.pl disciplines.vams admsPreprocessor) && \
(cd admsPreprocessor && perl ../scripts/text2Ccode.pl constants.vams admsPreprocessor) && \
(cd admsXml && perl ../scripts/text2Ccode.pl admsImplicitTransforms.xml admsXml) && \
(cd admsXml && perl ../scripts/xmlXpath.pl ..) && \
gcc $CFLAGS $DEFINE $PKG_CFLAGS $INCLUDE $SOURCE $PKG_LIBS $DMALLOC_LIBS -o admsXml.exe && \
VERSION=$(grep VERSION config.h | sed 's/.*"\(.*\)".*/\1/') && \
cp -f admsXml.exe /usr/local/bin/admsXml-$VERSION.exe && \
cp -f admsXml.exe /usr/local/bin/admsXml.exe && \
echo "/usr/local/bin/admsXml-$VERSION.exe created"
