/*
 * RCS Info
 * $Id: admsXml.c 615 2007-04-19 13:00:04Z r29173 $
 * 
 * Log
 * $Log$
 * Revision 1.12  2006/09/08 16:03:46  r29173
 * set admsttransform attributes as admsttext
 *
 * Revision 1.11  2006/08/30 02:57:12  r29173
 * added %() support
 *
 * Revision 1.10  2006/08/18 17:10:50  r29173
 * did lot of simplifications
 * added element quark (character array)
 *
 * Revision 1.9  2006/08/10 11:31:47  r29173
 * did lot of simplifications
 *
 * Revision 1.8  2006/08/04 17:15:31  r29173
 * rearranged code partionning into files
 *
 * Revision 1.7  2006/08/02 16:45:52  r29173
 * rearranged code partionning into files
 *
 * Revision 1.6  2005/04/25 12:29:33  r29173
 * fixed few memory leak issues (introduced adms.._free)
 *
 * Revision 1.5  2004/11/19 12:29:56  r29173
 * renamed _C into CAT
 * saved argc, argv into admsmain element
 * added adms:setenv transform
 *
 * Revision 1.4  2004/08/19 16:46:44  r29173
 * cleaned-up i/o file handling
 *
 * Revision 1.3  2004/08/03 12:33:55  r29173
 * import adms-1.21.0 from local CVS
 *
 * Revision 1.2  2004/05/26 13:02:47  r29173
 * added default values to all enumerations
 *
 * Revision 1.1.1.1  2004/05/21 12:20:01  r29173
 * recreated cvs data structure (crashed after revision 1.13.0!)
 *
 * Revision 1.67  2004/05/17 11:50:28  r29173
 * simplified handling of variable attributes
 *
 * Revision 1.66  2004/05/13 07:34:50  r29173
 * continue removing GNode* structure
 *
 * Revision 1.65  2004/05/05 10:19:30  r29173
 * started removing GNode* structure
 *
 * Revision 1.64  2004/05/04 08:07:10  r29173
 * added code for @final
 * removed libltdl
 *
 * Revision 1.63  2004/04/19 16:24:31  r29173
 * moved code of xparser to xmlParser
 *
 * Revision 1.62  2004/04/19 15:41:37  r29173
 * moved code of treeValidate to xmlParser
 *
 * Revision 1.61  2004/04/19 14:52:19  r29173
 * cleaned-up code
 * added handling of \t in xml files
 *
 * Revision 1.60  2004/03/30 09:06:34  r29173
 * added adms_message
 * added statistics
 * started noise implementation
 *
 * Revision 1.59  2004/03/25 20:14:49  r29173
 * splitted variable->scope into small pieces
 *
 * Revision 1.58  2004/03/19 12:45:35  r29173
 * started implementing code builder in yacc parser
 *
 * Revision 1.57  2004/03/19 10:24:58  r29173
 * started implementing code builder in yacc parser
 *
 * Revision 1.56  2004/03/08 13:58:07  r29173
 * all code lower-cased
 *
 * Revision 1.55  2004/03/08 08:24:20  r29173
 * started implementing code builder in yacc parser
 *
 * Revision 1.54  2004/03/04 11:01:28  r29173
 * started implementing code builder in yacc parser
 *
 * Revision 1.53  2004/03/02 13:42:00  r29173
 * started implementing code builder in yacc parser
 *
 * Revision 1.52  2004/03/02 10:48:27  r29173
 * start implementing support to new vla syntax
 *
 * Revision 1.51  2004/02/25 11:34:23  r29173
 * start implementing support to new vla syntax
 *
 * Revision 1.50  2004/02/21 16:13:54  r29173
 * start implementing support to new vla syntax
 *
 * Revision 1.49  2004/02/20 22:22:18  r29173
 * start implementing support to new vla syntax
 *
 * Revision 1.48  2004/02/20 19:40:08  r29173
 * start implementing support to new vla syntax
 *
 * Revision 1.47  2004/02/20 19:05:53  r29173
 * start implementing support to new vla syntax
 *
 * Revision 1.46  2004/02/20 14:56:37  r29173
 * start implementing support to new vla syntax
 *
 * Revision 1.45  2004/02/20 13:45:30  r29173
 * start implementing support to new vla syntax
 *
 * Revision 1.44  2004/02/19 17:02:38  r29173
 * started implementing code builder in yacc parser
 *
 * Revision 1.43  2004/02/19 01:25:11  r29173
 * started implementing code builder in yacc parser
 *
 * Revision 1.42  2004/02/18 23:30:46  r29173
 * started implementing code builder in yacc parser
 *
 * Revision 1.41  2004/02/18 00:43:01  r29173
 * started implementing code builder in yacc parser
 *
 * Revision 1.40  2004/02/15 13:07:43  r29173
 * started implementing code builder in yacc parser
 *
 * Revision 1.39  2004/02/14 22:46:49  r29173
 * started implementing code builder in yacc parser
 *
 * Revision 1.38  2004/02/14 20:15:42  r29173
 * started implementing code builder in yacc parser
 *
 * Revision 1.37  2004/02/13 14:28:39  r29173
 * started implementing code builder in yacc parser
 *
 * Revision 1.36  2004/02/11 15:19:31  r29173
 * release 1.5.1
 *
 * Revision 1.35  2004/02/11 14:20:11  r29173
 * started implementing code builder in yacc parser
 *
 * Revision 1.34  2004/02/10 16:44:30  r29173
 * started implementing code builder in yacc parser
 *
 * Revision 1.33  2004/02/10 10:48:24  r29173
 * started implementing code builder in yacc parser
 *
 * Revision 1.32  2004/02/06 16:27:19  r29173
 * started implementing code builder in yacc parser
 *
 * Revision 1.31  2004/02/06 14:52:08  r29173
 * started implementing code builder in yacc parser
 *
 * Revision 1.30  2004/02/05 21:37:03  r29173
 * started implementing code builder in yacc parser
 *
 * Revision 1.29  2004/02/05 14:02:30  r29173
 * started implementing code builder in yacc parser
 *
 * Revision 1.28  2004/02/04 20:49:12  r29173
 * started implementing code builder in yacc parser
 *
 * Revision 1.27  2004/02/04 20:34:24  r29173
 * started implementing code builder in yacc parser
 *
 * Revision 1.26  2004/02/03 12:48:29  r29173
 * started implementing code builder in yacc parser
 *
 * Revision 1.25  2004/01/29 15:49:08  r29173
 * renamed accessors of xmlnodes
 *
 * Revision 1.24  2004/01/28 16:15:06  r29173
 * started implementing code builder in yacc parser
 *
 * Revision 1.23  2004/01/28 10:37:29  r29173
 * started implementing code builder in yacc parser
 *
 * Revision 1.22  2004/01/27 17:20:15  r29173
 * started implementing code builder in yacc parser
 *
 * Revision 1.21  2004/01/27 13:46:14  r29173
 * started implementing code builder in yacc parser
 *
 * Revision 1.20  2004/01/22 12:10:40  r29173
 * started implementing code builder in yacc parser
 *
 * Revision 1.19  2004/01/21 14:35:45  r29173
 * started implementing code builder in yacc parser
 *
 * Revision 1.18  2004/01/16 11:18:29  r29173
 * removed use of adms_xml_load_scope
 *
 * Revision 1.17  2004/01/16 10:24:02  r29173
 * added admsPreprocessor code
 * added admsSimulator code
 *
 * Revision 1.16  2004/01/13 11:25:52  r29173
 * added adms_message_usage
 *
 * Revision 1.15  2004/01/09 16:23:48  r29173
 * cleaned-up use of #include
 *
 * Revision 1.14  2004/01/08 10:28:49  r29173
 * moved code to always.[ch]
 *
 * Revision 1.13  2004/01/07 15:19:15  r29173
 * added command line arguments -h and -v
 *
 * Revision 1.12  2004/01/06 12:35:01  r29173
 * fixed the use of globals: input file and output file
 *
 * Revision 1.11  2004/01/05 11:40:14  r29173
 * added message when no arg specified at command line
 *
 * Revision 1.10  2003/12/15 21:47:14  r29173
 * started to create adms_object_new automatically
 *
 * Revision 1.9  2003/12/15 20:54:30  r29173
 * started to create adms_object_new automatically
 *
 * Revision 1.8  2003/12/12 14:33:27  r29173
 * changed construct (a!=NULL) into (a) or (a)?1:0
 *
 * Revision 1.7  2003/12/11 16:01:54  r29173
 * changed prefix [epst]_adms_ to [epst]_
 *
 * Revision 1.6  2003/12/05 13:47:14  r29173
 * used only one routine to create xml nodes
 *
 * Revision 1.5  2003/11/08 22:25:52  r29173
 * re-organized code (removed file simulatorLoad.c)
 *
 * Revision 1.4  2003/11/08 17:46:10  r29173
 * re-organized handling of xparsers
 *
 * Revision 1.3  2003/10/31 16:43:06  r29173
 * clean-up the way xparser works
 *
 * Revision 1.2  2003/05/21 14:18:02  r29173
 * add rcs info
 *
 */

#include <admsFile/admsFile.h>
#include <admsObject/admsH.h>
#include <admsVeriloga/admsVeriloga.h>
#include <admsObject/admsC.h>
#include <time.h>

static int adms_donouse_xml_implicit_file=0;

static p_admsttransform adms_admstpath_admsttransform(p_admsttransform myadmsttransform,const char*myname)
{
  p_admsttransform mytemplate=NULL;
  p_slist mytemplates;
  for(mytemplates=adms_admsmain_valueof_template(adms_global_admsmain());mytemplates&&!mytemplate;mytemplates=mytemplates->next)
    if(!strcmp(adms_admsttransform_valueof_zzmatch(adms_admsttransform(mytemplates->data))->_value,myname))
      mytemplate=adms_admsttransform(mytemplates->data);
  if(mytemplate==NULL)
  {
    adms_message_fatal_continue(("Template not found: %s\n",myname))
    adms_message_fatal(("  see:  %s\n",adms_admsttransform_uid(myadmsttransform)))
  }
  return mytemplate;
}
static p_instanceofadmsttransform adms_admstpath_instanceofadmsttransform(p_admsttransform myadmsttransform)
{
  p_instanceofadmsttransform myinstanceofadmsttransform=
    adms_admsmain_valueof_instanceofadmsttransforminsideapplytemplate(adms_global_admsmain())?
    adms_instanceofadmsttransform(adms_admsmain_valueof_instanceofadmsttransforminsideapplytemplate(adms_global_admsmain())->data):NULL;
  if(myinstanceofadmsttransform==NULL)
  {
    adms_message_fatal_continue(("return(.) allowed only inside admst:apply-templates\n"))
    adms_message_fatal(("see %s\n",adms_admsttransform_uid(myadmsttransform)))
  }
  return myinstanceofadmsttransform;
}
static p_admstvariable adms_admstpath_admstvariable(p_admsttransform myadmsttransform,const char*myname)
{
  p_admstvariable myadmstvariable=NULL;
  p_instanceofadmsttransform myinstanceofadmsttransform;
  p_quark myquark;
  myinstanceofadmsttransform=adms_admsmain_valueof_instanceofadmsttransform(adms_global_admsmain())?
    adms_instanceofadmsttransform(adms_admsmain_valueof_instanceofadmsttransform(adms_global_admsmain())->data):NULL;
  myquark=adms_quark_new(myname);
  if(myinstanceofadmsttransform)
    myadmstvariable=adms_instanceofadmsttransform_list_variable_lookup_by_id(myinstanceofadmsttransform,myquark);
  if(myadmstvariable==NULL)
    myadmstvariable=adms_admsmain_list_variable_lookup_by_id(adms_global_admsmain(),myquark);
  if(myadmstvariable==NULL)
    adms_message_fatal(("%s: admst variable is undefined! see %s\n",myname,adms_admsttransform_uid(myadmsttransform)))
  adms_quark_free(myquark);
  return myadmstvariable;
}

/*local header*/
typedef void (t_admsttransform_evaluate) (p_admsttransform myadmsttransform,p_admst myadmstparent);
typedef void (*p_admsttransform_evaluate) (p_admsttransform myadmsttransform,p_admst myadmstparent);
#define _t_admsttransform_evaluate(function) void (function) (p_admsttransform myadmsttransform,p_admst myadmstparent)
#define _t_inline_admsttransform_evaluate(function) inline  _t_admsttransform_evaluate(function)

/*xml parser built from admstpath.xml*/
static char *adms_admsttext_tostring (const p_admst myadmstparent,const p_admsttext myadmsttext);
static void adms_admsttext_parse (p_admsttext myadmsttext);

static char*adms_admstpath_tostring(const p_admsttransform myadmsttransform, const p_admst myadmstparent, const char* myadmstpath)
{
  p_admsttext myadmsttext=adms_admsttext_new(myadmsttransform,myadmstpath);
  char* ret;
  adms_admsttext_parse(myadmsttext);
  ret=adms_admsttext_tostring(myadmstparent,myadmsttext);
  adms_admsttext_free(myadmsttext);
  return ret;
}
static p_admstvariable adms_admstvariable_lookup(const char*myvariablename)
{
  p_admstvariable myadmstvariable=NULL;
  p_instanceofadmsttransform myinstanceofadmsttransform=adms_admsmain_valueof_instanceofadmsttransform(adms_global_admsmain())
    ?adms_instanceofadmsttransform(adms_admsmain_valueof_instanceofadmsttransform(adms_global_admsmain())->data):NULL;
  p_quark myquark=adms_quark_new(myvariablename);
  if(myinstanceofadmsttransform)
     myadmstvariable=adms_instanceofadmsttransform_list_variable_lookup_by_id(myinstanceofadmsttransform,myquark);
  if(myadmstvariable==NULL)
    myadmstvariable=adms_admsmain_list_variable_lookup_by_id(adms_global_admsmain(),myquark);
  adms_quark_free(myquark);
  return myadmstvariable;
}
static p_admstvariable adms_admstvariable_lookup_or_die(const char*myvariablename,const p_admsttransform myadmsttransform)
{
  p_admstvariable myadmstvariable=adms_admstvariable_lookup(myvariablename);
  if(myadmstvariable==NULL)
  {
    adms_message_fatal(("variable '%s' is undefined\n",myvariablename))
    adms_message_fatal(("see %s\n",myvariablename,adms_admsttransform_uid(myadmsttransform)))
  }
  return myadmstvariable;
}
static int adms_strtol(const char*mynumber,p_admsttransform myadmsttransform)
{
  int nb;
  errno=0;
  nb=(int)strtol(mynumber,(char **)NULL,10);
  if(errno)
  {
    adms_message_fatal_continue(("%s: not an integer value\n",mynumber))
    adms_message_fatal(("see %s\n",adms_admsttransform_uid(myadmsttransform)))
  }
  return nb;
}
static double adms_strtod(const char*mynumber)
{
  double nb;
  char*tail;
  errno=0;
  nb=strtod(mynumber,&tail);
  if(*tail||errno)
    return adms_NAN;
  else
    return nb;
}
_t_inline_admsttransform_evaluate(adms_admsttransform_evaluate);
static void free_admstpathevaluate(p_admstpathevaluate myadmstpathevaluate)
{
  p_slist myl;
  for(myl=myadmstpathevaluate->_alladmst;myl;myl=myl->next)
    adms_admst_free(adms_admst(myl->data));
  //adms_admstpathevaluate_free(myadmstpathevaluate);
  if(!myadmstpathevaluate)
    return;
  adms_slist_free(myadmstpathevaluate->_admstaslist);
  adms_slist_free(myadmstpathevaluate->_admstasscalar);
  adms_slist_free(myadmstpathevaluate->_admstasscalarfixme);
  adms_slist_free(myadmstpathevaluate->_alladmst);
  //dont do it!: adms_admsttransformattribute_free(myadmstpathevaluate->_admsttransformattribute);
  adms_global_increment_nbadmstpathevaluatedestroy();
  free(myadmstpathevaluate);
}
static inline p_admst adms_pull_admst(p_admsttransform myadmsttransform)
{
  if(adms_admsmain_valueof_valueof(adms_global_admsmain()))
    return adms_admst(adms_slist_pull(&adms_admsmain_valueof_valueof(adms_global_admsmain())));
  else
  {
    adms_message_fatal_continue(("adms stack has no more element!\n"))
    adms_message_fatal(("see %s",adms_admsttransform_uid(myadmsttransform)))
    return NULL;
  }
}
#include <admsXml/xmlXpath.c>
static p_admstpathevaluate admstpathevaluate(p_admsttransform myadmsttransform,p_admsttransformattribute myadmsttransformattribute,p_slist myadmstpathgotonode,p_admst myadmstparent)
{
  p_admstpathevaluate myadmstpathevaluate=adms_admstpathevaluate_new(myadmsttransform,myadmsttransformattribute);
  adms_admstpathevaluate_valueto_admstasscalar(myadmstpathevaluate,NULL);
  adms_admstpathevaluate_valueto_admstasscalarfixme(myadmstpathevaluate,NULL);
  adms_admstpathevaluate_valueto_admstaslist(myadmstpathevaluate,NULL);
  myadmstpathevaluate->_admstpathgotonode=&myadmstpathgotonode;
  admstpathevaluate_admstroot(myadmstpathevaluate,myadmstparent);
  return myadmstpathevaluate;
}
static inline p_admstpathevaluate evaluate(p_admst myadmstparent,const p_admsttransformattribute myadmsttransformattribute)
{
  p_admsttransform myadmsttransform=myadmsttransformattribute->_admsttransform;
  p_slist myadmstpathgotonode=adms_admsttransformattribute_valueof_admstpathgoto(myadmsttransformattribute);
  p_admstpathevaluate myadmstpathevaluate=admstpathevaluate(myadmsttransform,myadmsttransformattribute,myadmstpathgotonode,myadmstparent);
  return myadmstpathevaluate;
}
static inline p_admstpathevaluate evaluate2(p_admsttransform myadmsttransform,p_admst myadmstparent,p_admstpath myadmstpath)
{
  p_slist myadmstpathgotonode=adms_admsttransformattribute_valueof_admstpathgoto(myadmstpath->_admsttransformattribute);
  p_admstpathevaluate myadmstpathevaluate=admstpathevaluate(myadmsttransform,myadmstpath->_admsttransformattribute,myadmstpathgotonode,myadmstparent);
  return myadmstpathevaluate;
}

#define T(p) !strcmp(adms_admsttransform_valueof_admstname(myadmsttransform),#p)
static int adms_admsttransform_zztest_passed(const p_admsttransform myadmsttransform, const p_admst myadmstparent)
{
  int mypassed=1;
  if(adms_admsttransform_valueof_zztest(myadmsttransform))
  {
    p_admstpathevaluate myadmstpathevaluate=evaluate(myadmstparent,adms_admsttransform_valueof_zztest(myadmsttransform));
    if(T(admst:assert))
      mypassed=!myadmstpathevaluate->_admstasscalar;
    else
      mypassed=(myadmstpathevaluate->_admstasscalar&&adms_admst(myadmstpathevaluate->_admstasscalar->data)->_item);
    free_admstpathevaluate(myadmstpathevaluate);
  }
  return mypassed;
}
_t_inline_admsttransform_evaluate(adms_admsttransform_evaluate)
{
  adms_message_dbg_xml(("{ evl: %s[%s]\n",adms_admsttransform_uid(myadmsttransform),adms_admst_uid(myadmstparent)))
  if(adms_admsttransform_zztest_passed(myadmsttransform,myadmstparent))
    ((p_admsttransform_evaluate)myadmsttransform->_evaluator)(myadmsttransform,myadmstparent);
  adms_message_dbg_xml(("}\n"))
}
p_slist admstpathparse (p_admsttransform myadmsttransform,const char *myadmstpath)
{
  p_slist myadmstpathgoto;
  p_quark myquark=adms_quark_new(myadmstpath);
  p_admstpathparser myadmstpathparser=adms_admstpathparser_new(myadmsttransform,myquark);
  adms_admstpathparser_valueto_stringposition(myadmstpathparser,myquark->_value);
  adms_admstpathparse_lex(myadmstpathparser);
  adms_message_dbg_xml(("  admstpathparse=%s\n",myadmstpath))
  myadmstpathgoto=parse_admstroot(myadmstpathparser);
  {
    p_slist dbg; for(dbg=myadmstpathgoto;dbg;dbg=dbg->next)
      adms_message_dbg_xml(("  p=>%s.%i\n",adms_admstpathgoto(dbg->data)->_gotoname,adms_admstpathgoto(dbg->data)->_gotoindex))
  }
  if(adms_admstpathparser_valueof_token(myadmstpathparser)!=adms_admstpathparser_enumeration_token_eos)
    adms_message_fatal(("%s: %s: invalid admstpath expression\n",adms_admsttransform_uid(adms_admstpathparser_valueof_admsttransform(myadmstpathparser)),myadmstpath))
  else if(*adms_admstpathparser_valueof_stringposition(myadmstpathparser)!='\0')
    adms_message_fatal(("%s: %s: invalid admstpath expression\n",adms_admsttransform_uid(adms_admstpathparser_valueof_admsttransform(myadmstpathparser)),myadmstpath))
  return myadmstpathgoto;
}
/*constants*/
#include <admsXml/admsImplicitTransforms.xml.c>
#include <admsPreprocessor/admsPreprocessor.h>

/*pathname*/
static p_path adms_path_split (const char* myname)
{
  p_path mypath=adms_path_new(myname);
  char* mychars=adms_path_valueof_value(mypath);
  char* mynext=mychars;
  adms_message_verbose(("split '%s':",myname))
  while(*mychars!='\0')
  {
    if((*mychars=='/')||(*mychars=='\\'))
    {
      char* mytoken=adms_m2nclone(mynext,mychars);
      adms_message_verbose_continue((" '%s'",mytoken))
      adms_path_list_token_prepend_by_id(mypath,mytoken); 
      mynext=mychars+1;
    }
    mychars++;
  }
  /*remainder*/
  {
    char* mylasttoken=adms_m2nclone(mynext,mychars);
    adms_message_verbose_continue((" '%s'",mylasttoken))
    adms_path_list_token_prepend_by_id(mypath,mylasttoken); 
  }
  adms_path_valueof_token(mypath)=adms_slist_reverse(adms_path_valueof_token(mypath));
  adms_message_verbose_continue(("\n"))
  return mypath;
}
static char* adms_path_join(p_path mypath)
{
  char* str=NULL;
  p_slist list=adms_slist_nth(adms_path_valueof_token(mypath),0);
  while(list)
  {
    if(str)
      adms_strconcat2(&str,"/");
    adms_strconcat2(&str,(char*)list->data);
    list=list->next;
  }
  return str;
}
static char* adms_file_unixify(const char *myname)
{
  p_path myPath=adms_path_split(myname);
  char* mypath=adms_path_join(myPath);
  adms_message_verbose(("build unix path '%s'\n",mypath))
  adms_path_free(myPath);
  return mypath;
}
static char* adms_path_get_basename (const char *myname)
{
  char* mybasename;
  p_path mypath=adms_path_split(myname);
  mybasename=strdup((char*)adms_slist_last(adms_path_valueof_token(mypath))->data);
  adms_path_free(mypath);
  return mybasename;
}

/*split value of attribute admst:new.arguments*/
static char** adms_strsplit0 (const char *string,const char *delimiter,int max_tokens)
{
  p_slist string_list = NULL;
  p_slist slist;
  char **str_array, *s;
  unsigned int n = 0;
  const char* remainder=string;
  s=strstr(remainder,delimiter);
  if(s)
  {
    int delimiter_len = strlen (delimiter);
    while (--max_tokens && s)
    {
      int len=s-remainder;
      char* new_string=(char*)malloc(sizeof(char)*(len+1));
      strncpy(new_string,remainder,len);
      new_string[len]=0;
      adms_slist_push(&string_list,adms_adms(new_string));
      n++;
      remainder=s+delimiter_len;
      s=strstr(remainder,delimiter);
    }
  }
  if(*string)
  {
    n++;
    adms_slist_push(&string_list,adms_adms(strdup(remainder)));
  }
  str_array=(char**)malloc(sizeof(char*)*(n+1));
  str_array[n--]=NULL;
  for(slist=string_list;slist;slist=slist->next)
    str_array[n--]=(char*)slist->data;
  adms_slist_free(string_list);
  return str_array;
}
static char** adms_strsplit (const char *string,const char *delimiter,int max_tokens)
{
  char** arguments=adms_strsplit0 (string,delimiter,max_tokens);
  p_slist myslist=NULL;
  p_slist myslistfree;
  int nobackslashlatest=-1;
  int n=0;
  int m=0;
  char*myconcat=NULL;
  char**argumentsPtr=arguments;
  char **str_array;
  while(*argumentsPtr)
  {
    int mylength=strlen(*argumentsPtr);
    if(*(argumentsPtr+1)&&mylength&&(*(*argumentsPtr+mylength-1)=='\\'))
      *(*argumentsPtr+mylength-1)=',';
    else
    {
      int i;
      for(i=nobackslashlatest+1;i<=n;i++)
        adms_strconcat(&myconcat,*(arguments+i));
      adms_slist_push(&myslist,adms_adms(myconcat));
      nobackslashlatest=n;
      myconcat=NULL;
      m++;
    }
    argumentsPtr++;
    n++;
  }
  str_array=(char**)malloc(sizeof(char*)*(m+1));
  str_array[m--]=NULL;
  myslistfree=myslist;;
  for(;myslist;myslist=myslist->next)
    str_array[m--]=(char*)myslist->data;
  adms_slist_free(myslistfree);
  return str_array;
}

#define VALUETO(myadmst,myattributename,myvalue) (adms_admsxml_valueto(myadmst,myattributename))(myadmst->_item,adms_adms(myvalue));
static char *adms_admst_tostring(p_admst myadmst)
{
  if(adms_admst_valueof_size(myadmst)==adms_admst_enumeration_size_list)
    adms_message_fatal(("%s: cannot stringify %s (it is a list)",adms_admsttransform_uid(myadmst->_admsttransform),adms_admst_uid(myadmst)))
  if(myadmst->_item==NULL)
    return adms_constclone("");
  else if(!strcmp(adms_admst_valueof_attributename(myadmst),"datatypename"))
  {
    char *mydatatypename=adms_adms_tostring_datatypename_impl(myadmst->_admsttransform,adms_integer(myadmst->_item)->_value);
    return adms_constclone(mydatatypename);
  }
  else if(adms_adms_valueof_datatypename(myadmst->_item)==adms_adms_enumeration_datatypename_enumeration)
  {
    p_enumeration myenumeration=adms_enumeration(myadmst->_item);
    return adms_constclone(((p_valuetostring)myenumeration->_tostring)(myadmst->_admsttransform,myenumeration));
  }
  else if(adms_adms_valueof_datatypename(myadmst->_item)==adms_adms_enumeration_datatypename_quark)
    return adms_constclone(adms_quark(adms_admst_valueof_item(myadmst))->_value);
  else if(adms_adms_valueof_datatypename(myadmst->_item)==adms_adms_enumeration_datatypename_real)
    return adms_doubletostring(adms_real(myadmst->_item)->_value);
  else
    return adms_admsxml_uid(adms_admst_valueof_item(myadmst));
}
static void obsoletecallTemplate(p_admst myadmst,p_adms myelement)
{
  const char*mydatatypename=adms_adms_tostring_datatypename_impl(adms_admst_valueof_admsttransform(myadmst),adms_adms_valueof_datatypename(myelement));
  p_slist l=adms_admsmain_valueof_template(adms_global_admsmain()); for(;l;l=l->next)
  {
    char*mymatch=adms_admsttransform_valueof_zzmatch(adms_admsttransform(l->data))->_value;
    if(!strcmp(mymatch,mydatatypename))
    {
      p_admsttransform myadmsttransform=adms_admsttransform(l->data);
      p_admst myadmst=adms_admst_new(myadmsttransform,NULL,mydatatypename,adms_admst_enumeration_size_scalar);
      p_instanceofadmsttransform myinstanceofadmsttransform;
      adms_admst_valueto_item(myadmst,myelement);
      myinstanceofadmsttransform=adms_instanceofadmsttransform_new(myadmsttransform);
      adms_slist_push(&adms_admsmain_valueof_instanceofadmsttransform(adms_global_admsmain()),adms_adms(myinstanceofadmsttransform));
      {p_slist l;for(l=adms_admsttransform_valueof_children(myadmsttransform);l;l=l->next)
        adms_admsttransform_evaluate(adms_admsttransform(l->data),myadmst);}
      while(adms_instanceofadmsttransform_valueof_variable(myinstanceofadmsttransform))
      {
        p_admstvariable myadmstvariable=adms_admstvariable(adms_instanceofadmsttransform_valueof_variable(myinstanceofadmsttransform)->data);
        adms_admstvariable_free(myadmstvariable);
        adms_instanceofadmsttransform_valueto_variable(myinstanceofadmsttransform,adms_instanceofadmsttransform_valueof_variable(myinstanceofadmsttransform)->next);
      }
      adms_instanceofadmsttransform_free(myinstanceofadmsttransform);
      adms_slist_pull(&adms_admsmain_valueof_instanceofadmsttransform(adms_global_admsmain()));
      adms_admst_free(myadmst);
      return;
    }
  }
  adms_message_fatal_continue(("Template not found:\n"))
  adms_message_fatal_continue(("  <admst:template match=\"%s\"/>\n",mydatatypename))
  adms_message_fatal(("  see:  %s\n",adms_admsttransform_uid(adms_admst_valueof_admsttransform(myadmst))))
}
static inline char *adms_admst_tostring_with_obsolete(p_admst myadmst)
{
  if(adms_admst_valueof_size(myadmst)==adms_admst_enumeration_size_list)
    adms_message_fatal(("%s: cannot stringify %s (it is a list)",adms_admsttransform_uid(myadmst->_admsttransform),adms_admst_uid(myadmst)))
  else if(myadmst->_item==NULL)
    return NULL;
  else if(adms_adms_valueof_datatypename(myadmst->_item)==adms_adms_enumeration_datatypename_expression)
  {
    adms_message_obsolete_continue(("At: %s\n",adms_admst_uid(myadmst)))
    adms_message_obsolete_continue(("Please replace admst transform by:\n"))
    adms_message_obsolete_continue(("  <admst:value-of select=\"%s/tree/adms/datatypename\"/>\n",adms_admst_valueof_attributename(myadmst)))
    adms_message_obsolete_continue(("  <admst:apply-templates select=\"%s/tree\" match=\"%%s\"/>\n",adms_admst_valueof_attributename(myadmst)))
    adms_message_obsolete_continue(("  <admst:value-of select=\"/simulator/tmp\"/>\n"))
    adms_message_obsolete(("  Old construct will NOT be supported in adms-2.3.0 and future releases\n"))
    obsoletecallTemplate(myadmst,adms_expression_valueof_tree(adms_admst_valueof_item(myadmst)));
    return adms_constclone(adms_simulator_valueof_tmp(adms_admsmain_valueof_simulator(adms_global_admsmain()))->_value);
  }
  else if(!strcmp(adms_admst_valueof_attributename(myadmst),"arguments"))
  {
    adms_message_obsolete_continue(("At: %s\n",adms_admst_uid(myadmst)))
    adms_message_obsolete_continue(("Please replace admst transform by:\n"))
    adms_message_obsolete_continue(("  <admst:value-of select=\"%s/adms/datatypename\"/>\n",adms_admst_valueof_attributename(myadmst)))
    adms_message_obsolete_continue(("  <admst:apply-templates select=\"%s\" match=\"%%s\"/>\n",adms_admst_valueof_attributename(myadmst)))
    adms_message_obsolete_continue(("  <admst:value-of select=\"/simulator/tmp\"/>\n"))
    adms_message_obsolete(("  Old construct will NOT be supported in adms-2.3.0 and future releases\n"))
    obsoletecallTemplate(myadmst,adms_admst_valueof_item(myadmst));
    return adms_constclone(adms_simulator_valueof_tmp(adms_admsmain_valueof_simulator(adms_global_admsmain()))->_value);
  }
  return NULL;
}

/*admsttext parser*/
static inline void reduce_constquark(p_admsttext myadmsttext,const char*myvalue)
{
  if(!*myvalue)
    return;
  adms_slist_push(&(myadmsttext->_token),adms_adms(adms_quark_new(myvalue)));
}
static inline void reduce_quark(p_admsttext myadmsttext,char*myvalue)
{
  if(!*myvalue)
    return;
  adms_slist_push(&(myadmsttext->_token),adms_adms(adms_quark_new(myvalue)));
  free(myvalue);
}
static inline void reduce_admsttext(p_admsttext myadmsttext,char*myvalue)
{
  p_admsttext mynewadmsttext=adms_admsttext_new(myadmsttext->_admsttransform,myvalue);
  adms_admsttext_parse(mynewadmsttext);
  adms_slist_push(&(myadmsttext->_token),adms_adms(mynewadmsttext));
}
static const char* adms_admsttext_reduce (p_admsttext myadmsttext,const char*mycur,const char*myprev)
{
  if(*mycur=='%')
  {
    reduce_quark(myadmsttext,adms_m2nclone(myprev,mycur));
    if(*(mycur+1)=='%')
    {
      reduce_constquark(myadmsttext,"%");
      return mycur+2;
    }
    else if(*(mycur+1)=='(')
    {
      const char*mynewcur=mycur+2;
      int nomatch=1;
      while(nomatch&&*mynewcur)
      {
        if(*mynewcur==')')
          nomatch--;
        else if(*mynewcur=='(')
          nomatch++;
        if(nomatch)
          mynewcur++;
        else
        {
          char*myvalue=adms_m2nclone(mycur+2,mynewcur);
          p_admstpath myadmstpath=adms_admstpath_new(myvalue);
          p_admsttransformattribute myadmsttransformattribute=
            adms_admsttransformattribute_new(myadmsttext->_admsttransform,myvalue);
          p_slist myadmstpathgoto=admstpathparse(myadmsttext->_admsttransform,myvalue);
          adms_admsttransformattribute_valueto_admstpathgoto(myadmsttransformattribute,myadmstpathgoto);
          myadmstpath->_admsttransformattribute=myadmsttransformattribute;
          adms_slist_push(&(myadmsttext->_token),adms_adms(myadmstpath));
          free(myvalue);
          return mynewcur+1;
        }
      }
    }
    else if(*(mycur+1)=='\0')
    {
      reduce_constquark(myadmsttext,"%");
      return NULL;
    }
    else
    {
      reduce_quark(myadmsttext,adms_m2nclone(mycur,mycur+2));
      return mycur+2;
    }
  }
  else if(*mycur=='\\')
  {
    reduce_quark(myadmsttext,adms_m2nclone(myprev,mycur));
    if(*(mycur+1)=='n')
      reduce_constquark(myadmsttext,"\n");
    else if(*(mycur+1)=='r')
      reduce_constquark(myadmsttext,"\r");
    else if(*(mycur+1)=='t')
      reduce_constquark(myadmsttext,"\t");
    else if(*(mycur+1)=='\0')
    {
      reduce_constquark(myadmsttext,"\\");
      return NULL;
    }
    else
      reduce_quark(myadmsttext,adms_constnclone(mycur+1,1));
    return mycur+2;
  }
  else if(*mycur=='$')
  {
    reduce_quark(myadmsttext,adms_m2nclone(myprev,mycur));
    if(*(mycur+1)=='(')
    {
      const char*mynewcur=mycur+2;
      int nomatch=1;
      while(nomatch&&*mynewcur)
      {
        if(*mynewcur==')')
          nomatch--;
        else if(*mynewcur=='(')
          nomatch++;
        if(nomatch)
          mynewcur++;
        else
        {
          reduce_admsttext(myadmsttext,adms_m2nclone(mycur+2,mynewcur));
          return mynewcur+1;
        }
      }
    }
    else if(*(mycur+1)=='\0')
    {
      reduce_admsttext(myadmsttext,adms_constclone("$"));
      return NULL;
    }
    else
    {
      const char*mynewcur=mycur+1;
      while(*mynewcur&&(isalnum(*mynewcur)||*mynewcur=='_'))
        mynewcur++;
      reduce_admsttext(myadmsttext,adms_m2nclone(mycur+1,mynewcur));
      return mynewcur;
    }
  }
  return NULL;
}
static void adms_admsttext_parse (p_admsttext myadmsttext)
{
  const char*cur=myadmsttext->_value;
  const char*prev=cur;
  if(myadmsttext->_token)
    adms_message_fatal(("admsttext already parsed!\n"));
  if(!*cur)
    reduce_constquark(myadmsttext,"");
  while(*cur)
  {
    const char*reduce=adms_admsttext_reduce(myadmsttext,cur,prev);
    if(reduce)
      cur=prev=reduce;
    else
      cur++;
  }
  if(*prev)
    reduce_constquark(myadmsttext,prev);
  myadmsttext->_token=adms_slist_reverse(myadmsttext->_token);
}
static void adms_admsttext_parse_first (p_admsttext myadmsttext)
{
  adms_admsttext_parse(myadmsttext);
  if(!strcmp(myadmsttext->_value,"%p"))
    adms_admsttext_valueto_type(myadmsttext,adms_admsttext_enumeration_type_admsstack);
  else if(adms_slist_length(myadmsttext->_token)==1)
  {
    if(myadmsttext->_token->data->_datatypename==adms_adms_enumeration_datatypename_admstpath)
      adms_admsttext_valueto_type(myadmsttext,adms_admsttext_enumeration_type_list);
  }
}

static char*tostring2(const p_admst myadmstparent, const p_admsttransformattribute myadmsttransformattribute)
{
  p_admsttext myadmsttext=adms_admsttransformattribute_valueof_admsttext(myadmsttransformattribute);
  return adms_admsttext_tostring(myadmstparent,myadmsttext);
}
static char*adms_admsttext_tostring(const p_admst myadmstparent, const p_admsttext myadmsttext)
{
  if(myadmsttext)
  {
    char*myvalue=adms_constclone("");
    p_slist myl=myadmsttext->_token;for(;myl;myl=myl->next)
    {
      p_adms myadms=myl->data;
      if(myadms->_datatypename==adms_adms_enumeration_datatypename_admsttext)
      {
        char*myvariablename=adms_admsttext_tostring(myadmstparent,adms_admsttext(myadms));
        p_admstvariable myadmstvariable=adms_admstvariable_lookup(myvariablename);
        free(myvariablename);
        if(myadmstvariable)
        {
          p_slist myl2=adms_admstvariable_valueof_value(myadmstvariable);
          for(;myl2;myl2=myl2->next)
          {
            p_adms myadms=myl2->data;
            if(adms_adms_valueof_datatypename(myadms)==adms_adms_enumeration_datatypename_quark)
              adms_strconcat2(&myvalue,adms_quark(myadms)->_value);
            else if(adms_adms_valueof_datatypename(myadms)==adms_adms_enumeration_datatypename_enumeration)
            {
              p_enumeration myenumeration=adms_enumeration(myadms);
              p_admsttransform myadmsttransform=myadmsttext->_admsttransform;
              adms_strconcat2(&myvalue,(((p_valuetostring)myenumeration->_tostring)(myadmsttransform,myenumeration)));
            }
            else
              adms_strconcat2(&myvalue,adms_admsxml_uid(myadms));
          }
        }
        else
        {
          adms_message_obsolete_continue(("admst variable $(%s) is undefined\n",adms_admsttext_valueof_value(adms_admsttext(myadms))))
          adms_message_obsolete(("Check if you really wanted to access an admst variable. If not replace '$' by '\\$'\n"))
          adms_message_obsolete(("'see %s\n",adms_admsttransform_uid(myadmsttext->_admsttransform)))
          adms_strconcat2(&myvalue,"$");
          adms_strconcat2(&myvalue,adms_admsttext_valueof_value(adms_admsttext(myadms)));
        }
      }
      else if(myadms->_datatypename==adms_adms_enumeration_datatypename_quark)
      {
        if(!strcmp(adms_quark(myadms)->_value,"%s"))
        {
          char*mynewvalue;
          p_admsttransform myadmsttransform=myadmsttext->_admsttransform;
          p_admst mynewadmst=adms_pull_admst(myadmsttransform);
          if(!(mynewvalue=adms_admst_tostring_with_obsolete(mynewadmst)))
            mynewvalue=adms_admst_tostring(mynewadmst);
          adms_strconcat(&myvalue,mynewvalue);
          adms_admst_free(mynewadmst);
        }
        else
          adms_strconcat2(&myvalue,adms_quark(myadms)->_value);
      }
      else if(myadms->_datatypename==adms_adms_enumeration_datatypename_admstpath)
      {
        p_admstpathevaluate myadmstpathevaluate=evaluate2(myadmsttext->_admsttransform,myadmstparent,adms_admstpath(myadms));
        p_slist myl; for(myl=myadmstpathevaluate->_admstasscalar;myl;myl=myl->next)
          adms_strconcat(&myvalue,adms_admst_tostring(adms_admst(myl->data)));
        free_admstpathevaluate(myadmstpathevaluate);
      }
    }
    return myvalue;
  }
  else
    return NULL;
}
static void flush(const p_admst myadmstparent, const p_admsttransformattribute myadmsttransformattribute)
{
  p_admsttext myadmsttext=adms_admsttransformattribute_valueof_admsttext(myadmsttransformattribute);
  if(myadmsttext)
  {
    p_slist myl=myadmsttext->_token;for(;myl;myl=myl->next)
    {
      p_adms myadms=myl->data;
      if(myadms->_datatypename==adms_adms_enumeration_datatypename_admsttext)
      {
        char*myvariablename=adms_admsttext_tostring(myadmstparent,adms_admsttext(myadms));
        p_admstvariable myadmstvariable=adms_admstvariable_lookup(myvariablename);
        free(myvariablename);
        if(myadmstvariable)
        {
          p_slist myl2=adms_admstvariable_valueof_value(myadmstvariable);
          for(;myl2;myl2=myl2->next)
          {
            p_adms myadms=myl2->data;
            if(adms_adms_valueof_datatypename(myadms)==adms_adms_enumeration_datatypename_quark)
              g_print("%s",adms_quark(myadms)->_value);
            else if(adms_adms_valueof_datatypename(myadms)==adms_adms_enumeration_datatypename_enumeration)
            {
              p_enumeration myenumeration=adms_enumeration(myadms);
              p_admsttransform myadmsttransform=myadmsttext->_admsttransform;
              g_print("%s",(((p_valuetostring)myenumeration->_tostring)(myadmsttransform,myenumeration)));
            }
            else
              g_print("%s",adms_admsxml_uid(myadms));
          }
        }
        else
        {
          adms_message_obsolete_continue(("admst variable $(%s) is undefined\n",adms_admsttext_valueof_value(adms_admsttext(myadms))))
          adms_message_obsolete(("Check if you really wanted to access an admst variable. If not replace '$' by '\\$'\n"))
          adms_message_obsolete(("'see %s\n",adms_admsttransform_uid(myadmsttext->_admsttransform)))
          g_print("$");
          g_print("%s",adms_admsttext_valueof_value(adms_admsttext(myadms)));
        }
      }
      else if(myadms->_datatypename==adms_adms_enumeration_datatypename_quark)
      {
        if(!strcmp(adms_quark(myadms)->_value,"%s"))
        {
          char*mynewvalue;
          p_admsttransform myadmsttransform=myadmsttext->_admsttransform;
          p_admst mynewadmst=adms_pull_admst(myadmsttransform);
          if(!(mynewvalue=adms_admst_tostring_with_obsolete(mynewadmst)))
            mynewvalue=adms_admst_tostring(mynewadmst);
          g_print("%s",mynewvalue);
          free(mynewvalue);
          adms_admst_free(mynewadmst);
        }
        else
          g_print("%s",adms_quark(myadms)->_value);
      }
      else if(myadms->_datatypename==adms_adms_enumeration_datatypename_admstpath)
      {
        p_admstpathevaluate myadmstpathevaluate=evaluate2(myadmsttext->_admsttransform,myadmstparent,adms_admstpath(myadms));
        p_slist myl; for(myl=myadmstpathevaluate->_admstasscalar;myl;myl=myl->next)
          g_print("%s",adms_admst_tostring(adms_admst(myl->data)));
        free_admstpathevaluate(myadmstpathevaluate);
      }
    }
  }
}

static int is_admst (const char*admstname)
{
  if(((strlen(admstname)==5)&&!strncmp(admstname,"admst",5))||((strlen(admstname)>5)&&!strncmp(admstname,"admst:",6)))
    return 1;
  return 0;
}

_t_inline_admsttransform_evaluate(adms_admsttransform_notadmst_evaluate)
{
  p_slist l;
  p_slist Attribute;
  g_print("<%s",adms_admsttransform_valueof_admstname(myadmsttransform));
  Attribute=adms_admsttransform_valueof_attribute(myadmsttransform);
  while (Attribute)
  {
    p_attribute myattribute=adms_attribute(Attribute->data);
    char*name=adms_admsttext_tostring(myadmstparent,adms_admsttext(adms_attribute_valueof_value(myattribute)));
    g_print(" %s=\"",adms_attribute_valueof_name(myattribute)->_value);
    g_print("%s",name); free(name);
    g_print("\"");
    Attribute=Attribute->next;
  }
  for(l=adms_admsttransform_valueof_children(myadmsttransform);l;l=l->next)
  {
    p_admsttransform mychild=adms_admsttransform(l->data);
    if(!strcmp(adms_admsttransform_valueof_admstname(mychild),"admst:attribute"))
    {
      char*name=tostring2(myadmstparent,adms_admsttransform_valueof_zzname(mychild));
      g_print(" %s=\"",name); free(name);
      {p_slist ll;for(ll=adms_admsttransform_valueof_children(mychild);ll;ll=ll->next)
        adms_admsttransform_evaluate(adms_admsttransform(ll->data),myadmstparent);}
      g_print("\"");
    }
  }
  g_print(">\n");
  for(l=adms_admsttransform_valueof_children(myadmsttransform);l;l=l->next)
  {
    p_admsttransform mychild=adms_admsttransform(l->data);
    if(!!strcmp(adms_admsttransform_valueof_admstname(mychild),"admst:attribute"))
      adms_admsttransform_evaluate(mychild,myadmstparent);
  }
  g_print("</%s>\n",adms_admsttransform_valueof_admstname(myadmsttransform));
}
_t_inline_admsttransform_evaluate(adms_admsttransform_admst_evaluate)
{
  char*available=PACKAGE_VERSION;
  char**Available=adms_strsplit(available,".",3);
  int available_major=strtol(Available[0],(char **)NULL,10);
  int available_minor=strtol(Available[1],(char **)NULL,10);
  int available_micro=strtol(Available[2],(char **)NULL,10);
  char*required=tostring2(myadmstparent,adms_admsttransform_valueof_zzversion(myadmsttransform));
  char**Required=adms_strsplit(required,".",3);
  int required_major;
  int required_minor;
  int required_micro;
  if(!(Required[0]&&Required[1]&&Required[2]))
    adms_message_fatal(("%s: invalid version number\n",adms_admsttransform_uid(myadmsttransform)))
  errno=0;
  required_major=strtol(Required[0],(char **)NULL,10);
  required_minor=strtol(Required[1],(char **)NULL,10);
  required_micro=strtol(Required[2],(char **)NULL,10);
  if(errno)
    adms_message_fatal(("%s: '%s' invalid version number - should be for instance %s\n",adms_admsttransform_uid(myadmsttransform),required,available))
  if((required_major>available_major)||(required_minor>available_minor))
    adms_message_fatal(("%s: installed version of adms is too old (required: %s available: %s)\n",adms_admsttransform_uid(myadmsttransform),required,available))
  if((required_major<available_major)||(required_minor<available_minor))
    adms_message_fatal(("%s: installed version of adms is too recent (required: %s available: %s)\n",adms_admsttransform_uid(myadmsttransform),required,available))
  if(required_micro>available_micro)
    adms_message_warning(("%s: installed version of adms too old (required: %s available: %s)\n",adms_admsttransform_uid(myadmsttransform),required,available))
  {
    p_slist l;for(l=adms_admsttransform_valueof_children(myadmsttransform);l;l=l->next)
    adms_admsttransform_evaluate(adms_admsttransform(l->data),myadmstparent);
  }
  free(required);
}
_t_inline_admsttransform_evaluate(adms_admsttransform_foreach_evaluate)
{
  p_admstpathevaluate myadmstpathevaluate=evaluate(myadmstparent,adms_admsttransform_valueof_zzselect(myadmsttransform));
  p_slist myl;for(myl=myadmstpathevaluate->_admstasscalar;myl;myl=myl->next)
  {
    p_slist l;for(l=adms_admsttransform_valueof_children(myadmsttransform);l;l=l->next)
      adms_admsttransform_evaluate(adms_admsttransform(l->data),adms_admst(myl->data));
  }
  free_admstpathevaluate(myadmstpathevaluate);
}
_t_inline_admsttransform_evaluate(adms_admsttransform_join_evaluate)
{
  char*separator;
  p_admstpathevaluate myadmstpathevaluate;
  if(adms_admsttransform_valueof_zzseparator(myadmsttransform))
    separator=tostring2(myadmstparent,adms_admsttransform_valueof_zzseparator(myadmsttransform));
  else
    separator=adms_constclone(",\n");
  myadmstpathevaluate=evaluate(myadmstparent,adms_admsttransform_valueof_zzselect(myadmsttransform));
  {p_slist myl; for(myl=myadmstpathevaluate->_admstasscalar;myl;myl=myl->next)
  {
    p_slist l;for(l=adms_admsttransform_valueof_children(myadmsttransform);l;l=l->next)
      adms_admsttransform_evaluate(adms_admsttransform(l->data),adms_admst(myl->data));
    if(myl->next)
      g_print("%s",separator);
  }}
  free(separator);
  free_admstpathevaluate(myadmstpathevaluate);
}
_t_inline_admsttransform_evaluate(adms_admsttransform_valueof_evaluate)
{
  p_admstpathevaluate myadmstpathevaluate=evaluate(myadmstparent,adms_admsttransform_valueof_zzselect(myadmsttransform));
  if(myadmstpathevaluate->_admstaslist)
  {
    p_slist l=myadmstpathevaluate->_admstaslist; for(;l;l=l->next)
    {
      p_admst mynewadmst=adms_admst(l->data);
      p_admst mycloneadmst=adms_admst_new(mynewadmst->_admsttransform,NULL,mynewadmst->_attributename,adms_admst_enumeration_size_list);
      adms_admst_valueto_item(mycloneadmst,mynewadmst->_item);
      adms_slist_push(&adms_admsmain_valueof_valueof(adms_global_admsmain()),adms_adms(mycloneadmst));
    }
  }
  else if(myadmstpathevaluate->_admstasscalar)
  {
    p_slist myl=myadmstpathevaluate->_admstasscalar; for(;myl;myl=myl->next)
    {
      p_admst myadmst=adms_admst(myl->data);
      p_admst mycloneadmst=adms_admst_new(myadmst->_admsttransform,NULL,myadmst->_attributename,myadmst->_size);
      adms_admst_valueto_item(mycloneadmst,myadmst->_item);
      if(myadmst->_item&&(adms_admst_valueof_size(myadmst)==adms_admst_enumeration_size_scalar)&&(myadmst->_item->_datatypename==adms_adms_enumeration_datatypename_quark))
      {
        p_quark mynewquark=adms_quark_new(adms_quark_valueof_value(adms_admst_valueof_item(mycloneadmst)));
        adms_admst_valueto_item(mycloneadmst,adms_adms(mynewquark));
      }
      else
        adms_admst_valueto_item(mycloneadmst,myadmst->_item);
      adms_slist_push(&adms_admsmain_valueof_valueof(adms_global_admsmain()),adms_adms(mycloneadmst));
    }
  }
  else
    adms_slist_push(&adms_admsmain_valueof_valueof(adms_global_admsmain()),NULL);
  free_admstpathevaluate(myadmstpathevaluate);
}
_t_inline_admsttransform_evaluate(adms_admsttransform_inside_evaluate)
{
  p_admst mylistadmst;
  p_slist mylist=NULL;
  p_admsttext yylist=adms_admsttransform_valueof_zzlist(myadmsttransform)->_admsttext;
  int isEmpty;
  if(adms_admsttext_valueof_type(yylist)==adms_admsttext_enumeration_type_admsstack)
  {
    p_admst mynewadmst=adms_pull_admst(myadmsttransform);
    mylistadmst=adms_admst(mynewadmst);
    mylist=mylistadmst?(p_slist )mylistadmst->_item:NULL;
  }
  else if(adms_admsttext_valueof_type(yylist)==adms_admsttext_enumeration_type_list)
  {
    p_admstpathevaluate myadmstpathevaluate=evaluate2(myadmsttransform,myadmstparent,adms_admstpath(yylist->_token->data));
    mylistadmst=adms_admst(myadmstpathevaluate->_admstaslist->data);
    mylist=mylistadmst?(p_slist )mylistadmst->_item:NULL;
    free_admstpathevaluate(myadmstpathevaluate);
  }
  else
  {
    adms_message_fatal_continue(("attribute 'list' should be exactly '%%p' or '%%(admstpath)' where admstpath is a valid admstpath\n"))
    adms_message_fatal(("'see %s\n",adms_admsttransform_uid(myadmsttransform)))
  }
  {
    p_admstpathevaluate myadmstpathevaluate=evaluate(myadmstparent,adms_admsttransform_valueof_zzselect(myadmsttransform));
    isEmpty=1;
    {p_slist l=myadmstpathevaluate->_admstasscalar; for(;l&&isEmpty;l=l->next)
    {
      p_admst myadmst=adms_admst(l->data);
      /*bug: if-inside behaves like if-not-inside when 'select' is a list */
      if(T(admst:if-inside)&&myadmstpathevaluate->_admstaslist)
        isEmpty=!!adms_slist_find(mylist,adms_admst_valueof_item(myadmst));
      else
        isEmpty=!adms_slist_find(mylist,adms_admst_valueof_item(myadmst));
    }}
    if((isEmpty&&T(admst:if-not-inside))||(!isEmpty&&T(admst:if-inside)))
    {
      p_slist l;for(l=adms_admsttransform_valueof_children(myadmsttransform);l;l=l->next)
        adms_admsttransform_evaluate(adms_admsttransform(l->data),myadmstparent);
    }
    free_admstpathevaluate(myadmstpathevaluate);
  }
}
_t_inline_admsttransform_evaluate(adms_admsttransform_choose_evaluate)
{
  p_slist l;for(l=adms_admsttransform_valueof_children(myadmsttransform);l;l=l->next)
  {
    p_admsttransform mychild=adms_admsttransform(l->data);
    if(!strcmp(adms_admsttransform_valueof_admstname(mychild),"admst:when"))
    {
      p_admstpathevaluate myadmstpathevaluate=evaluate(myadmstparent,adms_admsttransform_valueof_zztest(mychild));
      if(myadmstpathevaluate->_admstasscalar&&adms_admst(myadmstpathevaluate->_admstasscalar->data)->_item)
      {
        p_slist ll;for(ll=adms_admsttransform_valueof_children(mychild);ll;ll=ll->next)
          adms_admsttransform_evaluate(adms_admsttransform(ll->data),myadmstparent);
        free_admstpathevaluate(myadmstpathevaluate);
        return;
      }
      free_admstpathevaluate(myadmstpathevaluate);
    }
    else if(!strcmp(adms_admsttransform_valueof_admstname(mychild),"admst:otherwise"))
    {
      p_slist ll;for(ll=adms_admsttransform_valueof_children(mychild);ll;ll=ll->next)
      adms_admsttransform_evaluate(adms_admsttransform(ll->data),myadmstparent);
      return;
    }
    else
      adms_message_fatal(("%s: %s admst transform unexpected",adms_admsttransform_uid(myadmsttransform),adms_admsttransform_uid(mychild)))
  }
}
_t_inline_admsttransform_evaluate(adms_admsttransform_if_evaluate)
{
  p_slist l;for(l=adms_admsttransform_valueof_children(myadmsttransform);l;l=l->next)
    adms_admsttransform_evaluate(adms_admsttransform(l->data),myadmstparent);
}
_t_inline_admsttransform_evaluate(adms_admsttransform_return_evaluate)
{
  char*myname=tostring2(myadmstparent,adms_admsttransform_valueof_zzname(myadmsttransform));
  char*myvalue=tostring2(myadmstparent,adms_admsttransform_valueof_zzvalue(myadmsttransform));
  p_attribute myattribute=adms_attribute_new(adms_quark_new(myname));
  p_instanceofadmsttransform myinstanceofadmsttransform=adms_admsmain_valueof_instanceofadmsttransform(adms_global_admsmain())
    ?adms_instanceofadmsttransform(adms_admsmain_valueof_instanceofadmsttransform(adms_global_admsmain())->data):NULL;
  adms_attribute_valueto_value(myattribute,adms_adms(adms_quark_new(myvalue)));
  free(myname);
  free(myvalue);
  if(myinstanceofadmsttransform)
    adms_instanceofadmsttransform_list_return_prepend_once_or_abort(myinstanceofadmsttransform,myattribute);
  else
  {
    adms_message_fatal_continue(("admst:return only allowed inside admst:template\n"))
    adms_message_fatal(("'see %s\n",adms_admsttransform_uid(myadmsttransform)))
  }
}
_t_inline_admsttransform_evaluate(adms_admsttransform_applytemplates_evaluate)
{
  p_admstpathevaluate myadmstpathevaluate=evaluate(myadmstparent,adms_admsttransform_valueof_zzselect(myadmsttransform));
  p_slist myl; for(myl=myadmstpathevaluate->_admstasscalar;myl;myl=myl->next)
  {
    p_slist l;
    p_admsttransform mytemplate=NULL;
    char*match=tostring2(adms_admst(myl->data),adms_admsttransform_valueof_zzmatch(myadmsttransform));
    p_instanceofadmsttransform myinstanceofadmsttransform;
    for(l=adms_admsmain_valueof_template(adms_global_admsmain());l&&!mytemplate;l=l->next)
      if(!strcmp(adms_admsttransform_valueof_zzmatch(l->data)->_value,match))
        mytemplate=adms_admsttransform(l->data);
    if(!mytemplate)
    {
      adms_message_fatal_continue(("Template not found:\n"))
      adms_message_fatal_continue(("  <admst:template match=\"%s\"/>\n",match))
      adms_message_fatal(("  see:  %s\n",adms_admsttransform_uid(myadmsttransform)))
    }
    myinstanceofadmsttransform=adms_instanceofadmsttransform_new(mytemplate);
    adms_slist_push(&adms_admsmain_valueof_instanceofadmsttransform(adms_global_admsmain()),adms_adms(myinstanceofadmsttransform));
    if(adms_admst_valueof_item(adms_admst(myl->data)))
    {
      for(l=adms_admsttransform_valueof_children(mytemplate);l;l=l->next)
        adms_admsttransform_evaluate(adms_admsttransform(l->data),adms_admst(myl->data));
      while(adms_instanceofadmsttransform_valueof_variable(myinstanceofadmsttransform))
      {
        p_admstvariable myadmstvariable=adms_admstvariable(adms_instanceofadmsttransform_valueof_variable(myinstanceofadmsttransform)->data);
        adms_admstvariable_free(myadmstvariable);
        adms_instanceofadmsttransform_valueto_variable(myinstanceofadmsttransform,adms_instanceofadmsttransform_valueof_variable(myinstanceofadmsttransform)->next);
      }
    }
    adms_slist_pull(&adms_admsmain_valueof_instanceofadmsttransform(adms_global_admsmain()));
    adms_slist_push(&adms_admsmain_valueof_instanceofadmsttransforminsideapplytemplate(adms_global_admsmain()),adms_adms(myinstanceofadmsttransform));
    for(l=adms_admsttransform_valueof_children(myadmsttransform);l;l=l->next)
      adms_admsttransform_evaluate(adms_admsttransform(l->data),adms_admst(myl->data));
    adms_instanceofadmsttransform_free(myinstanceofadmsttransform);
    adms_slist_pull(&adms_admsmain_valueof_instanceofadmsttransforminsideapplytemplate(adms_global_admsmain()));
    free(match);
  }
  free_admstpathevaluate(myadmstpathevaluate);
}
_t_inline_admsttransform_evaluate(adms_admsttransform_variable_evaluate)
{
  p_slist myoldvalue=NULL;
  p_slist mynewvalue=NULL;
  p_instanceofadmsttransform myinstanceofadmsttransform=adms_admsmain_valueof_instanceofadmsttransform(adms_global_admsmain())
    ?adms_instanceofadmsttransform(adms_admsmain_valueof_instanceofadmsttransform(adms_global_admsmain())->data):NULL;
  p_admstvariable myadmstvariable;
  char*zzname=tostring2(myadmstparent,adms_admsttransform_valueof_zzname(myadmsttransform));
  p_quark myquark=adms_quark_new(zzname); free(zzname);
  if(myinstanceofadmsttransform&&(myadmstvariable=adms_instanceofadmsttransform_list_variable_lookup_by_id(myinstanceofadmsttransform,myquark)))
    adms_quark_free(myquark);
  else if((myadmstvariable=adms_admsmain_list_variable_lookup_by_id(adms_global_admsmain(),myquark)))
    adms_quark_free(myquark);
  else if(myinstanceofadmsttransform)
    myadmstvariable=adms_instanceofadmsttransform_list_variable_prepend_by_id(myinstanceofadmsttransform,myquark);
  else
    myadmstvariable=adms_admsmain_list_variable_prepend_by_id(adms_global_admsmain(),myquark);
  if(myadmstvariable->_value_isdefault!=-1)
    myoldvalue=myadmstvariable->_value;
  if(adms_admsttransform_valueof_zzselect(myadmsttransform))
  {
    p_admsttext yyselect=adms_admsttransform_valueof_zzselect(myadmsttransform)->_admsttext;
    if(adms_admsttext_valueof_type(yyselect)==adms_admsttext_enumeration_type_admsstack)
    {
      p_admst mynewadmst=adms_pull_admst(myadmsttransform);
      adms_slist_push(&mynewvalue,adms_adms(adms_admst_valueof_item(mynewadmst)));
      myadmstvariable->_value=adms_slist_reverse(myadmstvariable->_value);
      adms_admst_free(mynewadmst);
    }
    else if(adms_admsttext_valueof_type(yyselect)==adms_admsttext_enumeration_type_list)
    {
      p_admstpathevaluate myadmstpathevaluate=evaluate2(myadmsttransform,myadmstparent,adms_admstpath(yyselect->_token->data));
      p_slist myl; for(myl=myadmstpathevaluate->_admstasscalar;myl;myl=myl->next)
      {
        p_admst myadmst=adms_admst(myl->data);
        if(myadmst->_item==NULL)
          adms_message_fatal(("%s\n",adms_admsttransform_uid(myadmsttransform))) 
        else if(adms_adms_valueof_datatypename(myadmst->_item)==adms_adms_enumeration_datatypename_quark)
        {
          char*myvalue=adms_admst_tostring(myadmst);
          p_quark myquark=adms_quark_new(myvalue);
          adms_slist_push(&mynewvalue,adms_adms(myquark));
          free(myvalue);
        }
        else
          adms_slist_push(&mynewvalue,adms_adms(myadmst->_item));
      }
      myadmstvariable->_value=adms_slist_reverse(myadmstvariable->_value);
      free_admstpathevaluate(myadmstpathevaluate);
    }
    else
    {
      char*newvalue=adms_admsttext_tostring(myadmstparent,yyselect);
      p_quark myquark=adms_quark_new(newvalue); free(newvalue);
      adms_slist_push(&mynewvalue,adms_adms(myquark));
    }
  }
  adms_admstvariable_valueto_value(myadmstvariable,mynewvalue);
  {
    p_slist myl; for(myl=myoldvalue;myl;myl=myl->next)
    {
      if(adms_adms_valueof_datatypename(myl->data)==adms_adms_enumeration_datatypename_quark)
        adms_quark_free(adms_quark(myl->data));
    }
    adms_slist_free(myoldvalue);
  }
}
_t_inline_admsttransform_evaluate(adms_admsttransform_text_evaluate)
{
  if(adms_admsttransform_valueof_zzselect(myadmsttransform))
  {
    p_admstpathevaluate myadmstpathevaluate=evaluate(myadmstparent,adms_admsttransform_valueof_zzselect(myadmsttransform));
    p_slist myl;for(myl=myadmstpathevaluate->_admstasscalar;myl;myl=myl->next)
      flush(adms_admst(myl->data),adms_admsttransform_valueof_zzformat(myadmsttransform));
    free_admstpathevaluate(myadmstpathevaluate);
  }
  else
    flush(myadmstparent,adms_admsttransform_valueof_zzformat(myadmsttransform));
}
_t_inline_admsttransform_evaluate(adms_admsttransform_new_evaluate)
{
  p_admst myadmst=adms_admst_new(myadmsttransform,myadmstparent,"?",adms_admst_enumeration_size_scalar);
  int size=adms_slist_length(adms_admsttransform_valueof_attribute(myadmsttransform));
  p_adms* Arguments=(p_adms*)malloc(sizeof(p_adms)*size);
  p_new new=adms_admsxml_new(myadmsttransform);
  int i=0;
  p_slist l;
  p_slist myll; for(myll=adms_admsttransform_valueof_attribute(myadmsttransform);myll;myll=myll->next)
  {
    p_admsttext zzarguments=adms_admsttext(myll->data);
    if(adms_admsttext_valueof_type(zzarguments)==adms_admsttext_enumeration_type_admsstack)
    {
      p_admst mynewadmst=adms_pull_admst(myadmsttransform);
      Arguments[i]=adms_admst_valueof_item(mynewadmst);
      adms_admst_free(mynewadmst);
    }
    else if(adms_admsttext_valueof_type(zzarguments)==adms_admsttext_enumeration_type_list)
    {
      p_admstpathevaluate myadmstpathevaluate=evaluate2(myadmsttransform,myadmstparent,adms_admstpath(zzarguments->_token->data));
      p_slist myl; for(myl=myadmstpathevaluate->_admstasscalar;myl;myl=myl->next)
      {
        p_admst myadmst=adms_admst(myl->data);
        Arguments[i]=adms_admst_valueof_item(myadmst);
      }
      free_admstpathevaluate(myadmstpathevaluate);
    }
    else
      Arguments[i]=adms_adms(adms_admsttext_tostring(myadmstparent,zzarguments));
    i++;
  }
  adms_admst_valueto_item(myadmst,new(Arguments));
  for(l=adms_admsttransform_valueof_children(myadmsttransform);l;l=l->next)
    adms_admsttransform_evaluate(adms_admsttransform(l->data),myadmst);
  adms_admst_free(myadmst);
}
_t_inline_admsttransform_evaluate(adms_admsttransform_pull_evaluate)
{
  p_slist myl;
  p_admstpathevaluate myadmstpathevaluate=evaluate(myadmstparent,adms_admsttransform_valueof_zzselect(myadmsttransform));
  for(myl=myadmstpathevaluate->_admstasscalar;myl;myl=myl->next)
  {
    p_admst myadmst=adms_admst(myl->data);
    p_slist mylist=(p_slist )adms_admsxml_valueof(adms_admst_valueof_previous(myadmst),adms_admst_valueof_attributename(myadmst));
    if(adms_admst_valueof_size(myadmst)!=adms_admst_enumeration_size_list)
      adms_message_fatal(("  assert=size(list) failed %s\n",adms_admsttransform_uid(myadmsttransform))) 
    adms_slist_pull(&mylist);
    VALUETO(adms_admst_valueof_previous(myadmst),adms_admst_valueof_attributename(myadmst),mylist)
  }
  free_admstpathevaluate(myadmstpathevaluate);
}
_t_inline_admsttransform_evaluate(adms_admsttransform_push_evaluate)
{
  int onduplicate_ignore=0;
  p_admsttransformattribute zzonduplicate=adms_admsttransform_valueof_zzonduplicate(myadmsttransform);
  p_slist l;
  p_admstpathevaluate myadmstpathevaluateinto;
  if(zzonduplicate&&!strcmp(zzonduplicate->_value,"ignore"))
    onduplicate_ignore=1;
  myadmstpathevaluateinto=evaluate(myadmstparent,adms_admsttransform_valueof_zzinto(myadmsttransform));
  for(l=myadmstpathevaluateinto->_admstaslist;l;l=l->next)
  {
    p_admst myadmstinto=adms_admst(l->data);
    p_slist mylistinto=(p_slist )(myadmstinto->_item);
    p_admstpathevaluate myadmstpathevaluate=evaluate(myadmstparent,adms_admsttransform_valueof_zzselect(myadmsttransform));
    p_slist myl; for(myl=myadmstpathevaluate->_admstasscalar;myl;myl=myl->next)
    {
      int found=0;
      p_admst myadmst=adms_admst(myl->data);
      p_cmp mycmp=adms_admsxml_cmp(myadmst);
      p_slist ll;for(ll=mylistinto;onduplicate_ignore&&ll&&!found;ll=ll->next)
      {
        if(ll->data->_datatypename!=adms_admst_valueof_item(myadmst)->_datatypename)
        {}
        else if(!mycmp(ll->data,adms_admst_valueof_item(myadmst)))
          found=1;
      }
      if(!found)
      {
        adms_slist_push(&mylistinto,adms_admst_valueof_item(myadmst));
        VALUETO(adms_admst_valueof_previous(myadmstinto),adms_admst_valueof_attributename(myadmstinto),mylistinto)
      }
    }
    free_admstpathevaluate(myadmstpathevaluate);
  }
  free_admstpathevaluate(myadmstpathevaluateinto);
}
_t_inline_admsttransform_evaluate(adms_admsttransform_reset_evaluate)
{
  p_admstpathevaluate myadmstpathevaluate=evaluate(myadmstparent,adms_admsttransform_valueof_zzselect(myadmsttransform));
  p_slist myl=myadmstpathevaluate->_admstasscalar;
  if(myl)
  {
    p_admst myadmst=adms_admst(myl->data);
    if(adms_admst_valueof_size(myadmst)!=adms_admst_enumeration_size_list)
      VALUETO(adms_admst_valueof_previous(myadmst),adms_admst_valueof_attributename(myadmst),NULL)
  }
  free_admstpathevaluate(myadmstpathevaluate);
}
_t_inline_admsttransform_evaluate(adms_admsttransform_valueto_evaluate)
{
  if(adms_admsttransform_valueof_zzvalue(myadmsttransform))
  {
    p_admstpathevaluate myadmstpathevaluate=evaluate(myadmstparent,adms_admsttransform_valueof_zzselect(myadmsttransform));
    p_slist myl; for(myl=myadmstpathevaluate->_admstasscalar;myl;myl=myl->next)
    {
      p_admst myadmst=adms_admst(myl->data);
      if(myadmst->_item)
      {
        if(myadmst->_item->_datatypename==adms_adms_enumeration_datatypename_enumeration)
        {
          p_enumeration myenumeration=adms_enumeration(myadmst->_item);
          p_valuefromstring myvaluefromstring=myenumeration->_fromstring;
          char *mysvalue=tostring2(myadmstparent,adms_admsttransform_valueof_zzvalue(myadmsttransform));
          int myvalue=myvaluefromstring(myadmsttransform,mysvalue);
          free(mysvalue);
          adms_enumeration_valueto_value(myenumeration,myvalue);
        }
        else if(myadmst->_item->_datatypename==adms_adms_enumeration_datatypename_real)
        {
          p_real myreal=adms_real(myadmst->_item);
          char*mynumber=tostring2(myadmstparent,adms_admsttransform_valueof_zzvalue(myadmsttransform));
          myreal->_value=adms_strtod(mynumber);
          free(mynumber);
        }
        else if(myadmst->_item->_datatypename==adms_adms_enumeration_datatypename_quark)
        {
          p_quark myquark=adms_quark(myadmst->_item);
          char*myvalue=tostring2(myadmstparent,adms_admsttransform_valueof_zzvalue(myadmsttransform));
          adms_quark_valueto_value(myquark,myvalue); free(myvalue);
        }
        else
        {
          p_admsttext yyvalue=adms_admsttransform_valueof_zzvalue(myadmsttransform)->_admsttext;
          if(adms_admsttext_valueof_type(yyvalue)==adms_admsttext_enumeration_type_admsstack)
          {
             p_admst mynewadmst=adms_pull_admst(myadmsttransform);
             VALUETO(adms_admst_valueof_previous(myadmst),adms_admst_valueof_attributename(myadmst),adms_admst_valueof_item(mynewadmst))
             adms_admst_free(mynewadmst);
          }
          else if(adms_admsttext_valueof_type(yyvalue)==adms_admsttext_enumeration_type_list)
          {
            p_admstpathevaluate myadmstpathevaluate2=evaluate2(myadmsttransform,myadmstparent,adms_admstpath(yyvalue->_token->data));
            p_slist myl; for(myl=myadmstpathevaluate2->_admstasscalar;myl;myl=myl->next)
            {
              p_admst mynewadmst=adms_admst(myl->data);
              VALUETO(adms_admst_valueof_previous(myadmst),adms_admst_valueof_attributename(myadmst),adms_admst_valueof_item(mynewadmst))
            }
            free_admstpathevaluate(myadmstpathevaluate2);
          }
          else
          {
            char*myvalue=tostring2(myadmstparent,adms_admsttransform_valueof_zzvalue(myadmsttransform));
            p_quark myquark=adms_quark_new(myvalue); free(myvalue);
            VALUETO(adms_admst_valueof_previous(myadmst),adms_admst_valueof_attributename(myadmst),myquark)
          }
        }
      }
      else
      {
        p_admsttext yyvalue=adms_admsttransform_valueof_zzvalue(myadmsttransform)->_admsttext;
        if(adms_admsttext_valueof_type(yyvalue)==adms_admsttext_enumeration_type_admsstack)
        {
           p_admst mynewadmst=adms_pull_admst(myadmsttransform);
           VALUETO(adms_admst_valueof_previous(myadmst),adms_admst_valueof_attributename(myadmst),adms_admst_valueof_item(mynewadmst))
           adms_admst_free(mynewadmst);
        }
        else if(adms_admsttext_valueof_type(yyvalue)==adms_admsttext_enumeration_type_list)
        {
          p_admstpathevaluate myadmstpathevaluate2=evaluate2(myadmsttransform,myadmstparent,adms_admstpath(yyvalue->_token->data));
          p_slist myl; 
          for(myl=myadmstpathevaluate2->_admstasscalar;myl;myl=myl->next)
          {
            p_admst mynewadmst=adms_admst(myl->data);
            VALUETO(adms_admst_valueof_previous(myadmst),adms_admst_valueof_attributename(myadmst),adms_admst_valueof_item(mynewadmst))
          }
          free_admstpathevaluate(myadmstpathevaluate2);
        }
        else
        {
          char*myvalue=tostring2(myadmstparent,adms_admsttransform_valueof_zzvalue(myadmsttransform));
          p_quark myquark=adms_quark_new(myvalue); free(myvalue);
          VALUETO(adms_admst_valueof_previous(myadmst),adms_admst_valueof_attributename(myadmst),myquark)
        }
      }
    }
    free_admstpathevaluate(myadmstpathevaluate);
  }
  else
  {
    p_admstpathevaluate myadmstpathevaluate=evaluate(myadmstparent,adms_admsttransform_valueof_zzselect(myadmsttransform));
    p_slist myl; for(myl=myadmstpathevaluate->_admstasscalar;myl;myl=myl->next)
    {
      p_admst myadmst=adms_admst(myl->data);
      if(myadmst->_item==NULL)
      {
        if(myadmst->_item->_datatypename==adms_adms_enumeration_datatypename_quark)
          adms_quark_free(adms_quark(myadmst->_item));
        else if(myadmst->_item->_datatypename==adms_adms_enumeration_datatypename_enumeration)
          adms_enumeration_free(adms_enumeration(myadmst->_item));
        VALUETO(adms_admst_valueof_previous(myadmst),adms_admst_valueof_attributename(myadmst),NULL)
      }
    }
    free_admstpathevaluate(myadmstpathevaluate);
  }
}
_t_inline_admsttransform_evaluate(adms_admsttransform_count_evaluate)
{
  p_admstpathevaluate myadmstpathevaluate=evaluate(myadmstparent,adms_admsttransform_valueof_zzselect(myadmsttransform));
  p_admst myadmst=adms_admst_new(myadmsttransform,NULL,"admst:count",adms_admst_enumeration_size_scalar);
  char*mycount=adms_integertostring(adms_slist_length(myadmstpathevaluate->_admstasscalar));
  adms_admst_valueto_item(myadmst,adms_adms(adms_quark_new(mycount))); free(mycount);
  adms_slist_push(&adms_admsmain_valueof_valueof(adms_global_admsmain()),adms_adms(myadmst));
  free_admstpathevaluate(myadmstpathevaluate);
}
_t_inline_admsttransform_evaluate(adms_admsttransform_reverse_evaluate)
{
  p_admstpathevaluate myadmstpathevaluate=evaluate(myadmstparent,adms_admsttransform_valueof_zzselect(myadmsttransform));
  p_slist l=myadmstpathevaluate->_admstaslist; for(;l;l=l->next)
  {
    p_admst myadmst=adms_admst(l->data);
    p_slist mylist=adms_slist_reverse((p_slist )myadmst->_item);
    VALUETO(adms_admst_valueof_previous(myadmst),adms_admst_valueof_attributename(myadmst),mylist)
  }
  free_admstpathevaluate(myadmstpathevaluate);
}
_t_inline_admsttransform_evaluate(adms_admsttransform_open_evaluate)
{
  char*myfilename=tostring2(myadmstparent,adms_admsttransform_valueof_zzfile(myadmsttransform));
  FILE*ofh=adms_file_open_write(myfilename);
  p_slist l;
  if(ofh)
    adms_file_setfile_output (ofh);
  else
   adms_message_fatal(("%s: cannot open file.\n",adms_admsttransform_uid(myadmsttransform)))
  for(l=adms_admsttransform_valueof_children(myadmsttransform);l;l=l->next)
    adms_admsttransform_evaluate(adms_admsttransform(l->data),myadmstparent);
  adms_file_close_output();
  adms_file_setfile_output(stdout);
  free(myfilename);
}
_t_inline_admsttransform_evaluate(adms_admsttransform_setenv_evaluate)
{
  char*myname=tostring2(myadmstparent,adms_admsttransform_valueof_zzname(myadmsttransform));
  char*myvalue=tostring2(myadmstparent,adms_admsttransform_valueof_zzvalue(myadmsttransform));
  if(!adms_setenv(myname,myvalue))
  {
    adms_message_fatal(("cannot set shell variable: '%s=%s'\n",myname,myvalue));
    adms_message_fatal(("see %s\n",adms_admsttransform_uid(myadmsttransform)))
  }
  free(myname);
  free(myvalue);
}
_t_inline_admsttransform_evaluate(adms_admsttransform_getenv_evaluate)
{
  char*zznameasstring=tostring2(myadmstparent,adms_admsttransform_valueof_zzname(myadmsttransform));
  const char*myenv=getenv(zznameasstring);
  if(myenv)
  {
    p_quark myquark=adms_quark_new(myenv);
    p_admst myadmst=adms_admst_new(myadmsttransform,NULL,"admst:getenv",adms_admst_enumeration_size_scalar);
    adms_admst_valueto_item(myadmst,adms_adms(myquark));
    adms_slist_push(&adms_admsmain_valueof_valueof(adms_global_admsmain()),adms_adms(myadmst));
  }
  else
  {
    adms_message_fatal_continue(("missing shell variable '%s'\n",zznameasstring))
    adms_message_fatal(("see %s\n",adms_admsttransform_uid(myadmsttransform)))
  }
  free(zznameasstring);
}
_t_inline_admsttransform_evaluate(adms_admsttransform_copy_evaluate)
{
  char*from=tostring2(myadmstparent,adms_admsttransform_valueof_zzfrom(myadmsttransform));
  char*to=tostring2(myadmstparent,adms_admsttransform_valueof_zzto(myadmsttransform));
  char*fromOS=adms_file_unixify(from);
  char*toOS=adms_file_unixify(to);
  if(!adms_file_isregular(fromOS))
    adms_message_fatal(("%s: from=`%s' file not found\n",adms_admsttransform_uid (myadmsttransform),fromOS))
  if(!adms_file_isdirectory(toOS))
    adms_message_fatal(("%s: to=`%s' invalid directory\n",adms_admsttransform_uid (myadmsttransform),toOS))
  {
    char*dirname=g_path_get_dirname(fromOS);
    char*basename=g_path_get_basename(fromOS);
    if(!strcmp(dirname,toOS))
      adms_message_fatal(("%s: file '%s' copied to itself!\n",adms_admsttransform_uid(myadmsttransform),fromOS))
    else
    {
      FILE*ifh=adms_file_open_read(fromOS);
      if(ifh)
      {
        char*tofile=NULL;
        FILE*ofh;
        adms_strconcat2(&tofile,toOS);
        adms_strconcat2(&tofile,ADMS_PATH_SEPARATOR);
        adms_strconcat2(&tofile,basename);
        ofh=adms_file_open_write(tofile);
        free (basename);
        if(ofh)
        {
           char c;
           while ((c=getc (ifh)) && !feof (ifh))
             putc (c, ofh);
           fclose (ofh);
        }
        else
          adms_message_fatal(("%s: to=`%s' cannot write file\n",adms_admsttransform_uid(myadmsttransform),toOS))
        free(tofile);
        fclose(ifh);
      }
      else
        adms_message_fatal(("%s: from=`%s' cannot open file\n",adms_admsttransform_uid(myadmsttransform),fromOS))
    }
  }
  free(from);
  free(to);
}
_t_inline_admsttransform_evaluate(adms_admsttransform_assert_evaluate)
{
  char*text=tostring2(myadmstparent,adms_admsttransform_valueof_zzformat(myadmsttransform));
  adms_message_fatal_continue(("%s",text));
  adms_message_fatal(("see %s\n",adms_admsttransform_uid(myadmsttransform)));
}
_t_inline_admsttransform_evaluate(adms_admsttransform_message_evaluate)
{
  char*text=tostring2(myadmstparent,adms_admsttransform_valueof_zzformat(myadmsttransform));
  adms_message_info(("%s",text));
  free(text);
}
_t_inline_admsttransform_evaluate(adms_admsttransform_warning_evaluate)
{
  char*text=tostring2(myadmstparent,adms_admsttransform_valueof_zzformat(myadmsttransform));
  adms_message_warning_continue(("%s",text));
  adms_message_warning(("see %s\n",adms_admsttransform_uid(myadmsttransform)));
  free(text);
}
_t_inline_admsttransform_evaluate(adms_admsttransform_error_evaluate)
{
  char*text=tostring2(myadmstparent,adms_admsttransform_valueof_zzformat(myadmsttransform));
  adms_message_error_continue(("%s",text));
  adms_message_error(("see %s\n",adms_admsttransform_uid(myadmsttransform)));
  free(text);
}
_t_inline_admsttransform_evaluate(adms_admsttransform_fatal_evaluate)
{
  char*text=tostring2(myadmstparent,adms_admsttransform_valueof_zzformat(myadmsttransform));
  adms_message_fatal_continue(("%s",text));
  adms_message_fatal(("see %s\n",adms_admsttransform_uid(myadmsttransform)));
}

static void adms_admsxml_xmlstart(GMarkupParseContext*context,const char*admstname,const char**attrnames,const char**attrvalues,void* usrdata,GError **error)
{
  int l=0;
  int c=0;
  p_slist admstfileList=adms_admsmain_valueof_admstfile(adms_global_admsmain());
  const char*admstfile=(char*)admstfileList?(char*)admstfileList->data:"";
  p_slist Transform=adms_admsmain_valueof_admsttransform(adms_global_admsmain());
  p_admsttransform Parent=Transform?adms_admsttransform(Transform->data):NULL;
  p_admsttransform myadmsttransform;
  g_markup_parse_context_get_position (context,&l,&c);
  myadmsttransform=adms_admsttransform_new (adms_quark_new(admstfile),l,admstname,Parent);
  adms_message_dbg_xml(("%s: b <%s>\n",admstfile,admstname));
  if(T(admst:templates)||T(admst:template))
    adms_slist_push(&adms_admsmain_valueof_template(adms_global_admsmain()),adms_adms(myadmsttransform));
  else if(!T(admst))
    adms_slist_push(&adms_admsttransform_valueof_children(Parent),adms_adms(myadmsttransform));
  if(is_admst(admstname))
  {
    while(*attrnames)
    {
      p_admsttransformattribute myadmsttransformattribute=NULL;
      #define zz(att) else if(!strcmp(*attrnames,#att)) \
        { \
          p_admsttext myadmsttext=adms_admsttext_new(myadmsttransform,*attrvalues); \
          myadmsttransformattribute=adms_admsttransformattribute_new(myadmsttransform,*attrvalues); \
          adms_admsttransformattribute_valueto_admsttext(myadmsttransformattribute,myadmsttext); \
          adms_admsttransform_valueto_zz##att(myadmsttransform,myadmsttransformattribute); \
          adms_admsttext_parse_first(myadmsttext); \
        }
      if(0) {}
      zz(select) zz(match) zz(required) zz(separator) zz(from) zz(to) zz(list) zz(into) zz(name) zz(value) zz(format) zz(onduplicate) zz(probe)
      zz(file) zz(version) zz(datatype) zz(test)
      else if(!strcmp(*attrnames,"arguments"))
      {
        p_admsttext myadmsttext=adms_admsttext_new(myadmsttransform,*attrvalues);
        char**arguments;
        char**argumentsPtr;
        int i;
        myadmsttransformattribute=adms_admsttransformattribute_new(myadmsttransform,*attrvalues);
        adms_admsttransformattribute_valueto_admsttext(myadmsttransformattribute,myadmsttext);
        adms_admsttransform_valueto_zzarguments(myadmsttransform,myadmsttransformattribute);
        adms_admsttext_parse_first(myadmsttext);
        arguments=adms_strsplit(adms_admsttransform_valueof_zzarguments(myadmsttransform)->_value,",",1000);
        argumentsPtr=arguments;
        while(*argumentsPtr)
        {
          p_admsttext myadmsttext=adms_admsttext_new(myadmsttransform,*argumentsPtr);
          adms_admsttext_parse_first(myadmsttext);
          adms_admsttransform_list_attribute_prepend(myadmsttransform,(void*)myadmsttext);
          argumentsPtr++;
        }
        adms_admsttransform_valueto_attribute(myadmsttransform,adms_slist_reverse(adms_admsttransform_valueof_attribute(myadmsttransform)));
        for(i=0;arguments[i]!=NULL;i++)
          free(arguments[i]);
        free (arguments);
      }
      else if(!strcmp(*attrnames,"xmlns:admst")) {}
      else if(!strcmp(*attrnames,"xmlns:m")) {}
      else if(!strcmp(*attrnames,"xmlns")) {}
      else if(!strcmp(*attrnames,"mode"))
        adms_message_obsolete(("%s:%i: attribute %s=\"%s\" is ignored\n",admstfile,l,*attrnames,*attrvalues))
      else
        adms_message_fatal(("%s:%i: unknown attribute %s=\"%s\"\n",admstfile,l,*attrnames,*attrvalues))
      if(
        (!strcmp(*attrnames,"test"))
        ||(!strcmp(admstname,"admst:apply-templates")&&!strcmp(*attrnames,"select"))
        ||(!strcmp(admstname,"admst:count")&&!strcmp(*attrnames,"select"))
        ||(!strcmp(admstname,"admst:for-each")&&!strcmp(*attrnames,"select"))
        ||(!strcmp(admstname,"admst:if-inside")&&!strcmp(*attrnames,"select"))
        ||(!strcmp(admstname,"admst:if-not-inside")&&!strcmp(*attrnames,"select"))
        ||(!strcmp(admstname,"admst:join")&&!strcmp(*attrnames,"select"))
        ||(!strcmp(admstname,"admst:push")&&!strcmp(*attrnames,"into"))
        ||(!strcmp(admstname,"admst:push")&&!strcmp(*attrnames,"select"))
        ||(!strcmp(admstname,"admst:reset")&&!strcmp(*attrnames,"select"))
        ||(!strcmp(admstname,"admst:reverse")&&!strcmp(*attrnames,"select"))
        ||(!strcmp(admstname,"admst:text")&&!strcmp(*attrnames,"select"))
        ||(!strcmp(admstname,"admst:value-of")&&!strcmp(*attrnames,"select"))
        ||(!strcmp(admstname,"admst:value-to")&&!strcmp(*attrnames,"select"))
      )
      {
        p_slist myadmstpathgoto=admstpathparse(myadmsttransform,*attrvalues);
        adms_admsttransformattribute_valueto_admstpathgoto(myadmsttransformattribute,myadmstpathgoto);
      }
      attrvalues++;
      attrnames++;
    }
  }
  else
  {
    while(*attrnames)
    {
      p_attribute myattribute=adms_attribute_new(adms_quark_new(*attrnames));
      p_admsttext myadmsttext=adms_admsttext_new(myadmsttransform,*attrvalues);
      adms_admsttext_parse_first(myadmsttext);
      adms_attribute_valueto_value(myattribute,adms_adms(myadmsttext));
      adms_admsttransform_list_attribute_prepend(myadmsttransform,myattribute);
      attrvalues++;
      attrnames++;
    }
    adms_admsttransform_valueto_attribute(myadmsttransform,
      adms_slist_reverse(adms_admsttransform_valueof_attribute(myadmsttransform)));
  }
  adms_slist_push(&adms_admsmain_valueof_admsttransform(adms_global_admsmain()),adms_adms(myadmsttransform));
}
#define NOCHILD if(adms_admsttransform_valueof_children(myadmsttransform))\
  adms_message_fatal(("  assert=no(child) failed %s\n",adms_admsttransform_uid(myadmsttransform))) 
#define HASCHILD if(!adms_admsttransform_valueof_children(myadmsttransform))\
  adms_message_fatal(("  assert=has(child) failed %s\n",adms_admsttransform_uid(myadmsttransform))) 
#define HAS(item) if(!adms_admsttransform_valueof_zz##item(myadmsttransform))\
  adms_message_fatal(("  assert=has(" #item ") failed %s\n",adms_admsttransform_uid(myadmsttransform))) 
#define NO(item) if(adms_admsttransform_valueof_zz##item(myadmsttransform))\
  adms_message_fatal(("  assert=no(" #item ") failed %s\n",adms_admsttransform_uid(myadmsttransform))) 
#define SET(item) myadmsttransform->_evaluator=&adms_admsttransform_##item##_evaluate;
#define OBSOLETE(obsolete,new) if(T(obsolete))\
  adms_message_obsolete(("%s: please use "#new" instead\n",adms_admsttransform_uid(myadmsttransform))) 
static void adms_admsxml_xmlend(GMarkupParseContext *context,const char*admstname,void* usrdata,GError **err)
{
  p_slist Transform=adms_admsmain_valueof_admsttransform(adms_global_admsmain());
  p_slist admstfileList=adms_admsmain_valueof_admstfile(adms_global_admsmain());
  const char*admstfile=(char*)admstfileList?(char*)admstfileList->data:"";
  p_admsttransform myadmsttransform=Transform?adms_admsttransform(Transform->data):NULL;
  adms_admsttransform_valueto_children(myadmsttransform,adms_slist_reverse(adms_admsttransform_valueof_children(myadmsttransform)));
  if(!is_admst(adms_admsttransform_valueof_admstname(myadmsttransform)))
  { SET(notadmst)}
  else if(T(admst))
  { NO(select) HAS(version) SET(admst)}
  else if(T(admst:for-each))
  { HAS(select) NO(test) SET(foreach)}
  else if(T(admst:join))
  { HAS(select) NO(test) SET(join)}
  else if(T(admst:value-of))
  { NO(format) NOCHILD HAS(select) SET(valueof)}
  else if(T(admst:if-inside))
  { HASCHILD HAS(list) HAS(select) SET(inside)}
  else if(T(admst:if-not-inside))
  { HASCHILD HAS(list) HAS(select) SET(inside)}
  else if(T(admst:choice)||T(admst:choose))
  { OBSOLETE(admst:choice,admst:choose) NO(select) NO(test) SET(choose)}
  else if(T(admst:when))
  { HAS(test) NO(select)}
  else if(T(admst:otherwise))
  { NO(select) NO(test)}
  else if(T(admst:if))
  { HASCHILD HAS(test) NO(select) SET(if)}
  else if(T(admst:templates)||T(admst:template))
  { OBSOLETE(admst:templates,admst:template) NO(select) HAS(match)}
  else if(T(admst:apply-template)||T(admst:apply-templates))
  { OBSOLETE(admst:apply-template,admst:apply-templates) HAS(select) HAS(match) SET(applytemplates)}
  else if(T(admst:return))
  { HAS(name) NOCHILD HAS(value) SET(return)}
  else if(T(admst:attribute))
  { HASCHILD HAS(name)}
  else if(T(admst:variable))
  { NOCHILD HAS(name) SET(variable)}
  else if(T(admst:text))
  { NOCHILD HAS(format) SET(text)}
  else if(T(admst:new))
  { HAS(datatype) HAS(arguments) NO(select) SET(new)}
  else if(T(admst:pull))
  { NOCHILD HAS(select) SET(pull)}
  else if(T(admst:push))
  { NOCHILD HAS(select) HAS(into) SET(push)}
  else if(T(admst:reset))
  { NOCHILD HAS(select) SET(reset)}
  else if(T(admst:value-to))
  { HAS(select) SET(valueto)}
  else if(T(admst:count))
  { HAS(select) SET(count)}
  else if(T(admst:reverse))
  { HAS(select) SET(reverse)}
  else if(T(admst:open))
  { HAS(file) NO(select) SET(open)}
  else if(T(admst:setenv))
  { NOCHILD NO(select) SET(setenv)}
  else if(T(admst:getenv))
  { NOCHILD NO(select) SET(getenv)}
  else if(T(admst:copy))
  { NOCHILD NO(select) SET(copy)}
  else if(T(admst:assert))
  { NO(select) NOCHILD HAS(test) HAS(format) SET(assert)}
  else if(T(admst:message))
  { NO(select) NOCHILD HAS(format) SET(message)}
  else if(T(admst:warning))
  { NO(select) NOCHILD HAS(format) SET(warning)}
  else if(T(admst:error))
  { NO(select) NOCHILD HAS(format) SET(error)}
  else if(T(admst:fatal))
  { NO(select) NOCHILD HAS(format) SET(fatal)}
  else
    adms_message_fatal(("%s: unknown transform\n",adms_admsttransform_uid (myadmsttransform)))
  if(!T(admst))
    adms_slist_pull(&adms_admsmain_valueof_admsttransform(adms_global_admsmain()));
  adms_message_dbg_xml(("%s: b </%s>\n",admstfile,admstname));
}
/*SNT becomes T
static const char* text_excluding_leadingspaces (const char*text)
{
  const char*cPtr=text;
  while(*cPtr&&isspace(*cPtr))
    cPtr++;
  if(*cPtr&&(*cPtr=='\n' || *cPtr=='\r'))
    cPtr++;
  return cPtr;
}
*/
/*[TNS]NS becomes [TNS]N */
static char* text_excluding_trailingspaces (const char*text)
{
  const char*cPtr=text;
  const char*nl=NULL;
  int t=0;
  int space=0;
  while(*cPtr)
  {
    if(!isspace(*cPtr))
    {t=1; space=0;}
    if(t&&(*cPtr=='\n' || *cPtr=='\r'))
    {nl=cPtr; space=0;}
    if(nl&&(*cPtr=='\n' || *cPtr=='\r'))
      space=1;
    cPtr++;
  }
  if(t&&space)
    return adms_constnclone(text,nl-text);
  else if(t)
    return adms_constclone(text);
  else
    return NULL;
}
static void adms_admsxml_xmltext (GMarkupParseContext*context,const char*text,gsize text_len,void* user_data,GError **error)
{
  char*newtext=text_excluding_trailingspaces(text);
  if(newtext)
  {
    p_slist Transform=adms_admsmain_valueof_admsttransform(adms_global_admsmain());
    p_slist admstfileList=adms_admsmain_valueof_admstfile(adms_global_admsmain());
    const char*admstfile=(char*)admstfileList?(char*)admstfileList->data:adms_constclone("");
    p_admsttransform Parent=Transform?adms_admsttransform(Transform->data):NULL;
    p_admsttransform myadmsttransform=adms_admsttransform_new(adms_quark_new(admstfile),adms_admsttransform_valueof_l(Parent),"admst:text",Parent);
    p_admsttransformattribute myadmsttransformattribute=adms_admsttransformattribute_new(myadmsttransform,newtext);
    p_admsttext myadmsttext=adms_admsttext_new(myadmsttransform,newtext);
    adms_admsttext_parse_first(myadmsttext);
    SET(text)
    adms_slist_push(&adms_admsttransform_valueof_children(Parent),adms_adms(myadmsttransform));
    adms_admsttransformattribute_valueto_admsttext(myadmsttransformattribute,myadmsttext);
    adms_admsttransform_valueto_zzformat(myadmsttransform,myadmsttransformattribute);
  }
  free(newtext);
}
static void adms_admsxml_xmlerror(GMarkupParseContext *context, GError *error, gpointer user_data)
{
  adms_message_info(("%s\n",error->message))
}
static const GMarkupParser myadms_global_xmlparser={
  adms_admsxml_xmlstart,
  adms_admsxml_xmlend,
  adms_admsxml_xmltext,
  NULL,
  adms_admsxml_xmlerror
};

static void adms_admsttransform_recursive_destroy(p_admsttransform myadmsttransform)
{
  p_slist myl;
  for(myl=myadmsttransform->_children;myl;myl=myl->next)
    adms_admsttransform_recursive_destroy(adms_admsttransform(myl->data));
  adms_admsttransform_free(myadmsttransform);
}
static void adms_admsxml_process_admstscript (const char*myadmstfile)
{
  GMarkupParseContext* context=g_markup_parse_context_new(&myadms_global_xmlparser,0,NULL,NULL);
  size_t length;
  GError*error=NULL;
  char*contents;
  char*myunixadmstfile=adms_file_unixify(myadmstfile);
  p_slist l;
  if(!adms_file_isregular(myunixadmstfile))
    adms_message_warning(("%s: cannot open file\n",myunixadmstfile))
  adms_slist_push(&adms_admsmain_valueof_admstfile(adms_global_admsmain()),adms_adms(myunixadmstfile));
  if(!g_file_get_contents (myunixadmstfile, &contents, &length, &error))
    adms_message_fatal(("%s\n",error->message))
  adms_message_verbose(("load admst script: '%s'\n",myunixadmstfile))
  if(!g_markup_parse_context_parse(context,contents,length,NULL)||!g_markup_parse_context_end_parse(context, NULL))
  {
    p_slist Transform=adms_admsmain_valueof_admsttransform(adms_global_admsmain());
    adms_message_fatal_continue(("xml parsing failed - admst script '%s'\n",myunixadmstfile))
    if(Transform)
      adms_message_fatal(("latest transform seen: %s\n",adms_admsttransform_uid(adms_admsttransform(Transform->data))))
    else
      adms_message_fatal(("after loading all admst transforms from script\n"))
  }
  g_markup_parse_context_free (context);
  free(contents);
  adms_message_verbose(("evaluate admst script: '%s'\n",myunixadmstfile))
  for(l=adms_admsmain_valueof_admsttransform(adms_global_admsmain());l;l=l->next)
  {
    p_admst myadmst=adms_admst_new(adms_admsttransform(l->data),NULL,"/",adms_admst_enumeration_size_scalar);
    adms_admst_valueto_item(myadmst,adms_adms(adms_global_admsmain()));
    adms_admsttransform_evaluate(adms_admsttransform(l->data),myadmst);
    adms_admst_free(myadmst);
  }
  if(adms_admsmain_valueof_valueof(adms_global_admsmain()))
  {
    p_admst latestgetadmst=adms_admst(adms_admsmain_valueof_valueof(adms_global_admsmain())->data);
    adms_message_fatal(("adms stack has %i element(s)) left - should be empty\n ... see transform: %s\n",
      adms_slist_length(adms_admsmain_valueof_valueof(adms_global_admsmain())),adms_admst_uid(latestgetadmst)))
  }
  adms_slist_pull(&adms_admsmain_valueof_admstfile(adms_global_admsmain()));
  /*valgrind:adms_admsttransform_recursive_destroy(adms_admsmain_valueof_admsttransform(adms_global_admsmain())->data);*/
  adms_slist_free(adms_admsmain_valueof_admsttransform(adms_global_admsmain()));
  adms_admsmain_valueof_admsttransform(adms_global_admsmain())=NULL;
}

static char* adms_parse_create_admsimplicitxmlfile (void)
{
  char *mygetenv=getenv("adms_implicit_transforms");
  char *tmpFileName=NULL;
  if(mygetenv)
  {
    tmpFileName = adms_file_unixify (mygetenv);
    adms_message_info(("load local transforms %s\n",tmpFileName))
  }
  else
  {
    tmpFileName=strdup(".adms.implicit.xml");
    adms_message_verbose(("create/load implicit transforms file %s\n",tmpFileName))
    adms_file_setfile_output(adms_file_open_write(tmpFileName));
    g_print("%s",admsImplicitTransforms_xml);
    adms_file_close_output ();
  }
  return tmpFileName;
}
static void adms_admsxml_usage(void)
{
  adms_message_usage(("%s%s-%s (%s) %s %s (os=%s compiler=%s)\n",PACKAGE_NAME,"Xml",PACKAGE_VERSION,SVN,__DATE__,__TIME__,ADMS_OS,ADMS_COMPILER))
  adms_message_usage(("%s%s source [options] -e script1 [-e script2 ...]\n",PACKAGE_NAME,"Xml"))
  adms_message_usage(("files:\n"))
  adms_message_usage(("  source: verilog-ams source code\n"))
  adms_message_usage(("  script1, ...: admst scripts (xml format)\n"))
  adms_message_usage(("options:\n"))
  adms_message_usage(("  -D NAME: predefine NAME as a macro, with definition `1'\n"))
  adms_message_usage(("  -D NAME=DEFINITION: predefine NAME as a macro, with definition DEFINITION\n"))
  adms_message_usage(("  -I DIR: Add directory DIR to search path for header files\n"))
  adms_message_usage(("  -x: skip download of any implicit admst scripts\n"))
  adms_message_usage(("shell variables:\n"))
  adms_message_usage(("- adms_info=\"yes\": do not print info [default is yes]\n"))
  adms_message_usage(("- adms_usage=\"yes\": do not print usage [default is yes]\n"))
  adms_message_usage(("- adms_verbose=\"yes\": print messages [default is no]\n"))
  adms_message_usage(("- adms_debug=\"yes\": print more messages [default is no]\n"))
  adms_message_usage(("- adms_dbg_vla=\"yes\": print more messages during Verilog-AMS parsing [default is no]\n"))
  adms_message_usage(("- adms_dbg_xml=\"yes\": print more messages during xml parsing [default is no]\n"))
  adms_message_usage(("- adms_dbg_mem=\"yes\": print more messages for memory leak debugging [default is no]\n"))
  adms_message_usage(("- adms_implicit_transforms=<script>: includes admst script <script> prior any -e admst files\n"))
  adms_message_usage(("  Otherwise admst script .adms.implicit.xml is included and saved in local directory\n"))
  adms_message_usage(("  Example: my-shell> adms_implicit_transforms=my.xml\n"))
}
static p_slist adms_xml_buildlist_from_argv(const int argc,const char* *argv,const char *opt,char *argtype)
{
  p_slist mylist=NULL;
  int i;
  for(i=1;i<argc;i++)
  {
    char* myargvalue=NULL;
    const char* value=argv[i];
    if((strlen(value)==2)&&!strcmp(value,"-x"))
    {
      adms_message_verbose(("command option %s: ignored\n",value))
    }
    else
    {
    if(!strcmp(opt,"-f"))
    {
      if((strlen(value)>2)&&(value[0]=='-'))
      {}
      else if((strlen(value)==2)&&(value[0]=='-'))
        i++;
      else
        myargvalue=strdup(argv[i]);
    }
    if(!strcmp(opt,value))
    {
      if(i<argc-1)
        myargvalue=strdup(argv[++i]);
      else
        adms_message_fatal(("command option %s: no value found - expecting %s\n",opt,argtype))
    }
    else if((strlen(value)>2)&&!strncmp(opt,value,2))
      myargvalue=adms_constnclone(value+2,strlen(value)-2);
    if(myargvalue)
    {
      char* myunixpath=adms_file_unixify(myargvalue);
      free(myargvalue);
      if(
          (!strcmp(argtype,"regular file")&&adms_file_isregular(myunixpath))
          ||(!strcmp(argtype,"directory")&&adms_file_isdirectory(myunixpath))
      )
        adms_slist_push(&mylist,adms_adms(myunixpath));
      else
        adms_message_fatal(("command option %s: value not valid '%s' - expecting %s\n",opt,myunixpath,argtype))
      adms_message_verbose(("command option %s: found %s '%s'\n",opt,argtype,myunixpath))
    }
    }
  }
  return adms_slist_reverse(mylist);
}
int main (const int argc,const char**argv)
{
  time_t mytime=time(NULL);
  p_slist myallverilogamsfile;
  p_slist myallverilogamsfile0;
  p_slist myalladmstscript;
  p_slist myalladmstscript0;
  g_set_print_handler((GPrintFunc)adms_file_filehandling_print);
  /*admsmain*/
  adms_global_valueto_admsmain(adms_admsmain_new(adms_quark_new("admsmain")));
  /*argc,argv*/
  { 
    int i;
    adms_admsmain_valueto_argc(adms_global_admsmain(),argc);
    adms_admsmain_valueto_argv(adms_global_admsmain(),NULL);
    for(i=0;i<argc;i++)
      adms_slist_push(&adms_admsmain_valueof_argv(adms_global_admsmain()),adms_adms(adms_quark_new(argv[i])));
  }
  /*main.simulator*/
  {
    p_simulator mysimulator;
    char*sfullname=NULL;
    p_quark qfullname;
    if(getenv("adms_check"))
    {
      adms_strconcat2(&sfullname,PACKAGE_NAME);
      adms_strconcat2(&sfullname,"Xml");
      adms_strconcat2(&sfullname,"-0.0.0 (shell variable 'adms_check' is set!)");
    }
    else
    {
      adms_strconcat2(&sfullname,PACKAGE_NAME);
      adms_strconcat2(&sfullname,"Xml");
      adms_strconcat2(&sfullname,"-");
      adms_strconcat2(&sfullname,PACKAGE_VERSION);
    }
    qfullname=adms_quark_new(sfullname);
    mysimulator=adms_simulator_new(qfullname);
    adms_admsmain_valueto_simulator(adms_global_admsmain(),mysimulator);
    qfullname=adms_quark_new(sfullname);
    adms_simulator_valueto_fullname(adms_admsmain_valueof_simulator(adms_global_admsmain()),qfullname);
    free(sfullname);
  }
  /*main.simulator.developer*/
  {
    p_quark qdeveloper;
    if(getenv("adms_check"))
      qdeveloper=adms_quark_new("0.0.0 (shell variable 'adms_check' is set)");
    else
    {
      char* sdeveloper=NULL;
      adms_strconcat2(&sdeveloper,PACKAGE_NAME);
      adms_strconcat2(&sdeveloper,"Xml");
      adms_strconcat2(&sdeveloper,"-");
      adms_strconcat2(&sdeveloper,PACKAGE_VERSION);
      adms_strconcat2(&sdeveloper," (");
      adms_strconcat2(&sdeveloper,__DATE__);
      adms_strconcat2(&sdeveloper,"-");
      adms_strconcat2(&sdeveloper,__TIME__);
      adms_strconcat2(&sdeveloper,")");
      qdeveloper=adms_quark_new(sdeveloper);
      free(sdeveloper);
    }
    adms_simulator_valueto_developer(adms_admsmain_valueof_simulator(adms_global_admsmain()),qdeveloper);
  }
  /*main.simulator.currentdate*/
  {
    p_quark qcurrentdate;
    if(getenv("adms_check"))
      qcurrentdate=adms_quark_new("0.0.0 (shell variable 'adms_check' is set)\n");
    else
    {
      char mybuffer[100];
      struct tm* mylocaltime=localtime(&mytime);
      strftime (mybuffer,100,"%a, %d %b %Y %H:%M:%S",mylocaltime);
      qcurrentdate=adms_quark_new(strdup(mybuffer));
    }
    adms_simulator_valueto_currentdate(adms_admsmain_valueof_simulator(adms_global_admsmain()),qcurrentdate);
  }
  /*shell*/
  if(getenv("adms_preprocessor_debug"))
    adms_preprocessor_setint_yydebug(1);
  else
    adms_preprocessor_setint_yydebug(0);
  #define TESTGETENV(name,value) if(getenv("adms_"#name)&&!strcmp(getenv("adms_"#name),#value)) \
  adms_admsmain_valueto_##name(adms_global_admsmain(),ENUMERATION(adms_admsmain_enumeration_##name##_##value,admsmain,name));
  TESTGETENV(info,no)
  TESTGETENV(usage,no)
  TESTGETENV(obsolete,no)
  TESTGETENV(hint,yes)
  TESTGETENV(verbose,yes)
  TESTGETENV(debug,yes)
  TESTGETENV(dbg_vla,yes)
  TESTGETENV(dbg_xml,yes)
  TESTGETENV(dbg_mem,yes)
  /*validate argv*/
  if(argc==1)
  {
    adms_admsxml_usage();
    adms_message_usage(("switches: type %s%s -h for more info\n",PACKAGE_NAME,"Xml"))
  }
  else if(
    ((argc==2)&&!strcmp(argv[1],"-v"))
    ||
    ((argc==2)&&!strcmp(argv[1],"--version"))
    ||
    ((argc==3)&&!strcmp(argv[1],"-")&&!strcmp (argv[2],"v"))
    ||
    ((argc==3)&&!strcmp(argv[1],"--")&&!strcmp (argv[2],"version"))
  )
  {
    adms_message_usage(("<release name=\"%s%s\" version=\"%s\" date=\"%s\" time=\"%s\"/>\n",PACKAGE_NAME,"Xml",PACKAGE_VERSION,__DATE__,__TIME__))
    return 0;
  }
  else if(
    ((argc==2)&&!strcmp(argv[1],"-i"))
    ||
    ((argc==2)&&!strcmp(argv[1],"--info"))
    ||
    ((argc==3)&&!strcmp(argv[1],"-")&&!strcmp(argv[2],"i"))
    ||
    ((argc==3)&&!strcmp(argv[1],"--")&&!strcmp(argv[2],"info"))
  )
  {
    adms_message_usage(("<info\n",PACKAGE_BUGREPORT))
    adms_message_usage(("  author=\"laurent lemaitre\"\n",PACKAGE_BUGREPORT))
    adms_message_usage(("  bug-report=\"%s\"\n",PACKAGE_BUGREPORT))
    adms_message_usage(("  home-page=\"http://mot-adms.sourceforge.net\"\n"))
    adms_message_usage(("  mailing-list=\"mot-adms-users@lists.sourceforge.net\">\n"))
    adms_message_usage(("  <release name=\"%s\" version=\"%s\" svn=\"%s\" date=\"%s\" time=\"%s\"/>\n",PACKAGE_NAME,PACKAGE_VERSION,SVN,__DATE__,__TIME__);)
    adms_message_usage(("  <dependency>\n"))
    adms_message_usage(("    <library name=\"glib-2\" version=\"%i.%i.%i\">\n",GLIB_MAJOR_VERSION,GLIB_MINOR_VERSION,GLIB_MICRO_VERSION);)
    adms_message_usage(("      <source location=\"http://www.gtk.org/\"/>\n"))
    adms_message_usage(("    </library>\n"))
    adms_message_usage(("  </dependency>\n"))
    adms_message_usage(("</info>\n"))
    return 0;
  }
  else if(
    ((argc==2)&&!strcmp(argv[1],"-h"))
    ||
    ((argc==2)&&!strcmp(argv[1],"--help"))
    ||
    ((argc==3)&&!strcmp(argv[1],"-")&&!strcmp(argv[2],"h"))
    ||
    ((argc==3)&&!strcmp(argv[1],"--")&&!strcmp(argv[2],"help"))
  )
  {
    adms_admsxml_usage();
    adms_message_usage(("-i or -info: info on the tools (release, web site, mailing list)\n"))
    adms_message_usage(("-v or -version: version number\n"))
    adms_message_usage(("-h or -help: short help\n"))
    return 0;
  }
  {
    int i=1;
    while(i<argc)
    {
      if(!strcmp(argv[i],"-x"))
        adms_donouse_xml_implicit_file=1;
      i++;
    }
  }
  /*build vla list*/
  myallverilogamsfile0=adms_xml_buildlist_from_argv(argc,argv,"-f","regular file");
  /*parse vla list*/
  for(myallverilogamsfile=myallverilogamsfile0;myallverilogamsfile;myallverilogamsfile=myallverilogamsfile->next)
  {
    char*myverilogamsfile=(char*)myallverilogamsfile->data;
    char*mytmpverilogamsfile=NULL;
    adms_strconcat2(&mytmpverilogamsfile,".");
    adms_strconcat(&mytmpverilogamsfile,adms_path_get_basename(myverilogamsfile));
    adms_strconcat2(&mytmpverilogamsfile,".adms");
    adms_admsmain_valueto_filename(adms_global_admsmain(),adms_quark_new(myverilogamsfile));
    adms_message_usage(("%s%s-%s (%s) %s %s\n",PACKAGE_NAME,"Xml",PACKAGE_VERSION,SVN,__DATE__,__TIME__))
    /* preprocess input Verilog-AMS file */
    {
      FILE* myverilogamsfilefh=adms_file_open_read(myverilogamsfile);
      FILE* mytmpverilogamsfilefh=adms_file_open_write(mytmpverilogamsfile);
      p_preprocessor mypreprocessor=(p_preprocessor)malloc(sizeof(t_preprocessor));
      adms_preprocessor_setfile_input(myverilogamsfilefh);
      mypreprocessor->cur_line_position = 1;
      mypreprocessor->cur_char_position = 1;
      mypreprocessor->fid = myverilogamsfilefh;
      mypreprocessor->filename=strdup(myverilogamsfile);
      mypreprocessor->buffer = NULL;
      mypreprocessor->cur_continuator_position=NULL;
      adms_preprocessor_valueto_main((p_preprocessor_main)malloc(sizeof(t_preprocessor_main)));
      adms_preprocessor_valueof_main()->Defined=NULL;
      adms_preprocessor_valueof_main()->Scanner=NULL;
      adms_preprocessor_valueof_main()->Text=NULL;
      adms_preprocessor_valueof_main()->cr_filename=strdup(myverilogamsfile);
      adms_preprocessor_valueof_main()->cr_scanner=mypreprocessor;
      adms_preprocessor_valueof_main()->error=0;
      adms_preprocessor_valueof_main()->includePath=adms_xml_buildlist_from_argv(argc,argv,"-I","directory");
      adms_preprocessor_valueof_main()->skipp_text=FALSE;
      adms_slist_push(&adms_preprocessor_valueof_main()->includePath,adms_adms("."));
      adms_preprocessor_get_define_from_argv(argc,argv);
      adms_preprocessor_define_add_default("insideADMS");
      free(myverilogamsfile);
      adms_file_setfile_output(mytmpverilogamsfilefh);
      adms_message_verbose(("create temporary file %s\n",mytmpverilogamsfile))
      (int) adms_preprocessor_parse();
      /* save preprocessed Verilog-AMS file */
      g_print("# 1 \"%s\"\n",adms_preprocessor_valueof_main()->cr_scanner->filename);
      adms_preprocessor_valueof_main()->Text = adms_slist_reverse (adms_preprocessor_valueof_main()->Text);
      adms_preprocessor_text_list_printf(adms_preprocessor_valueof_main()->Text);
      /* free preprocessor */
      {
        free(mypreprocessor->filename);
        free(adms_preprocessor_valueof_main()->cr_scanner);
        free(adms_preprocessor_valueof_main()->cr_filename);
      }
      fclose(mytmpverilogamsfilefh);
      fclose(myverilogamsfilefh);
    }
    /* parses temporary Verilog-AMS file */
    {
      FILE* mytmpverilogamsfilefh=adms_file_open_read(mytmpverilogamsfile);
      if(adms_admsmain_valueof_dbg_vla(adms_global_admsmain())->_value==adms_admsmain_enumeration_dbg_vla_yes)
        adms_veriloga_setint_yydebug(1);
      adms_veriloga_setfile_input(mytmpverilogamsfilefh);
      if(adms_veriloga_parse(adms_global_admsmain ()))
        adms_message_fatal(("parse Verilog-AMS preprocessed file '%s' failed\n",mytmpverilogamsfile))
      else
        adms_message_verbose(("No error found during parsing\n"))
      fclose(mytmpverilogamsfilefh);
    }
    adms_file_setfile_output(stdout);
    {
      p_slist l; for(l=adms_admsmain_valueof_module(adms_global_admsmain());l;l=l->next)
        adms_module_valueto_evaluation(adms_module(l->data),adms_evaluation_new(adms_module(l->data)));
    }
    free(mytmpverilogamsfile);
  }
  adms_slist_free(myallverilogamsfile0);
  /*evaluate implicit admst script*/
  if(adms_donouse_xml_implicit_file)
    adms_message_info(("skipping any implicit xml scripts\n"))
  else
  {
    char* myadmsimplicitxmlfile=adms_parse_create_admsimplicitxmlfile();
    adms_admsxml_process_admstscript((char*)myadmsimplicitxmlfile);
    free(myadmsimplicitxmlfile);
  }
  /*build admstscript list*/
  myalladmstscript0=adms_xml_buildlist_from_argv(argc,argv,"-e","regular file");
  /*evaluate admst scripts*/
  for(myalladmstscript=myalladmstscript0;myalladmstscript;myalladmstscript=myalladmstscript->next)
  {
    adms_file_setfile_output(stdout);
    adms_admsxml_process_admstscript((char*)myalladmstscript->data);
    free(myalladmstscript->data);
  }
  adms_slist_free(myalladmstscript0);
  /*timer*/
  adms_message_info(("elapsed time: %g (second)\n",difftime(time(NULL),mytime)))
  /*memory*/
  {
    p_slist l; for(l=adms_admsmain_valueof_module(adms_global_admsmain());l;l=l->next)
    {
      p_slist ll;
      p_module mymodule=adms_module(l->data);
      #define FREE(obj) for(ll=adms_module_valueof_##obj(mymodule);ll;ll=ll->next) adms_##obj##_free(adms_##obj(ll->data));
      FREE(block)
      FREE(jacobian)
      FREE(contribution)
      FREE(expression)
      //FREE(source) fixme - share attributes of contribution
      FREE(probe)
      FREE(instance)
      //FREE(instantiator) list of modules
      FREE(branchalias)
      FREE(branch)
      FREE(nodealias)
      FREE(node)
      //FREE(attribute) always done for list.attribute
      FREE(variable)
      //FREE(assignment) should be after FREE(variable)
      FREE(assignment)
      FREE(range)
      //FREE(analogfunction) analogfunction->_tree already freed by FREE(block)
      adms_evaluation_free(mymodule->_evaluation);
      adms_module_free(mymodule);
    }
    for(l=adms_admsmain_valueof_discipline(adms_global_admsmain());l;l=l->next)
      adms_discipline_free(adms_discipline(l->data));
    for(l=adms_admsmain_valueof_nature(adms_global_admsmain());l;l=l->next)
      adms_nature_free(adms_nature(l->data));
  }
  adms_message_info(("admst iterations: %i (%i freed)\n",adms_global_nbadmstnew(),adms_global_nbadmstdestroy()));
  {
    p_slist l=adms_admsmain_valueof_variable(adms_global_admsmain()); for(;l;l=l->next)
      adms_admstvariable_free(adms_admstvariable(l->data));
  }
  if(adms_admsmain_valueof_dbg_mem(adms_global_admsmain())->_value==adms_admsmain_enumeration_dbg_mem_no)
    adms_admsmain_free(adms_global_admsmain());
  else
  {
    #define MEMORY(obj) printf(#obj": %i (%i freed)\n",adms_global_nb##obj##new(),adms_global_nb##obj##destroy());
    adms_admsmain_free(adms_global_admsmain());
    MEMORY(adms)
    MEMORY(simulator)
    MEMORY(admsmain)
    MEMORY(attribute)
    MEMORY(enumeration)
    MEMORY(list)
    MEMORY(nature)
    MEMORY(discipline)
    MEMORY(module)
    MEMORY(analogfunction)
    MEMORY(nodealias)
    MEMORY(node)
    MEMORY(branchalias)
    MEMORY(branch)
    MEMORY(source)
    MEMORY(range)
    MEMORY(jacobian)
    MEMORY(analog)
    MEMORY(math)
    MEMORY(string)
    MEMORY(subexpression)
    MEMORY(mapply_unary)
    MEMORY(mapply_binary)
    MEMORY(mapply_ternary)
    MEMORY(number)
    MEMORY(function)
    MEMORY(variable)
    MEMORY(probe)
    MEMORY(expression)
    MEMORY(instance)
    MEMORY(instanceparameter)
    MEMORY(instancenode)
    MEMORY(nilled)
    MEMORY(assignment)
    MEMORY(contribution)
    MEMORY(conditional)
    MEMORY(whileloop)
    MEMORY(case)
    MEMORY(caseitem)
    MEMORY(blockvariable)
    MEMORY(block)
    MEMORY(callfunction)
    MEMORY(evaluation)
    MEMORY(admstpathgoto)
    MEMORY(admstpathevaluate)
    MEMORY(admst)
    MEMORY(admsttransform)
    MEMORY(instanceofadmsttransform)
    MEMORY(admstvariable)
    MEMORY(path)
    MEMORY(lexval)
    MEMORY(yaccval)
  }
  return 0;
}
