%{

#include <admsVeriloga/admsVeriloga.h>
#include <admsObject/objectLexval.h>
#include <admsVeriloga/verilogaYacc.h>

#undef win32_interface
#if defined(WIN32)
#  if defined(_inside_admsVeriloga)
#    define win32_interface __declspec(dllexport)
#  else
#    define win32_interface __declspec(dllimport)
#  endif
#else
#  define win32_interface
#endif

static int adms_strtointeger (const char *mystr)
{
  int val;
  errno=0;
  val=(int)strtol(mystr,NULL,10);
  if(errno)
    adms_message_fatal(("%s: strtoint conversion failed\n",mystr))
  return val;
}
void adms_veriloga_setfile_input (FILE *ifile)
{
  yyin=ifile;
}
void adms_veriloga_error (const char *s)
{
  adms_message_fatal(("%s: during lexical analysis %s at line %i -- see '%s'\n",
    adms_admsmain_valueof_filename(adms_global_admsmain())->_value,s,adms_admsmain_valueof_curline(adms_global_admsmain ()),adms_veriloga_text))
}
inline void POS_UPDATE(const int myyyleng,const char*myyytext)
{
  int fpos=adms_admsmain_valueof_fpos(adms_global_admsmain());
  adms_message_dbg_vla(("%s:%i:%i-%i read token '%s'\n",adms_admsmain_valueof_filename(adms_global_admsmain())->_value,
    adms_admsmain_valueof_curline(adms_global_admsmain()),fpos+1,fpos+myyyleng,myyytext))
  adms_admsmain_valueto_fpos(adms_global_admsmain(),fpos+myyyleng);
}
inline void TKRETURN(const char*myyytext, const int myyyleng)
{
  POS_UPDATE(myyyleng,myyytext);
  adms_veriloga_lval._lexval=adms_lexval_new(
    myyytext,
    adms_admsmain_valueof_filename(adms_global_admsmain())->_value,
    adms_admsmain_valueof_curline(adms_global_admsmain()),
    adms_admsmain_valueof_fpos(adms_global_admsmain())
  );
}
inline void TKSTRIPPEDRETURN(const char*myyytext, const int myyyleng)
{
  char*mystrippedstring;
  int mynewlen=strlen(myyytext)-2;
  assert(mynewlen>=0);
  mystrippedstring=(char*)malloc(mynewlen+1);
  if(mystrippedstring)
  {
    strncpy(mystrippedstring,myyytext+1,mynewlen);
    mystrippedstring[mynewlen]='\0';
  }
  POS_UPDATE(myyyleng,myyytext);
  adms_veriloga_lval._lexval=adms_lexval_new(
    mystrippedstring,
    adms_admsmain_valueof_filename(adms_global_admsmain())->_value,
    adms_admsmain_valueof_curline(adms_global_admsmain()),
    adms_admsmain_valueof_fpos(adms_global_admsmain())
  );
  free(mystrippedstring);
}
#ifdef YYDEBUG
extern int yydebug;
#endif

%}

whitespace [ \t\v\f]+
newline    \r?\n
ident      [A-Za-z_][A-Za-z0-9_]*
attribute  [A-Za-z_][A-Za-z0-9_:.]*
anystring  \"[^\"]*\"
b8_int     0[0-9]*
b10_uint   [1-9][0-9]*
b16_int    0[xX][0-9A-Fa-f]+
float      [0-9]*\.[0-9]+([eE][+-]?[0-9]+)?|[0-9]+\.?([eE][+-]?[0-9]+)?
char       \'[^\']*[\'\n]

%x insideAttribute 
%x insidePragma 

%%

{newline} {
  adms_admsmain_valueto_curline(adms_global_admsmain(),adms_admsmain_valueof_curline(adms_global_admsmain())+1);
  adms_admsmain_valueto_fpos(adms_global_admsmain(),0);
}

^#{whitespace} {BEGIN(insidePragma);}
{whitespace} {POS_UPDATE(yyleng,yytext);}

<insidePragma>{
{anystring} {
  char*mystrippedstring;
  int mynewlen=strlen(yytext)-2;
  assert(mynewlen>=0);
  mystrippedstring=(char*)malloc(mynewlen+1);
  if(mystrippedstring)
  {
    strncpy(mystrippedstring,yytext+1,mynewlen);
    mystrippedstring[mynewlen]='\0';
  }
  adms_admsmain_valueto_filename(adms_global_admsmain(),adms_quark_new(mystrippedstring));
  free(mystrippedstring);
}
{b10_uint} {
    adms_admsmain_valueto_curline(adms_global_admsmain(),adms_strtointeger(yytext));
    adms_admsmain_valueto_fpos(adms_global_admsmain(),0);
}
{newline} {
  BEGIN(INITIAL);
  adms_admsmain_valueto_fpos(adms_global_admsmain(),0);
}
{whitespace} {POS_UPDATE(yyleng,yytext);}
. {
  adms_message_fatal(("[%s:%i]: inside pragma declaration unexpected character at [%s]\n",
    adms_admsmain_valueof_filename (adms_global_admsmain ())->_value,
    adms_admsmain_valueof_curline (adms_global_admsmain ()),
    yytext))
}
}

{anystring} {TKSTRIPPEDRETURN(yytext,yyleng); return tk_anystring;}

\(\* {BEGIN(insideAttribute); {TKRETURN(yytext,yyleng); return tk_beginattribute;}}

<insideAttribute>{
\*\) {
  BEGIN(INITIAL);
  {TKRETURN(yytext,yyleng); return tk_endattribute;}
}
{attribute} {TKRETURN(yytext,yyleng); return tk_ident;}
= {return yytext[0];}
{anystring} {TKSTRIPPEDRETURN(yytext,yyleng); return tk_anystring;}
{whitespace} {POS_UPDATE(yyleng,yytext);}
, {return yytext[0];}
{newline} {
  adms_admsmain_valueto_curline(adms_global_admsmain(),adms_admsmain_valueof_curline(adms_global_admsmain())+1);
  adms_admsmain_valueto_fpos(adms_global_admsmain(),0);
}
. {
  adms_message_fatal(("[%s:%i]: inside Verilog-ams attribute declaration unexpected character at [%s]\n",
    adms_admsmain_valueof_filename (adms_global_admsmain ())->_value,
    adms_admsmain_valueof_curline (adms_global_admsmain ()),
    yytext))
}
}

parameter {TKRETURN(yytext,yyleng); return tk_parameter;}
aliasparameter {TKRETURN(yytext,yyleng); return tk_aliasparameter;}
aliasparam {TKRETURN(yytext,yyleng); return tk_aliasparam;}
module {TKRETURN(yytext,yyleng); return tk_module;}
endmodule {TKRETURN(yytext,yyleng); return tk_endmodule;}
function {TKRETURN(yytext,yyleng); return tk_function;}
endfunction {TKRETURN(yytext,yyleng); return tk_endfunction;}
discipline {TKRETURN(yytext,yyleng); return tk_discipline;}
potential {TKRETURN(yytext,yyleng); return tk_potential;}
flow {TKRETURN(yytext,yyleng); return tk_flow;}
ground {TKRETURN(yytext,yyleng); return tk_ground;}
enddiscipline {TKRETURN(yytext,yyleng); return tk_enddiscipline;}
nature {TKRETURN(yytext,yyleng); return tk_nature;}
endnature {TKRETURN(yytext,yyleng); return tk_endnature;}
input {TKRETURN(yytext,yyleng); return tk_input;}
output {TKRETURN(yytext,yyleng); return tk_output;}
inout {TKRETURN(yytext,yyleng); return tk_inout;}
branch {TKRETURN(yytext,yyleng); return tk_branch;}
analog {TKRETURN(yytext,yyleng); return tk_analog;}
begin {TKRETURN(yytext,yyleng); return tk_begin;}
end {TKRETURN(yytext,yyleng); return tk_end;}
if {TKRETURN(yytext,yyleng); return tk_if;}
while {TKRETURN(yytext,yyleng); return tk_while;}
case {TKRETURN(yytext,yyleng); return tk_case;}
endcase {TKRETURN(yytext,yyleng); return tk_endcase;}
default {TKRETURN(yytext,yyleng); return tk_default;}
for {TKRETURN(yytext,yyleng); return tk_for;}
else {TKRETURN(yytext,yyleng); return tk_else;}
integer {TKRETURN(yytext,yyleng); return tk_integer;}
real {TKRETURN(yytext,yyleng); return tk_real;}
string {TKRETURN(yytext,yyleng); return tk_string;}
from {TKRETURN(yytext,yyleng); return tk_from;}
exclude {TKRETURN(yytext,yyleng); return tk_exclude;}
inf {TKRETURN(yytext,yyleng); return tk_inf;}
INF {TKRETURN(yytext,yyleng); return tk_inf;}

{ident} {TKRETURN(yytext,yyleng); return tk_ident;}

\>\> {TKRETURN(yytext,yyleng); return tk_op_shr;}
\<\< {TKRETURN(yytext,yyleng); return tk_op_shl;}
\&\& {TKRETURN(yytext,yyleng); return tk_and;}
\|\| {TKRETURN(yytext,yyleng); return tk_or;}
\^\~ {TKRETURN(yytext,yyleng); return tk_bitwise_equr;}

\${ident} {TKRETURN(yytext,yyleng); return tk_dollar_ident;}
{char} {TKSTRIPPEDRETURN(yytext,yyleng); return tk_char;}
{b8_int} {TKRETURN(yytext,yyleng); return tk_number;}
{b10_uint} {TKRETURN(yytext,yyleng); return tk_number;}
{b16_int} {TKRETURN(yytext,yyleng); return tk_number;}
{float} {TKRETURN(yytext,yyleng); return tk_number;}

. {POS_UPDATE(yyleng,yytext);return yytext[0];}

%%

int yywrap (void) {return 1;}
