%{

#include <admsPreprocessor/admsPreprocessor.h>
#include <admsPreprocessor/preprocessorYacc.h>
#include <admsObject/admsC.h>

#undef win32_interface
#if defined(WIN32)
#  if defined(_inside_admsPreprocessor)
#    define win32_interface __declspec(dllexport)
#  else
#    define win32_interface __declspec(dllimport)
#  endif
#else
#  define win32_interface
#endif

#ifndef INITIAL
#  define INITIAL 0
#endif

#include <admsPreprocessor/constants.vams.c>
#include <admsPreprocessor/disciplines.vams.c>

#define adms_preprocessor_flex_unput \
{\
  int i;\
  char *yycopy=strdup(yytext);\
  for ( i = yyleng - 1; i >= 0; --i )\
    unput(yycopy[i]);\
  free(yycopy);\
}

#define DONT_SKIPP_TEXT (adms_preprocessor_valueof_main()->skipp_text==NULL)||(adms_preprocessor_valueof_main()->skipp_text->data==INT2ADMS(0))

void adms_preprocessor_setfile_input (FILE *ifile)
{
  yyin = ifile;
}

FILE *adms_preprocessor_getfile_input (void)
{
  return yyin;
}

void adms_preprocessor_setfile_output (FILE *ifile)
{
  yyout = ifile;
}

FILE *adms_preprocessor_getfile_output (void)
{
  return yyout;
}

#define tkreturn(token)   do {                                                         \
        adms_preprocessor_valueof_main()->cr_scanner->cur_char_position+=adms_preprocessor_leng; \
        return token;                                                                  \
} while (0)

static char* adms_preprocessor_lex_remove_leading_quote (char* name)
{
  char* unquoted_name;
  char* start;
  char* finish;
  start = name+1;
  finish = name + strlen(name);
  unquoted_name = adms_constnclone (start, finish - start );
  return (unquoted_name);
}

static char* adms_preprocessor_lex_get_path (char* macro, const char begin, const char end)
  {
    char* path;
    char* start;
    char* finish;

    start = macro;

    while( *start && (*start != begin) )
      start++;

    finish = ++start;

    while( *finish && (*finish != end) )
      finish++;

    path = g_strndup (start, finish - start );

    return (path);

  }

void adms_preprocessor_error (const char *message)
{
  p_preprocessor cr_preprocessor=adms_preprocessor_valueof_main()->cr_scanner;
  adms_message_fatal (("[%s:%i]:%s: %s\n",
    cr_preprocessor->filename,
    adms_preprocessor_get_line_position(cr_preprocessor,cr_preprocessor->cur_char_position-adms_preprocessor_leng),
    message,
    cr_preprocessor->cur_message?cr_preprocessor->cur_message:""
  ))
}
static void adms_file_fprintf ( char *filename, const char *filedata)
{
  FILE *ofh = fopen (filename, "w");
  if (fprintf (ofh, filedata)==EOF)
    adms_message_fatal(("%s: cannot write file\n", filename))
  fclose (ofh);
}
static void adms_preprocessor_lex_include_file (char* fileName)
{
  FILE*myfh;
  p_preprocessor scanner;
  char*message=NULL;
  adms_strconcat2(&message,adms_preprocessor_valueof_main()->cr_scanner->filename);
  adms_strconcat2(&message,":");
  adms_strconcat(&message,adms_integertostring(adms_preprocessor_get_line_position (adms_preprocessor_valueof_main()->cr_scanner, 0)));
  if(adms_preprocessor_valueof_main()->cr_filename)
    free(adms_preprocessor_valueof_main()->cr_filename);
  adms_preprocessor_valueof_main()->cr_filename=strdup(fileName);
  if(!(myfh=adms_file_open_read_with_path(fileName,adms_slist(adms_preprocessor_valueof_main()->includePath))))
  {
    if(!strcmp(fileName,"discipline.h")||!strcmp(fileName,"disciplines.h")
      ||!strcmp(fileName,"discipline.vams")||!strcmp(fileName,"disciplines.vams"))
    {
      adms_message_warning(("[%s]: standard vams file created (not found in -I path) ... '%s'\n",message,fileName))
      adms_file_fprintf(fileName,disciplines_vams);
      myfh=adms_file_open_read(fileName);
    }
    else if(
      !strcmp(fileName,"constant.h")||!strcmp(fileName,"constants.h")
      ||!strcmp(fileName,"constant.vams")||!strcmp(fileName,"constants.vams")
    )
    {
      adms_message_warning(("[%s]: standard vams file created (not found in -I path) ... '%s'\n",message,fileName))
      adms_file_fprintf(fileName,constants_vams);
      myfh=adms_file_open_read(fileName);
    }
    else
      adms_message_fatal(("[%s]: failed to open file ... '%s'\n",message,fileName))
  }
  scanner=(p_preprocessor)malloc(sizeof(t_preprocessor));
  adms_message_verbose(("include file '%s'\n",fileName))
  scanner->buffer=NULL;
  scanner->fid=NULL;
  scanner->cur_continuator_position=NULL;
  adms_preprocessor_valueof_main()->cr_scanner->buffer = adms_adms(YY_CURRENT_BUFFER);
  adms_slist_push(&adms_preprocessor_valueof_main()->Scanner,(void*)adms_preprocessor_valueof_main()->cr_scanner );
  adms_preprocessor_in = myfh;
  scanner->fid = adms_preprocessor_in;
  scanner->cur_line_position = 1;
  scanner->cur_char_position = 1;
  scanner->filename=strdup(adms_preprocessor_valueof_main()->cr_filename);
  scanner->buffer = (void*) yy_create_buffer(adms_preprocessor_in,YY_BUF_SIZE );
  adms_preprocessor_valueof_main()->cr_scanner = scanner;
  adms_preprocessor__switch_to_buffer((YY_BUFFER_STATE)scanner->buffer );
  adms_preprocessor_lval.mystr = NULL;
  adms_strconcat2(&adms_preprocessor_lval.mystr,"# 1 \"");
  adms_strconcat2(&adms_preprocessor_lval.mystr,adms_preprocessor_valueof_main()->cr_scanner->filename);
  adms_strconcat2(&adms_preprocessor_lval.mystr,"\"\n");
  BEGIN( INITIAL );
  free(message);
}

static char *adms_preprocessor_lex_skipp_text ()
{
  char *c;
  int nbline=0;
  c = adms_preprocessor_text;
  while (*c)
  {
    if(*c=='\n')
    {
      adms_preprocessor_valueof_main()->cr_scanner->cur_char_position = 1;
      adms_preprocessor_valueof_main()->cr_scanner->cur_line_position++;
      nbline++;
    }
    else
      adms_preprocessor_valueof_main()->cr_scanner->cur_char_position++;
    c++;
  }
  if(nbline)
  {
    char*str=(char*)malloc(sizeof(char)*(nbline+1));
    memset(str,'\n',nbline);
    str[nbline] = '\0';
    return str;
  }
  else
    return g_strdup("");
}

%}

whitespace	 [ \t\v\f]*
Whitespace	 [ \t\v\f]+
newline		 \r?\n
ident		 $?[A-Za-z_][A-Za-z0-9_]*
notident	 [^`a-zA-Z_\r\n]+
notpragma	 [^#`a-zA-Z_\r\n]+
xpath	         \"[^\"]*\"
ipath	         \<[^>]+\>
continuator	 \\\r?\n
anystring  \"[^\"]*\"
b10_uint   [1-9][0-9]*
 
comment          \/\*[^\*]*\*+([^\*\/][^\*]*\*+)*\/
comment_oneline  \/\/[^\r\n]*


%x PRAGMA_PATH
%x PRAGMA_COMMENT
%x PRAGMA_NAME
%x PRAGMA_ERROR
%x PRAGMA_DEFINE_START
%x PRAGMA_DEFINE_IGNORE
%x PRAGMA_DEFINE_NOARG
%x PRAGMA_DEFINE_WITHARG
%x PRAGMA_DEFINE_TEXT_START
%x PRAGMA_DEFINE_TEXT
%x PRAGMA_DEFINE_WITHARG_COMMA
%x PRAGMA_DEFINE_WITHARG_ARGS
%x PRAGMA_SUBSTITUTOR_START
%x PRAGMA_SUBSTITUTOR_ARG
%x PRAGMA_SUBSTITUTOR_PAIR
%x PRAGMA_SUBSTITUTOR_ARGITEM
%x PRAGMA_SUBSTITUTOR_ARGCOMMA
%x PRAGMA_SUBSTITUTOR_ARGEND

%%

\"[^"]*\"  {
  adms_preprocessor_lval.mystr = g_strdup( adms_preprocessor_text );
  tkreturn( TK_STRING);
}

{continuator} {
  p_continuator continuator;

  continuator=(p_continuator)malloc(sizeof(t_continuator));
  continuator->char_position = yyleng-1;
  continuator->line_position = adms_preprocessor_valueof_main()->cr_scanner->cur_line_position;

  adms_preprocessor_valueof_main()->cr_scanner->cur_line_position += 1;
  adms_preprocessor_valueof_main()->cr_scanner->cur_char_position = 1;
  adms_slist_push(&(adms_preprocessor_valueof_main()->cr_scanner->cur_continuator_position),adms_adms(continuator));

  tkreturn( TK_NOPRAGMA_CONTINUATOR );
}

 /* ignored sequences */

^#{Whitespace}{b10_uint}{whitespace}{anystring}{Whitespace}{newline} {
}

\r\n {
  adms_preprocessor_lval.mystr=g_strdup(g_strdup(adms_preprocessor_text));
  return(TK_EOL);
}
\n {
  adms_preprocessor_lval.mystr=g_strdup(g_strdup(adms_preprocessor_text));
  return(TK_EOL);
}
 
{Whitespace} {
  adms_preprocessor_valueof_main()->cr_scanner->cur_char_position+=adms_preprocessor_leng; 
  adms_preprocessor_lval.mystr=g_strdup(g_strdup(adms_preprocessor_text));
  return(TK_SPACE );
}

{comment} {
  adms_preprocessor_lval.mystr=adms_preprocessor_lex_skipp_text (); return(TK_COMMENT);
}

{comment_oneline} {
  adms_preprocessor_lval.mystr=adms_preprocessor_lex_skipp_text (); return(TK_COMMENT);
}

 /* pragma */

^{whitespace}[`]define {
  adms_preprocessor_valueof_main()->cr_scanner->cur_char_position+=adms_preprocessor_leng; 
  if ( DONT_SKIPP_TEXT )
    {
      BEGIN( PRAGMA_DEFINE_START );
      tkreturn( TK_DEFINE );
    }
  else
      BEGIN( PRAGMA_DEFINE_IGNORE );
}
<PRAGMA_DEFINE_IGNORE>.* {
  adms_preprocessor_valueof_main()->cr_scanner->cur_char_position+=adms_preprocessor_leng; 
  BEGIN( INITIAL );
}
<PRAGMA_DEFINE_IGNORE>{newline} {
  adms_preprocessor_valueof_main()->cr_scanner->cur_message=g_strdup("- `define: unexpected end-of-line");
  adms_preprocessor_flex_unput
  BEGIN( INITIAL );
}

^{whitespace}[`]undef {
  if ( DONT_SKIPP_TEXT )
    {
      BEGIN( PRAGMA_NAME );
      tkreturn( TK_UNDEF );
    }
  else
      BEGIN( PRAGMA_DEFINE_IGNORE );
}
^{whitespace}[`]ifdef {
  adms_preprocessor_lval.mystr=g_strdup("");;
  BEGIN( PRAGMA_NAME );
  tkreturn( TK_IFDEF );
}
^{whitespace}[`]ifndef {
  adms_preprocessor_lval.mystr=g_strdup("");;
  BEGIN( PRAGMA_NAME );
  tkreturn( TK_IFNDEF );
}
^{whitespace}[`]else {
  char* string=NULL;
  adms_strconcat2(&string,"# ");
  adms_strconcat(&string,adms_integertostring(adms_preprocessor_valueof_main()->cr_scanner->cur_line_position+1));
  adms_strconcat2(&string," \"");
  adms_strconcat2(&string,adms_preprocessor_valueof_main()->cr_scanner->filename);
  adms_strconcat2(&string,"\"");
  adms_preprocessor_lval.mystr=string;
  BEGIN( PRAGMA_COMMENT );
  tkreturn( TK_ELSE);
}
^{whitespace}[`]endif {
  char* string=NULL;
  adms_strconcat2(&string,"# ");
  adms_strconcat(&string,adms_integertostring(adms_preprocessor_valueof_main()->cr_scanner->cur_line_position+1));
  adms_strconcat2(&string," \"");
  adms_strconcat2(&string,adms_preprocessor_valueof_main()->cr_scanner->filename);
  adms_strconcat2(&string,"\"");
  adms_preprocessor_lval.mystr=string;
  BEGIN( PRAGMA_COMMENT );
  tkreturn( TK_ENDIF );
}
^{whitespace}[`]include {
  if ( DONT_SKIPP_TEXT )
    {
      BEGIN( PRAGMA_PATH );
    }
  else
      BEGIN( PRAGMA_DEFINE_IGNORE );
}

<PRAGMA_DEFINE_START>{ident}/{newline} {
  BEGIN( PRAGMA_DEFINE_NOARG );
  adms_preprocessor_lval.mystr=g_strdup(adms_preprocessor_text );
  tkreturn( TK_PRAGMA_NAME );
}
<PRAGMA_DEFINE_START>{ident}/{Whitespace} {
  BEGIN( PRAGMA_DEFINE_NOARG );
  adms_preprocessor_lval.mystr=g_strdup(adms_preprocessor_text );
  tkreturn( TK_PRAGMA_NAME );
}
<PRAGMA_DEFINE_START>{ident}/\( {
  BEGIN( PRAGMA_DEFINE_WITHARG );
  adms_preprocessor_lval.mystr=g_strdup(adms_preprocessor_text );
  tkreturn( TK_PRAGMA_NAME );
}
<PRAGMA_DEFINE_START>{Whitespace} {
  adms_preprocessor_valueof_main()->cr_scanner->cur_char_position+=adms_preprocessor_leng; 
}
<PRAGMA_DEFINE_START>{newline} {
  adms_preprocessor_valueof_main()->cr_scanner->cur_message =
    g_strdup ("- pragma name: unexpected end-of-line");
  adms_preprocessor_flex_unput
  BEGIN( PRAGMA_ERROR );
}
<PRAGMA_DEFINE_START>. {
  char* string=NULL;
  adms_strconcat2(&string,"at character ");
  adms_strconcat2(&string,adms_preprocessor_text);
  adms_strconcat2(&string," - identifier was expected");
  adms_preprocessor_valueof_main()->cr_scanner->cur_message=string;
  adms_preprocessor_flex_unput
  BEGIN( PRAGMA_ERROR );
}

<PRAGMA_DEFINE_NOARG>{Whitespace} {
  adms_preprocessor_valueof_main()->cr_scanner->cur_char_position+=adms_preprocessor_leng; 
}
<PRAGMA_DEFINE_NOARG>{newline} {
  adms_preprocessor_valueof_main()->cr_scanner->cur_message =
    g_strdup ("- `define: unexpected end-of-line)");
  adms_preprocessor_flex_unput
  BEGIN( INITIAL );
  tkreturn( TK_DEFINE_END );
}
<PRAGMA_DEFINE_NOARG>{continuator} {
  p_continuator continuator;

  continuator=(p_continuator)malloc(sizeof(t_continuator));
  continuator->char_position = yyleng-1;
  continuator->line_position = adms_preprocessor_valueof_main()->cr_scanner->cur_line_position;

  adms_preprocessor_valueof_main()->cr_scanner->cur_line_position += 1;
  adms_preprocessor_valueof_main()->cr_scanner->cur_char_position = 1;
  adms_slist_push(&(adms_preprocessor_valueof_main()->cr_scanner->cur_continuator_position),adms_adms(continuator));

  tkreturn( TK_CONTINUATOR );
}
<PRAGMA_DEFINE_NOARG>. {
  char* string=NULL;
  adms_strconcat2(&string,"at character ");
  adms_strconcat2(&string,adms_preprocessor_text);
  adms_strconcat2(&string," - whitespace was expected");
  adms_preprocessor_valueof_main()->cr_scanner->cur_message=string;
  adms_preprocessor_flex_unput
  BEGIN( PRAGMA_DEFINE_TEXT_START );
}

<PRAGMA_DEFINE_WITHARG>\({whitespace}\) {
  adms_preprocessor_valueof_main()->cr_scanner->cur_char_position+=adms_preprocessor_leng; 
  BEGIN( PRAGMA_DEFINE_TEXT_START );
  tkreturn(TK_ARG_NULL);
}
<PRAGMA_DEFINE_WITHARG>\([^)]+{newline} {
  char* string=NULL;
  adms_strconcat2(&string,"at character ");
  adms_strconcat2(&string,adms_preprocessor_text);
  adms_strconcat2(&string," - `define has no closing paren");
  adms_preprocessor_valueof_main()->cr_scanner->cur_message=string;
  adms_preprocessor_flex_unput
  BEGIN( PRAGMA_ERROR );
}
<PRAGMA_DEFINE_WITHARG>\({whitespace} {
  adms_preprocessor_valueof_main()->cr_scanner->cur_char_position+=adms_preprocessor_leng; 
  BEGIN( PRAGMA_DEFINE_WITHARG_ARGS );
}

<PRAGMA_DEFINE_WITHARG_ARGS>{ident} {
  BEGIN( PRAGMA_DEFINE_WITHARG_COMMA );
  adms_preprocessor_lval.mystr=g_strdup(adms_preprocessor_text );
  tkreturn( TK_ARG );
}
<PRAGMA_DEFINE_WITHARG_ARGS>. {
  char* string=NULL;
  adms_strconcat2(&string,"at character ");
  adms_strconcat2(&string,adms_preprocessor_text);
  adms_strconcat2(&string," - `define has unexpected syntax");
  adms_preprocessor_valueof_main()->cr_scanner->cur_message=string;
  adms_preprocessor_flex_unput
  BEGIN( PRAGMA_ERROR );
}

<PRAGMA_DEFINE_WITHARG_COMMA>, {
  adms_preprocessor_valueof_main()->cr_scanner->cur_char_position+=adms_preprocessor_leng; 
}
<PRAGMA_DEFINE_WITHARG_COMMA>\) {
  adms_preprocessor_valueof_main()->cr_scanner->cur_char_position+=adms_preprocessor_leng; 
  BEGIN( PRAGMA_DEFINE_TEXT_START );
}
<PRAGMA_DEFINE_WITHARG_COMMA>{Whitespace} {
  adms_preprocessor_valueof_main()->cr_scanner->cur_char_position+=adms_preprocessor_leng; 
}
<PRAGMA_DEFINE_WITHARG_COMMA>. {
  adms_preprocessor_flex_unput
  BEGIN( PRAGMA_DEFINE_WITHARG_ARGS );
}

<PRAGMA_DEFINE_TEXT_START>{Whitespace} {
  adms_preprocessor_valueof_main()->cr_scanner->cur_char_position+=adms_preprocessor_leng; 
  BEGIN( PRAGMA_DEFINE_TEXT );
}
<PRAGMA_DEFINE_TEXT_START>{continuator} {
  p_continuator continuator;

  continuator=(p_continuator)malloc(sizeof(t_continuator));
  continuator->char_position = yyleng-1;
  continuator->line_position = adms_preprocessor_valueof_main()->cr_scanner->cur_line_position;

  adms_preprocessor_valueof_main()->cr_scanner->cur_line_position += 1;
  adms_preprocessor_valueof_main()->cr_scanner->cur_char_position = 1;
  adms_slist_push(&(adms_preprocessor_valueof_main()->cr_scanner->cur_continuator_position),adms_adms(continuator));

  tkreturn( TK_CONTINUATOR );
}
<PRAGMA_DEFINE_TEXT_START>{newline} {
  adms_preprocessor_flex_unput
  BEGIN( INITIAL );
  tkreturn( TK_DEFINE_END );
}
<PRAGMA_DEFINE_TEXT_START>. {
  adms_preprocessor_flex_unput
  BEGIN( PRAGMA_DEFINE_TEXT );
}

<PRAGMA_DEFINE_TEXT>{Whitespace}/{newline} {
  adms_preprocessor_valueof_main()->cr_scanner->cur_char_position+=adms_preprocessor_leng; 
}

<PRAGMA_DEFINE_TEXT>`{ident}/[ ]*\( {

  adms_preprocessor_lval.mystr = 
    g_strdup(adms_preprocessor_lex_remove_leading_quote( adms_preprocessor_text ));
  {
    if ( DONT_SKIPP_TEXT )
      {
        p_preprocessor_pragma_define Define;
        if ((Define = adms_preprocessor_pragma_define_exists (adms_preprocessor_lval.mystr)))
          {
            if(adms_preprocessor_pragma_define_has_noarg(Define))
              tkreturn( TK_SUBSTITUTOR_NOARG );
            else if(adms_preprocessor_pragma_define_has_nullarg(Define))
              tkreturn( TK_SUBSTITUTOR_NULLARG );
            else
              tkreturn( TK_SUBSTITUTOR_WITHARG );
          }
        else
         {
            adms_preprocessor_lval.mystr = g_strdup(adms_preprocessor_text);
            adms_preprocessor_valueof_main()->cr_scanner->cur_message=strdup(adms_preprocessor_text);
            tkreturn( TK_ERROR_PRAGMA_NOT_FOUND );
         }
      }
    else
      tkreturn( TK_IDENT );
  }

}

<PRAGMA_DEFINE_TEXT>`{ident} {

  adms_preprocessor_lval.mystr = 
    g_strdup(adms_preprocessor_lex_remove_leading_quote( adms_preprocessor_text ));
  {
    if ( DONT_SKIPP_TEXT )
      {
        p_preprocessor_pragma_define Define;
        if ((Define = adms_preprocessor_pragma_define_exists (adms_preprocessor_lval.mystr)))
          {
            if(adms_preprocessor_pragma_define_has_noarg(Define))
              tkreturn( TK_SUBSTITUTOR_NOARG );
            else if(adms_preprocessor_pragma_define_has_nullarg(Define))
              tkreturn( TK_SUBSTITUTOR_NULLARG_ALONE );
            else
              tkreturn( TK_SUBSTITUTOR_WITHARG_ALONE );
          }
        else
         {
            adms_preprocessor_lval.mystr = g_strdup(adms_preprocessor_text);
            adms_preprocessor_valueof_main()->cr_scanner->cur_message=strdup(adms_preprocessor_text);
            tkreturn( TK_ERROR_PRAGMA_NOT_FOUND );
         }
      }
    else
      tkreturn( TK_IDENT );
  }

}

<PRAGMA_DEFINE_TEXT>{ident} {

  adms_preprocessor_lval.mystr = g_strdup(adms_preprocessor_text);
  tkreturn( TK_IDENT );

}

<PRAGMA_DEFINE_TEXT>\(  {
  adms_preprocessor_lval.mystr = g_strdup(adms_preprocessor_text);
  tkreturn('(');
}

<PRAGMA_DEFINE_TEXT>\)  {
  adms_preprocessor_lval.mystr = g_strdup(adms_preprocessor_text);
  tkreturn(')');
}

<PRAGMA_DEFINE_TEXT>\,  {
  adms_preprocessor_lval.mystr = g_strdup(adms_preprocessor_text);
  tkreturn(',');
}

<PRAGMA_DEFINE_TEXT>{Whitespace} {
  adms_preprocessor_valueof_main()->cr_scanner->cur_char_position+=adms_preprocessor_leng; 
  adms_preprocessor_lval.mystr=g_strdup(adms_preprocessor_text);
  return(TK_SPACE );
}

<PRAGMA_DEFINE_TEXT>{comment_oneline} {
  adms_preprocessor_lval.mystr=adms_preprocessor_lex_skipp_text (); return(TK_COMMENT);
}

<PRAGMA_DEFINE_TEXT>{comment} {
  adms_preprocessor_lval.mystr=adms_preprocessor_lex_skipp_text (); return(TK_COMMENT);
}

<PRAGMA_DEFINE_TEXT>.  {
  adms_preprocessor_lval.mystr = g_strdup(adms_preprocessor_text);
  tkreturn( TK_NOT_IDENT);
}

<PRAGMA_DEFINE_TEXT>{continuator} {
  p_continuator continuator;

  continuator=(p_continuator)malloc(sizeof(t_continuator));
  continuator->char_position = yyleng-1;
  continuator->line_position = adms_preprocessor_valueof_main()->cr_scanner->cur_line_position;

  adms_preprocessor_valueof_main()->cr_scanner->cur_line_position += 1;
  adms_preprocessor_valueof_main()->cr_scanner->cur_char_position = 1;
  adms_slist_push(&(adms_preprocessor_valueof_main()->cr_scanner->cur_continuator_position),adms_adms(continuator));

  tkreturn( TK_CONTINUATOR );
}
<PRAGMA_DEFINE_TEXT>{newline} {
  adms_preprocessor_flex_unput
  BEGIN( INITIAL );
  tkreturn( TK_DEFINE_END );
}

<PRAGMA_NAME>{ident} {
  BEGIN( PRAGMA_COMMENT );
  adms_preprocessor_lval.mystr=g_strdup(adms_preprocessor_text );
  tkreturn( TK_PRAGMA_NAME );
}
<PRAGMA_NAME>{Whitespace} {
  adms_preprocessor_valueof_main()->cr_scanner->cur_char_position+=adms_preprocessor_leng; 
}
<PRAGMA_NAME>{newline} {
  adms_preprocessor_valueof_main()->cr_scanner->cur_message=g_strdup ("- unexpected end-of-line");
  adms_preprocessor_flex_unput
  BEGIN( PRAGMA_ERROR );
}
<PRAGMA_NAME>. {
  char* string=NULL;
  adms_strconcat2(&string,"at character ");
  adms_strconcat2(&string,adms_preprocessor_text);
  adms_strconcat2(&string," - pragma name was expected");
  adms_preprocessor_valueof_main()->cr_scanner->cur_message=string;
  adms_preprocessor_flex_unput
  BEGIN( PRAGMA_ERROR );
}
<PRAGMA_NAME>{continuator} {
  p_continuator continuator;

  continuator=(p_continuator)malloc(sizeof(t_continuator));
  continuator->char_position = yyleng-1;
  continuator->line_position = adms_preprocessor_valueof_main()->cr_scanner->cur_line_position;

  adms_preprocessor_valueof_main()->cr_scanner->cur_line_position += 1;
  adms_preprocessor_valueof_main()->cr_scanner->cur_char_position = 1;
  adms_slist_push(&(adms_preprocessor_valueof_main()->cr_scanner->cur_continuator_position),adms_adms(continuator));

  tkreturn( TK_CONTINUATOR );
}

<PRAGMA_PATH>{Whitespace} {
  adms_preprocessor_valueof_main()->cr_scanner->cur_char_position+=adms_preprocessor_leng; 
}
<PRAGMA_PATH>{xpath} {
  char* fileName;
  BEGIN( INITIAL );
  fileName = adms_preprocessor_lex_get_path(adms_preprocessor_text,'"','"');
  adms_preprocessor_lex_include_file(fileName);
  tkreturn(TK_INCLUDE);
}
<PRAGMA_PATH>{ipath} {
  char* fileName;
  BEGIN( INITIAL );
  fileName = adms_preprocessor_lex_get_path(adms_preprocessor_text,'<','>');
  adms_message_info(("%s: implicit path handled as explicit path!",fileName))
  adms_preprocessor_lex_include_file(fileName);
  tkreturn(TK_INCLUDE);
}
<PRAGMA_PATH>. {
  char* string=NULL;
  adms_strconcat2(&string,"at character ");
  adms_strconcat2(&string,adms_preprocessor_text);
  adms_strconcat2(&string," - bad path");
  adms_preprocessor_valueof_main()->cr_scanner->cur_message=string;
  adms_preprocessor_flex_unput
  BEGIN( PRAGMA_ERROR );
}

<PRAGMA_COMMENT>{Whitespace} {
  adms_preprocessor_valueof_main()->cr_scanner->cur_char_position+=adms_preprocessor_leng; 
}
<PRAGMA_COMMENT>{comment_oneline} {
  adms_preprocessor_lval.mystr=adms_preprocessor_lex_skipp_text (); return(TK_COMMENT);
}
<PRAGMA_COMMENT>{comment} {
  adms_preprocessor_lval.mystr=adms_preprocessor_lex_skipp_text (); return(TK_COMMENT);
}
<PRAGMA_COMMENT>{continuator} {
  p_continuator continuator;

  continuator=(p_continuator)malloc(sizeof(t_continuator));
  continuator->char_position = yyleng-1;
  continuator->line_position = adms_preprocessor_valueof_main()->cr_scanner->cur_line_position;

  adms_preprocessor_valueof_main()->cr_scanner->cur_line_position += 1;
  adms_preprocessor_valueof_main()->cr_scanner->cur_char_position = 1;
  adms_slist_push(&(adms_preprocessor_valueof_main()->cr_scanner->cur_continuator_position),adms_adms(continuator));

  tkreturn( TK_CONTINUATOR );

}
<PRAGMA_COMMENT>{newline} {
  adms_preprocessor_flex_unput
  BEGIN( INITIAL );
}
<PRAGMA_COMMENT>. {
  char* string=NULL;
  adms_strconcat2(&string,"at character ");
  adms_strconcat2(&string,adms_preprocessor_text);
  adms_strconcat2(&string," - unknown error");
  adms_preprocessor_valueof_main()->cr_scanner->cur_message=string;
  adms_preprocessor_flex_unput
  BEGIN( PRAGMA_ERROR );
}

<PRAGMA_ERROR>.*{newline} {
  char* string=NULL;
  adms_strconcat2(&string,"at character ");
  adms_strconcat2(&string,adms_preprocessor_text);
  adms_strconcat2(&string," - unknown error");
  adms_preprocessor_valueof_main()->cr_scanner->cur_message=string;
  tkreturn( TK_ERROR_PRAGMA_DEFINITION );
}

`{ident}/[ ]*\( {

  p_preprocessor_pragma_define Define;
  adms_preprocessor_lval.mystr = 
    g_strdup(adms_preprocessor_lex_remove_leading_quote( adms_preprocessor_text));
  if ( DONT_SKIPP_TEXT )
    {
      if ((Define = adms_preprocessor_pragma_define_exists (adms_preprocessor_lval.mystr)))
        {
          if(adms_preprocessor_pragma_define_has_noarg(Define))
            tkreturn( TK_SUBSTITUTOR_NOARG );
          else if(adms_preprocessor_pragma_define_has_nullarg(Define))
            tkreturn( TK_SUBSTITUTOR_NULLARG );
          else
            tkreturn( TK_SUBSTITUTOR_WITHARG );
        }
      else
       {
          adms_preprocessor_lval.mystr = g_strdup(adms_preprocessor_text);
          adms_preprocessor_valueof_main()->cr_scanner->cur_message=strdup(adms_preprocessor_text);
          tkreturn( TK_ERROR_PRAGMA_NOT_FOUND );
       }
    }
  else
    tkreturn( TK_IDENT );

}

`{ident} {

  adms_preprocessor_lval.mystr = 
    g_strdup(adms_preprocessor_lex_remove_leading_quote( adms_preprocessor_text ));
  {
    p_preprocessor_pragma_define Define;
    if ( DONT_SKIPP_TEXT )
      {
        if ((Define = adms_preprocessor_pragma_define_exists (adms_preprocessor_lval.mystr)))
          {
            if(adms_preprocessor_pragma_define_has_noarg(Define))
              tkreturn( TK_SUBSTITUTOR_NOARG );
            else if(adms_preprocessor_pragma_define_has_nullarg(Define))
              tkreturn( TK_SUBSTITUTOR_NULLARG_ALONE );
            else
              tkreturn( TK_SUBSTITUTOR_WITHARG_ALONE );
          }
        else
         {
            adms_preprocessor_lval.mystr = g_strdup(adms_preprocessor_text);
            adms_preprocessor_valueof_main()->cr_scanner->cur_message=strdup(adms_preprocessor_text);
            tkreturn( TK_ERROR_PRAGMA_NOT_FOUND );
         }
      }
    else
      tkreturn( TK_IDENT );
  }

}

{ident} {

  adms_preprocessor_lval.mystr = g_strdup(adms_preprocessor_text);
  tkreturn( TK_IDENT );

}

\(  {
  adms_preprocessor_lval.mystr = g_strdup(adms_preprocessor_text);
  return '(';
}

\)  {
  adms_preprocessor_lval.mystr = g_strdup(adms_preprocessor_text);
  return ')';
}

\,  {
  adms_preprocessor_lval.mystr = g_strdup(adms_preprocessor_text);
  return ',';
}

.  {
  adms_preprocessor_lval.mystr = g_strdup(adms_preprocessor_text);
  return TK_NOT_IDENT;
}

<<EOF>> {
  char* string=NULL;
  if( adms_preprocessor_valueof_main()->Scanner != NULL )
    {
      yy_delete_buffer((YY_BUFFER_STATE)(adms_preprocessor_valueof_main()->cr_scanner->buffer));
      free(adms_preprocessor_valueof_main()->cr_scanner );
      adms_preprocessor_valueof_main()->cr_scanner = (p_preprocessor) adms_slist_pull(&adms_preprocessor_valueof_main()->Scanner );
      adms_preprocessor_in = adms_preprocessor_valueof_main()->cr_scanner->fid;
      yy_switch_to_buffer((YY_BUFFER_STATE)adms_preprocessor_valueof_main()->cr_scanner->buffer );
    }
  else
    yyterminate ();
  adms_strconcat2(&string,"# ");
  adms_strconcat(&string,adms_integertostring(adms_preprocessor_valueof_main()->cr_scanner->cur_line_position+1));
  adms_strconcat2(&string," \"");
  adms_strconcat2(&string,adms_preprocessor_valueof_main()->cr_scanner->filename);
  adms_strconcat2(&string,"\"");
  adms_preprocessor_lval.mystr=string;
  tkreturn(TK_EOF);
}

%%

int adms_preprocessor_wrap (void)
  {
    return 1;
  }
