
/* ------- code automatically created by ../scripts/adms_build_object.pl -------------- */
#include <admsObject/objectNode.h>
#include <admsObject/objectAdmsmain.h>

inline void adms_node_free(p_node mynode)
{
  if(!mynode)
    return;
  {p_slist l=mynode->_attribute;for(;l;l=l->next) adms_attribute_free(adms_attribute(l->data));}
  adms_slist_free(mynode->_attribute);
  adms_quark_free(mynode->_name);
  adms_enumeration_free(mynode->_direction);
  adms_enumeration_free(mynode->_grounded);
  adms_enumeration_free(mynode->_location);
  adms_global_increment_nbnodedestroy();
  free(mynode);
}
int adms_node_cmp (p_node mynode,p_node refnode)
{
  int status;
  status =
  (
    (adms_node_valueof_module (mynode) != adms_node_valueof_module (refnode))
    ||
    !!strcmp(adms_node_valueof_name (mynode)->_value,adms_node_valueof_name (refnode)->_value)
  );
  return status;
}
p_node adms_node_new(p_module mymodule,p_quark myname)
{
  p_node mynewnode=(p_node) calloc(1,(size_t)sizeof(t_node));
  adms_global_increment_nbnodenew();
  mynewnode->_adms._datatypename=adms_adms_enumeration_datatypename_node;
  mynewnode->_adms._seen=adms_adms_enumeration_seen_no;
  mynewnode->_module_isdefault=-1;
  adms_node_valueto_module (mynewnode,mymodule);
  mynewnode->_module_isdefault=1;
  mynewnode->_name_isdefault=-1;
  adms_node_valueto_name (mynewnode,myname);
  mynewnode->_name_isdefault=1;
  mynewnode->_direction_isdefault=-1;
  adms_node_valueto_direction(mynewnode,adms_enumeration_new(adms_node_enumeration_direction_inout,adms_node_fromstring_direction_impl,adms_node_tostring_direction_impl));
  mynewnode->_direction_isdefault=1;
  mynewnode->_discipline_isdefault=-1;
  mynewnode->_grounded_isdefault=-1;
  adms_node_valueto_grounded(mynewnode,adms_enumeration_new(adms_node_enumeration_grounded_no,adms_node_fromstring_grounded_impl,adms_node_tostring_grounded_impl));
  mynewnode->_grounded_isdefault=1;
  mynewnode->_location_isdefault=-1;
  adms_node_valueto_location(mynewnode,adms_enumeration_new(adms_node_enumeration_location_internal,adms_node_fromstring_location_impl,adms_node_tostring_location_impl));
  mynewnode->_location_isdefault=1;
  mynewnode->_attribute_isdefault=-1;
  return mynewnode;
}
p_adms adms_node_new_impl (p_adms arguments[])
{
  p_node mynewnode;
  p_module mymodule=(p_module)arguments[0];
  p_quark myname=adms_quark_new((char*)arguments[1]);
  mynewnode=adms_node_new(mymodule,myname);
  return adms_adms(mynewnode);
}
/*$2*/
char*adms_node_uid (p_node mynewnode)
{
  char*myuid=NULL;
  char*myuid0=adms_quark_uid(mynewnode->_name);
  adms_strconcat(&myuid,myuid0);
  return myuid;
}

inline void
adms_node_valueto_module (p_node mynode,p_module _module)
{
  mynode->_module=_module;
  mynode->_module_isdefault=0;
}

inline void
adms_node_valueto_name (p_node mynode,p_quark _name)
{
  if(mynode->_name_isdefault!=-1)
    adms_quark_free(mynode->_name);
  mynode->_name=_name;
  mynode->_name_isdefault=0;
}

inline void
adms_node_valueto_direction (p_node mynode,p_enumeration _direction)
{
  mynode->_direction=_direction;
  mynode->_direction_isdefault=0;
}

inline void
adms_node_valueto_discipline (p_node mynode,p_discipline _discipline)
{
  mynode->_discipline=_discipline;
  mynode->_discipline_isdefault=0;
}

inline void
adms_node_valueto_grounded (p_node mynode,p_enumeration _grounded)
{
  mynode->_grounded=_grounded;
  mynode->_grounded_isdefault=0;
}

inline void
adms_node_valueto_location (p_node mynode,p_enumeration _location)
{
  mynode->_location=_location;
  mynode->_location_isdefault=0;
}

inline void
adms_node_valueto_attribute (p_node mynode,p_slist _attribute)
{
  mynode->_attribute=_attribute;
  mynode->_attribute_isdefault=0;
}
p_attribute
adms_node_list_attribute_lookup_by_id (p_node mymynode,p_quark myname)
{
  p_slist list=adms_node_valueof_attribute(mymynode);
  while(list) {
    p_attribute refattribute=adms_attribute(list->data);
    if(!strcmp(adms_attribute_valueof_name(refattribute)->_value,myname->_value))
      return refattribute;
    list=list->next;
  }
  return NULL;
}
p_attribute
adms_node_list_attribute_prepend_by_id (p_node mymynode,p_quark myname)
{
  p_attribute refattribute=adms_attribute_new(myname);
  adms_slist_push(&adms_node_valueof_attribute(mymynode),adms_adms(refattribute));
  return refattribute;
}
p_attribute
adms_node_list_attribute_prepend_by_id_once_or_ignore (p_node mymynode,p_quark myname)
{
  p_attribute refattribute=adms_attribute_new(myname);
  adms_slist_push(&adms_node_valueof_attribute(mymynode),adms_adms(refattribute));
  return refattribute;
}
void
adms_node_list_attribute_prepend (p_node mymynode,p_attribute myattribute)
{
  adms_slist_push(&adms_node_valueof_attribute(mymynode),adms_adms(myattribute));
}
e_node_direction
adms_node_fromstring_direction_impl (p_admsttransform myadmsttransform,char*token)
{
  if(!strcmp(token,"inout"))
    return adms_node_enumeration_direction_inout;
  if(!strcmp(token,"input"))
    return adms_node_enumeration_direction_input;
  if(!strcmp(token,"internal"))
    return adms_node_enumeration_direction_internal;
  if(!strcmp(token,"output"))
    return adms_node_enumeration_direction_output;
  adms_message_fatal_continue(("select='node/direction': possible values:\n"))
  adms_message_fatal_continue(("inout|input|internal|output\n"))
  adms_message_fatal(("see %s\n",adms_admsttransform_uid(myadmsttransform)))
  return 0;
}
char*
adms_node_tostring_direction_impl (p_admsttransform myadmsttransform,p_enumeration myenumeration)
{
  e_node_direction e=myenumeration->_value;
  if(e==adms_node_enumeration_direction_inout)
    return "inout";
  if(e==adms_node_enumeration_direction_input)
    return "input";
  if(e==adms_node_enumeration_direction_internal)
    return "internal";
  if(e==adms_node_enumeration_direction_output)
    return "output";
  adms_message_fatal_continue(("select='node/direction': possible values:\n"))
  adms_message_fatal_continue(("inout|input|internal|output\n"))
  adms_message_fatal(("see %s\n",adms_admsttransform_uid(myadmsttransform)))
  return NULL;
}

e_node_grounded
adms_node_fromstring_grounded_impl (p_admsttransform myadmsttransform,char*token)
{
  if(!strcmp(token,"no"))
    return adms_node_enumeration_grounded_no;
  if(!strcmp(token,"yes"))
    return adms_node_enumeration_grounded_yes;
  adms_message_fatal_continue(("select='node/grounded': possible values:\n"))
  adms_message_fatal_continue(("no|yes\n"))
  adms_message_fatal(("see %s\n",adms_admsttransform_uid(myadmsttransform)))
  return 0;
}
char*
adms_node_tostring_grounded_impl (p_admsttransform myadmsttransform,p_enumeration myenumeration)
{
  e_node_grounded e=myenumeration->_value;
  if(e==adms_node_enumeration_grounded_no)
    return "no";
  if(e==adms_node_enumeration_grounded_yes)
    return "yes";
  adms_message_fatal_continue(("select='node/grounded': possible values:\n"))
  adms_message_fatal_continue(("no|yes\n"))
  adms_message_fatal(("see %s\n",adms_admsttransform_uid(myadmsttransform)))
  return NULL;
}

e_node_location
adms_node_fromstring_location_impl (p_admsttransform myadmsttransform,char*token)
{
  if(!strcmp(token,"external"))
    return adms_node_enumeration_location_external;
  if(!strcmp(token,"ground"))
    return adms_node_enumeration_location_ground;
  if(!strcmp(token,"internal"))
    return adms_node_enumeration_location_internal;
  adms_message_fatal_continue(("select='node/location': possible values:\n"))
  adms_message_fatal_continue(("external|ground|internal\n"))
  adms_message_fatal(("see %s\n",adms_admsttransform_uid(myadmsttransform)))
  return 0;
}
char*
adms_node_tostring_location_impl (p_admsttransform myadmsttransform,p_enumeration myenumeration)
{
  e_node_location e=myenumeration->_value;
  if(e==adms_node_enumeration_location_external)
    return "external";
  if(e==adms_node_enumeration_location_ground)
    return "ground";
  if(e==adms_node_enumeration_location_internal)
    return "internal";
  adms_message_fatal_continue(("select='node/location': possible values:\n"))
  adms_message_fatal_continue(("external|ground|internal\n"))
  adms_message_fatal(("see %s\n",adms_admsttransform_uid(myadmsttransform)))
  return NULL;
}

