
/* ------- code automatically created by ../scripts/adms_build_object.pl -------------- */
#include <admsObject/objectModule.h>
#include <admsObject/objectAdmsmain.h>

inline void adms_module_free(p_module mymodule)
{
  if(!mymodule)
    return;
  adms_slist_free(mymodule->_node);
  adms_slist_free(mymodule->_block);
  adms_slist_free(mymodule->_contribution);
  adms_slist_free(mymodule->_assignment);
  adms_slist_free(mymodule->_expression);
  adms_slist_free(mymodule->_conditional);
  adms_slist_free(mymodule->_blockvariable);
  adms_slist_free(mymodule->_branch);
  adms_slist_free(mymodule->_jacobian);
  adms_slist_free(mymodule->_probe);
  adms_slist_free(mymodule->_source);
  adms_slist_free(mymodule->_instance);
  adms_slist_free(mymodule->_instantiator);
  adms_slist_free(mymodule->_branchalias);
  adms_slist_free(mymodule->_range);
  adms_slist_free(mymodule->_nodealias);
  adms_slist_free(mymodule->_variable);
  adms_slist_free(mymodule->_analogfunction);
  {p_slist l=mymodule->_attribute;for(;l;l=l->next) adms_attribute_free(adms_attribute(l->data));}
  adms_slist_free(mymodule->_attribute);
  adms_quark_free(mymodule->_name);
  adms_global_increment_nbmoduledestroy();
  free(mymodule);
}
int adms_module_cmp (p_module mymodule,p_module refmodule)
{
  int status;
  status =
  (
    !!strcmp(adms_module_valueof_name (mymodule)->_value,adms_module_valueof_name (refmodule)->_value)
  );
  return status;
}
p_module adms_module_new(p_quark myname)
{
  p_module mynewmodule=(p_module) calloc(1,(size_t)sizeof(t_module));
  adms_global_increment_nbmodulenew();
  mynewmodule->_adms._datatypename=adms_adms_enumeration_datatypename_module;
  mynewmodule->_adms._seen=adms_adms_enumeration_seen_no;
  mynewmodule->_name_isdefault=-1;
  adms_module_valueto_name (mynewmodule,myname);
  mynewmodule->_name_isdefault=1;
  mynewmodule->_evaluation_isdefault=-1;
  mynewmodule->_analog_isdefault=-1;
  mynewmodule->_node_isdefault=-1;
  mynewmodule->_block_isdefault=-1;
  mynewmodule->_contribution_isdefault=-1;
  mynewmodule->_assignment_isdefault=-1;
  mynewmodule->_expression_isdefault=-1;
  mynewmodule->_conditional_isdefault=-1;
  mynewmodule->_blockvariable_isdefault=-1;
  mynewmodule->_branch_isdefault=-1;
  mynewmodule->_jacobian_isdefault=-1;
  mynewmodule->_probe_isdefault=-1;
  mynewmodule->_source_isdefault=-1;
  mynewmodule->_instance_isdefault=-1;
  mynewmodule->_instantiator_isdefault=-1;
  mynewmodule->_branchalias_isdefault=-1;
  mynewmodule->_range_isdefault=-1;
  mynewmodule->_nodealias_isdefault=-1;
  mynewmodule->_variable_isdefault=-1;
  mynewmodule->_analogfunction_isdefault=-1;
  mynewmodule->_attribute_isdefault=-1;
  return mynewmodule;
}
p_adms adms_module_new_impl (p_adms arguments[])
{
  p_module mynewmodule;
  p_quark myname=adms_quark_new((char*)arguments[0]);
  mynewmodule=adms_module_new(myname);
  return adms_adms(mynewmodule);
}
/*$1*/
char*adms_module_uid (p_module mynewmodule)
{
  char*myuid=NULL;
  char*myuid0=adms_quark_uid(mynewmodule->_name);
  adms_strconcat(&myuid,myuid0);
  return myuid;
}

inline void
adms_module_valueto_name (p_module mymodule,p_quark _name)
{
  if(mymodule->_name_isdefault!=-1)
    adms_quark_free(mymodule->_name);
  mymodule->_name=_name;
  mymodule->_name_isdefault=0;
}

inline void
adms_module_valueto_evaluation (p_module mymodule,p_evaluation _evaluation)
{
  mymodule->_evaluation=_evaluation;
  mymodule->_evaluation_isdefault=0;
}

inline void
adms_module_valueto_analog (p_module mymodule,p_analog _analog)
{
  mymodule->_analog=_analog;
  mymodule->_analog_isdefault=0;
}

inline void
adms_module_valueto_node (p_module mymodule,p_slist _node)
{
  mymodule->_node=_node;
  mymodule->_node_isdefault=0;
}
p_node
adms_module_list_node_lookup_by_id (p_module mymymodule,p_module mymodule,p_quark myname)
{
  p_slist list=adms_module_valueof_node(mymymodule);
  while(list) {
    p_node refnode=adms_node(list->data);
    if((adms_node_valueof_module(refnode)==mymodule)&&
       !strcmp(adms_node_valueof_name(refnode)->_value,myname->_value))
      return refnode;
    list=list->next;
  }
  return NULL;
}
p_node
adms_module_list_node_prepend_by_id (p_module mymymodule,p_module mymodule,p_quark myname)
{
  p_node refnode=adms_node_new(mymodule,myname);
  adms_slist_push(&adms_module_valueof_node(mymymodule),adms_adms(refnode));
  return refnode;
}
p_node
adms_module_list_node_prepend_by_id_once_or_ignore (p_module mymymodule,p_module mymodule,p_quark myname)
{
  p_slist list=adms_module_valueof_node(mymymodule);
  p_node refnode=adms_node_new(mymodule,myname);
  while(list)
  {
    if(!adms_node_cmp(adms_node(list->data),refnode))
    {
      adms_node_free (refnode);
      return adms_node(list->data);
    }
    list=list->next;
  }
  adms_slist_push(&adms_module_valueof_node(mymymodule),adms_adms(refnode));
  return refnode;
}
void
adms_module_list_node_prepend_once_or_ignore (p_module mymymodule,p_node mynode)
{
  p_slist list=adms_module_valueof_node(mymymodule);
  while(list)
  {
    if(!adms_node_cmp(adms_node(list->data),mynode))
      return;
    list=list->next;
  }
  adms_slist_push(&adms_module_valueof_node(mymymodule),adms_adms(mynode));
}
p_node
adms_module_list_node_prepend_by_id_once_or_abort (p_module mymymodule,p_module mymodule,p_quark myname)
{
  p_slist list=adms_module_valueof_node(mymymodule);
  p_node refnode=adms_node_new(mymodule,myname);
  while(list)
  {
    if(!adms_node_cmp(adms_node(list->data),refnode))
    {
      adms_message_fatal(("module=[%s] node=[%s] already defined\n",
        adms_module_uid(mymymodule),adms_node_uid(refnode)))
      adms_node_free (refnode);
    }
    list=list->next;
  }
  adms_slist_push(&adms_module_valueof_node(mymymodule),adms_adms(refnode));
  return refnode;
}
void
adms_module_list_node_prepend_once_or_abort (p_module mymymodule,p_node mynode)
{
  p_slist list=adms_module_valueof_node(mymymodule);
  while(list)
  {
    if(!adms_node_cmp(adms_node(list->data),mynode))
    {
      adms_message_fatal(("module=[%s] node=[%s] already defined\n",
        adms_module_uid(mymymodule),adms_node_uid(mynode)))
      return;
    }
    list=list->next;
  }
  adms_slist_push(&adms_module_valueof_node(mymymodule),adms_adms(mynode));
}

inline void
adms_module_valueto_block (p_module mymodule,p_slist _block)
{
  mymodule->_block=_block;
  mymodule->_block_isdefault=0;
}
p_block
adms_module_list_block_lookup_by_id (p_module mymymodule,p_module mymodule,p_quark myname,p_block myblock)
{
  p_slist list=adms_module_valueof_block(mymymodule);
  while(list) {
    p_block refblock=adms_block(list->data);
    if((adms_block_valueof_module(refblock)==mymodule)&&
       !strcmp(adms_block_valueof_name(refblock)->_value,myname->_value)&&
       (adms_block_valueof_block(refblock)==myblock))
      return refblock;
    list=list->next;
  }
  return NULL;
}
p_block
adms_module_list_block_prepend_by_id (p_module mymymodule,p_module mymodule,p_quark myname,p_block myblock)
{
  p_block refblock=adms_block_new(mymodule,myname,myblock);
  adms_slist_push(&adms_module_valueof_block(mymymodule),adms_adms(refblock));
  return refblock;
}
p_block
adms_module_list_block_prepend_by_id_once_or_ignore (p_module mymymodule,p_module mymodule,p_quark myname,p_block myblock)
{
  p_block refblock=adms_block_new(mymodule,myname,myblock);
  adms_slist_push(&adms_module_valueof_block(mymymodule),adms_adms(refblock));
  return refblock;
}
void
adms_module_list_block_prepend (p_module mymymodule,p_block myblock)
{
  adms_slist_push(&adms_module_valueof_block(mymymodule),adms_adms(myblock));
}

inline void
adms_module_valueto_contribution (p_module mymodule,p_slist _contribution)
{
  mymodule->_contribution=_contribution;
  mymodule->_contribution_isdefault=0;
}
p_contribution
adms_module_list_contribution_lookup_by_id (p_module mymymodule,p_module mymodule,p_source mylhs,p_expression myrhs)
{
  p_slist list=adms_module_valueof_contribution(mymymodule);
  while(list) {
    p_contribution refcontribution=adms_contribution(list->data);
    if((adms_contribution_valueof_module(refcontribution)==mymodule)&&
       (adms_contribution_valueof_lhs(refcontribution)==mylhs)&&
       (adms_contribution_valueof_rhs(refcontribution)==myrhs))
      return refcontribution;
    list=list->next;
  }
  return NULL;
}
p_contribution
adms_module_list_contribution_prepend_by_id (p_module mymymodule,p_module mymodule,p_source mylhs,p_expression myrhs)
{
  p_contribution refcontribution=adms_contribution_new(mymodule,mylhs,myrhs);
  adms_slist_push(&adms_module_valueof_contribution(mymymodule),adms_adms(refcontribution));
  return refcontribution;
}
p_contribution
adms_module_list_contribution_prepend_by_id_once_or_ignore (p_module mymymodule,p_module mymodule,p_source mylhs,p_expression myrhs)
{
  p_contribution refcontribution=adms_contribution_new(mymodule,mylhs,myrhs);
  adms_slist_push(&adms_module_valueof_contribution(mymymodule),adms_adms(refcontribution));
  return refcontribution;
}
void
adms_module_list_contribution_prepend (p_module mymymodule,p_contribution mycontribution)
{
  adms_slist_push(&adms_module_valueof_contribution(mymymodule),adms_adms(mycontribution));
}

inline void
adms_module_valueto_assignment (p_module mymodule,p_slist _assignment)
{
  mymodule->_assignment=_assignment;
  mymodule->_assignment_isdefault=0;
}
p_assignment
adms_module_list_assignment_lookup_by_id (p_module mymymodule,p_module mymodule,p_variable mylhs,p_expression myrhs)
{
  p_slist list=adms_module_valueof_assignment(mymymodule);
  while(list) {
    p_assignment refassignment=adms_assignment(list->data);
    if((adms_assignment_valueof_module(refassignment)==mymodule)&&
       (adms_assignment_valueof_lhs(refassignment)==mylhs)&&
       (adms_assignment_valueof_rhs(refassignment)==myrhs))
      return refassignment;
    list=list->next;
  }
  return NULL;
}
p_assignment
adms_module_list_assignment_prepend_by_id (p_module mymymodule,p_module mymodule,p_variable mylhs,p_expression myrhs)
{
  p_assignment refassignment=adms_assignment_new(mymodule,mylhs,myrhs);
  adms_slist_push(&adms_module_valueof_assignment(mymymodule),adms_adms(refassignment));
  return refassignment;
}
p_assignment
adms_module_list_assignment_prepend_by_id_once_or_ignore (p_module mymymodule,p_module mymodule,p_variable mylhs,p_expression myrhs)
{
  p_assignment refassignment=adms_assignment_new(mymodule,mylhs,myrhs);
  adms_slist_push(&adms_module_valueof_assignment(mymymodule),adms_adms(refassignment));
  return refassignment;
}
void
adms_module_list_assignment_prepend (p_module mymymodule,p_assignment myassignment)
{
  adms_slist_push(&adms_module_valueof_assignment(mymymodule),adms_adms(myassignment));
}

inline void
adms_module_valueto_expression (p_module mymodule,p_slist _expression)
{
  mymodule->_expression=_expression;
  mymodule->_expression_isdefault=0;
}
p_expression
adms_module_list_expression_lookup_by_id (p_module mymymodule,p_module mymodule,p_adms mytree)
{
  p_slist list=adms_module_valueof_expression(mymymodule);
  while(list) {
    p_expression refexpression=adms_expression(list->data);
    if((adms_expression_valueof_module(refexpression)==mymodule)&&
       (adms_expression_valueof_tree(refexpression)==mytree))
      return refexpression;
    list=list->next;
  }
  return NULL;
}
p_expression
adms_module_list_expression_prepend_by_id (p_module mymymodule,p_module mymodule,p_adms mytree)
{
  p_expression refexpression=adms_expression_new(mymodule,mytree);
  adms_slist_push(&adms_module_valueof_expression(mymymodule),adms_adms(refexpression));
  return refexpression;
}
p_expression
adms_module_list_expression_prepend_by_id_once_or_ignore (p_module mymymodule,p_module mymodule,p_adms mytree)
{
  p_expression refexpression=adms_expression_new(mymodule,mytree);
  adms_slist_push(&adms_module_valueof_expression(mymymodule),adms_adms(refexpression));
  return refexpression;
}
void
adms_module_list_expression_prepend (p_module mymymodule,p_expression myexpression)
{
  adms_slist_push(&adms_module_valueof_expression(mymymodule),adms_adms(myexpression));
}

inline void
adms_module_valueto_conditional (p_module mymodule,p_slist _conditional)
{
  mymodule->_conditional=_conditional;
  mymodule->_conditional_isdefault=0;
}
p_conditional
adms_module_list_conditional_lookup_by_id (p_module mymymodule,p_module mymodule,p_expression myif,p_adms mythen,p_adms myelse)
{
  p_slist list=adms_module_valueof_conditional(mymymodule);
  while(list) {
    p_conditional refconditional=adms_conditional(list->data);
    if((adms_conditional_valueof_module(refconditional)==mymodule)&&
       (adms_conditional_valueof_if(refconditional)==myif)&&
       (adms_conditional_valueof_then(refconditional)==mythen)&&
       (adms_conditional_valueof_else(refconditional)==myelse))
      return refconditional;
    list=list->next;
  }
  return NULL;
}
p_conditional
adms_module_list_conditional_prepend_by_id (p_module mymymodule,p_module mymodule,p_expression myif,p_adms mythen,p_adms myelse)
{
  p_conditional refconditional=adms_conditional_new(mymodule,myif,mythen,myelse);
  adms_slist_push(&adms_module_valueof_conditional(mymymodule),adms_adms(refconditional));
  return refconditional;
}
p_conditional
adms_module_list_conditional_prepend_by_id_once_or_ignore (p_module mymymodule,p_module mymodule,p_expression myif,p_adms mythen,p_adms myelse)
{
  p_conditional refconditional=adms_conditional_new(mymodule,myif,mythen,myelse);
  adms_slist_push(&adms_module_valueof_conditional(mymymodule),adms_adms(refconditional));
  return refconditional;
}
void
adms_module_list_conditional_prepend (p_module mymymodule,p_conditional myconditional)
{
  adms_slist_push(&adms_module_valueof_conditional(mymymodule),adms_adms(myconditional));
}

inline void
adms_module_valueto_blockvariable (p_module mymodule,p_slist _blockvariable)
{
  mymodule->_blockvariable=_blockvariable;
  mymodule->_blockvariable_isdefault=0;
}
p_blockvariable
adms_module_list_blockvariable_lookup_by_id (p_module mymymodule,p_block myblock)
{
  p_slist list=adms_module_valueof_blockvariable(mymymodule);
  while(list) {
    p_blockvariable refblockvariable=adms_blockvariable(list->data);
    if((adms_blockvariable_valueof_block(refblockvariable)==myblock))
      return refblockvariable;
    list=list->next;
  }
  return NULL;
}
p_blockvariable
adms_module_list_blockvariable_prepend_by_id (p_module mymymodule,p_block myblock)
{
  p_blockvariable refblockvariable=adms_blockvariable_new(myblock);
  adms_slist_push(&adms_module_valueof_blockvariable(mymymodule),adms_adms(refblockvariable));
  return refblockvariable;
}
p_blockvariable
adms_module_list_blockvariable_prepend_by_id_once_or_ignore (p_module mymymodule,p_block myblock)
{
  p_blockvariable refblockvariable=adms_blockvariable_new(myblock);
  adms_slist_push(&adms_module_valueof_blockvariable(mymymodule),adms_adms(refblockvariable));
  return refblockvariable;
}
void
adms_module_list_blockvariable_prepend (p_module mymymodule,p_blockvariable myblockvariable)
{
  adms_slist_push(&adms_module_valueof_blockvariable(mymymodule),adms_adms(myblockvariable));
}

inline void
adms_module_valueto_branch (p_module mymodule,p_slist _branch)
{
  mymodule->_branch=_branch;
  mymodule->_branch_isdefault=0;
}
p_branch
adms_module_list_branch_lookup_by_id (p_module mymymodule,p_module mymodule,p_node mypnode,p_node mynnode)
{
  p_slist list=adms_module_valueof_branch(mymymodule);
  while(list) {
    p_branch refbranch=adms_branch(list->data);
    if((adms_branch_valueof_module(refbranch)==mymodule)&&
       (adms_branch_valueof_pnode(refbranch)==mypnode)&&
       (adms_branch_valueof_nnode(refbranch)==mynnode))
      return refbranch;
    list=list->next;
  }
  return NULL;
}
p_branch
adms_module_list_branch_prepend_by_id (p_module mymymodule,p_module mymodule,p_node mypnode,p_node mynnode)
{
  p_branch refbranch=adms_branch_new(mymodule,mypnode,mynnode);
  adms_slist_push(&adms_module_valueof_branch(mymymodule),adms_adms(refbranch));
  return refbranch;
}
p_branch
adms_module_list_branch_prepend_by_id_once_or_ignore (p_module mymymodule,p_module mymodule,p_node mypnode,p_node mynnode)
{
  p_slist list=adms_module_valueof_branch(mymymodule);
  p_branch refbranch=adms_branch_new(mymodule,mypnode,mynnode);
  while(list)
  {
    if(!adms_branch_cmp(adms_branch(list->data),refbranch))
    {
      adms_branch_free (refbranch);
      return adms_branch(list->data);
    }
    list=list->next;
  }
  adms_slist_push(&adms_module_valueof_branch(mymymodule),adms_adms(refbranch));
  return refbranch;
}
void
adms_module_list_branch_prepend_once_or_ignore (p_module mymymodule,p_branch mybranch)
{
  p_slist list=adms_module_valueof_branch(mymymodule);
  while(list)
  {
    if(!adms_branch_cmp(adms_branch(list->data),mybranch))
      return;
    list=list->next;
  }
  adms_slist_push(&adms_module_valueof_branch(mymymodule),adms_adms(mybranch));
}

inline void
adms_module_valueto_jacobian (p_module mymodule,p_slist _jacobian)
{
  mymodule->_jacobian=_jacobian;
  mymodule->_jacobian_isdefault=0;
}
p_jacobian
adms_module_list_jacobian_lookup_by_id (p_module mymymodule,p_module mymodule,p_node myrow,p_node mycolumn)
{
  p_slist list=adms_module_valueof_jacobian(mymymodule);
  while(list) {
    p_jacobian refjacobian=adms_jacobian(list->data);
    if((adms_jacobian_valueof_module(refjacobian)==mymodule)&&
       (adms_jacobian_valueof_row(refjacobian)==myrow)&&
       (adms_jacobian_valueof_column(refjacobian)==mycolumn))
      return refjacobian;
    list=list->next;
  }
  return NULL;
}
p_jacobian
adms_module_list_jacobian_prepend_by_id (p_module mymymodule,p_module mymodule,p_node myrow,p_node mycolumn)
{
  p_jacobian refjacobian=adms_jacobian_new(mymodule,myrow,mycolumn);
  adms_slist_push(&adms_module_valueof_jacobian(mymymodule),adms_adms(refjacobian));
  return refjacobian;
}
p_jacobian
adms_module_list_jacobian_prepend_by_id_once_or_ignore (p_module mymymodule,p_module mymodule,p_node myrow,p_node mycolumn)
{
  p_slist list=adms_module_valueof_jacobian(mymymodule);
  p_jacobian refjacobian=adms_jacobian_new(mymodule,myrow,mycolumn);
  while(list)
  {
    if(!adms_jacobian_cmp(adms_jacobian(list->data),refjacobian))
    {
      adms_jacobian_free (refjacobian);
      return adms_jacobian(list->data);
    }
    list=list->next;
  }
  adms_slist_push(&adms_module_valueof_jacobian(mymymodule),adms_adms(refjacobian));
  return refjacobian;
}
void
adms_module_list_jacobian_prepend_once_or_ignore (p_module mymymodule,p_jacobian myjacobian)
{
  p_slist list=adms_module_valueof_jacobian(mymymodule);
  while(list)
  {
    if(!adms_jacobian_cmp(adms_jacobian(list->data),myjacobian))
      return;
    list=list->next;
  }
  adms_slist_push(&adms_module_valueof_jacobian(mymymodule),adms_adms(myjacobian));
}

inline void
adms_module_valueto_probe (p_module mymodule,p_slist _probe)
{
  mymodule->_probe=_probe;
  mymodule->_probe_isdefault=0;
}
p_probe
adms_module_list_probe_lookup_by_id (p_module mymymodule,p_module mymodule,p_branch mybranch,p_nature mynature)
{
  p_slist list=adms_module_valueof_probe(mymymodule);
  while(list) {
    p_probe refprobe=adms_probe(list->data);
    if((adms_probe_valueof_module(refprobe)==mymodule)&&
       (adms_probe_valueof_branch(refprobe)==mybranch)&&
       (adms_probe_valueof_nature(refprobe)==mynature))
      return refprobe;
    list=list->next;
  }
  return NULL;
}
p_probe
adms_module_list_probe_prepend_by_id (p_module mymymodule,p_module mymodule,p_branch mybranch,p_nature mynature)
{
  p_probe refprobe=adms_probe_new(mymodule,mybranch,mynature);
  adms_slist_push(&adms_module_valueof_probe(mymymodule),adms_adms(refprobe));
  return refprobe;
}
p_probe
adms_module_list_probe_prepend_by_id_once_or_ignore (p_module mymymodule,p_module mymodule,p_branch mybranch,p_nature mynature)
{
  p_slist list=adms_module_valueof_probe(mymymodule);
  p_probe refprobe=adms_probe_new(mymodule,mybranch,mynature);
  while(list)
  {
    if(!adms_probe_cmp(adms_probe(list->data),refprobe))
    {
      adms_probe_free (refprobe);
      return adms_probe(list->data);
    }
    list=list->next;
  }
  adms_slist_push(&adms_module_valueof_probe(mymymodule),adms_adms(refprobe));
  return refprobe;
}
void
adms_module_list_probe_prepend_once_or_ignore (p_module mymymodule,p_probe myprobe)
{
  p_slist list=adms_module_valueof_probe(mymymodule);
  while(list)
  {
    if(!adms_probe_cmp(adms_probe(list->data),myprobe))
      return;
    list=list->next;
  }
  adms_slist_push(&adms_module_valueof_probe(mymymodule),adms_adms(myprobe));
}

inline void
adms_module_valueto_source (p_module mymodule,p_slist _source)
{
  mymodule->_source=_source;
  mymodule->_source_isdefault=0;
}
p_source
adms_module_list_source_lookup_by_id (p_module mymymodule,p_module mymodule,p_branch mybranch,p_nature mynature)
{
  p_slist list=adms_module_valueof_source(mymymodule);
  while(list) {
    p_source refsource=adms_source(list->data);
    if((adms_source_valueof_module(refsource)==mymodule)&&
       (adms_source_valueof_branch(refsource)==mybranch)&&
       (adms_source_valueof_nature(refsource)==mynature))
      return refsource;
    list=list->next;
  }
  return NULL;
}
p_source
adms_module_list_source_prepend_by_id (p_module mymymodule,p_module mymodule,p_branch mybranch,p_nature mynature)
{
  p_source refsource=adms_source_new(mymodule,mybranch,mynature);
  adms_slist_push(&adms_module_valueof_source(mymymodule),adms_adms(refsource));
  return refsource;
}
p_source
adms_module_list_source_prepend_by_id_once_or_ignore (p_module mymymodule,p_module mymodule,p_branch mybranch,p_nature mynature)
{
  p_slist list=adms_module_valueof_source(mymymodule);
  p_source refsource=adms_source_new(mymodule,mybranch,mynature);
  while(list)
  {
    if(!adms_source_cmp(adms_source(list->data),refsource))
    {
      adms_source_free (refsource);
      return adms_source(list->data);
    }
    list=list->next;
  }
  adms_slist_push(&adms_module_valueof_source(mymymodule),adms_adms(refsource));
  return refsource;
}
void
adms_module_list_source_prepend_once_or_ignore (p_module mymymodule,p_source mysource)
{
  p_slist list=adms_module_valueof_source(mymymodule);
  while(list)
  {
    if(!adms_source_cmp(adms_source(list->data),mysource))
      return;
    list=list->next;
  }
  adms_slist_push(&adms_module_valueof_source(mymymodule),adms_adms(mysource));
}

inline void
adms_module_valueto_instance (p_module mymodule,p_slist _instance)
{
  mymodule->_instance=_instance;
  mymodule->_instance_isdefault=0;
}
p_instance
adms_module_list_instance_lookup_by_id (p_module mymymodule,p_module myinstantiator,p_module mymodule,p_quark myname)
{
  p_slist list=adms_module_valueof_instance(mymymodule);
  while(list) {
    p_instance refinstance=adms_instance(list->data);
    if((adms_instance_valueof_instantiator(refinstance)==myinstantiator)&&
       (adms_instance_valueof_module(refinstance)==mymodule)&&
       !strcmp(adms_instance_valueof_name(refinstance)->_value,myname->_value))
      return refinstance;
    list=list->next;
  }
  return NULL;
}
p_instance
adms_module_list_instance_prepend_by_id (p_module mymymodule,p_module myinstantiator,p_module mymodule,p_quark myname)
{
  p_instance refinstance=adms_instance_new(myinstantiator,mymodule,myname);
  adms_slist_push(&adms_module_valueof_instance(mymymodule),adms_adms(refinstance));
  return refinstance;
}
p_instance
adms_module_list_instance_prepend_by_id_once_or_abort (p_module mymymodule,p_module myinstantiator,p_module mymodule,p_quark myname)
{
  p_slist list=adms_module_valueof_instance(mymymodule);
  p_instance refinstance=adms_instance_new(myinstantiator,mymodule,myname);
  while(list)
  {
    if(!adms_instance_cmp(adms_instance(list->data),refinstance))
    {
      adms_message_fatal(("module=[%s] instance=[%s] already defined\n",
        adms_module_uid(mymymodule),adms_instance_uid(refinstance)))
      adms_instance_free (refinstance);
    }
    list=list->next;
  }
  adms_slist_push(&adms_module_valueof_instance(mymymodule),adms_adms(refinstance));
  return refinstance;
}
void
adms_module_list_instance_prepend_once_or_abort (p_module mymymodule,p_instance myinstance)
{
  p_slist list=adms_module_valueof_instance(mymymodule);
  while(list)
  {
    if(!adms_instance_cmp(adms_instance(list->data),myinstance))
    {
      adms_message_fatal(("module=[%s] instance=[%s] already defined\n",
        adms_module_uid(mymymodule),adms_instance_uid(myinstance)))
      return;
    }
    list=list->next;
  }
  adms_slist_push(&adms_module_valueof_instance(mymymodule),adms_adms(myinstance));
}

inline void
adms_module_valueto_instantiator (p_module mymodule,p_slist _instantiator)
{
  mymodule->_instantiator=_instantiator;
  mymodule->_instantiator_isdefault=0;
}
p_module
adms_module_list_instantiator_lookup_by_id (p_module mymymodule,p_quark myname)
{
  p_slist list=adms_module_valueof_instantiator(mymymodule);
  while(list) {
    p_module refmodule=adms_module(list->data);
    if(!strcmp(adms_module_valueof_name(refmodule)->_value,myname->_value))
      return refmodule;
    list=list->next;
  }
  return NULL;
}
p_module
adms_module_list_instantiator_prepend_by_id (p_module mymymodule,p_quark myname)
{
  p_module refinstantiator=adms_module_new(myname);
  adms_slist_push(&adms_module_valueof_instantiator(mymymodule),adms_adms(refinstantiator));
  return refinstantiator;
}
p_module
adms_module_list_instantiator_prepend_by_id_once_or_abort (p_module mymymodule,p_quark myname)
{
  p_slist list=adms_module_valueof_instantiator(mymymodule);
  p_module refinstantiator=adms_module_new(myname);
  while(list)
  {
    if(!adms_module_cmp(adms_module(list->data),refinstantiator))
    {
      adms_message_fatal(("module=[%s] instantiator=[%s] already defined\n",
        adms_module_uid(mymymodule),adms_module_uid(refinstantiator)))
      adms_module_free (refinstantiator);
    }
    list=list->next;
  }
  adms_slist_push(&adms_module_valueof_instantiator(mymymodule),adms_adms(refinstantiator));
  return refinstantiator;
}
void
adms_module_list_instantiator_prepend_once_or_abort (p_module mymymodule,p_module myinstantiator)
{
  p_slist list=adms_module_valueof_instantiator(mymymodule);
  while(list)
  {
    if(!adms_module_cmp(adms_module(list->data),myinstantiator))
    {
      adms_message_fatal(("module=[%s] instantiator=[%s] already defined\n",
        adms_module_uid(mymymodule),adms_module_uid(myinstantiator)))
      return;
    }
    list=list->next;
  }
  adms_slist_push(&adms_module_valueof_instantiator(mymymodule),adms_adms(myinstantiator));
}

inline void
adms_module_valueto_branchalias (p_module mymodule,p_slist _branchalias)
{
  mymodule->_branchalias=_branchalias;
  mymodule->_branchalias_isdefault=0;
}
p_branchalias
adms_module_list_branchalias_lookup_by_id (p_module mymymodule,p_module mymodule,p_quark myname)
{
  p_slist list=adms_module_valueof_branchalias(mymymodule);
  while(list) {
    p_branchalias refbranchalias=adms_branchalias(list->data);
    if((adms_branchalias_valueof_module(refbranchalias)==mymodule)&&
       !strcmp(adms_branchalias_valueof_name(refbranchalias)->_value,myname->_value))
      return refbranchalias;
    list=list->next;
  }
  return NULL;
}
p_branchalias
adms_module_list_branchalias_prepend_by_id (p_module mymymodule,p_module mymodule,p_quark myname)
{
  p_branchalias refbranchalias=adms_branchalias_new(mymodule,myname);
  adms_slist_push(&adms_module_valueof_branchalias(mymymodule),adms_adms(refbranchalias));
  return refbranchalias;
}
p_branchalias
adms_module_list_branchalias_prepend_by_id_once_or_abort (p_module mymymodule,p_module mymodule,p_quark myname)
{
  p_slist list=adms_module_valueof_branchalias(mymymodule);
  p_branchalias refbranchalias=adms_branchalias_new(mymodule,myname);
  while(list)
  {
    if(!adms_branchalias_cmp(adms_branchalias(list->data),refbranchalias))
    {
      adms_message_fatal(("module=[%s] branchalias=[%s] already defined\n",
        adms_module_uid(mymymodule),adms_branchalias_uid(refbranchalias)))
      adms_branchalias_free (refbranchalias);
    }
    list=list->next;
  }
  adms_slist_push(&adms_module_valueof_branchalias(mymymodule),adms_adms(refbranchalias));
  return refbranchalias;
}
void
adms_module_list_branchalias_prepend_once_or_abort (p_module mymymodule,p_branchalias mybranchalias)
{
  p_slist list=adms_module_valueof_branchalias(mymymodule);
  while(list)
  {
    if(!adms_branchalias_cmp(adms_branchalias(list->data),mybranchalias))
    {
      adms_message_fatal(("module=[%s] branchalias=[%s] already defined\n",
        adms_module_uid(mymymodule),adms_branchalias_uid(mybranchalias)))
      return;
    }
    list=list->next;
  }
  adms_slist_push(&adms_module_valueof_branchalias(mymymodule),adms_adms(mybranchalias));
}

inline void
adms_module_valueto_range (p_module mymodule,p_slist _range)
{
  mymodule->_range=_range;
  mymodule->_range_isdefault=0;
}
p_range
adms_module_list_range_lookup_by_id (p_module mymymodule,p_module mymodule,p_expression myinfexpr,p_expression mysupexpr)
{
  p_slist list=adms_module_valueof_range(mymymodule);
  while(list) {
    p_range refrange=adms_range(list->data);
    if((adms_range_valueof_module(refrange)==mymodule)&&
       (adms_range_valueof_infexpr(refrange)==myinfexpr)&&
       (adms_range_valueof_supexpr(refrange)==mysupexpr))
      return refrange;
    list=list->next;
  }
  return NULL;
}
p_range
adms_module_list_range_prepend_by_id (p_module mymymodule,p_module mymodule,p_expression myinfexpr,p_expression mysupexpr)
{
  p_range refrange=adms_range_new(mymodule,myinfexpr,mysupexpr);
  adms_slist_push(&adms_module_valueof_range(mymymodule),adms_adms(refrange));
  return refrange;
}
p_range
adms_module_list_range_prepend_by_id_once_or_abort (p_module mymymodule,p_module mymodule,p_expression myinfexpr,p_expression mysupexpr)
{
  p_slist list=adms_module_valueof_range(mymymodule);
  p_range refrange=adms_range_new(mymodule,myinfexpr,mysupexpr);
  while(list)
  {
    if(!adms_range_cmp(adms_range(list->data),refrange))
    {
      adms_message_fatal(("module=[%s] range=[%s] already defined\n",
        adms_module_uid(mymymodule),adms_range_uid(refrange)))
      adms_range_free (refrange);
    }
    list=list->next;
  }
  adms_slist_push(&adms_module_valueof_range(mymymodule),adms_adms(refrange));
  return refrange;
}
void
adms_module_list_range_prepend_once_or_abort (p_module mymymodule,p_range myrange)
{
  p_slist list=adms_module_valueof_range(mymymodule);
  while(list)
  {
    if(!adms_range_cmp(adms_range(list->data),myrange))
    {
      adms_message_fatal(("module=[%s] range=[%s] already defined\n",
        adms_module_uid(mymymodule),adms_range_uid(myrange)))
      return;
    }
    list=list->next;
  }
  adms_slist_push(&adms_module_valueof_range(mymymodule),adms_adms(myrange));
}

inline void
adms_module_valueto_nodealias (p_module mymodule,p_slist _nodealias)
{
  mymodule->_nodealias=_nodealias;
  mymodule->_nodealias_isdefault=0;
}
p_nodealias
adms_module_list_nodealias_lookup_by_id (p_module mymymodule,p_module mymodule,p_quark myname)
{
  p_slist list=adms_module_valueof_nodealias(mymymodule);
  while(list) {
    p_nodealias refnodealias=adms_nodealias(list->data);
    if((adms_nodealias_valueof_module(refnodealias)==mymodule)&&
       !strcmp(adms_nodealias_valueof_name(refnodealias)->_value,myname->_value))
      return refnodealias;
    list=list->next;
  }
  return NULL;
}
p_nodealias
adms_module_list_nodealias_prepend_by_id (p_module mymymodule,p_module mymodule,p_quark myname)
{
  p_nodealias refnodealias=adms_nodealias_new(mymodule,myname);
  adms_slist_push(&adms_module_valueof_nodealias(mymymodule),adms_adms(refnodealias));
  return refnodealias;
}
p_nodealias
adms_module_list_nodealias_prepend_by_id_once_or_abort (p_module mymymodule,p_module mymodule,p_quark myname)
{
  p_slist list=adms_module_valueof_nodealias(mymymodule);
  p_nodealias refnodealias=adms_nodealias_new(mymodule,myname);
  while(list)
  {
    if(!adms_nodealias_cmp(adms_nodealias(list->data),refnodealias))
    {
      adms_message_fatal(("module=[%s] nodealias=[%s] already defined\n",
        adms_module_uid(mymymodule),adms_nodealias_uid(refnodealias)))
      adms_nodealias_free (refnodealias);
    }
    list=list->next;
  }
  adms_slist_push(&adms_module_valueof_nodealias(mymymodule),adms_adms(refnodealias));
  return refnodealias;
}
void
adms_module_list_nodealias_prepend_once_or_abort (p_module mymymodule,p_nodealias mynodealias)
{
  p_slist list=adms_module_valueof_nodealias(mymymodule);
  while(list)
  {
    if(!adms_nodealias_cmp(adms_nodealias(list->data),mynodealias))
    {
      adms_message_fatal(("module=[%s] nodealias=[%s] already defined\n",
        adms_module_uid(mymymodule),adms_nodealias_uid(mynodealias)))
      return;
    }
    list=list->next;
  }
  adms_slist_push(&adms_module_valueof_nodealias(mymymodule),adms_adms(mynodealias));
}

inline void
adms_module_valueto_variable (p_module mymodule,p_slist _variable)
{
  mymodule->_variable=_variable;
  mymodule->_variable_isdefault=0;
}
p_variable
adms_module_list_variable_lookup_by_id (p_module mymymodule,p_module mymodule,p_quark myname,p_adms myblock)
{
  p_slist list=adms_module_valueof_variable(mymymodule);
  while(list) {
    p_variable refvariable=adms_variable(list->data);
    if((adms_variable_valueof_module(refvariable)==mymodule)&&
       !strcmp(adms_variable_valueof_name(refvariable)->_value,myname->_value)&&
       (adms_variable_valueof_block(refvariable)==myblock))
      return refvariable;
    list=list->next;
  }
  return NULL;
}
p_variable
adms_module_list_variable_prepend_by_id (p_module mymymodule,p_module mymodule,p_quark myname,p_adms myblock)
{
  p_variable refvariable=adms_variable_new(mymodule,myname,myblock);
  adms_slist_push(&adms_module_valueof_variable(mymymodule),adms_adms(refvariable));
  return refvariable;
}
p_variable
adms_module_list_variable_prepend_by_id_once_or_abort (p_module mymymodule,p_module mymodule,p_quark myname,p_adms myblock)
{
  p_slist list=adms_module_valueof_variable(mymymodule);
  p_variable refvariable=adms_variable_new(mymodule,myname,myblock);
  while(list)
  {
    if(!adms_variable_cmp(adms_variable(list->data),refvariable))
    {
      adms_message_fatal(("module=[%s] variable=[%s] already defined\n",
        adms_module_uid(mymymodule),adms_variable_uid(refvariable)))
      adms_variable_free (refvariable);
    }
    list=list->next;
  }
  adms_slist_push(&adms_module_valueof_variable(mymymodule),adms_adms(refvariable));
  return refvariable;
}
void
adms_module_list_variable_prepend_once_or_abort (p_module mymymodule,p_variable myvariable)
{
  p_slist list=adms_module_valueof_variable(mymymodule);
  while(list)
  {
    if(!adms_variable_cmp(adms_variable(list->data),myvariable))
    {
      adms_message_fatal(("module=[%s] variable=[%s] already defined\n",
        adms_module_uid(mymymodule),adms_variable_uid(myvariable)))
      return;
    }
    list=list->next;
  }
  adms_slist_push(&adms_module_valueof_variable(mymymodule),adms_adms(myvariable));
}

inline void
adms_module_valueto_analogfunction (p_module mymodule,p_slist _analogfunction)
{
  mymodule->_analogfunction=_analogfunction;
  mymodule->_analogfunction_isdefault=0;
}
p_analogfunction
adms_module_list_analogfunction_lookup_by_id (p_module mymymodule,p_module mymodule,p_quark myname)
{
  p_slist list=adms_module_valueof_analogfunction(mymymodule);
  while(list) {
    p_analogfunction refanalogfunction=adms_analogfunction(list->data);
    if((adms_analogfunction_valueof_module(refanalogfunction)==mymodule)&&
       !strcmp(adms_analogfunction_valueof_name(refanalogfunction)->_value,myname->_value))
      return refanalogfunction;
    list=list->next;
  }
  return NULL;
}
p_analogfunction
adms_module_list_analogfunction_prepend_by_id (p_module mymymodule,p_module mymodule,p_quark myname)
{
  p_analogfunction refanalogfunction=adms_analogfunction_new(mymodule,myname);
  adms_slist_push(&adms_module_valueof_analogfunction(mymymodule),adms_adms(refanalogfunction));
  return refanalogfunction;
}
p_analogfunction
adms_module_list_analogfunction_prepend_by_id_once_or_abort (p_module mymymodule,p_module mymodule,p_quark myname)
{
  p_slist list=adms_module_valueof_analogfunction(mymymodule);
  p_analogfunction refanalogfunction=adms_analogfunction_new(mymodule,myname);
  while(list)
  {
    if(!adms_analogfunction_cmp(adms_analogfunction(list->data),refanalogfunction))
    {
      adms_message_fatal(("module=[%s] analogfunction=[%s] already defined\n",
        adms_module_uid(mymymodule),adms_analogfunction_uid(refanalogfunction)))
      adms_analogfunction_free (refanalogfunction);
    }
    list=list->next;
  }
  adms_slist_push(&adms_module_valueof_analogfunction(mymymodule),adms_adms(refanalogfunction));
  return refanalogfunction;
}
void
adms_module_list_analogfunction_prepend_once_or_abort (p_module mymymodule,p_analogfunction myanalogfunction)
{
  p_slist list=adms_module_valueof_analogfunction(mymymodule);
  while(list)
  {
    if(!adms_analogfunction_cmp(adms_analogfunction(list->data),myanalogfunction))
    {
      adms_message_fatal(("module=[%s] analogfunction=[%s] already defined\n",
        adms_module_uid(mymymodule),adms_analogfunction_uid(myanalogfunction)))
      return;
    }
    list=list->next;
  }
  adms_slist_push(&adms_module_valueof_analogfunction(mymymodule),adms_adms(myanalogfunction));
}

inline void
adms_module_valueto_attribute (p_module mymodule,p_slist _attribute)
{
  mymodule->_attribute=_attribute;
  mymodule->_attribute_isdefault=0;
}
p_attribute
adms_module_list_attribute_lookup_by_id (p_module mymymodule,p_quark myname)
{
  p_slist list=adms_module_valueof_attribute(mymymodule);
  while(list) {
    p_attribute refattribute=adms_attribute(list->data);
    if(!strcmp(adms_attribute_valueof_name(refattribute)->_value,myname->_value))
      return refattribute;
    list=list->next;
  }
  return NULL;
}
p_attribute
adms_module_list_attribute_prepend_by_id (p_module mymymodule,p_quark myname)
{
  p_attribute refattribute=adms_attribute_new(myname);
  adms_slist_push(&adms_module_valueof_attribute(mymymodule),adms_adms(refattribute));
  return refattribute;
}
p_attribute
adms_module_list_attribute_prepend_by_id_once_or_ignore (p_module mymymodule,p_quark myname)
{
  p_attribute refattribute=adms_attribute_new(myname);
  adms_slist_push(&adms_module_valueof_attribute(mymymodule),adms_adms(refattribute));
  return refattribute;
}
void
adms_module_list_attribute_prepend (p_module mymymodule,p_attribute myattribute)
{
  adms_slist_push(&adms_module_valueof_attribute(mymymodule),adms_adms(myattribute));
}
