/*
 * RCS Info
 * $Id: fileMain.c 537 2007-03-01 14:10:34Z r29173 $
 * 
 * Log
 * $Log$
 * Revision 1.25  2006/09/13 16:13:20  r29173
 * started migration to www.antlr.org tools
 *
 * Revision 1.24  2006/08/10 11:31:47  r29173
 * did lot of simplifications
 *
 * Revision 1.23  2006/08/04 17:15:31  r29173
 * rearranged code partionning into files
 *
 * Revision 1.22  2006/08/02 16:45:53  r29173
 * rearranged code partionning into files
 *
 * Revision 1.21  2006/06/16 12:24:25  r29173
 * ton of changes: memory clean-up
 *
 * Revision 1.20  2005/11/01 14:11:14  r29173
 * fixed spelling
 *
 * Revision 1.19  2005/06/17 16:44:27  r29173
 * debug memory allocation with valgrind
 *
 * Revision 1.18  2005/05/09 14:38:30  r29173
 * cleaned-up source directory structure
 *
 * Revision 1.17  2005/05/03 09:35:15  r29173
 * cleaned-up header file dependencies
 *
 * Revision 1.16  2005/05/03 07:58:20  r29173
 * moved admsNS into admsFile
 *
 * Revision 1.15  2005/04/21 07:54:49  r29173
 * removed some usages of adms_strconcat
 *
 * Revision 1.14  2005/03/23 13:38:33  r29173
 * migration to adms-2.x.x: added xpath parser
 *
 * Revision 1.13  2005/01/11 09:58:00  r29173
 * tons of changes - simplify accessor names (valueof, valueto)
 *
 * Revision 1.12  2004/11/19 12:27:50  r29173
 * improved parsing of command line
 *
 * Revision 1.11  2004/11/10 13:32:22  r29173
 * did minor clean-up
 *
 * Revision 1.10  2004/11/01 09:37:37  r29173
 * changed messaging macros (avoid useless computation of arguments)
 * improved the coding of transforms in xmlProgram.c
 *
 * Revision 1.9  2004/10/27 16:11:39  r29173
 * release 1.37.0
 * tons of changes - modify the way settors and gettors are built
 * from adms.xml in order to simplify admsProgram.c
 * added zspice to testbench
 * spectre/ads/mica/zspice/simkit passed
 *
 * Revision 1.8  2004/10/20 15:33:51  r29173
 * tons of changes
 * 1- introduced element whileloop (marat)
 * 2- reshaped the handling of the messaging system
 * 3- fixed bug in admsCheck/Makefile.am
 * 4- started implementation of implicit adms transforms
 *
 * Revision 1.7  2004/10/13 15:24:13  r29173
 * preprocess xml files passed to admsXml with adms_file_unixify
 *
 * Revision 1.6  2004/09/23 16:20:48  r29173
 * create automatically standard vams files when missing.
 *
 * Revision 1.5  2004/09/07 07:38:46  r29173
 * cleaned-up the messaging system
 *
 * Revision 1.4  2004/08/19 16:43:13  r29173
 * cleaned-up i/o file handling
 *
 * Revision 1.3  2004/08/16 10:52:29  r29173
 * changed handling of adms_message_verbose (created adms_message_debug)
 *
 * Revision 1.2  2004/08/14 17:01:02  marat_yakupov
 * Added default -I /install_dir/include to admsXml
 *
 * Revision 1.1  2004/08/03 12:33:54  r29173
 * import adms-1.21.0 from local CVS
 *
 * Revision 1.2  2004/05/26 13:02:48  r29173
 * added default values to all enumerations
 *
 * Revision 1.1.1.1  2004/05/21 12:20:01  r29173
 * recreated cvs data structure (crashed after revision 1.13.0!)
 *
 * Revision 1.7  2004/03/08 20:47:48  r29173
 * removed admsbegin/admsend constructs
 *
 * Revision 1.6  2004/03/08 13:58:05  r29173
 * all code lower-cased
 *
 * Revision 1.5  2004/02/19 17:02:38  r29173
 * started implementing code builder in yacc parser
 *
 * Revision 1.4  2004/02/13 14:28:40  r29173
 * started implementing code builder in yacc parser
 *
 * Revision 1.3  2004/02/10 10:48:25  r29173
 * started implementing code builder in yacc parser
 *
 * Revision 1.2  2004/01/13 11:26:15  r29173
 * added adms_message_usage
 *
 * Revision 1.1  2004/01/09 16:26:45  r29173
 * cleaned-up use of #include
 *
 * Revision 1.10  2004/01/06 12:35:10  r29173
 * fixed the use of globals: input file and output file
 *
 * Revision 1.9  2004/01/05 11:40:29  r29173
 * removed unused code
 *
 * Revision 1.8  2003/12/12 15:08:34  r29173
 * changed construct (a==NULL) to (!a)
 *
 * Revision 1.7  2003/12/12 14:43:37  r29173
 * changed construct (a==NULL) to (!a)
 *
 * Revision 1.6  2003/12/12 14:33:26  r29173
 * changed construct (a!=NULL) into (a) or (a)?1:0
 *
 * Revision 1.5  2003/12/11 20:14:08  r29173
 * cleaned-up after compilation with CFLAG+=-Wall
 *
 * Revision 1.4  2003/12/11 16:01:53  r29173
 * changed prefix [epst]_adms_ to [epst]_
 *
 * Revision 1.3  2003/11/06 12:45:08  r29173
 * tried to improve/fixed setting of nodes/variables/expressions units
 * NOTE: v-1.1.16 of SPevaluate.include differs from v-1.1.15
 *
 * Revision 1.2  2003/05/21 14:18:01  r29173
 * add rcs info
 *
 */

#include <admsFile/admsFile.h>
#include <admsObject/admsC.h>

FILE* adms_file_output;
void adms_file_setfile_output (FILE* ofh)
{
  adms_file_output=ofh;
}
void adms_file_close_output(void)
{
  adms_message_verbose(("closing output file\n"))
  fclose(adms_file_output);
}
int adms_file_filehandling_print(const char* str)
{
  fputs(str,adms_file_output);
  fflush(adms_file_output);
  return 0;
}

static inline FILE* adms_file_open (const char *myfilename,const char *mypermissions)
{
  adms_message_verbose(("open file '%s' [mode %s]\n",myfilename,mypermissions))
  return fopen(myfilename,mypermissions);
}
FILE* adms_file_open_read (const char *myfilename)
{
  FILE* fh=adms_file_open(myfilename,"r");
  if(!fh)
    adms_message_fatal(("%s: failed to open file [reading mode]\n",myfilename))
  return fh;
}
FILE* adms_file_open_read_with_path (const char *myfilename, p_slist mypath)
{
  FILE* myfh=NULL;
  p_slist l; for(l=mypath;l;l=l->next)
  {
    char* mypathname=strdup((char*)(l->data));
    adms_strconcat2(&mypathname,ADMS_PATH_SEPARATOR);
    adms_strconcat2(&mypathname,myfilename);
    if((myfh=adms_file_open(mypathname,"r")))
      return myfh;
  }
  return NULL;
}
FILE* adms_file_open_write (const char *myfilename)
{
  FILE* fh=adms_file_open(myfilename,"wb");
  if(!fh)
    adms_message_fatal(("failed to open file [write mode]\n",myfilename))
  return fh;
}

