/* File automatically created by ../scripts/text2Ccode.pl*/

const char * VBICSELFT_va = ""
"\n"
"//\n"
"//	Verilog-A definition of VBIC\n"
"//\n"
"//	Version:	1.2\n"
"//	Revision:	1.1\n"
"//\n"
"//	 1. Functions redefined to work properly in Verilog-A, previously\n"
"//	    they were substituted by special code to generate .va files\n"
"//	    without function calls.\n"
"//	 2. Noise declarations added, consistent with 1.1.5 version.\n"
"//	 3. qb and qbp calculations protected from having argument of the\n"
"//	    square-root go less than zero (this required very unusual\n"
"//	    conditions and parameters to occur, and needless to say\n"
"//	    this happened some times).\n"
"//	 4. Parameter names changed to lower case, this is what they are\n"
"//	    in simulator implementations.\n"
"//	 5. log mapped to ln, this was done in generated code, but in\n"
"//	    Verilog-A log is log_10, not log_e.\n"
"//	 6. The avalanche function was modified to protect against\n"
"//	    numerical problems for forward and low reverse bias.\n"
"//	 7. Hard limits on the local temperature were added. This is\n"
"//	    required to avoid numerical problems.\n"
"//	 8. The excess phase network has been defined in a simpler\n"
"//	    manner, but is exactly equivalent to the previous version.\n"
"//	    It is now done without an inductor. This is the transformation:\n"
"//	    Itzf-V(xf2)-j*w*C*V(xf1)=0\n"
"//	    j*w*L*V(xf2)+V(xf2)-V(xf1)=0\n"
"//	    where C=TD and L=TD/3 is what was done.\n"
"//	    Itzf=V(xf2)+j*w*TD*V(xf1)\n"
"//	    V(xf1)=j*w*(TD/3)*V(xf2)+V(xf2)\n"
"//	    node xf1: two VCCS (Itzf, V(xf2)) plus TD capacitor\n"
"//	    node xf2: one VCCS (V(xf1)), TD/3 capacitor, 1Ohm resistor\n"
"//	 9. gmin added explicitly\n"
"//	10. pnjmaxi added explicitly, diode type currents linearized\n"
"//	    for values greater than pnjmaxi\n"
"//	11. Fixed implementation of shrink factors\n"
"//\n"
"\n"
"`include \"discipline.h\"\n"
"\n"
"`ifdef insideADMS\n"
"  `define P(prop) (* prop *)\n"
"  `define PGIVEN(p)		$given(p)\n"
"  `define GMIN			$options(\"OPTgmin\")\n"
"  `define PNJMAXI		$options(\"OPTpnjmaxi\")\n"
"  `define SHRINKL		$shrinkl(\"q\")\n"
"  `define SHRINKA		$shrinka(\"q\")\n"
"  `define SCALE			$scale\n"
"  `define DERIVATE(x,y)		$derivate(x,y)\n"
"  `define INITIAL_MODEL		@(initial_model)\n"
"  `define INITIAL_INSTANCE	@(initial_instance)\n"
"  `define FINAL_STEP\n"
"`else\n"
"  `define P(prop)\n"
"  `define PGIVEN(p)		p\n"
"  `define GMIN			gmin\n"
"  `define PNJMAXI		pnjmaxi\n"
"  `define SHRINKL		1.0\n"
"  `define SHRINKA		1.0\n"
"  `define SCALE			1.0\n"
"  `define DERIVATE(x,y)		1.0\n"
"  `define INITIAL_MODEL		@(initial_step(\"op\",\"dc\",\"ac\",\"noise\"))\n"
"  `define INITIAL_INSTANCE	@(initial_step(\"op\",\"dc\",\"ac\",\"noise\"))\n"
"  `define FINAL_STEP		@(final_step)\n"
"`endif\n"
"\n"
"`define	KB	1.380662e-23		// Boltzmann constant (J/K)\n"
"`define	QQ	1.602189e-19		// mag. of electronic charge (C)\n"
"`define	TABS	2.731500e+02		// 0C in K\n"
"\n"
"`define	NPN	+1\n"
"`define	PNP	-1\n"
"\n"
"`define expLinA(expv,V,Vmax,a) \\\n"
"	if (V<Vmax) begin \\\n"
"		mac1	=  V*a; \\\n"
"		expv	=  exp(mac1); \\\n"
"	end else begin \\\n"
"		mac1	=  Vmax*a; \\\n"
"		expl	=  exp(mac1); \\\n"
"		expv	=  expl*(1.0+(V-Vmax)*a); \\\n"
"	end\n"
"`define expLin(expv,V,Vmax) \\\n"
"	if (V<Vmax) \\\n"
"		expv	=  exp(V); \\\n"
"	else begin \\\n"
"		expl	=  exp(Vmax); \\\n"
"		expv	=  expl*(1.0+(V-Vmax)); \\\n"
"	end\n"
"`define psibi(P_T,P,EA,Vtv,rT) \\\n"
"	psiio = 2.0*(Vtv/rT)*ln(exp(0.5*P*rT/Vtv)-exp(-0.5*P*rT/Vtv)); \\\n"
"	psiin = psiio*rT-3.0*Vtv*ln(rT)-EA*(rT-1.0); \\\n"
"	P_T   = psiin+2.0*Vtv*ln(0.5*(1.0+sqrt(1.0+4.0*exp(-psiin/Vtv))));\n"
"`define qj(qj,V,P,M,FC,A) \\\n"
"	dv0   = -P*FC; \\\n"
"	if (A<=0.0) begin \\\n"
"		dvh =  V+dv0; \\\n"
"		if (dvh>0.0) begin \\\n"
"			pwq = pow((1.0-FC),(-1.0-M)); \\\n"
"			qlo = P*(1.0-pwq*(1.0-FC)*(1.0-FC))/(1.0-M); \\\n"
"			qhi = dvh*(1.0-FC+0.5*M*dvh/P)*pwq; \\\n"
"		end else begin \\\n"
"			qlo = P*(1.0-pow((1.0-V/P),(1.0-M)))/(1.0-M); \\\n"
"			qhi = 0.0; \\\n"
"		end \\\n"
"		qj  = qlo+qhi; \\\n"
"	end else begin \\\n"
"		mv0 =  sqrt(dv0*dv0+4*A*A); \\\n"
"		vl0 = -0.5*(dv0+mv0); \\\n"
"		q0  = -P*pow((1.0-vl0/P),(1.0-M))/(1.0-M); \\\n"
"		dv  =  V+dv0; \\\n"
"		mv  =  sqrt(dv*dv+4*A*A); \\\n"
"		vl  =  0.5*(dv-mv)-dv0; \\\n"
"		qlo = -P*pow((1.0-vl/P),(1.0-M))/(1.0-M); \\\n"
"		qj  =  qlo+pow((1.0-FC),(-M))*(V-vl+vl0)-q0; \\\n"
"	end\n"
"`define qjrt(qj,V,P,M,FC,A,VRT,ART) \\\n"
"	dv0   = -P*FC; \\\n"
"	if (A<=0.0) begin \\\n"
"		dvh =  V+dv0; \\\n"
"		if (dvh>0.0) begin \\\n"
"			pwq = pow((1.0-FC),(-1.0-M)); \\\n"
"			qlo = P*(1.0-pwq*(1.0-FC)*(1.0-FC))/(1.0-M); \\\n"
"			qhi = dvh*(1.0-FC+0.5*M*dvh/P)*pwq; \\\n"
"		end else begin \\\n"
"			if ((VRT>0.0)&&(V<-VRT)) begin \\\n"
"				qlo = P*(1.0-pow((1.0+VRT/P),(1.0-M))*(1.0-((1.0-M)*(V+VRT))/(P+VRT)))/(1.0-M); \\\n"
"			end else begin \\\n"
"				qlo = P*(1.0-pow((1.0-V/P),(1.0-M)))/(1.0-M); \\\n"
"			end \\\n"
"			qhi = 0.0; \\\n"
"		end \\\n"
"		qj  = qlo+qhi; \\\n"
"	end else begin \\\n"
"		if ((VRT>0.0)&&(ART>0.0)) begin \\\n"
"			vn0  =  (VRT+dv0)/(VRT-dv0); \\\n"
"			vnl0 =  2.0*vn0/(sqrt((vn0-1.0)*(vn0-1)+4*A*A)+sqrt((vn0+1.0)*(vn0+1)+4*ART*ART)); \\\n"
"			vl0  =  0.5*(vnl0*(VRT-dv0)-VRT-dv0); \\\n"
"			qlo0 =  P*(1.0-pow((1.0-vl0/P),(1.0-M)))/(1.0-M); \\\n"
"			vn   =  (2*V+VRT+dv0)/(VRT-dv0); \\\n"
"			vnl  =  2.0*vn/(sqrt((vn-1.0)*(vn-1)+4*A*A)+sqrt((vn+1.0)*(vn+1)+4*ART*ART)); \\\n"
"			vl   =  0.5*(vnl*(VRT-dv0)-VRT-dv0); \\\n"
"			qlo  =  P*(1.0-pow((1.0-vl/P),(1.0-M)))/(1.0-M); \\\n"
"			sel  =  0.5*(vnl+1.0); \\\n"
"			crt  =  pow((1.0+VRT/P),(-M)); \\\n"
"			cmx  =  pow((1.0+dv0/P),(-M)); \\\n"
"			cl   =  (1.0-sel)*crt+sel*cmx; \\\n"
"			ql   =  (V-vl+vl0)*cl; \\\n"
"			qj   =  ql+qlo-qlo0; \\\n"
"		end else begin \\\n"
"			mv0  =  sqrt(dv0*dv0+4*A*A); \\\n"
"			vl0  = -0.5*(dv0+mv0); \\\n"
"			q0   = -P*pow((1.0-vl0/P),(1.0-M))/(1.0-M); \\\n"
"			dv   =  V+dv0; \\\n"
"			mv   =  sqrt(dv*dv+4*A*A); \\\n"
"			vl   =  0.5*(dv-mv)-dv0; \\\n"
"			qlo  = -P*pow((1.0-vl/P),(1.0-M))/(1.0-M); \\\n"
"			qj   =  qlo+pow((1.0-FC),(-M))*(V-vl+vl0)-q0; \\\n"
"		end \\\n"
"	end\n"
"`define avalm(avalm,V,P,M,AV1,AV2,VmaxExp) \\\n"
"	vminm = pow((0.02*(AV2+1.0)),(1.0/(1.01-M))); \\\n"
"	vl    = 0.5*(sqrt((P-V-vminm)*(P-V-vminm)+0.01)+(P-V-vminm))+vminm; \\\n"
"	mac1  = -AV2*pow(vl,(M-1.0)); \\\n"
"	if (mac1<VmaxExp) \\\n"
"		expi	=  exp(mac1); \\\n"
"	else begin \\\n"
"		expl	=  exp(VmaxExp); \\\n"
"		expi	=  expl*(1.0+(mac1-VmaxExp)); \\\n"
"	end \\\n"
"	avalm = AV1*vl*expi;\n"
"\n"
"//\n"
"//	There are 8 separate versions of VBIC, defined as follows:\n"
"//\n"
"//				#Elect	Electro	Excess\n"
"//		Name		Terms	Thermal	Phase\n"
"//		=============	=======	=======	======\n"
"//		vbic_3T_it_cf	3	no	no\n"
"//		vbic_3T_it_xf	3	no	yes\n"
"//		vbic_3T_et_cf	3	yes	no\n"
"//		vbic_3T_et_xf	3	yes	yes\n"
"//		vbic_4T_it_cf	4	no	no\n"
"//		vbic_4T_it_xf	4	no	yes\n"
"//		vbic_4T_et_cf	4	yes	no\n"
"//		vbic_4T_et_xf	4	yes	yes\n"
"//\n"
"//	These can be selected by appropriate specification of\n"
"//	the following `define text macros. Note that the specification\n"
"//	of a 3- or 4-terminal model relates to the number of\n"
"//	electrical terminals, and does not include the local temperature\n"
"//	node for the electrothermal version of the model.\n"
"//\n"
"//	There are two separate versions of each of the above,\n"
"//	with and without homotopy. When the homotopy is included\n"
"//	this code will not work in Verilog-A, but will be\n"
"//	handled by the VBIC code generator properly.\n"
"//\n"
"\n"
"//`define ThreeTerminal		// default is FourTerminal\n"
"//`define ExcessPhase		// default is ConstantPhase\n"
"//`define ElectroThermal	// default is IsoThermal\n"
"//`define WithHomotopy		// default is NoHomotopy\n"
"\n"
"//\n"
"//	Start of VBIC model code\n"
"//\n"
"\n"
"	////////////////////////////////////////////////////\n"
"	// General Information for Simulator\n"
"	////////////////////////////////////////////////////\n"
"\n"
"`ifdef VERSION\n"
"`else\n"
"  `define VERSION \"unknown\"\n"
"`endif\n"
"\n"
"module VBICSELFT(c,b,e,s)\n"
"  (*\n"
"    version=`VERSION\n"
"    spice:prefix=\"q\"\n"
"    spice:ntype=\"npn\"\n"
"    spice:ptype=\"pnp\"\n"
"    spice:level=\"3\"\n"
"    spice:terminal:min=\"4\"\n"
"    spice:terminal:max=\"4\"\n"
"    description=\"Vertical Bipolar Transistor\"\n"
"    info=\"Level 3 BJT: vbic selft\"\n"
"    mica:isdefault=\"0\"\n"
"  *);\n"
"\n"
"//\n"
"//	Node definitions\n"
"//\n"
"\n"
"	inout		c,b;				// external nodes\n"
"	inout		e,s;				// external nodes\n"
"\n"
"	// external nodes\n"
"	electrical c (*\n"
"		spice:name=\"cnode\"\n"
"		mica:reprint=\"yes\"\n"
"		info=\"external collector node                   \" *);\n"
"	electrical b (*\n"
"		spice:name=\"bnode\"\n"
"		mica:reprint=\"yes\"\n"
"		info=\"external base node                        \" *);\n"
"	electrical e (*\n"
"		spice:name=\"enode\"\n"
"		mica:reprint=\"yes\"\n"
"		info=\"external emitter node                     \" *);\n"
"	electrical s (*\n"
"		spice:name=\"snode\"\n"
"		mica:reprint=\"yes\"\n"
"		info=\"external substrate node                   \" *);\n"
"	// electrothermal node\n"
"	electrical dt (*\n"
"		spice:name=\"dtnode\"\n"
"		info=\"local temperature rise node               \" *);\n"
"	// internal nodes\n"
"	electrical cx (*\n"
"		spice:name=\"cxnode\"\n"
"		info=\"internal extrinsic collector node         \" *);\n"
"	electrical ci (*\n"
"		spice:name=\"cinode\"\n"
"		info=\"internal intrinsic collector node         \" *);\n"
"	electrical bx (*\n"
"		spice:name=\"bxnode\"\n"
"		info=\"internal extrinsic base node              \" *);\n"
"	electrical bi (*\n"
"		spice:name=\"binode\"\n"
"		info=\"internal intrinsic base node              \" *);\n"
"	electrical ei (*\n"
"		spice:name=\"einode\"\n"
"		info=\"internal intrinsic emitter node           \" *);\n"
"	electrical bp (*\n"
"		spice:name=\"bpnode\"\n"
"		info=\"internal parasitic base node              \" *);\n"
"	electrical si (*\n"
"		spice:name=\"sinode\"\n"
"		info=\"internal substrate node                   \" *);\n"
"	electrical xf1 (*\n"
"		spice:name=\"xf1node\"\n"
"		info=\"excess phase node xf1                     \" *);\n"
"	electrical xf2 (*\n"
"		spice:name=\"xf2node\"\n"
"		info=\"excess phase node xf2                     \" *);\n"
"\n"
"//\n"
"//	Branch definitions\n"
"//\n"
"\n"
"	branch (b ,e )		b_be;			//           base-emit\n"
"	branch (b ,c )		b_bc;			//           base-coll\n"
"	branch (bi,ei)		b_bei;			// intrinsic base-emit\n"
"	branch (bx,ei)		b_bex;			// extrinsic base-emit\n"
"	branch (bi,ci)		b_bci;			// intrinsic base-coll\n"
"	branch (bi,cx)		b_bcx;			// extrinsic base-coll\n"
"	branch (ci,ei)		b_cei;			// intrinsic coll-emit\n"
"	branch (ei,ci)		b_eci;			// intrinsic emit-coll\n"
"	branch (bx,bp)		b_bep;			// parasitic base-emit\n"
"	branch (e ,ei)		b_re;			// emit resistance\n"
"	branch (c ,cx)		b_rcx;			// coll resistance, extrinsic\n"
"	branch (cx,ci)		b_rci;			// coll resistance, intrinsic\n"
"	branch (b ,bx)		b_rbx;			// base resistance, extrinsic\n"
"	branch (bx,bi)		b_rbi;			// base resistance, intrinsic\n"
"	branch (bp,cx)		b_rbp;			// base resistance, parasitic\n"
"	branch (si,bp)		b_bcp;			// parasitic base-coll\n"
"	branch (bx,si)		b_cep;			// parasitic coll-emit\n"
"	branch (s ,si)		b_rs;			// subs resistance\n"
"	branch (dt)		b_rth;			// local thermal branch\n"
"	branch (dt)		b_ith;			// local thermal branch\n"
"	branch (xf1)		b_xf1;\n"
"	branch (xf1)		c_xf1;\n"
"	branch (xf2)		b_xf2;\n"
"	branch (xf2)		c_xf2;\n"
"\n"
"//\n"
"//	Parameter definitions\n"
"//\n"
"\n"
"	parameter	real	tnom	=  27.0\n"
"	  `P(info=\"nominal parameter measurement temperature \" unit=\"C\");\n"
"	parameter	real	rcx	=   0.0		from[0.0:inf]\n"
"	  `P(info=\"extrinsic collector resistance            \" unit=\"Ohm\");\n"
"	parameter	real	rci	=   0.0		from[0.0:inf]\n"
"	  `P(info=\"intrinsic collector resistance            \" unit=\"Ohm\");\n"
"	parameter	real	vo	=   0.0		from[0.0:inf]\n"
"	  `P(info=\"epi drift saturation voltage              \" unit=\"V\");\n"
"	parameter	real	gamm	=   0.0		from[0.0:inf]\n"
"	  `P(info=\"epi doping parameter                      \" );\n"
"	parameter	real	hrcf	=   0.0		from[0.0:inf]\n"
"	  `P(info=\"high current collector resistance factor  \" );\n"
"	parameter	real	rbx	=   0.0		from[0.0:inf]\n"
"	  `P(info=\"extrinsic base resistance                 \" unit=\"Ohm\");\n"
"	parameter	real	rbi	=   0.0		from[0.0:inf]\n"
"	  `P(info=\"intrinsic base resistance                 \" unit=\"Ohm\");\n"
"	parameter	real	re	=   0.0		from[0.0:inf]\n"
"	  `P(info=\"extrinsic emitter resistance              \" unit=\"Ohm\");\n"
"	parameter	real	rs	=   0.0		from[0.0:inf]\n"
"	  `P(info=\"extrinsic substrate resistance            \" unit=\"Ohm\");\n"
"	parameter	real	rbp	=   0.0		from[0.0:inf]\n"
"	  `P(info=\"parasitic transistor base resistance      \" unit=\"Ohm\");\n"
"	parameter	real	is	=   1.0e-16	from(0.0:inf]\n"
"	  `P(info=\"transport saturation current              \" unit=\"A\");\n"
"	parameter	real	nf	=   1.0		from(0.0:inf]\n"
"	  `P(info=\"fwd emission coefficient (ideality factor)\" );\n"
"	parameter	real	nr	=   1.0		from(0.0:inf]\n"
"	  `P(info=\"rev emission coefficient (ideality factor)\" );\n"
"	parameter	real	fc	=   0.9		from[0.0:1.0)\n"
"	  `P(info=\"forward bias depletion capacitance limit  \" );\n"
"	parameter	real	cbeo	=   0.0		from[0.0:inf]\n"
"	  `P(info=\"extrinsic b-e overlap capacitance         \" unit=\"F\");\n"
"	parameter	real	cje	=   0.0		from[0.0:inf]\n"
"	  `P(info=\"zero-bias b-e depletion capacitance       \" unit=\"F\");\n"
"	parameter	real	pe	=   0.75	from(0.0:inf]\n"
"	  `P(info=\"b-e built-in potential                    \" unit=\"V\");\n"
"	parameter	real	me	=   0.33	from(0.0:1.0]\n"
"	  `P(info=\"b-e grading coefficient                   \" );\n"
"	parameter	real	aje	=  -0.5\n"
"	  `P(info=\"b-e capacitance smoothing factor          \" );\n"
"	parameter	real	cbco	=   0.0		from[0.0:inf]\n"
"	  `P(info=\"extrinsic b-c overlap capacitance         \" unit=\"F\");\n"
"	parameter	real	cjc	=   0.0		from[0.0:inf]\n"
"	  `P(info=\"zero-bias intrinsic b-c depletion cap     \" unit=\"F\");\n"
"	parameter	real	qco	=   0.0		from[0.0:inf]\n"
"	  `P(info=\"epi charge parameter                      \" unit=\"C\");\n"
"	parameter	real	cjep	=   0.0		from[0.0:inf]\n"
"	  `P(info=\"zero-bias extrinsic b-c depletion cap     \" unit=\"F\");\n"
"	parameter	real	pc	=   0.75	from(0.0:inf]\n"
"	  `P(info=\"b-c built-in potential                    \" unit=\"V\");\n"
"	parameter	real	mc	=   0.33	from(0.0:1.0]\n"
"	  `P(info=\"b-c grading coefficient                   \" );\n"
"	parameter	real	ajc	=  -0.5\n"
"	  `P(info=\"b-c capacitance smoothing factor          \" );\n"
"	parameter	real	cjcp	=   0.0		from[0.0:inf]\n"
"	  `P(info=\"zero-bias c-s depletion capacitance       \" unit=\"F\");\n"
"	parameter	real	ps	=   0.75	from(0.0:inf]\n"
"	  `P(info=\"c-s built-in potential                    \" unit=\"V\");\n"
"	parameter	real	ms	=   0.33	from(0.0:1.0]\n"
"	  `P(info=\"c-s grading coefficient                   \" );\n"
"	parameter	real	ajs	=  -0.5\n"
"	  `P(info=\"c-s capacitance smoothing factor          \" );\n"
"	parameter	real	ibei	=   1.0e-18	from(0.0:inf]\n"
"	  `P(info=\"ideal b-e saturation current              \" unit=\"A\");\n"
"	parameter	real	wbe	=   1.0		from[0.0:1.0]\n"
"	  `P(info=\"partitioning of Ibe/Ibex and Qbe/Qbex     \" );\n"
"	parameter	real	nei	=   1.0		from(0.0:inf]\n"
"	  `P(info=\"ideal b-e emission coefficient            \" );\n"
"	parameter	real	iben	=   0.0		from[0.0:inf]\n"
"	  `P(info=\"non-ideal b-e saturation current          \" unit=\"A\");\n"
"	parameter	real	nen	=   2.0		from(0.0:inf]\n"
"	  `P(info=\"non-ideal b-e emission coefficient        \" );\n"
"	parameter	real	ibci	=   1.0e-16	from(0.0:inf]\n"
"	  `P(info=\"ideal b-c saturation current              \" unit=\"A\");\n"
"	parameter	real	nci	=   1.0		from(0.0:inf]\n"
"	  `P(info=\"ideal b-c emission coefficient            \" );\n"
"	parameter	real	ibcn	=   0.0		from[0.0:inf]\n"
"	  `P(info=\"non-ideal b-c saturation current          \" unit=\"A\");\n"
"	parameter	real	ncn	=   2.0		from(0.0:inf]\n"
"	  `P(info=\"non-ideal b-c emission coefficient        \" );\n"
"	parameter	real	avc1	=   0.0		from[0.0:inf]\n"
"	  `P(info=\"b-c weak avalanche parameter 1            \" unit=\"/V\");\n"
"	parameter	real	avc2	=   0.0		from[0.0:inf]\n"
"	  `P(info=\"b-c weak avalanche parameter 2            \" );\n"
"	parameter	real	isp	=   0.0		from[0.0:inf]\n"
"	  `P(info=\"parasitic transport saturation current    \" unit=\"A\");\n"
"	parameter	real	wsp	=   1.0		from[0.0:1.0]\n"
"	  `P(info=\"partitioning of Iccp between Vbep and Vbci\" );\n"
"	parameter	real	nfp	=   1.0		from(0.0:inf]\n"
"	  `P(info=\"parasitic emission coeff (ideality fctr)  \" );\n"
"	parameter	real	ibeip	=   0.0		from[0.0:inf]\n"
"	  `P(info=\"ideal parasitic b-e saturation current    \" unit=\"A\");\n"
"	parameter	real	ibenp	=   0.0		from[0.0:inf]\n"
"	  `P(info=\"non-ideal parasitic b-e saturation current\" unit=\"A\");\n"
"	parameter	real	ibcip	=   0.0		from[0.0:inf]\n"
"	  `P(info=\"ideal parasitic b-c saturation current    \" unit=\"A\");\n"
"	parameter	real	ncip	=   1.0		from(0.0:inf]\n"
"	  `P(info=\"ideal parasitic b-c emission coefficient  \" );\n"
"	parameter	real	ibcnp	=   0.0		from[0.0:inf]\n"
"	  `P(info=\"non-ideal parasitic b-c saturation current\" unit=\"A\");\n"
"	parameter	real	ncnp	=   2.0		from(0.0:inf]\n"
"	  `P(info=\"non-ideal parasitic b-c emission coeff    \" );\n"
"	parameter	real	vef	=   0.0		from[0.0:inf]\n"
"	  `P(info=\"forward Early voltage (zero=infinite)     \" unit=\"V\");\n"
"	parameter	real	ver	=   0.0		from[0.0:inf]\n"
"	  `P(info=\"reverse Early voltage (zero=infinite)     \" unit=\"V\");\n"
"	parameter	real	ikf	=   0.0		from[0.0:inf]\n"
"	  `P(info=\"forward knee current (zero=infinite)      \" unit=\"A\");\n"
"	parameter	real	ikr	=   0.0		from[0.0:inf]\n"
"	  `P(info=\"reverse knee current (zero=infinite)      \" unit=\"A\");\n"
"	parameter	real	ikp	=   0.0		from[0.0:inf]\n"
"	  `P(info=\"parasitic knee current (zero=infinite)    \" unit=\"A\");\n"
"	parameter	real	tf	=   0.0		from[0.0:inf]\n"
"	  `P(info=\"forward transit time                      \" unit=\"s\");\n"
"	parameter	real	qtf	=   0.0		from[0.0:inf]\n"
"	  `P(info=\"variation of tf with base-width modulation\" );\n"
"	parameter	real	xtf	=   0.0		from[0.0:inf]\n"
"	  `P(info=\"tf bias dependence coefficient            \" );\n"
"	parameter	real	vtf	=   0.0		from[0.0:inf]\n"
"	  `P(info=\"tf coefficient of Vbci dependence         \" unit=\"V\");\n"
"	parameter	real	itf	=   0.0		from[0.0:inf]\n"
"	  `P(info=\"tf coefficient of Ic dependence           \" unit=\"A\");\n"
"	parameter	real	tr	=   0.0		from[0.0:inf]\n"
"	  `P(info=\"reverse transit time                      \" unit=\"s\");\n"
"	parameter	real	td	=   0.0		from[0.0:inf]\n"
"	  `P(info=\"forward excess-phase delay time           \" unit=\"s\");\n"
"	parameter	real	kfn	=   0.0		from[0.0:inf]\n"
"	  `P(info=\"b-e flicker noise constant                \" );\n"
"	parameter	real	afn	=   1.0		from(0.0:inf]\n"
"	  `P(info=\"b-e flicker noise current exponent        \" );\n"
"	parameter	real	bfn	=   1.0		from(0.0:inf]\n"
"	  `P(info=\"b-e flicker noise 1/f dependence          \" );\n"
"	parameter	real	xre	=   0.0\n"
"	  `P(info=\"temperature exponent of re                \" );\n"
"	parameter	real	xrbi	=   0.0\n"
"	  `P(info=\"temperature exponent of rbi               \" );\n"
"	parameter	real	xrci	=   0.0\n"
"	  `P(info=\"temperature exponent of rci               \" );\n"
"	parameter	real	xrs	=   0.0\n"
"	  `P(info=\"temperature exponent of rs                \" );\n"
"	parameter	real	xvo	=   0.0\n"
"	  `P(info=\"temperature exponent of vo                \" );\n"
"	parameter	real	ea	=   1.12\n"
"	  `P(info=\"activation energy for is                  \" unit=\"V\");\n"
"	parameter	real	eaie	=   1.12\n"
"	  `P(info=\"activiation energy for ibei               \" unit=\"V\");\n"
"	parameter	real	eaic	=   1.12\n"
"	  `P(info=\"activiation energy for ibci and ibeip     \" unit=\"V\");\n"
"	parameter	real	eais	=   1.12\n"
"	  `P(info=\"activiation energy for ibcip              \" unit=\"V\");\n"
"	parameter	real	eane	=   1.12\n"
"	  `P(info=\"activiation energy for iben               \" unit=\"V\");\n"
"	parameter	real	eanc	=   1.12\n"
"	  `P(info=\"activiation energy for ibcn and ibenp     \" unit=\"V\");\n"
"	parameter	real	eans	=   1.12\n"
"	  `P(info=\"activiation energy for ibcnp              \" unit=\"V\");\n"
"	parameter	real	xis	=   3.0\n"
"	  `P(info=\"temperature exponent of is                \" );\n"
"	parameter	real	xii	=   3.0\n"
"	  `P(info=\"temp exponent of ibei, ibci, ibeip, ibcip \" );\n"
"	parameter	real	xin	=   3.0\n"
"	  `P(info=\"temp exponent of iben, ibcn, ibenp, ibcnp \" );\n"
"	parameter	real	tnf	=   0.0\n"
"	  `P(info=\"temperature exponent of nf and nr         \" unit=\"/C\");\n"
"	parameter	real	tavc	=   0.0\n"
"	  `P(info=\"temperature exponent of avc2              \" unit=\"/C\");\n"
"	parameter	real	rth	=   0.0		from[0.0:inf]\n"
"	  `P(info=\"thermal resistance                        \" unit=\"C/W\");\n"
"	parameter	real	cth	=   0.0		from[0.0:inf]\n"
"	  `P(info=\"thermal capacitance                       \" unit=\"J/C\");\n"
"	parameter	real	vrt	=   0.0		from[0.0:inf]\n"
"	  `P(info=\"reach-through voltage for Cbc limiting    \" unit=\"V\");\n"
"	parameter	real	art	=   0.1		from(0.0:inf]\n"
"	  `P(info=\"smoothing parameter for reach-through     \" );\n"
"	parameter	real	ccso	=   0.0		from[0.0:inf]\n"
"	  `P(info=\"extrinsic c-s overlap capacitance         \" unit=\"F\");\n"
"	parameter	real	qbm	=   0.0\n"
"	  `P(info=\"base charge model selection parameter     \" );\n"
"	parameter	real	nkf	=   0.5		from(0.0:inf]\n"
"	  `P(info=\"high current beta roll-off parameter      \" );\n"
"	parameter	real	xikf	=   0.0\n"
"	  `P(info=\"temperature exponent of ikf               \" );\n"
"	parameter	real	xrcx	=   0.0\n"
"	  `P(info=\"temperature exponent of rcx               \" );\n"
"	parameter	real	xrbx	=   0.0\n"
"	  `P(info=\"temperature exponent of rbx               \" );\n"
"	parameter	real	xrbp	=   0.0\n"
"	  `P(info=\"temperature exponent of rbp               \" );\n"
"	parameter	real	isrr	=   1.0		from(0.0:inf]\n"
"	  `P(info=\"ratio of is(reverse) to is(forward)       \" );\n"
"	parameter	real	xisr	=   0.0\n"
"	  `P(info=\"temperature exponent for isrr             \" );\n"
"	parameter	real	dear	=   0.0\n"
"	  `P(info=\"delta activation energy for isrr          \" unit=\"V\");\n"
"	parameter	real	eap	=   1.12\n"
"	  `P(info=\"activiation energy for isp                \" unit=\"V\");\n"
"	parameter	real	vbbe	=   0.0\n"
"	  `P(info=\"b-e breakdown voltage                     \" unit=\"V\");\n"
"	parameter	real	nbbe	=   1.0		from(0.0:inf]\n"
"	  `P(info=\"b-e breakdown emission coefficient        \" );\n"
"	parameter	real	ibbe	=   1.0e-6\n"
"	  `P(info=\"b-e breakdown current                     \" unit=\"A\");\n"
"	parameter	real	tvbbe1	=   0.0\n"
"	  `P(info=\"linear temperature coefficient of vbbe    \" unit=\"/C\");\n"
"	parameter	real	tvbbe2	=   0.0\n"
"	  `P(info=\"quadratic temperature coefficient of vbbe \" unit=\"/C^2\");\n"
"	parameter	real	tnbbe	=   0.0\n"
"	  `P(info=\"temperature coefficient of nbbe           \" );\n"
"	parameter	real	ebbe	=   0.0\n"
"	  `P(info=\"calculated exp(-vbbe/(nbbe*Vtv))          \" );\n"
"	parameter	real	dtemp	=   0.0\n"
"	  `P(info=\"local temperature rise                    \" unit=\"C\");\n"
"	parameter	real	vers	=   1.2\n"
"	  `P(info=\"version number                            \" );\n"
"	parameter	real	vrev	=   1.0\n"
"	  `P(info=\"revision number                           \" );\n"
"\n"
"	parameter	real	xrb	=   0.0\n"
"	  `P(info=\"temp exponent of rbx/i, xrbx/i not given  \" );\n"
"	parameter	real	xrc	=   0.0\n"
"	  `P(info=\"temp exp rcx/i&rbp, xrcx/i&xrbp not given \" );\n"
"	parameter	real	npn	=   0.0\n"
"	  `P(spice:isflag=\"yes\" info=\"model type flag  for npn                  \" );\n"
"	parameter	real	pnp	=   0.0\n"
"	  `P(info=\"model type flag  for pnp                  \" );\n"
"	parameter	real	m	=   1.0		from(0.0:inf]\n"
"	  `P(spice:isflag=\"yes\" type=\"instance\" info=\"multiplicity scale factor                 \" );\n"
"	parameter	real	mag	=   1.0		from(0.0:inf]\n"
"	  `P(type=\"instance\" info=\"multiplicity scale factor                 \" );\n"
"`ifdef insideADMS\n"
"`else\n"
"	parameter	real	gmin	=   1.0e-12	from[0.0:inf];\n"
"	parameter	real	pnjmaxi	=   1.0		from[0.0:inf];\n"
"`endif\n"
"	parameter	real	tmin	=  -1.0e+02	from[-250:27]\n"
"	  `P(info=\"min temperature                           \" unit=\"K\");\n"
"	parameter	real	tmax	=   5.0e+02	from[27:1000]\n"
"	  `P(info=\"max temperature                           \" unit=\"K\");\n"
"	parameter	real	shrink	=   0.0		from[0.0:100.0]\n"
"	  `P(info=\"shrink factor                             \" );\n"
"	parameter	real	shrink2	=   0.0		from[0.0:100.0]\n"
"	  `P(info=\"shrink2 factor                            \" );\n"
"	parameter	integer	off	=   1.0		from[0:1]\n"
"	  `P(spice:isflag=\"yes\" type=\"instance\" info=\"Device initially off?                     \" );\n"
"	parameter	real	area	=   1.0		from(0.0:inf]\n"
"	  `P(type=\"instance\" info=\"area factor                               \" );\n"
"	parameter	real	maxexp	=   1.0e22	from[1.0e10:inf]\n"
"	  `P(info=\"maximum allowed value of exponential      \" );\n"
"\n"
"	real	is_t     `P(ask=\"yes\" info=\"transport saturation current at temp      \" unit=\"A\");\n"
"	real	isrr_t   `P(ask=\"yes\" info=\"ratio of is(rev) to is(fwd) at temperature\" );\n"
"	real	ikf_t    `P(ask=\"yes\" info=\"fwd knee current (zero=infinite) at temp  \" unit=\"A\");\n"
"	real	ibei_t   `P(ask=\"yes\" info=\"ideal b-e saturation current at temp      \" unit=\"A\");\n"
"	real	ibci_t   `P(ask=\"yes\" info=\"ideal b-c saturation current at temp      \" unit=\"A\");\n"
"	real	isp_t    `P(ask=\"yes\" info=\"parasitic transport satn current at temp  \" unit=\"A\");\n"
"	real	iben_t   `P(ask=\"yes\" info=\"non-ideal b-e saturation current at temp  \" unit=\"A\");\n"
"	real	ibcn_t   `P(ask=\"yes\" info=\"non-ideal b-c saturation current at temp  \" unit=\"A\");\n"
"	real	ibeip_t  `P(ask=\"yes\" info=\"ideal parasitic b-e satn current at temp  \" unit=\"A\");\n"
"	real	ibenp_t  `P(ask=\"yes\" info=\"non-ideal para b-e satn current at temp   \" unit=\"A\");\n"
"	real	ibcip_t  `P(ask=\"yes\" info=\"ideal parasitic b-c satn current at temp  \" unit=\"A\");\n"
"	real	ibcnp_t  `P(ask=\"yes\" info=\"non-ideal para b-c satn current at temp   \" unit=\"A\");\n"
"	real	rcx_t    `P(ask=\"yes\" info=\"extrinsic collector resistance at temp    \" unit=\"Ohm\");\n"
"	real	rci_t    `P(ask=\"yes\" info=\"intrinsic collector resistance at temp    \" unit=\"Ohm\");\n"
"	real	rbx_t    `P(ask=\"yes\" info=\"extrinsic base resistance at temperature  \" unit=\"Ohm\");\n"
"	real	rbi_t    `P(ask=\"yes\" info=\"intrinsic base resistance at temperature  \" unit=\"Ohm\");\n"
"	real	re_t     `P(ask=\"yes\" info=\"extrinsic emitter resistance at temp      \" unit=\"Ohm\");\n"
"	real	rs_t     `P(ask=\"yes\" info=\"extrinsic substrate resistance at temp    \" unit=\"Ohm\");\n"
"	real	rbp_t    `P(ask=\"yes\" info=\"parasitic base resistance at temperature  \" );\n"
"	real	pe_t     `P(ask=\"yes\" info=\"b-e built-in potential at temperature     \" unit=\"V\");\n"
"	real	pc_t     `P(ask=\"yes\" info=\"b-c built-in potential at temperature     \" unit=\"V\");\n"
"	real	ps_t     `P(ask=\"yes\" info=\"c-s built-in potential at temperature     \" unit=\"V\");\n"
"	real	cje_t    `P(ask=\"yes\" info=\"zero-bias b-e depletion cap at temp       \" unit=\"F\");\n"
"	real	cjc_t    `P(ask=\"yes\" info=\"zero-bias intrinsic b-c depl cap at temp  \" unit=\"F\");\n"
"	real	cjep_t   `P(ask=\"yes\" info=\"zero-bias extrinsic b-c depl cap at temp  \" unit=\"F\");\n"
"	real	cjcp_t   `P(ask=\"yes\" info=\"zero-bias c-s depletion cap at temperature\" unit=\"F\");\n"
"	real	nf_t     `P(ask=\"yes\" info=\"forward emission coefficient at temp      \" );\n"
"	real	nr_t     `P(ask=\"yes\" info=\"reverse emission coefficient at temp      \" );\n"
"	real	avc2_t   `P(ask=\"yes\" info=\"b-c weak avalanche parameter 2 at temp    \" );\n"
"	real	vbbe_t   `P(ask=\"yes\" info=\"b-e breakdown voltage at temperature      \" unit=\"V\");\n"
"	real	nbbe_t   `P(ask=\"yes\" info=\"b-e breakdown emission coeff at temp      \" );\n"
"	real	gamm_t   `P(ask=\"yes\" info=\"epi doping parameter at temperature       \" );\n"
"	real	vo_t     `P(ask=\"yes\" info=\"epi drift saturation voltage at temp      \" unit=\"V\");\n"
"	real	ebbe_t;\n"
"	real	Tdev     `P(ask=\"yes\" spice:name=\"tdev\" info=\"device temperature (K)                    \" );\n"
"	real	Tini, rT, dT, Ivef, Iver, Iikf, Iikr, Iikp;\n"
"	real	Ivo, Ihrcf, Ivtf, Iitf, sltf, psiio, psiin, dv0;\n"
"	real	dvh, pwq, qlo, qhi, mv0, vl0, q0, dv;\n"
"	real	mv, vl, vminm, vn0, vnl0, qlo0, vn, vnl;\n"
"	real	sel, crt, cmx, cl, ql, Gcx, Gci, Gbx;\n"
"	real	Gbi, Ge, Gbp, Gs, Gth, maxvIfi, maxvIri;\n"
"	real	maxvIp, maxvIbbe, maxvIbei, maxvIben, maxvIbci, maxvIbcn;\n"
"	real	maxvIbeip, maxvIbenp, maxvIbcip, maxvIbcnp;\n"
"	real	Vtv, Ifi, Iri, Itzf;\n"
"	real	Itxf `P(ask=\"yes\" spice:name=\"itzf\" info=\"forward transport current                 \" unit=\"A\");\n"
"	real	Itzr `P(ask=\"yes\" spice:name=\"itzr\" info=\"reverse transport current                 \" unit=\"A\");\n"
"	real	q1z, q1, q2, qb, Ifp, Irp;\n"
"	real	Iccp `P(ask=\"yes\" spice:name=\"iccp\" info=\"parasitic transport current               \" unit=\"A\");\n"
"	real	q2p, qbp;\n"
"	real	Ibe  `P(ask=\"yes\" spice:name=\"ibe\" info=\"intrinsic b-e current                     \" unit=\"A\");\n"
"	real	Ibex `P(ask=\"yes\" spice:name=\"ibex\" info=\"extrinsic b-e current                     \" unit=\"A\");\n"
"	real	Ibcj;\n"
"	real	Ibc  `P(ask=\"yes\" spice:name=\"ibc\" info=\"intrinsic b-c current                     \" unit=\"A\");\n"
"	real	Ibep `P(ask=\"yes\" spice:name=\"ibep\" info=\"extrinsic b-c current                     \" unit=\"A\");\n"
"	real	Ibcp `P(ask=\"yes\" spice:name=\"ibcp\" info=\"parasitic b-c current                     \" unit=\"A\");\n"
"	real	Igc `P(ask=\"yes\" spice:name=\"igc\" info=\"c-b avalanche current                     \" unit=\"A\");\n"
"	real	avalf;\n"
"	real	Ircx `P(ask=\"yes\" spice:name=\"ircx\" info=\"current in rcx element                    \" unit=\"A\");\n"
"	real	Irci `P(ask=\"yes\" spice:name=\"irci\" info=\"current in rci element                    \" unit=\"A\");\n"
"	real	Irbx `P(ask=\"yes\" spice:name=\"irbx\" info=\"current in rbx element                    \" unit=\"A\");\n"
"	real	Irbi `P(ask=\"yes\" spice:name=\"irbi\" info=\"current in rbi element                    \" unit=\"A\");\n"
"	real	Ire  `P(ask=\"yes\" spice:name=\"ire\" info=\"current in re  element                    \" unit=\"A\");\n"
"	real	Irbp `P(ask=\"yes\" spice:name=\"irbp\" info=\"current in rbp element                    \" unit=\"A\");\n"
"	real	Irs  `P(ask=\"yes\" spice:name=\"irs\" info=\"current in rs  element                    \" unit=\"A\");\n"
"	real	Kbci, Kbcx, rKp1, Iohm, derf, arg, expl;\n"
"	real	expi, expn, expx, afac, mac1, VmaxExp, qdbe, qdbex;\n"
"	real	qdbc, qdbep, qdbcp;\n"
"\n"
"	// conductances (for backward compatibility with level 2)\n"
"	real	ibc_vbci `P(ask=\"yes\" info=\"Derivative of ibc with respect to vbci\" unit=\"S\");\n"
"	real	 ibcp_vbcp `P(ask=\"yes\" info=\"Derivative of ibcp with respect to vbcp\" unit=\"S\");\n"
"	real	 ibe_vbei `P(ask=\"yes\" info=\"Derivative of ibe with respect to vbei\" unit=\"S\");\n"
"	real	 ibep_vbep `P(ask=\"yes\" info=\"Derivative of ibep with respect to vbep\" unit=\"S\");\n"
"	real	 ibex_vbex `P(ask=\"yes\" info=\"Derivative of ibex with respect to Vbex\" unit=\"S\");\n"
"	real	 iccp_vbci `P(ask=\"yes\" info=\"Derivative of iccp with respect to vbci\" unit=\"S\");\n"
"	real	iccp_vbcp `P(ask=\"yes\" info=\"Derivative of iccp with respect to vbcp\" unit=\"S\");\n"
"	real	 iccp_vbep `P(ask=\"yes\" info=\"Derivative of iccp with respect to vbep\" unit=\"S\");\n"
"	real	 igc_vbci `P(ask=\"yes\" info=\"Derivative of igc with respect to vbci\" unit=\"S\");\n"
"	real	 igc_vbei `P(ask=\"yes\" info=\"Derivative of igc with respect to vbei\" unit=\"S\");\n"
"	real	 irbi_vbci `P(ask=\"yes\" info=\"Derivative of irbi with respect to vbci\" unit=\"S\");\n"
"	real	 irbi_vbei `P(ask=\"yes\" info=\"Derivative of irbi with respect to vbei\" unit=\"S\");\n"
"	real	irbp_vbci `P(ask=\"yes\" info=\"Derivative of irbp with respect to vbci\" unit=\"S\");\n"
"	real	 irci_vbci `P(ask=\"yes\" info=\"Derivative of irci with respect to vbci\" unit=\"S\");\n"
"	real	 itzf_vbci `P(ask=\"yes\" info=\"Derivative of itzf with respect to vbci\" unit=\"S\");\n"
"	real	 itzf_vbei `P(ask=\"yes\" info=\"Derivative of itzf with respect to vbei\" unit=\"S\");\n"
"	real	 itzr_vbci `P(ask=\"yes\" info=\"Derivative of itzr with respect to vbci\" unit=\"S\");\n"
"	real	 itzr_vbei `P(ask=\"yes\" info=\"Derivative of itzr with respect to vbei\" unit=\"S\");\n"
"	// capacitances (for backward compatibility with level 2)\n"
"	real	qbc_vbci `P(ask=\"yes\" info=\"Derivative of qbc with respect to vbci    \" unit=\"C/V\");\n"
"	real	 qbco_vbc `P(ask=\"yes\" info=\"Derivative of qbco with respect to vbc    \" unit=\"C/V\");\n"
"	real	 qbcp_vbcp `P(ask=\"yes\" info=\"Derivative of qbcp with respect to vbcp   \" unit=\"C/V\");\n"
"	real	 qbcx_vbcx `P(ask=\"yes\" info=\"Derivative of qbcx with respect to vbcx   \" unit=\"C/V\");\n"
"	real	 qbe_vbci `P(ask=\"yes\" info=\"Derivative of qbe with respect to vbci    \" unit=\"C/V\");\n"
"	real	qbe_vbei `P(ask=\"yes\" info=\"Derivative of qbe with respect to vbei    \" unit=\"C/V\");\n"
"	real	 qbeo_vbe `P(ask=\"yes\" info=\"Derivative of qbeo with respect to vbe    \" unit=\"C/V\");\n"
"	real	 qbep_vbci `P(ask=\"yes\" info=\"Derivative of qbep with respect to vbci   \" unit=\"C/V\");\n"
"	real	 qbep_vbep `P(ask=\"yes\" info=\"Derivative of qbep with respect to vbep   \" unit=\"C/V\");\n"
"	real	 qbex_vbex `P(ask=\"yes\" info=\"Derivative of qbex with respect to vbex   \" unit=\"C/V\");\n"
"	// power current (for backward compatibility with level 2)\n"
"	real	p `P(ask=\"yes\" info=\"thermal power generation                  \" unit=\"W\");\n"
"	// temperature (for backward compatibility with level 2)\n"
"	real	trise `P(ask=\"yes\" info=\"local temperature rise                    \" unit=\"C\");\n"
"	real	ft_int;\n"
"\n"
"	real	sgIf, rIf, mIf, tff;\n"
"	real	Qbe `P(ask=\"yes\" spice:name=\"qbe\" info=\"intrinsic b-e charge                      \" unit=\"C\");\n"
"	real	Qbex `P(ask=\"yes\" spice:name=\"qbex\" info=\"extrinsic (side-wall) b-e charge          \" unit=\"C\");\n"
"	real	Qbc `P(ask=\"yes\" spice:name=\"qbc\" info=\"intrinsic b-c charge                      \" unit=\"C\");\n"
"	real	Qbcx `P(ask=\"yes\" spice:name=\"qbcx\" info=\"extrinsic b-c charge                      \" unit=\"C\");\n"
"	real	Qbep `P(ask=\"yes\" spice:name=\"qbep\" info=\"parasitic b-e charge                      \" unit=\"C\");\n"
"	real	Qbcp `P(ask=\"yes\" spice:name=\"qbcp\" info=\"parasitic b-c charge                      \" unit=\"C\");\n"
"	real	Qbeo `P(ask=\"yes\" spice:name=\"qbeo\" info=\"extrinsic b-e overlap charge              \" unit=\"C\");\n"
"	real	Qbco `P(ask=\"yes\" spice:name=\"qbco\" info=\"extrinsic b-c overlap charge              \" unit=\"C\");\n"
"	real	Ixf1, Ixf2, Qxf1, Qxf2, Ith, Irth, Qcth;\n"
"	real	Vbei, Vbci, Vbex, Vbep, Vbcp, Vbcx, Vxf1, Vxf2;\n"
"	real	Bvbe, Vrth;\n"
"	real	Vbe `P(ask=\"yes\" spice:name=\"vbe\" info=\"external b-e voltage                      \" unit=\"V\");\n"
"	real	Vbc `P(ask=\"yes\" spice:name=\"vbc\" info=\"external b-c voltage                      \" unit=\"V\");\n"
"	real	Vrcx, Vrci, Vrbx, Vrbi, Vre, Vrbp, Vrs, Vcei, Vcep;\n"
"	real	VBICtype `P(spice:name=\"type\" info=\"Device type from npn or pnp flags         \" unit=\"no\");\n"
"	real	meff `P(ask=\"yes\" info=\"multiplicity scale factor (incl subckt)   \" );\n"
"	real	areaef `P(ask=\"yes\" info=\"Effective area factor                     \" unit=\"m^2\");\n"
"\n"
"	real	shrinklFactor `P(ask=\"yes\" spice:name=\"shrinkl\" info=\"lineal shrink factor                      \" );\n"
"	real	shrinkaFactor `P(ask=\"yes\" spice:name=\"shrinka\" info=\"areal shrink factor                       \" );\n"
"	real	instanceShrinklFactor `P(ask=\"yes\" spice:name=\"shrinkl\" info=\"lineal shrink factor                      \" );\n"
"	real	instanceShrinkaFactor `P(ask=\"yes\" spice:name=\"shrinka\" info=\"areal shrink factor                       \" );\n"
"	real	ic `P(ask=\"yes\" info=\"current into collector                    \" unit=\"A\");\n"
"	real	ib `P(ask=\"yes\" info=\"current into base                         \" unit=\"A\");\n"
"	real	ie `P(ask=\"yes\" info=\"current into emittor                      \" unit=\"A\");\n"
"	real	isub `P(ask=\"yes\" spice:name=\"is\" info=\"current into substrate                    \" unit=\"A\");\n"
"	real	powerT `P(ask=\"yes\" info=\"thermal power generation                  \" unit=\"W\");\n"
"	real	powerD `P(ask=\"yes\" info=\"thermal power dissipation in rth          \" unit=\"W\");\n"
"	real	Vce `P(ask=\"yes\" spice:name=\"vce\" info=\"external c-e voltage                      \" unit=\"V\");\n"
"	real	Ircx_Vrcx `P(ask=\"yes\" spice:name=\"ircx_vrcx\" info=\"rcx conductance                           \" unit=\"S\");\n"
"	real	Irci_Vrci `P(ask=\"yes\" spice:name=\"irci_vrci\" info=\"rci effective conductance                 \" unit=\"S\");\n"
"	real	Irbx_Vrbx `P(ask=\"yes\" spice:name=\"irbx_vrbx\" info=\"rbx conductance                           \" unit=\"S\");\n"
"	real	Irbi_Vrbi `P(ask=\"yes\" spice:name=\"irbi_vrbi\" info=\"rbi effective conductance                 \" unit=\"S\");\n"
"	real	Irbp_Vrbp `P(ask=\"yes\" spice:name=\"irbp_vrbp\" info=\"rbp effective conductance                 \" unit=\"S\");\n"
"	real	Ire_Vre `P(ask=\"yes\" spice:name=\"ire_vre\" info=\"re conductance                            \" unit=\"S\");\n"
"	real	Irs_Vrs `P(ask=\"yes\" spice:name=\"irs_vrs\" info=\"rs conductance                            \" unit=\"S\");\n"
"	real	gm `P(ask=\"yes\" info=\"intrinsic transconductance                \" unit=\"S\");\n"
"	real	go `P(ask=\"yes\" info=\"intrinsic output conductance              \" unit=\"S\");\n"
"	real	gpi `P(ask=\"yes\" info=\"intrinsic b-e conductance                 \" unit=\"S\");\n"
"	real	gpix `P(ask=\"yes\" info=\"extrinsic b-e conductance                 \" unit=\"S\");\n"
"	real	gmu `P(ask=\"yes\" info=\"intrinsic b-c conductance                 \" unit=\"S\");\n"
"	real	gmux `P(ask=\"yes\" info=\"extrinsic b-c conductance                 \" unit=\"S\");\n"
"	real	cpi `P(ask=\"yes\" info=\"intrinsic b-e capacitance d(Qbe)/d(Vbei)  \" unit=\"F\");\n"
"	real	cpix `P(ask=\"yes\" info=\"extrinsic b-e capacitance d(Qbex)/d(Vbex) \" unit=\"F\");\n"
"	real	cmu `P(ask=\"yes\" info=\"intrinsic b-c capacitance d(Qbc)/d(Vbci)  \" unit=\"F\");\n"
"	real	cmux `P(ask=\"yes\" info=\"extrinsic b-c capacitance d(Qbcx)/d(Vbcx) \" unit=\"F\");\n"
"	real	cpip `P(ask=\"yes\" info=\"parasitic b-e capacitance d(Qbep)/d(Vbep) \" unit=\"F\");\n"
"	real	ccs `P(ask=\"yes\" info=\"c-s capacitance d(Qbcp)/d(Vbcp)           \" unit=\"F\");\n"
"	real	cbeoXX `P(ask=\"yes\" spice:name=\"cbeo\" info=\"b-e overlap capacitance d(Qbeo)/d(Vbe)    \" unit=\"F\");\n"
"	real	cbcoXX `P(ask=\"yes\" spice:name=\"cbco\" info=\"b-c overlap capacitance d(Qbco)/d(Vbc)    \" unit=\"F\");\n"
"	real	rci_mod `P(ask=\"yes\" spice:name=\"rcimod\" info=\"rci modulatn fctr, rci_atBias/rci_zeroBias\" );\n"
"	real	rci_eff `P(ask=\"yes\" info=\"effective (small-signal) intr collctr res \" unit=\"Ohm\");\n"
"	real	rbi_eff `P(ask=\"yes\" info=\"modulated intrinsic base resistance       \" unit=\"Ohm\");\n"
"	real	rbp_eff `P(ask=\"yes\" info=\"modulated parasitic base resistance       \" unit=\"Ohm\");\n"
"	real	tauTh `P(ask=\"yes\" info=\"thermal time constant                     \" unit=\"s\");\n"
"\n"
"	parameter	integer level=3    `P(info=\"level number                              \" );\n"
"	parameter	integer libset = 0 `P(info=\"model parameter set ID number             \" );\n"
"	string	ft            `P(ask=\"yes\" info=\"Cutoff frequency                          \" unit=\"Hz\");\n"
"	string	VBICtypeName  `P(ask=\"yes\" spice:name=\"type\" info=\"Device type from npn or pnp flags         \" unit=\"no\");\n"
"	string	INSTANCEmodel `P(ask=\"yes\" spice:name=\"model\" info=\"model name                                \" );\n"
"	string	INSTANCEtype  `P(ask=\"yes\" spice:name=\"type\" info=\"bjt transistor type                       \" );\n"
"	real	INSTANCElevel `P(ask=\"yes\" spice:name=\"level\" info=\"level number                              \" );\n"
"\n"
"	real	inoise        `P(ask=\"yes\" spice:name=\"inoise\" info=\"Total noise\"\n"
"	  mica:ask=\"return(TOTnoiseAsk(&value->rValue, ASK_IN_NOISE, instance->VBICSELFTtotNoiseIndex));\"\n"
"	);\n"
"	real	inoise_itzf   `P(ask=\"yes\" spice:name=\"inoise.itzf\" info=\"itzf shot thermal noise\"\n"
"	  mica:ask=\"return(SHOTnoiseAsk(&value->rValue, ASK_IN_NOISE, instance->VBICSELFTshotSrcIndex, ITZF_NOISE));\"\n"
"	);\n"
"	real	inoise_ibe    `P(ask=\"yes\" spice:name=\"inoise.ibe\" info=\"ibe shot thermal noise\"\n"
"	  mica:ask=\"return(SHOTnoiseAsk(&value->rValue, ASK_IN_NOISE, instance->VBICSELFTshotSrcIndex, IBE_NOISE));\"\n"
"	);\n"
"	real	inoise_ibefn  `P(ask=\"yes\" spice:name=\"inoise.ibefn\" info=\"ibe flicker thermal noise\"\n"
"	  mica:ask=\"return(FLICKERnoiseAsk(&value->rValue, ASK_IN_NOISE, instance->VBICSELFTflickerSrcIndex, IBE_FLICKER));\"\n"
"	);\n"
"	real	inoise_rcx    `P(ask=\"yes\" spice:name=\"inoise.rcx\" info=\"rcx collector thermal noise\"\n"
"	  mica:ask=\"return(THERMALnoiseAsk(&value->rValue, ASK_IN_NOISE, instance->VBICSELFTthermalSrcIndex, RCX_NOISE));\"\n"
"	);\n"
"	real	inoise_rci    `P(ask=\"yes\" spice:name=\"inoise.rci\" info=\"rci collector thermal noise\"\n"
"	  mica:ask=\"return(THERMALnoiseAsk(&value->rValue, ASK_IN_NOISE, instance->VBICSELFTthermalSrcIndex, RCI_NOISE));\"\n"
"	);\n"
"	real	inoise_rbx    `P(ask=\"yes\" spice:name=\"inoise.rbx\" info=\"rbx base thermal noise\"\n"
"	  mica:ask=\"return(THERMALnoiseAsk(&value->rValue, ASK_IN_NOISE, instance->VBICSELFTthermalSrcIndex, RBX_NOISE));\"\n"
"	);\n"
"	real	inoise_rbi    `P(ask=\"yes\" spice:name=\"inoise.rbi\" info=\"rbi base thermal noise\"\n"
"	  mica:ask=\"return(THERMALnoiseAsk(&value->rValue, ASK_IN_NOISE, instance->VBICSELFTthermalSrcIndex, RBI_NOISE));\"\n"
"	);\n"
"	real	inoise_re     `P(ask=\"yes\" spice:name=\"inoise.re\" info=\"re emitter thermal noise\"\n"
"	  mica:ask=\"return(THERMALnoiseAsk(&value->rValue, ASK_IN_NOISE, instance->VBICSELFTthermalSrcIndex, RE_NOISE));\"\n"
"	);\n"
"	real	inoise_rs     `P(ask=\"yes\" spice:name=\"inoise.rs\" info=\"rs thermal noise\"\n"
"	  mica:ask=\"return(THERMALnoiseAsk(&value->rValue, ASK_IN_NOISE, instance->VBICSELFTthermalSrcIndex, RS_NOISE));\"\n"
"	);\n"
"	real	inoise_iccp   `P(ask=\"yes\" spice:name=\"inoise.iccp\" info=\"iccp shot noise\"\n"
"	  mica:ask=\"return(SHOTnoiseAsk(&value->rValue, ASK_IN_NOISE, instance->VBICSELFTshotSrcIndex, ICCP_NOISE));\"\n"
"	);\n"
"	real	inoise_ibep   `P(ask=\"yes\" spice:name=\"inoise.ibep\" info=\"ibep shot noise\"\n"
"	  mica:ask=\"return(SHOTnoiseAsk(&value->rValue, ASK_IN_NOISE, instance->VBICSELFTshotSrcIndex, IBEP_NOISE));   \"\n"
"	);\n"
"	real	inoise_ibepfn `P(ask=\"yes\" spice:name=\"inoise.ibepfn\" info=\"ibep flicker thermal noise\"\n"
"	  mica:ask=\"return(FLICKERnoiseAsk(&value->rValue, ASK_IN_NOISE, instance->VBICSELFTflickerSrcIndex, IBEP_FLICKER));\"\n"
"	);\n"
"	real	inoise_rbp    `P(ask=\"yes\" spice:name=\"inoise.rbp\" info=\"rbp thermal noise\"\n"
"	  mica:ask=\"return(THERMALnoiseAsk(&value->rValue, ASK_IN_NOISE, instance->VBICSELFTthermalSrcIndex, RBP_NOISE));\"\n"
"	);\n"
"	real	onoise        `P(ask=\"yes\" spice:name=\"onoise\" info=\"Total noise\"\n"
"	  mica:ask=\"return(TOTnoiseAsk(&value->rValue, ASK_OUT_NOISE, instance->VBICSELFTtotNoiseIndex));\"\n"
"	);\n"
"	real	onoise_itzf   `P(ask=\"yes\" spice:name=\"onoise.itzf\" info=\"itzf shot thermal noise\"\n"
"	  mica:ask=\"return(SHOTnoiseAsk(&value->rValue, ASK_OUT_NOISE, instance->VBICSELFTshotSrcIndex, ITZF_NOISE));\"\n"
"	);\n"
"	real	onoise_ibe    `P(ask=\"yes\" spice:name=\"onoise.ibe\" info=\"ibe shot thermal noise\"\n"
"	  mica:ask=\"return(SHOTnoiseAsk(&value->rValue, ASK_OUT_NOISE, instance->VBICSELFTshotSrcIndex, IBE_NOISE)); \"\n"
"	);\n"
"	real	onoise_ibefn  `P(ask=\"yes\" spice:name=\"onoise.ibefn\" info=\"ibe flicker thermal noise\"\n"
"	  mica:ask=\"return(FLICKERnoiseAsk(&value->rValue, ASK_OUT_NOISE, instance->VBICSELFTflickerSrcIndex, IBE_FLICKER));\"\n"
"	);\n"
"	real	onoise_rcx    `P(ask=\"yes\" spice:name=\"onoise.rcx\" info=\"rcx collector thermal noise\"\n"
"	  mica:ask=\"return(THERMALnoiseAsk(&value->rValue, ASK_OUT_NOISE, instance->VBICSELFTthermalSrcIndex, RCX_NOISE));\"\n"
"	);\n"
"	real	onoise_rci    `P(ask=\"yes\" spice:name=\"onoise.rci\" info=\"rci collector thermal noise\"\n"
"	  mica:ask=\"return(THERMALnoiseAsk(&value->rValue, ASK_OUT_NOISE, instance->VBICSELFTthermalSrcIndex, RCI_NOISE));\"\n"
"	);\n"
"	real	onoise_rbx    `P(ask=\"yes\" spice:name=\"onoise.rbx\" info=\"rbx base thermal noise\"\n"
"	  mica:ask=\"return(THERMALnoiseAsk(&value->rValue, ASK_OUT_NOISE, instance->VBICSELFTthermalSrcIndex, RBX_NOISE));\"\n"
"	);\n"
"	real	onoise_rbi    `P(ask=\"yes\" spice:name=\"onoise.rbi\" info=\"rbi base thermal noise\"\n"
"	  mica:ask=\"return(THERMALnoiseAsk(&value->rValue, ASK_OUT_NOISE, instance->VBICSELFTthermalSrcIndex, RBI_NOISE));\"\n"
"	);\n"
"	real	onoise_re     `P(ask=\"yes\" spice:name=\"onoise.re\" info=\"re emitter thermal noise\"\n"
"	  mica:ask=\"return(THERMALnoiseAsk(&value->rValue, ASK_OUT_NOISE, instance->VBICSELFTthermalSrcIndex, RE_NOISE));\"\n"
"	);\n"
"	real	onoise_rs     `P(ask=\"yes\" spice:name=\"onoise.rs\" info=\"rs thermal noise\"\n"
"	  mica:ask=\"return(THERMALnoiseAsk(&value->rValue, ASK_OUT_NOISE, instance->VBICSELFTthermalSrcIndex, RS_NOISE));\"\n"
"	);\n"
"	real	onoise_iccp   `P(ask=\"yes\" spice:name=\"onoise.iccp\" info=\"iccp shot noise\"\n"
"	  mica:ask=\"return(SHOTnoiseAsk(&value->rValue, ASK_OUT_NOISE, instance->VBICSELFTshotSrcIndex, ICCP_NOISE));\"\n"
"	);\n"
"	real	onoise_ibep   `P(ask=\"yes\" spice:name=\"onoise.ibep\" info=\"ibep shot noise\"\n"
"	  mica:ask=\"return(SHOTnoiseAsk(&value->rValue, ASK_OUT_NOISE, instance->VBICSELFTshotSrcIndex, IBEP_NOISE)); \"\n"
"	);\n"
"	real	onoise_ibepfn `P(ask=\"yes\" spice:name=\"onoise.ibepfn\" info=\"ibep flicker thermal noise\"\n"
"	  mica:ask=\"return(FLICKERnoiseAsk(&value->rValue, ASK_OUT_NOISE, instance->VBICSELFTflickerSrcIndex, IBEP_FLICKER));\"\n"
"	);\n"
"	real	onoise_rbp    `P(ask=\"yes\" spice:name=\"onoise.rbp\" info=\"rbp thermal noise\"\n"
"	  mica:ask=\"return(THERMALnoiseAsk(&value->rValue, ASK_OUT_NOISE, instance->VBICSELFTthermalSrcIndex, RBP_NOISE));\"\n"
"	);\n"
"\n"
"	analog begin\n"
"\n"
"	`INITIAL_MODEL\n"
"	begin	// begin loadmodel block: code independent of instance parameters or bias\n"
"		if (`PGIVEN(shrink)) begin\n"
"			shrinklFactor=1.0-shrink/100.0;\n"
"			if (`PGIVEN(shrink2))\n"
"				shrinkaFactor=1.0-shrink2/100.0;\n"
"			else\n"
"				shrinkaFactor=shrinklFactor*shrinklFactor;\n"
"		end else begin\n"
"			shrinklFactor=`SHRINKL;\n"
"			if (`PGIVEN(shrink2))\n"
"				shrinkaFactor=1.0-shrink2/100.0;\n"
"			else\n"
"				shrinkaFactor=`SHRINKA;\n"
"		end\n"
"\n"
"		if (`PGIVEN(npn))\n"
"			VBICtype	=  `NPN;\n"
"		else if (`PGIVEN(pnp))\n"
"			VBICtype	=  `PNP;\n"
"		else\n"
"			VBICtype	=  `NPN;\n"
"`ifdef insideADMS\n"
"		VBICtypeName = (VBICtype==`NPN)?\"Vertical npn\":\"Vertical pnp\";\n"
"`endif\n"
"	end	// end loadmodel block\n"
"\n"
"//\n"
"//	Temperature mappings\n"
"//\n"
"\n"
"	`INITIAL_INSTANCE\n"
"	begin	// begin loadinstance block: code independent of bias\n"
"`ifdef insideADMS\n"
"		INSTANCEmodel	= $model;\n"
"		INSTANCElevel	= level;\n"
"		INSTANCEtype=VBICtypeName;\n"
"`endif\n"
"		instanceShrinklFactor=shrinklFactor;\n"
"		instanceShrinkaFactor=shrinkaFactor;\n"
"		if (`PGIVEN(shrink2))\n"
"			meff	=  m*mag*area*(1.0-shrink2/100.0);\n"
"		else if (`PGIVEN(shrink))\n"
"			meff	=  m*mag*area*(1.0-shrink/100.0)*(1.0-shrink/100.0);\n"
"		else\n"
"			meff	=  m*mag*area*`SHRINKA;\n"
"	end	// end loadinstance block\n"
"		Tini	=  `TABS+tnom;\n"
"		Vrth	=  V(b_rth);\n"
"		Tdev	=  $temperature+dtemp+Vrth;\n"
"		Tdev	=  Tdev-`TABS;\n"
"		if (Tdev<tmin)\n"
"			Tdev	=  tmin;\n"
"		if (Tdev>tmax)\n"
"			Tdev	=  tmax;\n"
"		Tdev	=  Tdev+`TABS;\n"
"		Vtv	=  `KB*Tdev/`QQ;\n"
"		rT	=  Tdev/Tini;\n"
"		dT	=  Tdev-Tini;\n"
"		ikf_t	=  ikf*pow(rT,xikf);\n"
"		if (`PGIVEN(xrcx))\n"
"			rcx_t	=  rcx*pow(rT,xrcx);\n"
"		else\n"
"			rcx_t	=  rcx*pow(rT,xrc);\n"
"		if (`PGIVEN(xrci))\n"
"			rci_t	=  rci*pow(rT,xrci);\n"
"		else\n"
"			rci_t	=  rci*pow(rT,xrc);\n"
"		if (`PGIVEN(xrbx))\n"
"			rbx_t	=  rbx*pow(rT,xrbx);\n"
"		else\n"
"			rbx_t	=  rbx*pow(rT,xrb);\n"
"		if (`PGIVEN(xrbi))\n"
"			rbi_t	=  rbi*pow(rT,xrbi);\n"
"		else\n"
"			rbi_t	=  rbi*pow(rT,xrb);\n"
"		re_t	=  re*pow(rT,xre);\n"
"		rs_t	=  rs*pow(rT,xrs);\n"
"		if (`PGIVEN(xrbp))\n"
"			rbp_t	=  rbp*pow(rT,xrbp);\n"
"		else\n"
"			rbp_t	=  rbp*pow(rT,xrc);\n"
"		is_t	=  is*pow((pow(rT,xis)*exp(-ea*(1.0-rT)/Vtv)),(1.0/nf));\n"
"		isrr_t	=  isrr*pow((pow(rT,xisr)*exp(-dear*(1.0-rT)/Vtv)),(1.0/nr));\n"
"		isp_t	=  isp*pow((pow(rT,xis)*exp(-eap*(1.0-rT)/Vtv)),(1.0/nfp));\n"
"		ibei_t	=  ibei*pow((pow(rT,xii)*exp(-eaie*(1.0-rT)/Vtv)),(1.0/nei));\n"
"		iben_t	=  iben*pow((pow(rT,xin)*exp(-eane*(1.0-rT)/Vtv)),(1.0/nen));\n"
"		ibci_t	=  ibci*pow((pow(rT,xii)*exp(-eaic*(1.0-rT)/Vtv)),(1.0/nci));\n"
"		ibcn_t	=  ibcn*pow((pow(rT,xin)*exp(-eanc*(1.0-rT)/Vtv)),(1.0/ncn));\n"
"		ibeip_t	=  ibeip*pow((pow(rT,xii)*exp(-eaic*(1.0-rT)/Vtv)),(1.0/nci));\n"
"		ibenp_t	=  ibenp*pow((pow(rT,xin)*exp(-eanc*(1.0-rT)/Vtv)),(1.0/ncn));\n"
"		ibcip_t	=  ibcip*pow((pow(rT,xii)*exp(-eais*(1.0-rT)/Vtv)),(1.0/ncip));\n"
"		ibcnp_t	=  ibcnp*pow((pow(rT,xin)*exp(-eans*(1.0-rT)/Vtv)),(1.0/ncnp));\n"
"		nf_t	=  nf*(1.0+dT*tnf);\n"
"		nr_t	=  nr*(1.0+dT*tnf);\n"
"		avc2_t	=  avc2*(1.0+dT*tavc);\n"
"		vbbe_t	=  vbbe*(1.0+dT*(tvbbe1+dT*tvbbe2));\n"
"		nbbe_t	=  nbbe*(1.0+dT*tnbbe);\n"
"		`psibi(pe_t,pe,eaie,Vtv,rT);\n"
"		`psibi(pc_t,pc,eaic,Vtv,rT);\n"
"		`psibi(ps_t,ps,eais,Vtv,rT);\n"
"		cje_t	=  cje*pow(pe/pe_t,me);\n"
"		cjc_t	=  cjc*pow(pc/pc_t,mc);\n"
"		cjep_t	=  cjep*pow(pc/pc_t,mc);\n"
"		cjcp_t	=  cjcp*pow(ps/ps_t,ms);\n"
"		gamm_t	=  gamm*pow(rT,xis)*exp(-ea*(1.0-rT)/Vtv);\n"
"		vo_t	=  vo*pow(rT,xvo);\n"
"		ebbe_t	=  exp(-vbbe_t/(nbbe_t*Vtv));\n"
"		if (ibbe>0.0)\n"
"			maxvIbbe=  nbbe_t*Vtv*ln(ebbe_t+`PNJMAXI/ibbe);\n"
"		else\n"
"			maxvIbbe=  0.0;\n"
"		if (is_t>0.0)\n"
"			maxvIfi	=  nf_t*Vtv*ln(1.0+`PNJMAXI/is_t);\n"
"		else\n"
"			maxvIfi	=  0.0;\n"
"		if (is_t>0.0&&isrr_t>0.0)\n"
"			maxvIri	=  nr_t*Vtv*ln(1.0+`PNJMAXI/(is_t*isrr_t));\n"
"		else\n"
"			maxvIri	=  0.0;\n"
"		if (isp_t>0.0)\n"
"			maxvIp	=  nfp*Vtv*ln(1.0+`PNJMAXI/isp_t);\n"
"		else\n"
"			maxvIp	=  0.0;\n"
"		if (ibei_t>0.0)\n"
"			maxvIbei=  nei*Vtv*ln(1.0+`PNJMAXI/ibei_t);\n"
"		else\n"
"			maxvIbei=  0.0;\n"
"		if (iben_t>0.0)\n"
"			maxvIben=  nen*Vtv*ln(1.0+`PNJMAXI/iben_t);\n"
"		else\n"
"			maxvIben=  0.0;\n"
"		if (ibci_t>0.0)\n"
"			maxvIbci=  nci*Vtv*ln(1.0+`PNJMAXI/ibci_t);\n"
"		else\n"
"			maxvIbci=  0.0;\n"
"		if (ibcn_t>0.0)\n"
"			maxvIbcn=  ncn*Vtv*ln(1.0+`PNJMAXI/ibcn_t);\n"
"		else\n"
"			maxvIbcn=  0.0;\n"
"		if (ibeip_t>0.0)\n"
"			maxvIbeip=  nci*Vtv*ln(1.0+`PNJMAXI/ibeip_t);\n"
"		else\n"
"			maxvIbeip=  0.0;\n"
"		if (ibenp_t>0.0)\n"
"			maxvIbenp=  ncn*Vtv*ln(1.0+`PNJMAXI/ibenp_t);\n"
"		else\n"
"			maxvIbenp=  0.0;\n"
"		if (ibcip_t>0.0)\n"
"			maxvIbcip=  ncip*Vtv*ln(1.0+`PNJMAXI/ibcip_t);\n"
"		else\n"
"			maxvIbcip=  0.0;\n"
"		if (ibcnp_t>0.0)\n"
"			maxvIbcnp=  ncnp*Vtv*ln(1.0+`PNJMAXI/ibcnp_t);\n"
"		else\n"
"			maxvIbcnp=  0.0;\n"
"		VmaxExp	=  ln(maxexp);\n"
"\n"
"//\n"
"//	Parameter mappings\n"
"//\n"
"\n"
"		Gcx	=  rcx_t>1.0e-3 ? 1.0/rcx_t  : 1.0e3;\n"
"		Gci	=  rci_t>1.0e-3 ? 1.0/rci_t  : 1.0e3;\n"
"		Gbx	=  rbx_t>1.0e-3 ? 1.0/rbx_t  : 1.0e3;\n"
"		Gbi	=  rbi_t>1.0e-3 ? 1.0/rbi_t  : 1.0e3;\n"
"		Ge	=  re_t >1.0e-3 ? 1.0/re_t   : 1.0e3;\n"
"		Gbp	=  rbp_t>1.0e-3 ? 1.0/rbp_t  : 1.0e3;\n"
"		Gs	=  rs_t >1.0e-3 ? 1.0/rs_t   : 1.0e3;\n"
"		Gth	=  rth  >1.0e-3 ? 1.0/rth    : 1.0e3;\n"
"		Ivef	=  vef  >0.0    ? 1.0/vef    : 0.0;\n"
"		Iver	=  ver  >0.0    ? 1.0/ver    : 0.0;\n"
"		Iikf	=  ikf  >0.0    ? 1.0/ikf_t  : 0.0;\n"
"		Iikr	=  ikr  >0.0    ? 1.0/ikr    : 0.0;\n"
"		Iikp	=  ikp  >0.0    ? 1.0/ikp    : 0.0;\n"
"		Ivo	=  vo   >0.0    ? 1.0/vo_t   : 0.0;\n"
"		Ihrcf	=  hrcf >0.0    ? 1.0/hrcf   : 0.0;\n"
"		Ivtf	=  vtf  >0.0    ? 1.0/vtf    : 0.0;\n"
"		Iitf	=  itf  >0.0    ? 1.0/itf    : 0.0;\n"
"		sltf	=  itf  >0.0    ? 0.0        : 1.0;\n"
"\n"
"//\n"
"//	Branch voltages\n"
"//\n"
"\n"
"		Vbei	=  VBICtype*V(b_bei);\n"
"		Vbex	=  VBICtype*V(b_bex);\n"
"		Vbci	=  VBICtype*V(b_bci);\n"
"		Vbcx	=  VBICtype*V(b_bcx);\n"
"		Vcei	=  VBICtype*V(b_cei);\n"
"		Vbep	=  VBICtype*V(b_bep);\n"
"		Vbcp	=  VBICtype*V(b_bcp);\n"
"		Vcep	=  VBICtype*V(b_cep);\n"
"		Vxf1	=           V(b_xf1);\n"
"		Vxf2	=           V(b_xf2);\n"
"		Vbe	=           V(b_be);\n"
"		Vbc	=           V(b_bc);\n"
"		Vrcx	=           V(b_rcx);\n"
"		Vrci	=  VBICtype*V(b_rci);\n"
"		Vrbx	=           V(b_rbx);\n"
"		Vrbi	=           V(b_rbi);\n"
"		Vre	=           V(b_re);\n"
"		Vrbp	=           V(b_rbp);\n"
"		Vrs	=           V(b_rs);\n"
"\n"
"//\n"
"//	Electrical branch constituent relations\n"
"//\n"
"\n"
"//\n"
"//	Depletion charges\n"
"//\n"
"\n"
"		`qj(qdbe,Vbei,pe_t,me,fc,aje);\n"
"		`qj(qdbex,Vbex,pe_t,me,fc,aje);\n"
"		`qjrt(qdbc,Vbci,pc_t,mc,fc,ajc,vrt,art);\n"
"		`qjrt(qdbep,Vbep,pc_t,mc,fc,ajc,vrt,art);\n"
"		if (cjcp>0.0) begin\n"
"			`qj(qdbcp,Vbcp,ps_t,ms,fc,ajs);\n"
"		end else\n"
"			qdbcp	=  0.0;\n"
"\n"
"//\n"
"//	Transport current of main transistor\n"
"//\n"
"\n"
"		afac	=  1.0/(nf_t*Vtv);\n"
"		`expLinA(expi,Vbei,maxvIfi,afac);\n"
"		Ifi	=  is_t*(expi-1.0);\n"
"		afac	=  1.0/(nr_t*Vtv);\n"
"		`expLinA(expi,Vbci,maxvIri,afac);\n"
"		Iri	=  is_t*isrr_t*(expi-1.0);\n"
"		q1z	=  1.0+qdbe*Iver+qdbc*Ivef;\n"
"		q1	=  0.5*(sqrt((q1z-1.0e-4)*(q1z-1.0e-4)+1.0e-8)+q1z-1.0e-4)+1.0e-4;\n"
"		q2	=  Ifi*Iikf+Iri*Iikr;\n"
"		if (qbm<0.5) begin\n"
"			arg	=  pow(q1,1.0/nkf)+4.0*q2;\n"
"			if (arg>1.0e-8)\n"
"				qb	=  0.5*(q1+pow(arg,nkf));\n"
"			else\n"
"				qb	=  0.5*(q1+pow(1.0e-8,nkf));\n"
"		end else begin\n"
"			arg	=  1.0+4.0*q2;\n"
"			if (arg>1.0e-8)\n"
"				qb	=  0.5*q1*(1.0+pow(arg,nkf));\n"
"			else\n"
"				qb	=  0.5*q1*(1.0+pow(1.0e-8,nkf));\n"
"		end\n"
"		Itzr	=  Iri/qb;\n"
"		Itzf	=  Ifi/qb;\n"
"		Itxf	=  Vxf2;\n"
"\n"
"//\n"
"//	Transport current of parasitic transistor\n"
"//\n"
"\n"
"		if (isp>0.0) begin\n"
"			afac	=  1.0/(nfp*Vtv);\n"
"			`expLinA(expi,Vbep,maxvIp,afac);\n"
"			`expLinA(expx,Vbci,maxvIp,afac);\n"
"			Ifp	=  isp_t*(wsp*expi+(1.0-wsp)*expx-1.0);\n"
"			q2p	=  Ifp*Iikp;\n"
"			arg	=  1.0+4.0*q2p;\n"
"			if (arg>1.0e-8)\n"
"				qbp	=  0.5*(1.0+sqrt(arg));\n"
"			else\n"
"				qbp	=  0.5*(1.0+sqrt(1.0e-8));\n"
"			`expLinA(expi,Vbcp,maxvIp,afac);\n"
"			Irp	=  isp_t*(expi-1.0);\n"
"			Iccp	=  (Ifp-Irp)/qbp;\n"
"		end else begin\n"
"			Ifp	=  0.0;\n"
"			qbp	=  1.0;\n"
"			Iccp	=  0.0;\n"
"		end\n"
"\n"
"//\n"
"//	Diode-like currents for main transistor (includes\n"
"//	exponential-like breakdown for base-emitter)\n"
"//	and base-emitter of parasitic transistor\n"
"//\n"
"\n"
"		if (wbe==1.0) begin\n"
"			afac	=  1.0/(nei*Vtv);\n"
"			`expLinA(expi,Vbei,maxvIbei,afac);\n"
"			afac	=  1.0/(nen*Vtv);\n"
"			`expLinA(expn,Vbei,maxvIben,afac);\n"
"			if (vbbe>0.0) begin\n"
"				Bvbe	=  -vbbe_t-Vbei;\n"
"				afac	=  1.0/(nbbe_t*Vtv);\n"
"				`expLinA(expx,Bvbe,maxvIbbe,afac);\n"
"				Ibe	=  ibei_t*(expi-1.0)+iben_t*(expn-1.0)-ibbe*(expx-ebbe_t);\n"
"			end else\n"
"				Ibe	=  ibei_t*(expi-1.0)+iben_t*(expn-1.0);\n"
"			Ibex	=  0.0;\n"
"		end else if (wbe==0.0) begin\n"
"			Ibe	=  0.0;\n"
"			afac	=  1.0/(nei*Vtv);\n"
"			`expLinA(expi,Vbex,maxvIbei,afac);\n"
"			afac	=  1.0/(nen*Vtv);\n"
"			`expLinA(expn,Vbex,maxvIben,afac);\n"
"			if (vbbe>0.0) begin\n"
"				Bvbe	=  -vbbe_t-Vbei;\n"
"				afac	=  1.0/(nbbe_t*Vtv);\n"
"				`expLinA(expx,Bvbe,maxvIbbe,afac);\n"
"				Ibex	=  ibei_t*(expi-1.0)+iben_t*(expn-1.0)-ibbe*(expx-ebbe_t);\n"
"			end else\n"
"				Ibex	=  ibei_t*(expi-1.0)+iben_t*(expn-1.0);\n"
"		end else begin\n"
"			afac	=  1.0/(nei*Vtv);\n"
"			`expLinA(expi,Vbei,maxvIbei,afac);\n"
"			afac	=  1.0/(nen*Vtv);\n"
"			`expLinA(expn,Vbei,maxvIben,afac);\n"
"			if (vbbe>0.0) begin\n"
"				Bvbe	=  -vbbe_t-Vbei;\n"
"				afac	=  1.0/(nbbe_t*Vtv);\n"
"				`expLinA(expx,Bvbe,maxvIbbe,afac);\n"
"				Ibe	=  wbe*(ibei_t*(expi-1.0)+iben_t*(expn-1.0)-ibbe*(expx-ebbe_t));\n"
"			end else\n"
"				Ibe	=  wbe*(ibei_t*(expi-1.0)+iben_t*(expn-1.0));\n"
"			afac	=  1.0/(nei*Vtv);\n"
"			`expLinA(expi,Vbex,maxvIbei,afac);\n"
"			afac	=  1.0/(nen*Vtv);\n"
"			`expLinA(expn,Vbex,maxvIben,afac);\n"
"			if (vbbe>0.0) begin\n"
"				Bvbe	=  -vbbe_t-Vbei;\n"
"				afac	=  1.0/(nbbe_t*Vtv);\n"
"				`expLinA(expx,Bvbe,maxvIbbe,afac);\n"
"				Ibex	=  (1.0-wbe)*(ibei_t*(expi-1.0)+iben_t*(expn-1.0)-ibbe*(expx-ebbe_t));\n"
"			end else\n"
"				Ibex	=  (1.0-wbe)*(ibei_t*(expi-1.0)+iben_t*(expn-1.0));\n"
"		end\n"
"		afac	=  1.0/(nci*Vtv);\n"
"		`expLinA(expi,Vbci,maxvIbci,afac);\n"
"		afac	=  1.0/(ncn*Vtv);\n"
"		`expLinA(expn,Vbci,maxvIbcn,afac);\n"
"		Ibcj	=  ibci_t*(expi-1.0)+ibcn_t*(expn-1.0);\n"
"		if ((ibeip>0.0)||(ibenp>0.0)) begin\n"
"			afac	=  1.0/(nci*Vtv);\n"
"			`expLinA(expi,Vbep,maxvIbeip,afac);\n"
"			afac	=  1.0/(ncn*Vtv);\n"
"			`expLinA(expn,Vbep,maxvIbenp,afac);\n"
"			Ibep	=  ibeip_t*(expi-1.0)+ibenp_t*(expn-1.0);\n"
"		end else\n"
"			Ibep	=  0.0;\n"
"\n"
"//\n"
"//	Avalanche current\n"
"//\n"
"\n"
"		if (avc1>0.0) begin\n"
"			`avalm(avalf,Vbci,pc_t,mc,avc1,avc2_t,VmaxExp);\n"
"			Igc	=  (Itxf-Itzr-Ibcj)*avalf;\n"
"		end else\n"
"			Igc	=  0.0;\n"
"		Ibc	=  Ibcj-Igc;\n"
"\n"
"//\n"
"//	Base pushout charge factors\n"
"//\n"
"\n"
"		arg	=  Vbci/Vtv;\n"
"		`expLin(expi,arg,VmaxExp);\n"
"		arg	=  Vbcx/Vtv;\n"
"		`expLin(expx,arg,VmaxExp);\n"
"		Kbci	=  sqrt(1.0+gamm_t*expi);\n"
"		Kbcx	=  sqrt(1.0+gamm_t*expx);\n"
"\n"
"//\n"
"//	Diode-like current for base-collector of parasitic transistor\n"
"//\n"
"\n"
"		if ((ibcip>0.0)||(ibcnp>0.0)) begin\n"
"			afac	=  1.0/(ncip*Vtv);\n"
"			`expLinA(expi,Vbcp,maxvIbcip,afac);\n"
"			afac	=  1.0/(ncnp*Vtv);\n"
"			`expLinA(expn,Vbcp,maxvIbcnp,afac);\n"
"			Ibcp	=  ibcip_t*(expi-1.0)+ibcnp_t*(expn-1.0);\n"
"		end else\n"
"			Ibcp	=  0.0;\n"
"\n"
"//\n"
"//	Transit time\n"
"//\n"
"\n"
"		sgIf	=  Ifi>0.0?1.0:0.0;\n"
"		rIf	=  Ifi*sgIf*Iitf;\n"
"		mIf	=  rIf/(rIf+1.0);\n"
"		arg	=  Vbci*Ivtf/1.44;\n"
"		`expLin(expi,arg,VmaxExp);\n"
"		tff	=  tf*(1.0+qtf*q1)*(1.0+xtf*expi*(sltf+mIf*mIf)*sgIf);\n"
"\n"
"//\n"
"//	Charge elements\n"
"//\n"
"\n"
"		Qbe	=  cje_t*qdbe*wbe+tff*Ifi/qb;\n"
"		Qbex	=  cje_t*qdbex*(1.0-wbe);\n"
"		Qbc	=  cjc_t*qdbc+tr*Iri+qco*Kbci;\n"
"		Qbcx	=  qco*Kbcx;\n"
"		Qbep	=  cjep_t*qdbep+tr*Ifp;\n"
"		Qbcp	=  cjcp_t*qdbcp+ccso*Vbcp;\n"
"		Qbeo	=  Vbe*cbeo;\n"
"		Qbco	=  Vbc*cbco;\n"
"\n"
"//\n"
"//	Resistance branch currents\n"
"//\n"
"\n"
"		Ircx	=  Vrcx*Gcx;\n"
"		rKp1	=  (Kbci+1.0)/(Kbcx+1.0);\n"
"		Iohm	=  (Vrci+Vtv*(Kbci-Kbcx-ln(rKp1)))*Gci;\n"
"		derf	=  Ivo*Iohm/(Gci*(1.0+0.5*Ivo*Ihrcf*sqrt(Vrci*Vrci+0.01)));\n"
"		Irci	=  Iohm/sqrt(1+derf*derf);\n"
"		Irbx	=  Vrbx*Gbx;\n"
"		Irbi	=  Vrbi*qb*Gbi;\n"
"		Ire	=  Vre*Ge;\n"
"		Irbp	=  Vrbp*qbp*Gbp;\n"
"		Irs	=  Vrs*Gs;\n"
"\n"
"//\n"
"//	Thermal network elements\n"
"//\n"
"\n"
"			Ith	= -(Ibe*Vbei+Ibc*Vbci+(Itxf-Itzr)*Vcei+Ibex*Vbex+Ibep*Vbep+Irs*Vrs+Ibcp*Vbcp+Iccp*Vcep+Ircx*Vrcx+Irci*Vrci+Irbx*Vrbx+Irbi*Vrbi+Ire*Vre+Irbp*Vrbp);\n"
"		Irth	=  Vrth*Gth;\n"
"		Qcth	=  Vrth*cth;\n"
"\n"
"//\n"
"//	Excess phase elements\n"
"//\n"
"\n"
"		Ixf1	=  Vxf2-Itzf;\n"
"		Ixf2	=  Vxf2-Vxf1;\n"
"		Qxf1	=  td*Vxf1;\n"
"		Qxf2	=  td*Vxf2/3;\n"
"\n"
"//\n"
"//	Add gmin current to diode-like branches\n"
"//\n"
"\n"
"		Ibe	=  Ibe  + `GMIN * Vbei;\n"
"		Ibex	=  Ibex + `GMIN * Vbex;\n"
"		Ibep	=  Ibep + `GMIN * Vbep;\n"
"		Ibc	=  Ibc  + `GMIN * Vbci;\n"
"		Ibcp	=  Ibcp + `GMIN * Vbcp;\n"
"\n"
"//\n"
"//	Apply multiplicity factor and device type (+1 or -1, polarity)\n"
"//	(resistors apart from Irci do not depend on polarity)\n"
"//\n"
"\n"
"		Ibe	=  VBICtype * meff * Ibe;\n"
"		Ibex	=  VBICtype * meff * Ibex;\n"
"		Itzf	=  VBICtype * meff * Itzf;\n"
"		Itxf	=  VBICtype * meff * Itxf;\n"
"		Itzr	=  VBICtype * meff * Itzr;\n"
"		Ibc	=  VBICtype * meff * Ibc;\n"
"		Ibep	=  VBICtype * meff * Ibep;\n"
"		Ircx	=             meff * Ircx;\n"
"		Irci	=  VBICtype * meff * Irci;\n"
"		Irbx	=             meff * Irbx;\n"
"		Irbi	=             meff * Irbi;\n"
"		Ire	=             meff * Ire;\n"
"		Irbp	=             meff * Irbp;\n"
"		Qbe	=  VBICtype * meff * Qbe;\n"
"		Qbex	=  VBICtype * meff * Qbex;\n"
"		Qbc	=  VBICtype * meff * Qbc;\n"
"		Qbcx	=  VBICtype * meff * Qbcx;\n"
"		Qbep	=  VBICtype * meff * Qbep;\n"
"		Qbeo	=             meff * Qbeo;\n"
"		Qbco	=             meff * Qbco;\n"
"		Ibcp	=  VBICtype * meff * Ibcp;\n"
"		Iccp	=  VBICtype * meff * Iccp;\n"
"		Irs	=             meff * Irs;\n"
"		Qbcp	=  VBICtype * meff * Qbcp;\n"
"		Ith	=             meff * Ith;\n"
"		Irth	=             meff * Irth;\n"
"		Qcth	=             meff * Qcth;\n"
"\n"
"//\n"
"//	Branch contributions to VBIC model\n"
"//\n"
"\n"
"		I(b_bei) <+ Ibe;\n"
"		I(b_bex) <+ Ibex;\n"
"		I(b_cei) <+ Itxf;\n"
"		I(b_eci) <+ Itzr;\n"
"		I(b_bci) <+ Ibc;\n"
"		I(b_bep) <+ Ibep;\n"
"		I(b_rcx) <+ Ircx;\n"
"		I(b_rci) <+ Irci;\n"
"		I(b_rbx) <+ Irbx;\n"
"		I(b_rbi) <+ Irbi;\n"
"		I(b_re)  <+ Ire;\n"
"		I(b_rbp) <+ Irbp;\n"
"		I(b_bei) <+ ddt(Qbe);\n"
"		I(b_bex) <+ ddt(Qbex);\n"
"		I(b_bci) <+ ddt(Qbc);\n"
"		I(b_bcx) <+ ddt(Qbcx);\n"
"		I(b_bep) <+ ddt(Qbep);\n"
"		I(b_be)  <+ ddt(Qbeo);\n"
"		I(b_bc)  <+ ddt(Qbco);\n"
"		I(b_bcp) <+ Ibcp;\n"
"		I(b_cep) <+ Iccp;\n"
"		I(b_rs)  <+ Irs;\n"
"		I(b_bcp) <+ ddt(Qbcp);\n"
"		I(b_xf1) <+ Ixf1;\n"
"		I(c_xf1) <+ ddt(Qxf1);\n"
"		I(b_xf2) <+ Ixf2;\n"
"		I(c_xf2) <+ ddt(Qxf2);\n"
"		I(b_rth) <+ Irth;\n"
"		I(b_rth) <+ ddt(Qcth);\n"
"		I(b_ith) <+ Ith;\n"
"\n"
"`ifdef insideADMS\n"
"`else\n"
"	// <noise>\n"
"	begin	// begin noise block\n"
"		I(b_bei) <+ white_noise(2*`QQ*abs(Ibe))+flicker_noise(meff*kfn*pow(abs(Ibe/meff),afn),bfn);\n"
"		I(b_bex) <+ white_noise(2*`QQ*abs(Ibex))+flicker_noise(meff*kfn*pow(abs(Ibex/meff),afn),bfn);\n"
"		I(b_cei) <+ white_noise(2*`QQ*abs(Itzf));\n"
"		I(b_bep) <+ white_noise(2*`QQ*abs(Ibep))+flicker_noise(meff*kfn*pow(abs(Ibep/meff),afn),bfn);\n"
"		I(b_rcx) <+ white_noise(4*`KB*Tdev*Gcx*meff);\n"
"		I(b_rci) <+ white_noise(4*`KB*Tdev*((abs(Irci)+1.0e-10*Gci)/(abs(Vrci)+1.0e-10))*meff);\n"
"		I(b_rbx) <+ white_noise(4*`KB*Tdev*Gbx*meff);\n"
"		I(b_rbi) <+ white_noise(4*`KB*Tdev*qb*Gbi*meff);\n"
"		I(b_re)  <+ white_noise(4*`KB*Tdev*Ge*meff);\n"
"		I(b_rbp) <+ white_noise(4*`KB*Tdev*qbp*Gbp*meff);\n"
"		I(b_cep) <+ white_noise(2*`QQ*abs(Iccp));\n"
"		I(b_rs)  <+ white_noise(4*`KB*Tdev*Gs*meff);\n"
"	end	// end noise block\n"
"	// </noise>\n"
"`endif\n"
"\n"
"	`FINAL_STEP\n"
"	begin\n"
"\n"
"		// conductances of resistance elements\n"
"		Ircx_Vrcx = `DERIVATE(Ircx,V(b_rcx));\n"
"		Irci_Vrci = `DERIVATE(Irci,V(b_rci));\n"
"		Irbx_Vrbx = `DERIVATE(Irbx,V(b_rbx));\n"
"		Irbi_Vrbi = `DERIVATE(Irbi,V(b_rbi));\n"
"		Irbp_Vrbp = `DERIVATE(Irbp,V(b_rbp));\n"
"		Ire_Vre   = `DERIVATE(Ire,V(b_re));\n"
"		Irs_Vrs   = `DERIVATE(Irs,V(b_rs));\n"
"\n"
"		// conductances\n"
"		gm     = `DERIVATE(Itzf,V(b_bei))+`DERIVATE(Itzf,V(b_bci))-`DERIVATE(Itzr,V(b_bei))-`DERIVATE(Itzr,V(b_bci));\n"
"		go     = `DERIVATE(Itzr,V(b_bci))-`DERIVATE(Itzf,V(b_bci));\n"
"		gpi    = `DERIVATE(Ibe,V(b_bei));\n"
"		gpix   = `DERIVATE(Ibex,V(b_bex));\n"
"		gmu    = `DERIVATE(Ibc,V(b_bci));\n"
"		gmux   = `DERIVATE(Ibep,V(b_bep));\n"
"\n"
"		// conductances (for backward compatibility with level 2)\n"
"		ibc_vbci	= gmu;\n"
"		ibcp_vbcp	= `DERIVATE(Ibcp,V(b_bcp));\n"
"		ibe_vbei	= gpi;\n"
"		ibep_vbep	= gmux;\n"
"		ibex_vbex	= gpix;\n"
"		iccp_vbci	= `DERIVATE(Iccp,V(b_bci));\n"
"		iccp_vbcp	= `DERIVATE(Iccp,V(b_bcp));\n"
"		iccp_vbep	= `DERIVATE(Iccp,V(b_bep));\n"
"		irbi_vbci	= `DERIVATE(Irbi,V(b_bci));\n"
"		irbi_vbei	= `DERIVATE(Irbi,V(b_bei));\n"
"		irbp_vbci	= `DERIVATE(Irbp,V(b_bci));\n"
"		irci_vbci	= `DERIVATE(Irci,V(b_bci));\n"
"		itzf_vbci	= `DERIVATE(Itzf,V(b_bci));\n"
"		itzf_vbei	= `DERIVATE(Itzf,V(b_bei));\n"
"		itzr_vbci	= `DERIVATE(Itzr,V(b_bci));\n"
"		itzr_vbei	= `DERIVATE(Itzr,V(b_bei));\n"
"\n"
"		// capacitances\n"
"		cpi    = `DERIVATE(Qbe,V(b_bei));\n"
"		cpix   = `DERIVATE(Qbex,V(b_bex));\n"
"		cmu    = `DERIVATE(Qbc,V(b_bci));\n"
"		cmux   = `DERIVATE(Qbcx,V(b_bcx));\n"
"		cpip   = `DERIVATE(Qbep,V(b_bep));\n"
"		ccs    = `DERIVATE(Qbcp,V(b_bcp));\n"
"		cbeoXX = `DERIVATE(Qbeo,V(b_be));\n"
"		cbcoXX = `DERIVATE(Qbco,V(b_bc));\n"
"\n"
"		// crude estimate of ft, intrinsic component just has\n"
"		// overlap capacitances added, and the extrinsic ft\n"
"		// will be affected by extrinsic elements like Rc*Cc,\n"
"		// proper terminal simulations are needed to get the\n"
"		// actual ft, this is just an estimate: gm/(2*pi*Cbase)\n"
"		ft_int = 0.1591549*abs(gm)/(1.0e-20+abs(cpi+cpix+cmu+cmux+cpip+cbeoXX+cbcoXX));\n"
"\n"
"		// capacitances (for backward compatibility with level 2)\n"
"		qbc_vbci  = cmu;\n"
"		qbco_vbc  = cbcoXX;\n"
"		qbcp_vbcp = ccs;\n"
"		qbcx_vbcx = `DERIVATE(Qbcx,V(b_bcx));	// not equivalent to level 2, Vbcx=Vbci-Vrcx\n"
"		qbe_vbci  = `DERIVATE(Qbe,V(b_bci));\n"
"		qbe_vbei  = cpi;\n"
"		qbeo_vbe  = cbeoXX;\n"
"		qbep_vbci = `DERIVATE(Qbep,V(b_bci));\n"
"		qbep_vbep = cpip;\n"
"		qbex_vbex = cpix;\n"
"\n"
"\n"
"		// resistances\n"
"		rci_mod = Gci/((abs(Irci)+1.0e-10*Gci)/(abs(Vrci)+1.0e-10));\n"
"		rci_eff = `DERIVATE(Irci,V(b_rci));\n"
"                rci_eff = (rci_eff==0)?rci_eff:(1/rci_eff);\n"
"		rbi_eff = (qb*Gbi);\n"
"                rbi_eff = (rbi_eff==0)?rbi_eff:((1/rbi_eff)/meff);\n"
"		rbp_eff = (qbp*Gbp);\n"
"                rbp_eff = (rbp_eff==0)?rbp_eff:((1/rbp_eff)/meff);\n"
"\n"
"		// terminal currents\n"
"		ic   = Itzf - Itzr - Ibc - Ibcp - Ibep;\n"
"		ib   = Ibe + Ibex + Ibc + Ibep + Iccp;\n"
"		ie   = -Itzf + Itzr - Ibe - Ibex;\n"
"		isub = -ic - ib - ie;\n"
"		ic   = VBICtype * ic;\n"
"		ib   = VBICtype * ib;\n"
"		ie   = VBICtype * ie;\n"
"		isub = VBICtype * isub;\n"
"\n"
"		// power currents\n"
"		powerT =-Ith;\n"
"		powerD = Irth;\n"
"		tauTh  = cth/Gth;\n"
"\n"
"		// power currents (for backward compatibility with level 2)\n"
"		p = powerT;\n"
"\n"
"		// power currents (for backward compatibility with level 2)\n"
"		trise = dtemp;\n"
"\n"
"		// terminal voltages\n"
"		Vce = V(b_be)-V(b_bc);\n"
"\n"
"	end\n"
"\n"
"	end\n"
"endmodule\n"
;
