#ifndef COMPAT_H_fogjseogje4
#define COMPAT_H_fogjseogje4 1

#include <sys/types.h>
#include <stdarg.h>

#include "config.h"

#include "compat_vis.h"

#if !HAVE_PLEDGE
# define pledge(x, y) 0
#endif

#if !HAVE_UNVEIL
# define unveil(x, y) 0
#endif

#if !HAVE_REALLOCARRAY
void *reallocarray(void *ptr, size_t nmemb, size_t size);
#endif

#if !HAVE_RECALLOCARRAY
void *recallocarray(void *ptr, size_t oldnmemb, size_t nmemb, size_t size);
#endif

#if HAVE_ERR_H
# include <err.h>
#else
void err(int, const char*, ...);
void warn(const char*, ...);
void errx(int, const char*, ...);
void warnx(const char*, ...);
void vwarnx(const char*, va_list);
#endif

#if !HAVE_ASPRINTF
int asprintf(char **, const char *, ...);
#endif

#if !HAVE_VASPRINTF
int vasprintf(char **, const char *, va_list);
#endif

#if !HAVE_STRLCAT
size_t strlcat(char *, const char *, size_t);
#endif

#if !HAVE_STRTONUM
long long strtonum(const char *, long long, long long, const char **);
#endif

#endif /* COMPAT_H_fogjseogje4 */
