/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include "printdialog.h"
#include "inputbox.h"
#include "entrypop.h"
#include "main.h"
#include "button.h"

Widget tofile, center, portrait;
Entry_Pop *magnifpop, *copiespop, *paperpop;

static char *printpane[] = {
  "Print",
  "Page",
  "Margin",
  "Top/Bottom",
  "Worksheet",
};

void
X11m_print ()
{
  display_prompt (td3, gettop ());
}

void
doprint ()
{
  char *filename = NULL;
  char *language = "ps";
  int vcenter = 1;
  int vportrait = 1;
  char *paper;
  int multiplepage = 1;
  double magnification = 1.0;
  int copies = 1;
  double xshift = 0;
  double yshift = 0;

  int print2file = getcheck (tofile);
  vportrait = getcheck (portrait);
  vcenter = getcheck (center);
  magnification = entrypop_getvalue (magnifpop);
  copies = entrypop_getvalue (copiespop);
  paper = entrypop_gettext (paperpop);

  if (print2file)
    filename = inputbox ("File name:", "Print to File", "output.fig");
  printfile (filename, language, vcenter, vportrait, paper, multiplepage,
	     magnification, copies, xshift, yshift);
}

void
initprintdial ()
{

}

int
make_print_dial ()
{
  Widget /*viewport, viewport2, viewport3, viewport4, list, label1, */ sel
    /*,wks,wkb */ ;
  Widget landscape;
  Widget /*adjust, */ reduce;
  Widget flushtl;
  Widget base;
  Entry_Pop *pop;

  td3 =
    CreateThumbDialog (gettop (), XtNumber (printpane), printpane, doprint,
		       initprintdial);

  base = get_base (td3);

  addpanechild (td3, 0, CreateLabel (base, "Printer:", 20, 55, 60, 20));

  pop = newentrypop (base, "printerpop", popdown, 200, 20);
  w_n = 0;
  w_rel (NULL, 100, 55);
  w_set (pop->baseform);
  addpanechild (td3, 0, pop->baseform);
  entrypop_add_item (pop, "default postscript");
  entrypop_add_item (pop, "fig format file");
  entrypop_init_val (pop, "fig format file");

  addpanechild (td3, 0, CreateLabel (base, "Print to File", 20, 95, 100, 20));
  w_n = 0;
  w_rel (NULL, 120, 95);
  tofile = (Widget) make_check (base, "to file", NULL, (caddr_t) td3);
  w_set (tofile);
  setcheck (tofile, 1);
  addpanechild (td3, 0, tofile);

  addpanechild (td3, 0, CreateLabel (base, "Print", 20, 120, 100, 20));

  addpanechild (td3, 0, CreateLabel (base, "Selection", 50, 145, 80, 20));
  sel = (Widget) make_radio (base, "selection", NULL, NULL, NULL);
  w_n = 0;
  w_rel (NULL, 20, 145);
  XtSetValues (sel, w_args, w_n);
  addpanechild (td3, 0, sel);

  addpanechild (td3, 0,
		CreateLabel (base, "Number of copies:", 175, 145, 120, 20));
  copiespop = newentrypop (base, "copiespop", roll, 50, 20);
  entrypop_setrange (copiespop, 1, 1, 1, 32000);
  w_n = 0;
  w_rel (NULL, 305, 145);
  w_set (copiespop->baseform);
  addpanechild (td3, 0, copiespop->baseform);

  addpanechild (td3, 1, CreateLabel (base, "Orientation", 20, 35, 80, 20));

  addpanechild (td3, 1, CreateLabel (base, "Portrait", 50, 70, 80, 20));
  portrait = (Widget) make_radio (base, "portrait", NULL, NULL, NULL);
  w_n = 0;
  w_rel (NULL, 30, 70);
  XtSetValues (portrait, w_args, w_n);
  addpanechild (td3, 1, portrait);

  addpanechild (td3, 1, CreateLabel (base, "Landscape", 250, 70, 80, 20));
  landscape = (Widget) make_radio (base, "landscape", portrait, NULL, NULL);
  w_n = 0;
  w_rel (NULL, 230, 70);
  XtSetValues (landscape, w_args, w_n);
  addpanechild (td3, 1, landscape);

  addpanechild (td3, 1, CreateLabel (base, "Scale", 20, 100, 80, 20));

  reduce = (Widget) make_radio (base, "reduce", NULL, NULL, NULL);
  w_n = 0;
  w_rel (NULL, 40, 125);
  XtSetValues (reduce, w_args, w_n);
  addpanechild (td3, 1, reduce);
  addpanechild (td3, 1,
		CreateLabel (base, "Reduce/enlarge to:", 60, 125, 140, 20));
  magnifpop = newentrypop (base, "scalepop", roll, 50, 20);
  entrypop_setrange (magnifpop, 100, 5, 1, 4000);
  w_n = 0;
  w_rel (NULL, 190, 125);
  w_set (magnifpop->baseform);
  addpanechild (td3, 1, magnifpop->baseform);
  addpanechild (td3, 1,
		CreateLabel (base, "% of the normal size", 260, 125, 180,
			     20));

  addpanechild (td3, 1, CreateLabel (base, "Paper size:", 20, 190, 80, 20));
  paperpop = newentrypop (base, "papersize", popdown, 200, 20);
  entrypop_add_item (paperpop, "A0 (84.1cm x 118.9cm)");
  entrypop_add_item (paperpop, "A1 (59.4cm x  84.1cm)");
  entrypop_add_item (paperpop, "A2 (42  cm x  59.4cm)");
  entrypop_add_item (paperpop, "A3 (29.7cm x  42 cm)");
  entrypop_add_item (paperpop, "A4 (21cm x 29.7cm)");
  entrypop_add_item (paperpop, "B5 (18.2cm x 25.7cm)");
  entrypop_add_item (paperpop, "Ledger (11\" x 17\")");
  entrypop_add_item (paperpop, "Legal (11\" x 14\")");
  entrypop_add_item (paperpop, "Letter  (8.5\" x 11\")");
  entrypop_init_val (paperpop, "A4 (21cm x 29.7cm)");
  w_n = 0;
  w_rel (NULL, 120, 190);
  w_set (paperpop->baseform);
  addpanechild (td3, 1, paperpop->baseform);

  addpanechild (td3, 2, CreateLabel (base, "Position", 20, 35, 80, 20));

  addpanechild (td3, 2,
		CreateLabel (base, "Center on page", 50, 70, 130, 20));
  center = (Widget) make_radio (base, "center", NULL, NULL, NULL);
  w_n = 0;
  w_rel (NULL, 30, 70);
  XtSetValues (center, w_args, w_n);
  addpanechild (td3, 2, center);

  addpanechild (td3, 2,
		CreateLabel (base, "Flush top/left", 250, 70, 120, 20));
  flushtl = (Widget) make_radio (base, "flush", center, NULL, NULL);
  w_n = 0;
  w_rel (NULL, 230, 70);
  XtSetValues (flushtl, w_args, w_n);
  addpanechild (td3, 2, flushtl);

  activepane (td3, 0);

  return 0;

}
