/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include "plotdialog.h"
#include "application.h"
#include "main.h"
#include "callback.h"
#include "button.h"
#include "graph.h"
#include "param.h"
#include "mydialog.h"
#include "grap.xpm"

static char *plot_type[] = {
  "XY         ",
  "Pie        ",
  "Bar        ",
  "           ",
  "           ",
};
static char *plotpane[] = {
  "type",
  "range",
  "labels",
  "grid",
  "axis",
};

static char *serie[] = {
  "X",
  "Y1",
  "Y2",
  "Y3",
  "Y4",
  "Y5",
  "Y6",
  "Y7",
  "                     ",
};

static int selectedtype = -1;
static int previousrange = 1;

extern Widget gettop ();

ThumbDialog *td2;
Widget plottype;
Widget typelist;
Widget range;
Widget ranges;
Widget seriename;
Widget titre1;
Widget Xaxis;
Widget Yaxis;
Widget btn;
Widget btn2;
Widget btn3;
Widget btn4;
Widget btn5;
Widget hgrid;
Widget vgrid;
Widget ymax, ymin, yunit, xmax, xmin, xunit;
Widget ymaxv, yminv, yunitv, xmaxv, xminv, xunitv;

void
X11m_plottype ()
{
  selectedtype = -1;
  activepane (td2, 0);
  display_prompt (td2, gettop ());
}

void
X11m_plotdata ()
{
  selectedtype = -1;
  activepane (td2, 1);
  display_prompt (td2, gettop ());
}

void
X11m_plotoption ()
{
  char *buf;
  char name[32];
  char buf1[32];
  int serie;
  Arg arglist[1];
  selectedtype = -1;

  if (ActiveGraph == NULL)
    return;

  buf = (char *) gettitre1 ();
  if (buf != NULL)
    {
      XtSetArg (arglist[0], XtNstring, buf);
      XtSetValues (titre1, arglist, 1);
    }
  else
    {
      XtSetArg (arglist[0], XtNstring, "");
      XtSetValues (titre1, arglist, 1);
    }

  buf = (char *) getXaxis ();
  if (buf != NULL)
    {
      XtSetArg (arglist[0], XtNstring, buf);
      XtSetValues (Xaxis, arglist, 1);
    }
  else
    {
      XtSetArg (arglist[0], XtNstring, "");
      XtSetValues (Xaxis, arglist, 1);
    }

  buf = (char *) getYaxis ();
  if (buf != NULL)
    {
      XtSetArg (arglist[0], XtNstring, buf);
      XtSetValues (Yaxis, arglist, 1);
    }
  else
    {
      XtSetArg (arglist[0], XtNstring, "");
      XtSetValues (Yaxis, arglist, 1);
    }

  serie = 1;
  XawListHighlight (ranges, serie - 1);
  getrange (serie, buf1, name);
  if (buf1 != NULL)
    {
      XtSetArg (arglist[0], XtNstring, &buf1);
      XtSetValues (range, arglist, 1);
    }

  if (name != NULL)
    {
      XtSetArg (arglist[0], XtNstring, &name);
      XtSetValues (seriename, arglist, 1);
    }

  if (ActiveGraph != NULL)
    {
      setcheck (vgrid, ActiveGraph->Axes[xlCategory].HasMajorGridLines);
      setcheck (hgrid, ActiveGraph->Axes[xlValue].HasMajorGridLines);

      setcheck (xmin, ActiveGraph->Axes[xlCategory].MinimumScaleIsAuto);
      SetEntryVal (xminv, ActiveGraph->Axes[xlCategory].MinimumScale);

      setcheck (xmax, ActiveGraph->Axes[xlCategory].MaximumScaleIsAuto);
      SetEntryVal (xmaxv, ActiveGraph->Axes[xlCategory].MaximumScale);

      setcheck (xunit, ActiveGraph->Axes[xlCategory].MajorUnitIsAuto);
      SetEntryVal (xunitv, ActiveGraph->Axes[xlCategory].MajorUnit);

      setcheck (ymin, ActiveGraph->Axes[xlValue].MinimumScaleIsAuto);
      SetEntryVal (yminv, ActiveGraph->Axes[xlValue].MinimumScale);

      setcheck (ymax, ActiveGraph->Axes[xlValue].MaximumScaleIsAuto);
      SetEntryVal (ymaxv, ActiveGraph->Axes[xlValue].MaximumScale);

      setcheck (yunit, ActiveGraph->Axes[xlValue].MajorUnitIsAuto);
      SetEntryVal (yunitv, ActiveGraph->Axes[xlValue].MajorUnit);

    }

  previousrange = 1;

  display_prompt (td2, gettop ());
}

void
initplotdial ()
{
  int type = 0;

  if (ActiveGraph != NULL)
    {
      type = ActiveGraph->type;

      XawListHighlight (typelist, type);

    }

}

void
formatplot ()
{
  char *str;
  Arg arglist[1];
  Boolean on;
  int *touched_pane = (int *) get_touched_pane (td2);

  if (touched_pane[0])
    {
      if (selectedtype >= 0)
	setgraphtype (selectedtype);
    }
  if (touched_pane[1])
    {
      char *str1;
      char *str2;
      XtSetArg (arglist[0], XtNstring, &str1);
      XtGetValues (range, arglist, 1);
      XtSetArg (arglist[0], XtNstring, &str2);
      XtGetValues (seriename, arglist, 1);
      setrange (previousrange, str1, str2);
    }
  if (touched_pane[2])
    {
      XtSetArg (arglist[0], XtNstring, &str);
      XtGetValues (titre1, arglist, 1);
      settitre1 (str);
      XtSetArg (arglist[0], XtNstring, &str);
      XtGetValues (Xaxis, arglist, 1);
      setXaxis (str);
      XtGetValues (Yaxis, arglist, 1);
      setYaxis (str);
    }
  if (touched_pane[3])
    {
      XtSetArg (arglist[0], XtNstate, &on);
      XtGetValues (vgrid, arglist, 1);
      setgridv (on);
      XtSetArg (arglist[0], XtNstate, &on);
      XtGetValues (hgrid, arglist, 1);
      setgridh (on);
    }

  if (touched_pane[4])
    if (ActiveGraph != NULL)
      {
	ActiveGraph->Axes[xlCategory].MinimumScaleIsAuto = getcheck (xmin);
	ActiveGraph->Axes[xlCategory].MinimumScale = GetEntryVal (xminv);

	ActiveGraph->Axes[xlCategory].MaximumScaleIsAuto = getcheck (xmax);
	ActiveGraph->Axes[xlCategory].MaximumScale = GetEntryVal (xmaxv);

	ActiveGraph->Axes[xlCategory].MajorUnitIsAuto = getcheck (xunit);
	ActiveGraph->Axes[xlCategory].MajorUnit = GetEntryVal (xunitv);

	ActiveGraph->Axes[xlValue].MinimumScaleIsAuto = getcheck (ymin);
	ActiveGraph->Axes[xlValue].MinimumScale = GetEntryVal (yminv);

	ActiveGraph->Axes[xlValue].MaximumScaleIsAuto = getcheck (ymax);
	ActiveGraph->Axes[xlValue].MaximumScale = GetEntryVal (ymaxv);

	ActiveGraph->Axes[xlValue].MajorUnitIsAuto = getcheck (yunit);
	ActiveGraph->Axes[xlValue].MajorUnit = GetEntryVal (yunitv);

      }

  plot ();

}

void
graprange (w, pointer, call_data)
     Widget w;
     XtPointer pointer;
     XtPointer call_data;
{
  ThumbDialog *td = (ThumbDialog *) pointer;
  XtUnmanageChild (td->promptShell);

  cb_grap (range, td->promptShell);
}

void
grapseriename (w, pointer, call_data)
     Widget w;
     XtPointer pointer;
     XtPointer call_data;
{
  ThumbDialog *td = (ThumbDialog *) pointer;
  XtUnmanageChild (td->promptShell);

  cb_grap (seriename, td->promptShell);

}

void
graptitre1 (w, pointer, call_data)
     Widget w;
     XtPointer pointer;
     XtPointer call_data;
{
  ThumbDialog *td = (ThumbDialog *) pointer;
  XtUnmanageChild (td->promptShell);

  cb_grap (titre1, td->promptShell);

}

void
grapXaxis (w, pointer, call_data)
     Widget w;
     XtPointer pointer;
     XtPointer call_data;
{
  ThumbDialog *td = (ThumbDialog *) pointer;
  XtUnmanageChild (td->promptShell);

  cb_grap (Xaxis, td->promptShell);
}

void
grapYaxis (w, pointer, call_data)
     Widget w;
     XtPointer pointer;
     XtPointer call_data;
{
  ThumbDialog *td = (ThumbDialog *) pointer;
  XtUnmanageChild (td->promptShell);

  cb_grap (Yaxis, td->promptShell);
}

void
updaterange (w, closure, call_data)
     Widget w;
     XtPointer closure, call_data;
{
  Arg arglist[1];
  int serie;
  char buf[32];
  char name[32];

  char *str1;
  char *str2;
  XawListReturnStruct *item;

  XtSetArg (arglist[0], XtNstring, &str1);
  XtGetValues (range, arglist, 1);
  XtSetArg (arglist[0], XtNstring, &str2);
  XtGetValues (seriename, arglist, 1);
  setrange (previousrange, str1, str2);

  item = (XawListReturnStruct *) call_data;
  serie = item->list_index + 1;
  previousrange = serie;
  getrange (serie, buf, name);
  XtSetArg (arglist[0], XtNstring, &buf);
  XtSetValues (range, arglist, 1);
  XtSetArg (arglist[0], XtNstring, &name);
  XtSetValues (seriename, arglist, 1);

}

void
set_plottype (w, closure, call_data)
     Widget w;
     XtPointer closure, call_data;
{
  XawListReturnStruct *item = (XawListReturnStruct *) call_data;
  selectedtype = item->list_index;
}

int
make_plot_dial ()
{
  Widget viewport, viewport2;
  Widget base;

  td2 =
    CreateThumbDialog (gettop (), XtNumber (plotpane), plotpane, formatplot,
		       initplotdial);

  base = (Widget) get_base (td2);

  w_n = 0;
  w_bord (0);
  w_dim (100, 120);
  w_rel (NULL, 20, 55);
  XtSetArg (w_args[w_n], XtNuseRight, True);
  w_n++;
  XtSetArg (w_args[w_n], XtNallowVert, True);
  w_n++;
  XtSetArg (w_args[w_n], XtNforceBars, True);
  w_n++;
  viewport = XtCreateManagedWidget ("viewport",
				    viewportWidgetClass, base, w_args, w_n);

  addshadow (viewport, 6);
  addpanechild (td2, 0, viewport);

  w_n = 0;
  w_bord (0);
  XtSetArg (w_args[w_n], XtNdefaultColumns, 1);
  w_n++;
  XtSetArg (w_args[w_n], XtNforceColumns, True);
  w_n++;
  w_bONw ();
  typelist = XtCreateManagedWidget ("typelist", listWidgetClass,
				    viewport, w_args, w_n);
  XtAddCallback (typelist, XtNcallback, set_plottype, NULL);
  XawListChange (typelist, plot_type, 3, 0, True);

  w_n = 0;
  w_bord (0);
  w_dim (100, 120);
  w_rel (NULL, 20, 55);
  XtSetArg (w_args[w_n], XtNuseRight, True);
  w_n++;
  XtSetArg (w_args[w_n], XtNallowVert, True);
  w_n++;
  XtSetArg (w_args[w_n], XtNforceBars, True);
  w_n++;
  viewport2 = XtCreateManagedWidget ("viewport",
				     viewportWidgetClass, base, w_args, w_n);
  addshadow (viewport2, 6);

  addpanechild (td2, 1, viewport2);

  w_n = 0;
  w_bord (0);
  XtSetArg (w_args[w_n], XtNdefaultColumns, 1);
  w_n++;
  XtSetArg (w_args[w_n], XtNforceColumns, True);
  w_n++;

  w_bONw ();
  ranges = XtCreateManagedWidget ("list", listWidgetClass,
				  viewport2, w_args, w_n);
  XtAddCallback (ranges, XtNcallback, updaterange, NULL);
  XawListChange (ranges, serie, 8, 0, True);

  addpanechild (td2, 1, CreateLabel (base, "Range", 160, 35, 80, 20));
  range = CreateEntry (base, "test", 160, 60, 100, 20, "");
  w_n = 0;
  w_bONw ();
  w_set (range);
  XtAddEventHandler (range, ExposureMask, FALSE, shadow3, (XtPointer) range);

  addpanechild (td2, 1, range);

  w_n = 0;
  w_rel (NULL, 270, 60);
  btn =
    (Widget) make_button_pixmap (base, "grap", grap_xpm, graprange,
				 (XtPointer) td2);
  XtSetValues (btn, w_args, w_n);
  addpanechild (td2, 1, btn);

  addpanechild (td2, 1, CreateLabel (base, "Name", 160, 90, 80, 20));
  seriename = CreateEntry (base, "text", 160, 115, 100, 20, "");
  w_n = 0;
  w_bONw ();
  w_set (seriename);
  XtAddEventHandler (seriename,
		     ExposureMask, FALSE, shadow3, (XtPointer) seriename);

  addpanechild (td2, 1, seriename);

  w_n = 0;
  w_rel (NULL, 270, 115);
  btn2 =
    (Widget) make_button_pixmap (base, "grap", grap_xpm, grapseriename,
				 (XtPointer) td2);
  XtSetValues (btn2, w_args, w_n);
  addpanechild (td2, 1, btn2);

  addpanechild (td2, 2, CreateLabel (base, "Titre 1", 20, 35, 80, 20));
  titre1 = CreateEntry (base, "text", 110, 35, 180, 20, "");
  w_n = 0;
  w_bONw ();
  w_set (titre1);
  XtAddEventHandler (titre1,
		     ExposureMask, FALSE, shadow3, (XtPointer) titre1);

  addpanechild (td2, 2, titre1);
  w_n = 0;
  w_rel (NULL, 300, 35);
  btn3 =
    (Widget) make_button_pixmap (base, "grap", grap_xpm, graptitre1,
				 (XtPointer) td2);
  XtSetValues (btn3, w_args, w_n);
  addpanechild (td2, 2, btn3);

  addpanechild (td2, 2, CreateLabel (base, "X Axis", 20, 65, 80, 20));
  Xaxis = CreateEntry (base, "text", 110, 65, 180, 20, "");
  w_n = 0;
  w_bONw ();
  w_set (Xaxis);
  XtAddEventHandler (Xaxis, ExposureMask, FALSE, shadow3, (XtPointer) Xaxis);
  addpanechild (td2, 2, Xaxis);

  w_n = 0;
  w_rel (NULL, 300, 65);
  btn4 =
    (Widget) make_button_pixmap (base, "grap", grap_xpm, grapXaxis,
				 (XtPointer) td2);
  XtSetValues (btn4, w_args, w_n);
  addpanechild (td2, 2, btn4);

  addpanechild (td2, 2, CreateLabel (base, "Y Axis", 20, 95, 80, 20));
  Yaxis = CreateEntry (base, "text", 110, 95, 180, 20, "");
  w_n = 0;
  w_bONw ();
  w_set (Yaxis);
  XtAddEventHandler (Yaxis, ExposureMask, FALSE, shadow3, (XtPointer) Yaxis);
  addpanechild (td2, 2, Yaxis);

  w_n = 0;
  w_rel (NULL, 300, 95);
  btn5 =
    (Widget) make_button_pixmap (base, "grap", grap_xpm, grapYaxis,
				 (XtPointer) td2);
  XtSetValues (btn5, w_args, w_n);
  addpanechild (td2, 2, btn5);

  addpanechild (td2, 3,
		CreateLabel (base, "Vertical   grid", 20, 35, 80, 20));

  w_n = 0;
  w_rel (NULL, 130, 35);
  vgrid = (Widget) make_check (base, "vgrid", NULL, (XtPointer) td2);
  XtSetValues (vgrid, w_args, w_n);
  addpanechild (td2, 3, vgrid);

  addpanechild (td2, 3,
		CreateLabel (base, "Horizontal grid", 20, 65, 80, 20));

  w_n = 0;
  w_rel (NULL, 130, 65);
  hgrid = (Widget) make_check (base, "hgrid", NULL, (XtPointer) td2);
  XtSetValues (hgrid, w_args, w_n);
  addpanechild (td2, 3, hgrid);

  activepane (td2, 0);

  addpanechild (td2, 4, CreateLabel (base, "Automatic", 10, 35, 100, 22));
  addpanechild (td2, 4, CreateLabel (base, "X Minimum", 30, 60, 100, 22));
  addpanechild (td2, 4, CreateLabel (base, "X Maximum", 30, 85, 100, 22));
  addpanechild (td2, 4, CreateLabel (base, "X Unit", 30, 110, 100, 22));
  addpanechild (td2, 4, CreateLabel (base, "Y Minimum", 30, 135, 100, 22));
  addpanechild (td2, 4, CreateLabel (base, "Y Maximum", 30, 160, 100, 22));
  addpanechild (td2, 4, CreateLabel (base, "Y Unit", 30, 185, 100, 22));

  w_n = 0;
  w_rel (NULL, 10, 60);
  xmin = (Widget) make_check (base, "xmin", NULL, (XtPointer) td2);
  XtSetValues (xmin, w_args, w_n);
  addpanechild (td2, 4, xmin);

  w_n = 0;
  w_rel (NULL, 10, 85);
  xmax = (Widget) make_check (base, "xmax", NULL, (XtPointer) td2);
  XtSetValues (xmax, w_args, w_n);
  addpanechild (td2, 4, xmax);

  w_n = 0;
  w_rel (NULL, 10, 110);
  xunit = (Widget) make_check (base, "xunit", NULL, (XtPointer) td2);
  XtSetValues (xunit, w_args, w_n);
  addpanechild (td2, 4, xunit);

  w_n = 0;
  w_rel (NULL, 10, 135);
  ymin = (Widget) make_check (base, "ymin", NULL, (XtPointer) td2);
  XtSetValues (ymin, w_args, w_n);
  addpanechild (td2, 4, ymin);

  w_n = 0;
  w_rel (NULL, 10, 160);
  ymax = (Widget) make_check (base, "ymax", NULL, (XtPointer) td2);
  XtSetValues (ymax, w_args, w_n);
  addpanechild (td2, 4, ymax);

  w_n = 0;
  w_rel (NULL, 10, 185);
  yunit = (Widget) make_check (base, "yunit", NULL, (XtPointer) td2);
  XtSetValues (yunit, w_args, w_n);
  addpanechild (td2, 4, yunit);

  xminv = CreateEntry (base, "xminv", 160, 60, 150, 22, "");
  XtAddEventHandler (xminv, ExposureMask, FALSE, shadow3, (XtPointer) xminv);
  addpanechild (td2, 4, xminv);

  xmaxv = CreateEntry (base, "xmaxv", 160, 85, 150, 22, "");
  XtAddEventHandler (xmaxv, ExposureMask, FALSE, shadow3, (XtPointer) xmaxv);
  addpanechild (td2, 4, xmaxv);

  xunitv = CreateEntry (base, "xunitv", 160, 110, 150, 22, "");
  XtAddEventHandler (xunitv, ExposureMask, FALSE, shadow3,
		     (XtPointer) xunitv);
  addpanechild (td2, 4, xunitv);
  yminv = CreateEntry (base, "yminv", 160, 135, 150, 22, "");
  XtAddEventHandler (yminv, ExposureMask, FALSE, shadow3, (XtPointer) yminv);
  addpanechild (td2, 4, yminv);
  ymaxv = CreateEntry (base, "ymaxv", 160, 160, 150, 22, "");
  XtAddEventHandler (ymaxv, ExposureMask, FALSE, shadow3, (XtPointer) ymaxv);
  addpanechild (td2, 4, ymaxv);
  yunitv = CreateEntry (base, "yunitv", 160, 185, 150, 22, "");
  XtAddEventHandler (yunitv, ExposureMask, FALSE, shadow3,
		     (XtPointer) yunitv);
  addpanechild (td2, 4, yunitv);

  activepane (td2, 0);

  return 0;
}
