/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#ifndef PARAM_H
#define PARAM_H
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Core.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Panner.h>
#include <X11/Xaw/Porthole.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Shell.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/Repeater.h>

extern int BatchMode;

extern Arg w_args[50];
extern int w_n;

extern Widget top;

extern Pixel absblack;
extern Pixel abswhite;

struct menuEntry
{
  char *name;
  void (*function) ();
};

struct buttonEntry
{
  char *name;
  char **pixmapname;
  void (*function) ();
};

struct paneEntry
{
  char *name;
};

int modscroll (Widget w);
int addshadow (Widget w, int type);
void shadow6 (Widget widget, XtPointer pointer, XEvent * event,
	      Boolean * ctd);
void shadow5 (Widget widget, XtPointer pointer, XEvent * event,
	      Boolean * ctd);
void shadow4 (Widget widget, XtPointer pointer, XEvent * event,
	      Boolean * ctd);
void shadow3 (Widget widget, XtPointer pointer, XEvent * event,
	      Boolean * ctd);
void shadow2 (Widget widget, XtPointer pointer, XEvent * event,
	      Boolean * ctd);
void shadow (Widget widget, XtPointer pointer, XEvent * event, Boolean * ctd);
double GetEntryVal (Widget w);
int SetEntryVal (Widget w, double val);
char *GetEntryString (Widget w);
int SetEntryString (Widget w, char *buf);
Widget CreateEntry (Widget base, char *label, int x, int y, int w, int h,
		    char *val);
int EntrySetEditable (Widget w, int yes);
int EntrySetInsertionPosition (Widget w, int pos);
void TextPrintf (Widget w, char *str);
Widget CreateText (Widget base, char *label, int x, int y, int w, int h);
Widget CreateLabel (Widget base, char *label, int x, int y, int w, int h);
int w_bONw ();
int w_hresize ();
int w_vresize ();
int w_nohresize ();
int w_novresizebot ();
int w_novresize ();
int w_noresize ();
int w_inbord (int l);
int w_bord (int l);
int w_dim (int x, int y);
int w_relv (Widget w, int y);
int w_relh (Widget w, int x);
int w_rel (Widget w, int x, int y);
int w_set (Widget w);
int w_arg (String Name, XtArgVal Value);
#endif
