/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#ifndef MYSCROLL_H
#define MYSCROLL_H
#include <stdio.h>
#include <sys/stat.h>
#include "param.h"

typedef struct
{
  Widget back;
  Widget track;
  Widget up, down, left, right, thumb;
  int h, w;
  int vmin, vmax, val;
  int curx, cury, curh, curw;

  int thumblen, backlen;
  int thumbmin, thumbmax, thumbminlen;
  int thumbpos;
  int thumbpx, thumbpy;

  int ssx, ssy;
  int thumbpos0;

  void (*cbfunction) ();
  Widget parent;
  enum
  {
    vertical, horizontal
  }
  orientation;
}
Myscroll;

Myscroll *CreateMyscroll (Widget parent, int h, int w, int vmin, int vmax,
			  void (*func) ());

void setscrollval (Myscroll * ms, int val);
int setscrolllimit (Myscroll * ms, int vmin, int vmax);

void btncb (Widget widget, XtPointer pointer, XtPointer junk);

extern void
shadow2 (Widget widget, XtPointer pointer, XEvent * event, Boolean * ctd);
#endif
