/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include "myscroll.h"
#include "worksheet.h"
#include "gr_interf.h"
#include "memory.h"
#include "callback.h"
#include "button.h"

#include <math.h>

#include "pixmaps/up.xpm"
#include "pixmaps/down.xpm"
#include "pixmaps/left.xpm"
#include "pixmaps/right.xpm"

static int nosetval = 0;
static int downonthumb = 0;

int
val2pos (vmin, vmax, h, val)
     int vmin, vmax, val, h;
{
  int pos = (val - vmin) * (h - 36) / (vmax - vmin) + 18;

  return pos;
}

int
pos2val (vmin, vmax, h, pos)
     int vmin, vmax, pos, h;
{
  int val = (vmax - vmin) * (pos - 18) / (h - 36) + vmin;

  return val;
}

int
redrawthumb (ms)
     Myscroll *ms;
{
  if (ms->orientation == horizontal)
    {
      desactivate_zoom ();
      fillrectangle (XtDisplay (ms->back), XtWindow (ms->back), 3, 17, 2,
		     ms->backlen, ms->h - 4, 0, 0, 0);
      drawbuttonup (XtDisplay (ms->back), XtWindow (ms->back), ms->thumbpos,
		    3, ms->thumbpos + ms->thumblen, 14, NULL, 0, 0);
      reactivate_zoom ();
    }
  else
    {
      desactivate_zoom ();
      fillrectangle (XtDisplay (ms->back), XtWindow (ms->back), 3, 2, 17,
		     ms->w - 4, ms->backlen, 0, 0, 0);
      drawbuttonup (XtDisplay (ms->back), XtWindow (ms->back), 3,
		    ms->thumbpos, 14, ms->thumbpos + ms->thumblen, NULL, 0,
		    0);
      reactivate_zoom ();
    }
  return 0;
}

int
sethpos (ms, pos)
     Myscroll *ms;
     int pos;
{

  double p, l;
  int val;

  if (pos < ms->thumbmin)
    pos = ms->thumbmin;
  if (pos > ms->thumbmax - ms->thumbminlen)
    pos = ms->thumbmax - ms->thumbminlen;

  p = pos - ms->thumbmin;
  l = ms->thumbmax - ms->thumbminlen - ms->thumbmin;
  if (l <= 0)
    l = 1;
  val = p / l * (ms->vmax - ms->vmin) + ms->vmin;

  setscrollval (ms, val);
  return 0;

}

void
resizescroll (widget, pointer, event, ctd)
     Widget widget;
     XtPointer pointer;
     XEvent *event;
     Boolean *ctd;
{
  int n;
  Dimension h, w;
  Myscroll *ms;
  int butsize = 18;
  Arg args[2];
  ms = (Myscroll *) pointer;

  n = 0;
  XtSetArg (args[n], XtNheight, &h);
  n++;
  XtSetArg (args[n], XtNwidth, &w);
  n++;
  XtGetValues (widget, args, n);

  ms->h = h;
  ms->w = w;

  if (ms->orientation == horizontal)
    {
      ms->thumbmax = w - butsize;
    }
  else
    {
      ms->thumbmax = h - butsize;

    }
  ms->backlen = ms->thumbmax - ms->thumbmin;
  if (ms->backlen < ms->thumbminlen)
    ms->backlen = ms->thumbminlen;
  setscrollval (ms, ms->val);
}

void
btncb (widget, pointer, junk)
     Widget widget;
     XtPointer pointer;
     XtPointer junk;
{

  Myscroll *ms = (Myscroll *) pointer;

  if (widget == ms->up || widget == ms->left)
    {
      setscrollval (ms, ms->val - 1);
    }
  if (widget == ms->down || widget == ms->right)
    {
      setscrollval (ms, ms->val + 1);
    }
  if (widget == ms->thumb)
    {
    }

  nosetval = 1;
  ms->cbfunction (ms->val);
  nosetval = 0;
}

void
thumbupcb (w, pointer, event, ctd)
     Widget w;
     XtPointer pointer;
     XEvent *event;
     Boolean *ctd;
{

}

void
movecb (w, pointer, event, ctd)
     Widget w;
     XtPointer pointer;
     XEvent *event;
     Boolean *ctd;
{
  int x, y;
  int delta;
  Window root_return, child_return;
  int root_x_return, root_y_return;
  int win_x_return, win_y_return;
  unsigned int mask_return;
  Myscroll *ms = (Myscroll *) pointer;
  XQueryPointer (XtDisplay (w), XtWindow (w), &root_return, &child_return,
		 &root_x_return, &root_y_return, &win_x_return, &win_y_return,
		 &mask_return);

  if (!downonthumb)
    return;

  x = root_x_return;
  y = root_y_return;

  if (ms->orientation == vertical)
    {
      delta = y - ms->ssy;
    }
  else
    {
      delta = x - ms->ssx;
    }

  sethpos (ms, ms->thumbpos0 + delta);
  nosetval = 1;
  ms->cbfunction (ms->val);
  nosetval = 0;
}

void
redrawcb (w, pointer, event, ctd)
     Widget w;
     XtPointer pointer;
     XEvent *event;
     Boolean *ctd;
{
  Myscroll *ms = (Myscroll *) pointer;
  redrawthumb (ms);
}

void
stepcb (w, pointer, event, ctd)
     Widget w;
     XtPointer pointer;
     XEvent *event;
     Boolean *ctd;
{
  int x, y;
  int delta;

  Myscroll *ms = (Myscroll *) pointer;

  x = event->xbutton.x;
  y = event->xbutton.y;

  if (
      (ms->orientation == horizontal && x > ms->thumbpos
       && x < ms->thumbpos + ms->thumblen) || (ms->orientation == vertical
					       && y > ms->thumbpos
					       && y <
					       ms->thumbpos + ms->thumblen))
    {
      downonthumb = 1;
      ms->ssx = event->xbutton.x_root;
      ms->ssy = event->xbutton.y_root;
      ms->thumbpos0 = ms->thumbpos;
      return;
    }

  if (ms->orientation == horizontal)
    {
      y = x;
    }

  if (y < ms->thumbmin || y > ms->thumbmax)
    return;

  delta = (y - ms->thumbpos) / 5.0;
  if (fabs (delta / 1.0) < 2)
    return;

  sethpos (ms, ms->thumbpos + delta);

  nosetval = 1;
  ms->cbfunction (ms->val);
  nosetval = 0;

}

void
presscb (w, pointer, event, ctd)
     Widget w;
     XtPointer pointer;
     XEvent *event;
     Boolean *ctd;
{
  int x, y;

  Myscroll *ms = (Myscroll *) pointer;

  x = event->xbutton.x_root;
  y = event->xbutton.y_root;
  fprintf (stderr, "in presscb\n");
  ms->thumbpy = y;
  ms->thumbpx = x;
  ms->ssx = x;
  ms->ssy = y;
}

int
setscrolllimit (ms, vmin, vmax)
     Myscroll *ms;
     int vmin, vmax;
{
  ms->vmin = vmin;
  ms->vmax = vmax;
  if (vmax == vmin)
    vmax = vmin + 1;
  return 0;
}

void
setscrollval (ms, val)
     Myscroll *ms;
     int val;
{
  if (nosetval)
    return;

  ms->val = val;
  if (ms->val < ms->vmin)
    ms->val = ms->vmin;
  if (ms->val > ms->vmax)
    ms->val = ms->vmax;

  {
    double v = val;
    double vmin = ms->vmin;
    double vmax = ms->vmax;
    double loc = (v - vmin) / (vmax - vmin);
    int i1, j1, i2, j2;
    get_visible_cells (&i1, &j1, &i2, &j2);
    if (ms->orientation == horizontal)
      {

	ms->thumblen = (j2 - j1) / (vmax - vmin) * ms->backlen;
      }
    else
      {
	ms->thumblen = (i2 - i1) / (vmax - vmin) * ms->backlen;
      }

    if (ms->thumblen < ms->thumbminlen)
      ms->thumblen = ms->thumbminlen;
    if (ms->thumblen > ms->backlen)
      ms->thumblen = ms->backlen;

    if (loc < 0)
      loc = 0;
    if (loc > 1)
      loc = 1;
    ms->thumbpos = loc * (ms->backlen - ms->thumblen) + ms->thumbmin;

    redrawthumb (ms);

    if (ms->orientation == horizontal)
      {
	ms->cury = ms->thumbpos;

      }
    else
      {
	ms->curx = ms->thumbpos;
      }

  }

}

Myscroll *
CreateMyscroll (parent, h, w, vmin, vmax, func)
     Widget parent;
     int h, w, vmin, vmax;
     void (*func) ();
{
  Arg args[16];
  int n;
  Myscroll *ms;
  int butsize = 18;

  ms = (Myscroll *) absmalloc (sizeof (Myscroll), "CreateMyscroll:ms ");

  ms->parent = parent;
  ms->cbfunction = func;
  ms->h = h;
  ms->w = w;
  ms->vmin = vmin;
  ms->vmax = vmax;
  ms->val = 0;
  ms->thumblen = 30;
  ms->thumbminlen = 15;
  ms->thumbmin = butsize;
  ms->thumbpos = butsize;

  XtSetArg (w_args[w_n], XtNheight, h);
  w_n++;
  XtSetArg (w_args[w_n], XtNwidth, w);
  w_n++;
  XtSetArg (w_args[w_n], XtNborderWidth, 0);
  w_n++;
  ms->back =
    (Widget) XtCreateManagedWidget ("window", formWidgetClass, parent, w_args,
				    w_n);
  if (h > w)
    {
      ms->orientation = vertical;
      ms->thumbmax = h - butsize;

      ms->up =
	(Widget) make_repeater_pixmap (ms->back, "up", up_xpm, btncb,
				       (XtPointer) ms);
      n = 0;
      XtSetArg (args[n], XtNfromHoriz, NULL);
      n++;
      XtSetArg (args[n], XtNhorizDistance, 1);
      n++;
      XtSetArg (args[n], XtNfromVert, NULL);
      n++;
      XtSetArg (args[n], XtNvertDistance, 1);
      n++;
      XtSetValues (ms->up, args, n);

      ms->cury = 18;

      ms->down =
	(Widget) make_repeater_pixmap (ms->back, "down", down_xpm, btncb,
				       (XtPointer) ms);
      n = 0;
      XtSetArg (args[n], XtNfromVert, (XtPointer) NULL);
      n++;
      XtSetArg (args[n], XtNvertDistance, h - 14);
      n++;
      XtSetArg (args[n], XtNfromHoriz, NULL);
      n++;
      XtSetArg (args[n], XtNhorizDistance, 1);
      n++;
      XtSetValues (ms->down, args, n);
    }
  else
    {
      ms->orientation = horizontal;
      ms->thumbmax = w - butsize;

      ms->left =
	(Widget) make_repeater_pixmap (ms->back, "left", left_xpm, btncb,
				       (XtPointer) ms);
      n = 0;
      XtSetArg (args[n], XtNfromHoriz, NULL);
      n++;
      XtSetArg (args[n], XtNhorizDistance, 1);
      n++;
      XtSetArg (args[n], XtNfromVert, NULL);
      n++;
      XtSetArg (args[n], XtNvertDistance, 1);
      n++;
      XtSetValues (ms->left, args, n);

      ms->curx = 18;

      ms->right =
	(Widget) make_repeater_pixmap (ms->back, "right", right_xpm, btncb,
				       (XtPointer) ms);
      n = 0;
      XtSetArg (args[n], XtNfromHoriz, NULL);
      n++;
      XtSetArg (args[n], XtNhorizDistance, w - 14);
      n++;
      XtSetArg (args[n], XtNfromVert, NULL);
      n++;
      XtSetArg (args[n], XtNvertDistance, 1);
      n++;
      XtSetValues (ms->right, args, n);

    }

  ms->backlen = ms->thumbmax - ms->thumbmin;
  if (ms->backlen < ms->thumbminlen)
    ms->backlen = ms->thumbminlen;

  XtAddEventHandler (ms->back, ButtonPressMask, False, stepcb,
		     (XtPointer) ms);
  XtAddEventHandler (ms->back, ExposureMask, FALSE, shadow2,
		     (XtPointer) ms->back);
  XtAddEventHandler (ms->back, ButtonReleaseMask, False, thumbupcb,
		     (XtPointer) ms);

  XtAddEventHandler (ms->back, VisibilityChangeMask, False, redrawcb,
		     (XtPointer) ms);

  XtAddEventHandler (ms->back, Button1MotionMask, False, movecb,
		     (XtPointer) ms);

  XtAddEventHandler (ms->back, StructureNotifyMask, False, resizescroll,
		     (XtPointer) ms);
  return ms;
}
