/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#ifndef MYDIALOG_H
#define MYDIALOG_H
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Core.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Panner.h>
#include <X11/Xaw/Porthole.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Shell.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/List.h>
#include <X11/RectObj.h>
#include <stdio.h>
#include <sys/stat.h>
#include  <dirent.h>
#include "param.h"

typedef struct
{
  int activeprompt;
  Widget pane_btn[20];
  Widget pane_child[20][21];
  int npane_child[20];
  int active_pane;
  int npane;
  int touched_pane[20];
  Widget promptDialog;
  Widget promptShell;
  void (*promptfunction) ();
  void (*popupcb) ();
  Widget parent;
}
ThumbDialog;

extern int addpanechild (ThumbDialog * td, int i, Widget w);

extern ThumbDialog *CreateThumbDialog (Widget parent, int npane,
				       char **panename, void (*func) (),
				       void (*cbfunc) ());

extern void paneselect (Widget widget, XtPointer pointer, XtPointer junk);

extern int activepane (ThumbDialog * td, int a);

extern void
PromptCancelAction (Widget widget, XtPointer pointer, XtPointer junk);

extern void
PromptAcceptAction (Widget widget, XtPointer pointer, XtPointer junk);

extern void display_prompt (ThumbDialog * td, Widget centerw);

extern void childtouched (Widget widget, XtPointer pointer, XtPointer junk);

extern int *get_touched_pane (ThumbDialog * td);

extern Widget get_base (ThumbDialog * td);
#endif
