/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#ifndef CALLBACK_DECL_H
#define CALLBACK_DECL_H
#include "param.h"

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Core.h>
#include <X11/Shell.h>
#include <stdio.h>
#include <X11/Xaw/AsciiText.h>
#include "graph.h"
#include "style.h"
#include "cell.h"
#include "worksheet.h"
#include "workbook.h"
#include "draw.h"

#include "draw_cb.h"

void cb_first_sheet ();
void cb_last_sheet ();
void cb_next_sheet ();
void cb_previous_sheet ();
int deletegraphpixmap (Graph * gr);
int creategraphpixmap (Graph * gr);
int xdrawrrect (int x, int y, int width, int height, int type, Cell * cell);
int xdrawstring (char *name, int x, int y, int width, int widthmax,
		 int height, int type, Cell * cell);
int checkwidth (char *name, int width, Cell * cell, int r, int c, int type);
int cb_resize (int width, int height);
void cb_redrawgra ();
void cb_redrawdra ();
void cb_Repaint (Widget w, XtPointer data, XEvent * event);
void event_Repaint (Widget w, XtPointer cd, XEvent * event, Boolean * ctd);
int redrawbtn ();
int redrawdra ();
int xdrawcolcell (int i, int j, int color);
int xdrawlincell (int i, int j, int color);
Pixmap getpixmap (Graph * gr, int *x, int *y, int *w, int *h);
Pixmap createpixmapforgraph (Graph * gr);
void cb_grap (Widget w, Widget dialog);
int redrawdr (Drawing * dr);
int redrawgra ();
int cb_setzoom (int z);
int zoomout ();
int zoomin ();
void cb_ZoomChange (Widget w, XtPointer cd, XEvent * event, Boolean * ctd);
int lindrag (double l);
int coldrag (double c);
Widget getdrawzone ();
int xfitline (int ii, int jj);
int xfitcolumn (int ii, int jj);
int xfit (int ii, int jj, char *name);
int absijtoxy (int i, int j, int *x, int *y);
int get_visible (int *x1, int *x2, int *y1, int *y2);
int inform (char *str);
int cbsetup (Widget _toplevel, Widget drawzone, Dimension width,
	     Dimension height, Widget _colindex, Widget _linindex,
	     Widget _text, Widget _info, Widget _corner);
void m_exitdraw ();
void m_editdraw ();
void m_plotbutton ();
void m_plotcircle ();
void m_plotarc ();
void m_plotrect ();
void m_plotline ();
void m_createplot ();
void m_copyr ();
void m_copyd ();
void m_update ();

void m_printfile (Widget w, XtPointer client_data, XtPointer call_data);
void m_saveasfile (Widget w, XtPointer client_data, XtPointer call_data);
void m_savefile (Widget w, XtPointer client_data, XtPointer call_data);
void m_changewin (Widget w, XtPointer client_data, XtPointer call_data);
void m_insertcolumn (Widget w, XtPointer client_data, XtPointer call_data);
void m_insertline (Widget w, XtPointer client_data, XtPointer call_data);
void m_delsheet (Widget w, XtPointer client_data, XtPointer call_data);
void m_delline (Widget w, XtPointer client_data, XtPointer call_data);
void m_find (Widget w, XtPointer client_data, XtPointer call_data);
void m_replace (Widget w, XtPointer client_data, XtPointer call_data);
void m_goto (Widget w, XtPointer client_data, XtPointer call_data);
void m_delcolumn (Widget w, XtPointer client_data, XtPointer call_data);
void m_addsheet (Widget w, XtPointer client_data, XtPointer call_data);
void m_newfile (Widget w, XtPointer client_data, XtPointer call_data);
void m_openfile (char *filename);
void m_openfac (Widget w, XtPointer client_data, XtPointer call_data);
void m_fit ();
void m_color ();
void m_incr ();
void cb_DocDelete ();
void m_cut ();
void m_copy (Widget w, XEvent * event, String * params,
	     Cardinal * num_params);
void m_sortd (Widget w, XEvent * event, String * params,
	      Cardinal * num_params);
void m_sorta (Widget w, XEvent * event, String * params,
	      Cardinal * num_params);
void m_sum (Widget w, XEvent * event, String * params, Cardinal * num_params);
void m_brush (Widget w, XEvent * event, String * params,
	      Cardinal * num_params);
void m_paste (Widget w, XEvent * event, String * params,
	      Cardinal * num_params);
int redrawbtdown (Button * btn);
int xytoclotherij (int x, int y, int *i, int *j);

void cb_DocBtn1Down (Widget w, XEvent * event, String * params,
		     Cardinal * num_params);
int border_repaint (int n);
void cb_DocBtn1Motion (Widget w, XEvent * event, String * params,
		       Cardinal * num_params);
void cb_BtnCancel ();
void cb_BtnOk ();
void cb_TextReturn (Widget w, XEvent * event, String * params,
		    Cardinal * num_params);
void cb_TextChange ();
int set_visible (int i, int j);
int resizegra ();
void copypix ();
int redrawbt (Button * btn);
int drplot ();
void cb_PageRight (Widget w, XEvent * event, String * params,
		   Cardinal * num_params);
void cb_PageLeft (Widget w, XEvent * event, String * params,
		  Cardinal * num_params);
void cb_PageDown (Widget w, XEvent * event, String * params,
		  Cardinal * num_params);
int get_visible_cells (int *i1, int *j1, int *i2, int *j2);
void cb_PageUp (Widget w, XEvent * event, String * params,
		Cardinal * num_params);
void cb_PageHome (Widget w, XEvent * event, String * params,
		  Cardinal * num_params);
void cb_DocBtn2Up (Widget w, XEvent * event, String * params,
		   Cardinal * num_params);
int cbrepaint (int l, int c, Dimension width, Dimension height);
int xytoij (int x, int y, int *i, int *j);
void cb_DocBtn2Motion (Widget w, XEvent * event, String * params,
		       Cardinal * num_params);
void cb_DocBtn2Down (Widget w, XEvent * event, String * params,
		     Cardinal * num_params);
int ijtoxy (int i, int j, int *x, int *y);
int drawselect ();
void cb_DocMotion (Widget w, XEvent * event, String * params,
		   Cardinal * num_params);
void cb_BackSpace (Widget w, XEvent * event, String * params,
		   Cardinal * num_params);
void cb_Delete (Widget w, XEvent * event, String * params,
		Cardinal * num_params);
void cb_TextRight (Widget w, XEvent * event, String * params,
		   Cardinal * num_params);
void cb_TextLeft (Widget w, XEvent * event, String * params,
		  Cardinal * num_params);
void cb_TextDown (Widget w, XEvent * event, String * params,
		  Cardinal * num_params);
void cb_DocBtn1Up (Widget w, XEvent * event, String * params,
		   Cardinal * num_params);
void cb_TextUp (Widget w, XEvent * event, String * params,
		Cardinal * num_params);
int moveinsertionpoint (Widget w, int delta);
int insertstring (Widget w, char *str);
void echofct (char *buf);
int setstring (Widget w, char *str);
int xdrawcell (int i, int j, int type);
String getstring (Widget w);
void a_update ();
int selectingto0 ();
int xrepaint ();
int repaint_activesheet ();
int cb_changesheet (int sheet);
int DoUndoFormula (int r, int c, char *formula);

extern int popdownactivecell ();
extern int xdrawcursor ();
extern int KeyPressed ();
extern int drawselectbox (int i1, int j1, int i2, int j2);

extern void cb_Shift (int shift);
extern void cb_Control (int Control);

#endif
