/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#ifndef CHART_VB_H
#define CHART_VB_H
#include "graph.h"
#include "class.h"

extern obj vb_get_tempchartobjects (int narg, obj * arg);

extern obj vb_chartobjects_add (int narg, obj * arg);
extern obj vb_chartobjects_delete (int narg, obj * arg);
extern obj vb_chartobject_activate (int narg, obj * arg);

extern obj vb_chartobject_getchart (int narg, obj * arg);
extern obj vb_chartobject_setchart (int narg, obj * arg);

extern obj vb_get_ActiveChart ();

extern obj vb_chart_settitle (int narg, obj * arg);
extern obj vb_chart_gettitle (int narg, obj * arg);

extern obj vb_chart_setmaximumscale (int narg, obj * arg);
extern obj vb_chart_getmaximumscale (int narg, obj * arg);
extern obj vb_chart_setminimumscale (int narg, obj * arg);
extern obj vb_chart_getminimumscale (int narg, obj * arg);
extern obj vb_chart_setmajorunit (int narg, obj * arg);
extern obj vb_chart_getmajorunit (int narg, obj * arg);

extern obj vb_seriescollection_newserie (int narg, obj * arg);
extern obj vb_chart_getserie (int narg, obj * arg);
extern obj vb_serie_setxvalues (int narg, obj * arg);
extern obj vb_serie_getxvalues (int narg, obj * arg);
extern obj vb_serie_setname (int narg, obj * arg);
extern obj vb_serie_getname (int narg, obj * arg);
extern obj vb_serie_setvalues (int narg, obj * arg);
extern obj vb_serie_getvalues (int narg, obj * arg);

extern obj vb_chart_getaxis (int narg, obj * arg);
extern obj vb_chart_sethastitle (int narg, obj * arg);
extern obj vb_chart_gethastitle (int narg, obj * arg);
extern obj vb_chart_setcharttype (int narg, obj * arg);
extern obj vb_chart_getcharttype (int narg, obj * arg);

static Memberdata Chartobjectsdata[] = {
  {NULL, 0, NULL, NULL}
};

static Fct Chartobjectsfct[] = {
  {"Add", &vb_chartobjects_add, 4, CHARTOBJECT},
  {"Delete", &vb_chartobjects_delete, 0, INTEGER_CONSTANT},
  {NULL, NULL, 0, 0}
};

static Memberdata Chartobjectdata[] = {
  {"Chart", CHART, &vb_chartobject_setchart, &vb_chartobject_getchart},
  {"Border", OBJECT, NULL, NULL},
  {"Interior", OBJECT, NULL, NULL},
  {NULL, 0, NULL, NULL}
};

static Fct Chartobjectfct[] = {
  {"Activate", &vb_chartobject_activate, 1, CHART},
  {NULL, NULL, 0, 0}
};

static Memberdata Chartdata[] = {
  {"ChartTitle", TITLE, &vb_chart_settitle, &vb_chart_gettitle},
  {"HasTitle", BOOLEAN, &vb_chart_sethastitle, &vb_chart_gethastitle},
  {"ChartType", INTEGER, &vb_chart_setcharttype, &vb_chart_getcharttype},
  {"SeriesCollection", OBJECT, NULL, NULL},
  {NULL, 0, NULL, NULL}
};

static Fct Chartfct[] = {
  {"Axes", &vb_chart_getaxis, 1, AXIS},
  {"SeriesCollection", &vb_chart_getserie, 1, SERIE},
  {"MaximumScale", &vb_chart_getmaximumscale, 1, OBJECT},
  {"MinimumScale", &vb_chart_getminimumscale, 1, OBJECT},
  {"MajorUnit", &vb_chart_getmajorunit, 1, OBJECT},
  {NULL, NULL, 0, 0}
};

static Memberdata Seriescollectiondata[] = {
  {NULL, 0, NULL, NULL}
};

static Fct Seriescollectionfct[] = {
  {"NewSerie", &vb_seriescollection_newserie, 0, 0},
  {NULL, NULL, 0, 0}
};

static Memberdata Seriedata[] = {
  {"XValues", INTEGER, &vb_serie_setxvalues, &vb_serie_getxvalues},
  {"Name", INTEGER, &vb_serie_setname, &vb_serie_getname},
  {"Values", INTEGER, &vb_serie_setvalues, &vb_serie_getvalues},
  {NULL, 0, NULL, NULL}
};

static Fct Seriefct[] = {
  {NULL, NULL, 0, 0}
};

#endif
