/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include "application_vb.h"
#include "application.h"
#include "libfct.h"

obj vb_application_setactiveworkbook (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o;
  if (narg != 1)
    return o;
  o = arg[0];
  if (o.type == WORKBOOK)
    {
      ActivateWorkbook ((Workbook *) o.rec.s);
    }
  o.rec.s = (char *) ActiveWorkbook;
  o.type = WORKBOOK;
  o.label = NULL;
  return o;
}

obj vb_application_getactiveworkbook (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o;
  o.rec.s = (char *) ActiveWorkbook;
  o.type = WORKBOOK;
  o.label = NULL;
  return o;
}

obj vb_application_setthisworkbook (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o;
  o.label = NULL;
  return o;
}

obj vb_application_getthisworkbook (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o;
  o.type = WORKBOOK;
  o.label = NULL;
  o.rec.s = (char *) ActiveWorkbook;
  return o;
}

obj vb_application_setactiveworksheet (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o;
  if (narg != 1)
    return o;
  o = arg[0];
  if (o.type == WORKSHEET)
    {
      ActivateWorksheet ((Worksheet *) o.rec.s);
    }
  o.rec.s = (char *) ActiveWorksheet;
  o.type = WORKSHEET;
  o.label = NULL;
  return o;
}

obj vb_application_getactiveworksheet (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o;
  o.label = NULL;
  o.rec.s = (char *) ActiveWorksheet;
  o.type = WORKSHEET;
  return o;
}

obj vb_application_setactivecell (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o;
  o.label = NULL;
  o.rec.s = (char *) ActiveCell;
  o.type = CELL;
  return o;
}

obj vb_application_getactivecell (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o;
  o.label = NULL;
  o.rec.s = (char *) ActiveCell;
  o.type = CELL;
  return o;
}

obj vb_application_getscreenupdating (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o;
  o.label = NULL;
  return o;
}

obj vb_application_setscreenupdating (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o;
  o.label = NULL;
  return o;
}

obj vb_application_quit (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o;
  application_quit ();
  o.label = NULL;
  return o;
}

obj vb_application_calculate (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o;
  application_calculate ();
  o.label = NULL;
  return o;
}
