/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#ifndef GRAPH_H
#define GRAPH_H

#include "style.h"
#include "title.h"
#include "axis.h"
#include "range.h"

#include <stdio.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>

#ifndef graphvar
#define graphvar
#define grnone 0
#define grboth 1
#define grvert 2
#define grhori 3
#define grline 2
#define grsymb 3
#endif

typedef struct
{
  int i1;
  int j1;
  int i2;
  int j2;
  char name[32];
}
GRRange;

typedef struct
{
  Range XValues;
  Range YValues;
  char name[32];
  void *gr;
  int num;
}
Serie;

typedef struct
{
  int i;
  int j;
  int x;
  int y;
  int w;
  int h;
  int zoom;
  int numrange;
  int objnum;
  int type;
  int graphic_grid;
  GRRange range[10];
  int graphic_format[10];
  char titre1[64];
  char titre2[64];
  char Xlabel[64];
  char Ylabel[64];
  Pixmap pixmap;
  int axe_cat_grid;
  int axe_val_grid;
  Axis Axes[3];
  Boolean HasTitle;
  Title ChartTitle;
  Serie SeriesCollections[10];
  struct _Worksheet *worksheet;
}
Graph;

typedef Graph Chart;

extern Graph *ActiveGraph;

extern Graph *newgraph ();
extern Graph *newgraph1 (Graph * gr);
extern Graph *newgraph1 (Graph *);
extern int freegraph (Graph *);
extern Graph *graph_read (FILE * fp);
extern int graph_write (Graph * graph, FILE * fp);
extern int graph_copy (Graph * graph, Graph * gr);

extern Graph *ActivateGraph (Graph * graph);

extern int graph_settype (Graph * graph, int type);
extern int graph_setseriename (Graph * graph, int serie, char *name);
extern int graph_setserievalues (Graph * graph, int serie, char *valuerange);
extern int graph_setserierange (Graph * gr, int serie, Range * range);
extern int graph_setgrid (Graph * graph, int axe, int on);
extern Axis *graph_getaxis (Graph * graph, int a);

#endif
