/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include <stdio.h>

#include "clipboard.h"
#include "workbook.h"
#include "worksheet.h"
#include "graph.h"
#include "draw.h"
#include "button.h"
#include "cell.h"
#include "range.h"

#include "symboltable.h"
#include "memory.h"

#include "draw_cb.h"

#include "info_dialog.h"

Clipboard *clipboard;

#define cpbd clipboard

int
copy_clipboard (Selection * sel)
{
  obj o;

  clear_clipboard (clipboard);

  selection_resetget (sel);
  o = selection_getobjects (sel);

  while (o.type != SEL_END)
    {
      if (o.type == name2type ("RANGE"))
	{
	  Range *ran = (Range *) o.rec.s;
	  int r, c;
	  int i;
	  for (i = 0; i < ran->nplage; i++)
	    {
	      int r1 = ran->plage[i].r1;
	      int r2 = ran->plage[i].r2;
	      int c1 = ran->plage[i].c1;
	      int c2 = ran->plage[i].c2;
	      if (r1 < cpbd->r1)
		cpbd->r1 = r1;
	      if (c1 < cpbd->c1)
		cpbd->c1 = c1;
	      if (r2 > cpbd->r2)
		cpbd->r2 = r2;
	      if (c2 > cpbd->c2)
		cpbd->c2 = c2;

	      if (ActiveWorksheet != NULL)
		for (r = r1; r <= r2; r++)
		  for (c = c1; c <= c2; c++)
		    {
		      Cell *cell =
			worksheet_getcell (ActiveWorksheet, r, c, -1);
		      if (cell != NULL)
			{
			  Cell *copy = newcell (r, c);
			  copy->worksheet = NULL;
			  cell_cpy (copy, cell);
			  cpbd->ncells++;
			  cpbd->cells =
			    (Cell **) absrealloc (cpbd->cells,
						  sizeof (Cell *) *
						  cpbd->ncells,
						  "copy_clipboard:clipboard->cells");
			  cpbd->cells[cpbd->ncells - 1] = copy;
			}
		    }
	    }
	}

      if (o.type == name2type ("CHART"))
	{
	  Graph *graph = (Graph *) o.rec.s;
	  Graph *copy = newgraph1 (graph);

	  cpbd->ngraphs++;
	  cpbd->graphs =
	    (Graph **) absrealloc (cpbd->graphs,
				   sizeof (Graph *) * cpbd->ngraphs,
				   "copy_clipboard:clipboard->graphs");
	  cpbd->graphs[cpbd->ngraphs - 1] = copy;
	}

      if (o.type == name2type ("SHAPES"))
	{
	  Drawing *draw = (Drawing *) o.rec.s;
	  Drawing *copy = newdrawing1 (draw);

	  cpbd->ndrawings++;
	  cpbd->drawings =
	    (Drawing **) absrealloc (cpbd->drawings,
				     sizeof (Drawing *) * cpbd->ndrawings,
				     "copy_clipboard:clipboard->drawings");
	  cpbd->drawings[cpbd->ndrawings - 1] = copy;
	}
      o = selection_getobjects (sel);
    }

  return 0;
}

int
paste_clipboard (Selection * sel)
{
  obj o;
  int r2;
  int r1;
  int c2;
  int c1;
  int r, c, dr, dc;
  int i;
  int first = 1;
  int over = 0;
  Cell *copy;
  Cell *dest;
  Cell *cell;

  if (ActiveWorksheet == NULL)
    return -1;

  if (sel == NULL)
    {
      r1 = 1;
      r2 = ActiveWorksheet->nblin + 1;
      c1 = 1;
      c2 = ActiveWorksheet->nbcol + 1;
    }
  else
    {
      r2 = 0;
      r1 = ActiveWorksheet->nblin + 1;
      c2 = 0;
      c1 = ActiveWorksheet->nbcol + 1;
      o = selection_getobjects (sel);

      while (o.type != SEL_END)
	{
	  if (o.type == name2type ("RANGE"))
	    {
	      Range *ran = (Range *) o.rec.s;
	      for (i = 0; i < ran->nplage; i++)
		{
		  if (r1 > ran->plage[i].r1)
		    r1 = ran->plage[i].r1;
		  if (r2 < ran->plage[i].r2)
		    r2 = ran->plage[i].r2;
		  if (c1 > ran->plage[i].c1)
		    c1 = ran->plage[i].c1;
		  if (c2 < ran->plage[i].c2)
		    c2 = ran->plage[i].c2;
		}
	    }
	  o = selection_getobjects (sel);
	}
    }

  if (clipboard->ncells > 0)
    {

      for (r = r1; r <= r2; r++)
	for (c = c1; c <= c2; c++)
	  {
	    cell = worksheet_getcell (ActiveWorksheet, r, c, -1);
	    if (cell != NULL)
	      {

		if (first && cell->formula != NULL)
		  {
		    if (Ask ("Overwrite destination cells?", NULL) != RET_OK)
		      return 0;
		    first = 0;
		    over = 1;
		  }
		clear_cell (cell);
		xdrawcell2 (cell, DRAW_FORCED);
	      }
	  }

      for (i = 0; i < clipboard->ncells; i++)
	{
	  copy = clipboard->cells[i];
	  dr = r1 - clipboard->r1;
	  dc = c1 - clipboard->c1;
	  dest =
	    worksheet_getcell (ActiveWorksheet, copy->r + dr, copy->c + dc,
			       1);

	  if (dest != NULL)
	    {
	      copymod2 (dest, copy, copy->r, copy->c, dr, dc);

	      if (copy->style != NULL)
		{
		  if (dest->style == NULL)
		    dest->style = newstyle (STY_CELL);
		  style_cpy (dest->style, copy->style);
		}
	      else
		{
		  if (dest->style != NULL)
		    {
		      freestyle (dest->style);
		      dest->style = NULL;
		    }
		}

	      xdrawcell2 (dest, DRAW_FORCED);
	    }
	}
    }

  for (i = 0; i < clipboard->ngraphs; i++)
    {

      worksheet_newgraph1 (ActiveWorksheet, clipboard->graphs[i]);
    }

  for (i = 0; i < clipboard->ndrawings; i++)
    {

      worksheet_newdrawing1 (ActiveWorksheet, clipboard->drawings[i]);
    }

  return 0;
}

int
cut_clipboard (Selection * sel)
{

  obj o;
  int r2;
  int r1;
  int c2;
  int c1;
  int r, c;
  int i;
  Cell *cell;

  if (sel == NULL)
    {
      return -1;
    }


  if (copy_clipboard (sel) != 0)
    return -2;

  o = selection_getobjects (sel);
  while (o.type != SEL_END)
    {
      if (o.type == name2type ("RANGE"))
	{
	  Range *ran = (Range *) o.rec.s;
	  for (i = 0; i < ran->nplage; i++)
	    {
	      r1 = ran->plage[i].r1;
	      r2 = ran->plage[i].r2;
	      c1 = ran->plage[i].c1;
	      c2 = ran->plage[i].c2;

	      for (r = r1; r <= r2; r++)
		for (c = c1; c <= c2; c++)
		  {
		    cell = worksheet_getcell (ActiveWorksheet, r, c, -1);
		    if (cell != NULL)
		      {
			clear_cell (cell);
			xdrawcell2 (cell, DRAW_FORCED);
		      }
		  }
	    }
	}
      if (o.type == name2type ("CHART"))
	{
	  Graph *gr = (Graph *) o.rec.s;

	  freegraph (gr);
	}
      if (o.type == name2type ("SHAPES"))
	{
	  Drawing *dr = (Drawing *) o.rec.s;

	  freedrawing (dr);
	}
      o = selection_getobjects (sel);
    }

  return 0;
}

Clipboard *
newclipboard ()
{
  Clipboard *clipboard =
    (Clipboard *) absmalloc (sizeof (Clipboard), "newclipboard:clipboard");
  cpbd->ncells = 0;
  cpbd->cells = NULL;
  cpbd->ngraphs = 0;
  cpbd->graphs = NULL;
  cpbd->ndrawings = 0;
  cpbd->drawings = 0;
  return clipboard;
}

int
freeclipboard (Clipboard * clipboard)
{

  if (clipboard == NULL)
    return -1;
  clear_clipboard (clipboard);
  absfree (clipboard, "freeclipboard:clipboard");

  return 0;
}

int
clear_clipboard (Clipboard * clipboard)
{
  int i;
  if (clipboard == NULL)
    return -1;

  if (clipboard->cells != NULL)
    {
      for (i = 0; i < cpbd->ncells; i++)
	freecell (cpbd->cells[i]);
      absfree (cpbd->cells, "copy_cpbd:clipboard->cells");
      cpbd->cells = NULL;
    }
  cpbd->ncells = 0;
  cpbd->r1 = ActiveWorksheet->nblin + 1;
  cpbd->r2 = 0;
  cpbd->c1 = ActiveWorksheet->nbcol + 1;

  if (clipboard->graphs != NULL)
    {
      for (i = 0; i < cpbd->ngraphs; i++)
	freegraph (cpbd->graphs[i]);
      absfree (cpbd->graphs, "copy_cpbd:clipboard->graphs");
      cpbd->graphs = NULL;
    }
  cpbd->ngraphs = 0;

  if (clipboard->drawings != NULL)
    {
      for (i = 0; i < cpbd->ndrawings; i++)
	freedrawing (cpbd->drawings[i]);
      absfree (cpbd->drawings, "copy_cpbd:clipboard->drawings");
      cpbd->drawings = NULL;
    }
  cpbd->ndrawings = 0;

  cpbd->c2 = 0;
  return 0;
}
