/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#ifndef ABVPROJECT_H
#define ABVPROJECT_H
#include <stdio.h>
#include <stdlib.h>
#include "module.h"

typedef struct
{
  Module **modules;
  int nmodule;
  Module *activemodule;
}
Project;

extern int getnmacro (Project * project);
extern char *getmacroname (Project * project, int v);

extern Project *new_project ();
extern int freeproject (Project * project);
extern int project_addmodule (Project * project, char *filename);
extern int project_save (Project * project, FILE * fp);
extern Project *ActivateProject (Project * project);

extern int gotolabel (char *buf);
extern int labelexist (Project * project, char *buf);

extern int newmacroline (char *line);
extern void stoprecordmacro ();
extern void recordmacro (Project * project, char *name);
extern void editmacro (Project * project, int pos);
extern void playmacro (Project * project, int pos);

#endif
