/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include "module.h"
#include "project.h"
#include "memory.h"
#include "string.h"
#include "symboltable.h"
#include "abv.h"

static Project *ActiveProject = NULL;
#define AP ActiveProject

int
getnmacro (Project * project)
{
  if (project->nmodule > 0)
    return project->modules[0]->nproc;
  return 0;
}

char *
getmacroname (Project * project, int v)
{
  if (v >= 0 && v < project->modules[0]->nproc)
    return project->modules[0]->procedures[v]->label;
  return "bad macro num";
}

static int rec = 0;

void
playmacro (Project * project, int pos)
{
  if (rec)
    return;
  if (pos < 0)
    return;
  if (project == NULL)
    return;
  ActivateProject (project);

  gotolabel (project->modules[0]->procedures[pos]->label);

  screen_refresh ();
}

void
recordmacro (Project * project, char *name)
{
  char line[256];
  if (project == NULL)
    return;
  if (name == NULL)
    return;
  if (strlen (name) < 1)
    return;

  if (rec)
    return;
  rec = 1;

  if (project->nmodule < 1)
    project_addmodule (project, NULL);
  ActivateProject (project);

  sprintf (line, "Sub %s ()\n", name);
  newmacroline (line);
  return;
}

void
stoprecordmacro ()
{
  if (!rec)
    return;

  newmacroline ("End Sub\n");
  module_compile (ActiveProject->activemodule);
  rec = 0;

}

int
newmacroline (char *line)
{
  if (!rec)
    return -1;

  if (ActiveProject == NULL)
    return -1;
  if (ActiveProject->activemodule == NULL)
    return -2;
  if (line == NULL)
    return -3;
  if (strlen (line) < 1)
    return -4;

  return module_addline (ActiveProject->activemodule, line);

}

void
editmacro (Project * project, int pos)
{
  FILE *tmpmac;
  int i;

  if (project == NULL)
    return;

  tmpmac = fopen ("abstmpmacro", "w");
  if (tmpmac == NULL)
    {
      compiler_message ("unable to open: abstmpmacro");
      return;
    }

  if (project->nmodule < 1)
    project_addmodule (project, NULL);
  else
    {
      i = 0;
      if (project->modules[0]->sourcecode != NULL)
	while (project->modules[0]->sourcecode[i] != NULL)
	  {
	    fprintf (tmpmac, "%s", project->modules[0]->sourcecode[i]);
	    i++;
	  }
    }
  fclose (tmpmac);

  abv_editor ("abstmpmacro");

}

void
updatemodule ()
{
  if (ActiveProject == NULL)
    return;
  module_newfile (ActiveProject->activemodule, "abstmpmacro");
}

Project *
new_project ()
{
  Project *project =
    (Project *) absmalloc (sizeof (Project), "new_project:project");
  project->modules = NULL;
  project->nmodule = 0;
  ActiveProject = project;
  return project;
}

int
freeproject (project)
     Project *project;
{
  int i;
  if (project == NULL)
    return 1;
  for (i = 0; i < project->nmodule; i++)
    freemodule (project->modules[i]);

  if (project->modules != NULL)
    absfree (project->modules, "freeproject:project->modules");

  absfree (project, "freeproject:project");
  return 0;

}

int
project_save (Project * project, FILE * fp)
{
  int i;
  fprintf (fp, "'===================ABV PROJECT======================\n");
  for (i = 0; i < project->nmodule; i++)
    {
      fprintf (fp, "'===================MODULE %d  =======================\n",
	       i + 1);
      module_save (project->modules[i], fp);
    }
  return 0;
}

Project *
ActivateProject (project)
     Project *project;
{
  if (project == NULL)
    return ActiveProject;
  ActiveProject = project;
  if (project->nmodule > 0)
    ActivateModule (project->modules[0]);
  return ActiveProject;
}

int
project_addmodule (project, filename)
     Project *project;
     char *filename;
{
  project->nmodule++;
  project->modules =
    (Module **) absrealloc (project->modules,
			    sizeof (Module *) * project->nmodule,
			    "projet_addmodule:project->modules");
  project->modules[project->nmodule - 1] = new_module ();
  project->activemodule = project->modules[project->nmodule - 1];
  ActivateModule (project->modules[project->nmodule - 1]);

  if (filename != NULL)
    module_newfile (project->modules[project->nmodule - 1], filename);
  return 0;
}

#include "symboltable.h"

int
gotolabel (char *buf)
{
  int i, j;
  resetbreak ();
  for (j = 0; j < AP->nmodule; j++)
    for (i = 0; i < AP->modules[j]->nproc; i++)
      {
	if (strcasecmp (buf, AP->modules[j]->procedures[i]->label) == 0)
	  {
	    module_declare (AP->modules[j]);
	    newlocalidtable ();
	    if (AP->modules[j]->procedures[i]->statictable == NULL)
	      AP->modules[j]->procedures[i]->statictable = new_symboltable ();
	    setprocedurestatictable (AP->modules[j]->procedures[i]->
				     statictable);

	    exint (AP->modules[j]->procedures[i]->topnode);
	    deletelocalidtable ();

	    return 0;
	  }

      }
  return -1;
}

int
labelexist (Project * project, char *buf)
{
  int i, j;

  for (j = 0; j < project->nmodule; j++)
    for (i = 0; i < project->modules[j]->nproc; i++)
      {
	if (strcasecmp (buf, project->modules[j]->procedures[i]->label) == 0)
	  {
	    return 1;
	  }

      }
  return 0;
}
