/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#ifndef OBJECT_H
#define OBJECT_H

typedef struct
{
  union
  {
    int i;
    double d;
    char *s;
    void (*f) ();
  }
  rec;
  int type;
  char *label;
}
obj;

extern int freenocstobj (obj o);
extern int freeobj (obj o);

extern int obj2int (obj o);
extern double obj2double (obj o);
extern char *obj2string (obj o);
extern char *obj2text (obj o);
extern obj id2val (obj o);
extern obj obj2val (obj o);
extern int objisstring (obj o);

extern obj mkderef (obj o1, obj o2);
extern obj mkwithderef (obj o2);
extern int printobj (obj o);
extern int niceprintobj (obj o);
extern int withenter (obj o);
extern int withend ();
extern obj check_with (obj o);

extern int getbaseclass (obj o);
extern int getmemberpos (int class, obj o2);
extern obj member2val (obj o);
extern obj class2obj (obj o);
extern int classname2classpos (char *name);
extern int name2type (char *name);

extern int o1eqo2 (obj * o1, obj o2);
extern int o1plusplus (obj * o1);
extern int o1moinsmoins (obj * o1);

extern int objcmp (obj o1, obj o2);

#endif
