/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include "node.h"
#include "y.tab.h"
#include "memory.h"

extern int yyerror (char *s);

nodeType *
con (obj value)
{
  nodeType *p;

  if ((p = (nodeType *) absmalloc (sizeof (conNodeType), "nodeType:con")) ==
      NULL)
    yyerror ("out of memory");

  p->type = typeCon;
  p->con.value = value;
  if (value.type == INTEGER_CONSTANT)
    p->con.type = INTEGER;
  if (value.type == FLOATING_CONSTANT)
    p->con.type = DOUBLE;
  return p;
}

nodeType *
id (obj i)
{
  nodeType *p;

  if ((p = (nodeType *) absmalloc (sizeof (idNodeType), "nodeType:id")) ==
      NULL)
    yyerror ("out of memory");

  p->type = typeId;
  p->id.id = i;

  return p;
}

nodeType *
member (obj i)
{
  nodeType *p;

  if (
      (p =
       (nodeType *) absmalloc (sizeof (memberNodeType),
			       "nodeType:member")) == NULL)
    yyerror ("out of memory");

  p->type = typeMember;
  p->member.member = i;

  return p;
}

nodeType *
opr (int oper, char *label, int nops, ...)
{
  va_list ap;
  nodeType *p;

  int i;
  obj o;
  o.type = OPERATION;
  o.rec.i = oper;
  o.label = label;

  if ((p = (nodeType *) absmalloc (sizeof (oprNodeType), "nodeType:opr")) ==
      NULL)
    yyerror ("out of memory");

  p->type = typeOpr;
  p->opr.oper = o;

  if (nops > 0)
    {
      p->opr.op =
	(nodeType **) absmalloc ((nops) * sizeof (oprNodeType *),
				 "nodeType:opr.op");

      p->opr.nops = nops;
      va_start (ap, nops);
      for (i = 0; i < nops; i++)
	p->opr.op[i] = va_arg (ap, nodeType *);
      va_end (ap);
    }
  else
    {
      p->opr.op = NULL;
      p->opr.nops = 0;
    }

  return p;
}

nodeType *
addarg (nodeType * p, nodeType * arg)
{

  int nops = p->opr.nops;

  p->opr.op =
    (nodeType **) absrealloc (p->opr.op, (nops + 1) * sizeof (oprNodeType *),
			      "addarg:opr.op");

  p->opr.nops = nops + 1;
  p->opr.op[nops] = arg;
  return p;
}

void
freenode (nodeType * p)
{
  int i;

  if (!p)
    return;

  switch (p->type)
    {
    case typeOpr1:
      break;
    case typeOpr2:
      break;
    case typeOpr:
      {
	for (i = 0; i < p->opr.nops; i++)
	  freenode (p->opr.op[i]);
	if (p->opr.op != NULL)
	  absfree (p->opr.op, "freenode:opr.p");
	absfree (p, "freenode:p:typeopr");
	p = NULL;
	return;
      }
    case typeCon:
      {
	freeobj (p->con.value);

	absfree (p, "freenode:p:typeCon");
	p = NULL;
	return;
      }
    case typeId:
      {

	absfree (p, "freenode:p:typeId");
	p = NULL;
	return;
      }
    case typeMember:
      {

	absfree (p, "freenode:p:typeMember");
	p = NULL;
	return;
      }

    }
}

int static tab = 0;

void
printtab (t)
     int t;
{
  int i;
  if (t <= 0)
    return;
  for (i = 0; i < t; i++)
    fprintf (stderr, "-");
}

void
printTree (nodeType * p, int deep)
{
  int i;

  if (!p)
    return;
  switch (p->type)
    {
    case typeCon:
      {
	printtab (tab);
	printobj (p->con.value);
	return;
      }
    case typeId:
      {
	printtab (tab);
	printobj (p->id.id);
	return;
      }
    case typeOpr1:
      break;
    case typeOpr2:
      break;
    case typeOpr:
      {
	printtab (tab);
	printobj (p->opr.oper);
	tab++;
	if (tab < deep)
	  for (i = 0; i < p->opr.nops; i++)
	    printTree (p->opr.op[i], deep);
	tab--;
      }
    }
}
