/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#ifndef MODULE_H
#define MODULE_H
#include <stdio.h>
#include <stdlib.h>
#include "gram_ext.h"
#include "interpret.h"
#include "symboltable.h"

typedef struct
{
  char *label;
  nodeType *topnode;
  Symboltable *statictable;
  int scope;
}
Procedure;

extern Procedure *new_procedure (char *name, nodeType * topnode, int scope);
extern int freeprocedure (Procedure * procedure);

typedef struct
{
  nodeType *tree;
  char **sourcecode;
  int nlc;
  Procedure **procedures;
  int nproc;
  int declared;
  Symboltable *symboltable;
}
Module;

extern Module *new_module ();
extern int freemodule (Module * module);
extern int module_newfile (Module * module, char *filename);
extern int module_freecode (Module * module);
extern int module_compile (Module * module);
extern Module *ActivateModule (Module * module);
extern int module_declare (Module * module);
extern int emitlabel (nodeType * p, int scope);
extern int module_save (Module * module, FILE * fp);
extern int module_addline (Module * module, char *line);

#endif
