/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include "informationfct.h"
#include <stdlib.h>
#include "y.tab.h"
#include "cell.h"

Fct informationarrayfct[] = {
  {"ISBLANK", &vb_ISBLANK, 1, 1, NULL, NULL}
  ,
  {"ISNUMBER", &vb_ISNUMBER, 1, 1, NULL, NULL}
  ,
  {"ISTEXT", &vb_ISTEXT, 1, 1, NULL, NULL}
  ,
  {NULL, NULL, 0, 0, NULL, NULL}
  ,
};

extern obj vb_ISNUMBER (int narg, obj * arg);
extern obj vb_ISTEXT (int narg, obj * arg);
extern obj vb_ISBLANK (int narg, obj * arg);

obj vb_ISNUMBER (int narg, obj * arg)
{
  obj o;
  o.rec.i = 0;
  o.type = INTEGER;
  if (arg[0].type == CELL)
    {
      if (!((Cell *) arg[0].rec.s)->is_text)
	o.rec.i = 1;
    }
  else
    {
      if
	(arg[0].type == INTEGER ||
	 arg[0].type == DOUBLE || arg[0].type == INTEGER)
	o.rec.i = 1;
    }
  return o;
}

obj vb_ISTEXT (int narg, obj * arg)
{
  obj o;
  o.rec.i = 0;
  o.type = INTEGER;
  if (arg[0].type == CELL)
    {
      if (((Cell *) arg[0].rec.s)->is_text)
	o.rec.i = 1;
    }
  else
    {
      if (arg[0].type == STRING_CONSTANT || arg[0].type == STRING)
	o.rec.i = 1;
    }
  return o;
}

obj vb_ISBLANK (int narg, obj * arg)
{
  obj o;
  o.rec.i = 0;
  o.type = INTEGER;
  if (arg[0].type == CELL)
    if (((Cell *) arg[0].rec.s)->formula == NULL)
      o.rec.i = 1;
  return o;
}
