/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include <stdlib.h>
#include <stdio.h>

#define MEMSIZE 1

static void *memmap[MEMSIZE];
static size_t memsize[MEMSIZE];
static char *allocmsg[MEMSIZE];
static long allocation = 0;
static int nptr = 0;
static int startmap = 0;

int
absstartmap ()
{
#ifdef MEMDEBUG
  startmap = nptr - 1;
  printf ("\n\n\n\n==============NEW WORKBOOK=====nptr %d======\n\n\n", nptr);
#endif
  return 0;
}

int
absmemmap ()
{
#ifdef MEMDEBUG
  int i;
  printf ("\n\n\n\n==============WORKBOOK CLOSED=====nptr %d======\n\n\n",
	  nptr);
  for (i = startmap; i < nptr; i++)
    printf ("ptr %d len %d msg %s cont %10s\n", memmap[i], memsize[i],
	    allocmsg[i], (char *) memmap[i]);
  printf ("\n\n\n\n===============================================\n\n\n",
	  nptr);
#endif
  return 0;
}

void *
absmalloc (Size, message)
     size_t Size;
     char *message;
{
#ifdef MEMDEBUG
  void *ptr;
  ptr = malloc (Size);

  memmap[nptr] = ptr;
  memsize[nptr] = Size;
  allocmsg[nptr] = message;
  allocation += Size;
  nptr++;
  if (nptr > MEMSIZE - 1)
    nptr = MEMSIZE - 1;

  printf ("(%d/%d) %35s:	malloc size %d at %d\n", allocation, nptr,
	  message, Size, ptr);
  return ptr;
#endif

#ifndef MEMDEBUG
  return malloc (Size);
#endif

}

void
absfree (Pointer, message)
     void *Pointer;
     char *message;
{
#ifdef MEMDEBUG
  int i, j;
  size_t Size = 0;
  if (Pointer != NULL)
    {
      i = nptr - 1;
      while (i >= 0 && memmap[i] != Pointer)
	i--;
      if (i >= 0)
	{
	  Size = memsize[i];
	  allocation = allocation - Size;
	  for (j = i; j < nptr - 1; j++)
	    {
	      memsize[j] = memsize[j + 1];
	      memmap[j] = memmap[j + 1];
	      allocmsg[j] = allocmsg[j + 1];
	    }
	}
      else
	printf ("WARNING free of ptr %d not found!!! (%s)\n", Pointer,
		message);
      nptr--;
    }
  else
    printf ("WARNING free of NULL ptr %d !!! (%s)\n", Pointer, message);

  printf ("(%d/%d) %35s:	free size %d at  %d\n", allocation, nptr,
	  message, Size, Pointer);
  if (Size <= 0)
    {
      printf ("WARNING free of Size %d ptr %d !!! (%s)\n", Size, Pointer,
	      message);
      return;
    }
#endif

  free (Pointer);
}

void *
absrealloc (Pointer, Size, message)
     void *Pointer;
     size_t Size;
     char *message;
{
#ifdef MEMDEBUG
  int i = -1;
  int j;
  size_t oldSize = 0;
  void *ptr;

  if (Pointer != NULL)
    {
      int i = nptr - 1;
      while (i >= 0 && memmap[i] != Pointer)
	i--;
      if (i >= 0)
	{
	  oldSize = memsize[i];
	  allocation = allocation - memsize[i];
	  allocation = allocation + Size;
	  memsize[i] = Size;
	  allocmsg[i] = message;
	}
      else
	{
	  printf ("WARNING realloc to non NULL ptr %d not found!!! (%s)\n",
		  Pointer, message);
	}
    }
  else

    {
      i = nptr;
      nptr++;
      if (nptr > MEMSIZE - 1)
	nptr = MEMSIZE - 1;
      allocation += Size;
      memsize[i] = Size;
      allocmsg[i] = message;
    }
  ptr = realloc (Pointer, Size);

  memmap[i] = ptr;

  printf ("(%d/%d) %35s:	realloc size %d from %d to ", allocation,
	  nptr, message, oldSize, Pointer);
  printf ("size %d at %d\n", Size, ptr);
  return ptr;
#endif

#ifndef MEMDEBUG
  return realloc (Pointer, Size);
#endif

}
