#pragma once

#include "gfx/gl/gl_core_3_3.h"

typedef struct GFX_GL_Buffer {
    GLuint id;
    GLenum target;
} GFX_GL_Buffer;

void GFX_GL_Buffer_Init(GFX_GL_Buffer *buf, GLenum target);
void GFX_GL_Buffer_Close(GFX_GL_Buffer *buf);

void GFX_GL_Buffer_Bind(GFX_GL_Buffer *buf);
void GFX_GL_Buffer_Data(
    GFX_GL_Buffer *buf, GLsizei size, const void *data, GLenum usage);
void GFX_GL_Buffer_SubData(
    GFX_GL_Buffer *buf, GLsizei offset, GLsizei size, const void *data);
void *GFX_GL_Buffer_Map(GFX_GL_Buffer *buf, GLenum access);
void GFX_GL_Buffer_Unmap(GFX_GL_Buffer *buf);
GLint GFX_GL_Buffer_Parameter(GFX_GL_Buffer *buf, GLenum pname);
