/*  SpiralSynth
 *  Copyleft (C) 2000 David Griffiths <dave@pawfal.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include <math.h>
#include "NoteTable.h"
#include "SpiralInfo.h"
#include "Sample.h"

#ifndef OSC
#define OSC


class Oscillator
{
public:
 	Oscillator();
	virtual ~Oscillator();

	void 		Execute(int V, Sample &data);
	void	    StreamOut(ostream &s);
	void	    StreamIn(istream &s);
	
	enum Type{NONE,SQUARE,SAW,NOISE};
	
	void ModulateFreq(Sample *data) {m_FreqModBuf=data;}
	void ModulatePulseWidth(Sample *data) {m_PulseWidthModBuf=data;}
	void ModulateSHLen(Sample *data) {m_SHModBuf=data;}
	
	void NoteTrigger(int V,int s,float v);
	void SetOctave(int o) {m_Octave=o;}
	void SetVolume(int V,int o) {m_Volume[V]=o;}
	void SetFineFreq(float s) {m_FineFreq=s;}
	void SetPulseWidth(float p) {m_PulseWidth=p;}
	void SetType(Type t) {m_Type=t;}
	void SetSHLen(float s) {m_SHLen=s;}
	void SetModAmount(float s) {m_ModAmount=s;}
	int   GetOctave() {return m_Octave;}
	float GetFineFreq() {return m_FineFreq;}
	float GetPulseWidth() {return m_PulseWidth;}
	Type  GetType() {return m_Type;}
	float GetSHLen() {return m_SHLen;}
	float GetModAmount() {return m_ModAmount;}
	
private:

	// Voice specific parameter
	int   *m_Note;
	int   *m_CyclePos;
	float *m_LastFreq;
	float *m_Volume;
	
	// Common voice parameters
	Type   m_Type;
	int    m_Octave;
	float  m_FineFreq;
	float  m_PulseWidth; 
	float  m_SHLen; 
	float  m_ModAmount;
	float  m_Noisev;
	
	Sample *m_FreqModBuf;
	Sample *m_PulseWidthModBuf;
	Sample *m_SHModBuf;
	
	static const int FIXED;
	
	friend istream &operator>>(istream &s, Oscillator &o);
	friend ostream &operator<<(ostream &s, Oscillator &o);
};

istream &operator>>(istream &s, Oscillator &o);
ostream &operator<<(ostream &s, Oscillator &o);

#endif
