/*  SpiralSynth
 *  Copyleft (C) 2000 David Griffiths <dave@pawfal.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include <math.h>
#include "NoteTable.h"
#include "SpiralInfo.h"
#include "Sample.h"

#ifndef MIX
#define MIX


class Mixer
{
public:
	enum Type{NONE,ADD,RING,XMOD};

	Mixer();
	
	void Execute(Sample &data1, Sample &data2);	
	void SetType(Type t) {m_Type=t;}
	bool IsXMod() {return (m_Type==XMOD);}
	void SetAmount(float s) {m_Amount=s;}
	Type  GetType() {return m_Type;}
	float GetAmount() {return m_Amount;}
	void Randomise();
	
private:
	
	Type  m_Type;
	float m_Amount;
	
	friend istream &operator>>(istream &s, Mixer &o);
	friend ostream &operator<<(ostream &s, Mixer &o);
};

istream &operator>>(istream &s, Mixer &o);
ostream &operator<<(ostream &s, Mixer &o);

#endif
