/*  SpiralSynth
 *  Copyleft (C) 2000 David Griffiths <dave@pawfal.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include "Mixer.h"

Mixer::Mixer() :
m_Type(ADD),
m_Amount(0.001)
{
}

void Mixer::Execute(Sample &data1, Sample &data2)
{
	long temp=0;
	
	for (int n=0; n<SpiralInfo::BUFSIZE; n++)
	{
		switch (m_Type)
		{
			case ADD:  data2.Set(n,data1[n]+data2[n]); break;	
			case XMOD: data2.Set(n,data1[n]); break;
			case RING: data2.Set(n,data1[n]*data2[n]*m_Amount*50); break;	
			case NONE: break;
		}
	}	
}

void Mixer::Randomise()
{
	float t=RandFloat();
	if (t<0.3) m_Type=ADD;
	else if (t<0.6) m_Type=XMOD;
	else m_Type=RING;
	
	m_Amount=RandFloat(0.0f,0.002f);
}

istream &operator>>(istream &s, Mixer &o)
{
	s>>(int&)o.m_Type>>o.m_Amount;
	return s;
}

ostream &operator<<(ostream &s, Mixer &o)
{
	s<<(int)o.m_Type<<" "<<o.m_Amount<<" ";
	return s;
}

